#define FILE_BUF_SIZE	65535

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <glib.h>
//#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "filecntl.h"
#include "main.h"

static gint
uri_command (const char *command)
{
	GError *error = NULL;
	gint ret = 0;
	g_print("command->%s\n", command);
	if (!g_spawn_command_line_async (command, &error))
	{
		char *tmp = g_strdup_printf (_("Error launching \"%s\": %s"),
					     command, error->message);

		g_printerr (_("Unable to open URL->%s"), tmp);

		g_free (tmp);
		g_error_free (error);
		ret = 0;
	} else {
		ret = 1;
	}

return ret;
}

void
on_window1_destroy (GtkObject * object, gpointer user_data)
{
	sotsu_destroy ();
}

/* 設定ボタン */
void
on_buttonConfig_clicked (GtkButton * button, gpointer user_data)
{
	GtkWidget *dialog1;
	gchar tmp[20];

	dialog1 = create_dialog1 ();

	gtk_entry_set_text (GTK_ENTRY
			    ((GtkWidget *)
			     lookup_widget (dialog1, "entryBlogUrl")),
			    _(myParam.BlogUrl));
	switch (myParam.Status)
	{
	case 1:
		gtk_combo_box_set_active (GTK_COMBO_BOX
					  ((GtkWidget *)
					   lookup_widget (dialog1,
							  "comboStatus")), 0);
		break;
	case 2:
		gtk_combo_box_set_active (GTK_COMBO_BOX
					  ((GtkWidget *)
					   lookup_widget (dialog1,
							  "comboStatus")), 1);
		break;
	default:
		break;
	}

	switch (myParam.Dcopy)
	{
	case 0:
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					      ((GtkWidget *)
					       lookup_widget (dialog1,
							      "radioCoff")),
					      TRUE);
		break;
	case 1:
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					      ((GtkWidget *)
					       lookup_widget (dialog1,
							      "radioCon")),
					      TRUE);
		break;
	case 2:
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					      ((GtkWidget *)
					       lookup_widget (dialog1,
							      "radioConPlus")),
					      TRUE);
		break;
	default:
		break;
	}

	sprintf (tmp, "%d", myParam.DSY);
	gtk_entry_set_text (GTK_ENTRY
			    ((GtkWidget *)
			     lookup_widget (dialog1, "entryDSY")), _(tmp));
/*
struct GdkColor
{
  gulong  pixel;
  gushort red;
  gushort green;
  gushort blue;
};
*/
	gtk_color_button_set_color (GTK_COLOR_BUTTON(lookup_widget (dialog1, "colorbuttonText")), &myParam.colorText);
	gtk_color_button_set_color (GTK_COLOR_BUTTON(lookup_widget (dialog1, "colorbuttonBG")), &myParam.colorBG);
	
	switch (myParam.DBC)
	{
	case TRUE:
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					      ((GtkWidget *)
					       lookup_widget (dialog1,
							      "checkbuttonDBC")),
					      TRUE);
		break;
	case FALSE:
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					      ((GtkWidget *)
					       lookup_widget (dialog1,
							      "checkbuttonDBC")),
					      FALSE);
		break;
	}

	sprintf (tmp, "%d", myParam.DYear);
	gtk_entry_set_text (GTK_ENTRY
			    ((GtkWidget *)
			     lookup_widget (dialog1, "entryDYear")), _(tmp));
	sprintf (tmp, "%d", myParam.DMonth);
	gtk_entry_set_text (GTK_ENTRY
			    ((GtkWidget *)
			     lookup_widget (dialog1, "entryDMonth")), _(tmp));
	sprintf (tmp, "%d", myParam.DDay);
	gtk_entry_set_text (GTK_ENTRY
			    ((GtkWidget *)
			     lookup_widget (dialog1, "entryDDay")), _(tmp));
	sprintf (tmp, "%d", myParam.DHour);
	gtk_entry_set_text (GTK_ENTRY
			    ((GtkWidget *)
			     lookup_widget (dialog1, "entryDHour")), _(tmp));
	sprintf (tmp, "%d", myParam.DMin);
	gtk_entry_set_text (GTK_ENTRY
			    ((GtkWidget *)
			     lookup_widget (dialog1, "entryDMin")), _(tmp));
	sprintf (tmp, "%d", myParam.TCount);
	gtk_entry_set_text (GTK_ENTRY
			    ((GtkWidget *)
			     lookup_widget (dialog1, "entryTCount")), _(tmp));
	sprintf (tmp, "%d", myParam.TPrice);
	gtk_entry_set_text (GTK_ENTRY
			    ((GtkWidget *)
			     lookup_widget (dialog1, "entryTPrice")), _(tmp));
	sprintf (tmp, "%d", myParam.TTax);
	gtk_entry_set_text (GTK_ENTRY
			    ((GtkWidget *)
			     lookup_widget (dialog1, "entryTTax")), _(tmp));
	sprintf (tmp, "%d", myParam.TTaxPer);
	gtk_entry_set_text (GTK_ENTRY
			    ((GtkWidget *)
			     lookup_widget (dialog1, "entryTTaxPer")),
			    _(tmp));
	switch (myParam.TSize)
	{
	case 1:
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					      ((GtkWidget *)
					       lookup_widget (dialog1,
							      "radioS1")),
					      TRUE);
		break;
	case 2:
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					      ((GtkWidget *)
					       lookup_widget (dialog1,
							      "radioS2")),
					      TRUE);
		break;
	case 3:
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					      ((GtkWidget *)
					       lookup_widget (dialog1,
							      "radioS3")),
					      TRUE);
		break;
	default:
		break;
	}


	// Then show Dialog Box  
	gtk_widget_show (dialog1);

	gint response = gtk_dialog_run (GTK_DIALOG (dialog1));

	switch (response)
	{
	case GTK_RESPONSE_OK:
		g_print (_("Dialog1 response- OK\n"));
		sprintf (myParam.BlogUrl,
			 gtk_entry_get_text (GTK_ENTRY
					     ((GtkWidget *)
					      lookup_widget (dialog1,
							     "entryBlogUrl"))));
		if (gtk_combo_box_get_active
		    (GTK_COMBO_BOX
		     ((GtkWidget *) lookup_widget (dialog1, "comboStatus")))
		    == 0)
			myParam.Status = 1;
		if (gtk_combo_box_get_active
		    (GTK_COMBO_BOX
		     ((GtkWidget *) lookup_widget (dialog1, "comboStatus")))
		    == 1)
			myParam.Status = 2;

		if (gtk_toggle_button_get_active
		    (GTK_TOGGLE_BUTTON
		     ((GtkWidget *) lookup_widget (dialog1, "radioCoff"))))
			myParam.Dcopy = 0;
		if (gtk_toggle_button_get_active
		    (GTK_TOGGLE_BUTTON
		     ((GtkWidget *) lookup_widget (dialog1, "radioCon"))))
			myParam.Dcopy = 1;
		if (gtk_toggle_button_get_active
		    (GTK_TOGGLE_BUTTON
		     ((GtkWidget *) lookup_widget (dialog1, "radioConPlus"))))
			myParam.Dcopy = 2;
		myParam.DSY =
			atoi (gtk_entry_get_text
			      (GTK_ENTRY
			       ((GtkWidget *)
				lookup_widget (dialog1, "entryDSY"))));
		if (gtk_toggle_button_get_active
		    (GTK_TOGGLE_BUTTON
		     ((GtkWidget *)
		      lookup_widget (dialog1, "checkbuttonDBC"))))
			myParam.DBC = TRUE;
		else
			myParam.DBC = FALSE;
		myParam.DYear =
			atoi (gtk_entry_get_text
			      (GTK_ENTRY
			       ((GtkWidget *)
				lookup_widget (dialog1, "entryDYear"))));
		myParam.DMonth =
			atoi (gtk_entry_get_text
			      (GTK_ENTRY
			       ((GtkWidget *)
				lookup_widget (dialog1, "entryDMonth"))));
		myParam.DDay =
			atoi (gtk_entry_get_text
			      (GTK_ENTRY
			       ((GtkWidget *)
				lookup_widget (dialog1, "entryDDay"))));
		myParam.DHour =
			atoi (gtk_entry_get_text
			      (GTK_ENTRY
			       ((GtkWidget *)
				lookup_widget (dialog1, "entryDHour"))));
		myParam.DMin =
			atoi (gtk_entry_get_text
			      (GTK_ENTRY
			       ((GtkWidget *)
				lookup_widget (dialog1, "entryDMin"))));
		myParam.TCount =
			atoi (gtk_entry_get_text
			      (GTK_ENTRY
			       ((GtkWidget *)
				lookup_widget (dialog1, "entryTCount"))));
		myParam.TPrice =
			atoi (gtk_entry_get_text
			      (GTK_ENTRY
			       ((GtkWidget *)
				lookup_widget (dialog1, "entryTPrice"))));
		myParam.TTax =
			atoi (gtk_entry_get_text
			      (GTK_ENTRY
			       ((GtkWidget *)
				lookup_widget (dialog1, "entryTTax"))));
		myParam.TTaxPer =
			atoi (gtk_entry_get_text
			      (GTK_ENTRY
			       ((GtkWidget *)
				lookup_widget (dialog1, "entryTTaxPer"))));
		if (gtk_toggle_button_get_active
		    (GTK_TOGGLE_BUTTON
		     ((GtkWidget *) lookup_widget (dialog1, "radioS1"))))
			myParam.TSize = 1;
		if (gtk_toggle_button_get_active
		    (GTK_TOGGLE_BUTTON
		     ((GtkWidget *) lookup_widget (dialog1, "radioS2"))))
			myParam.TSize = 2;
		if (gtk_toggle_button_get_active
		    (GTK_TOGGLE_BUTTON
		     ((GtkWidget *) lookup_widget (dialog1, "radioS3"))))
			myParam.TSize = 3;

		if (sotsu_file_save () == 0)
			reload_timeout_from_callbacks ();
		
		break;
	case GTK_RESPONSE_CANCEL:
		g_print (_("Dialog1 response- CANCEL\n\n"));
		break;
	}

	gtk_widget_destroy (dialog1);
}

void
on_buttonAd_clicked (GtkButton * button, gpointer user_data)
{
	const gchar *cmd = _("firefox http://sotsuen.com/minsotsu/");

	if(!uri_command (cmd))
		g_print ("buttonAd sippai\n");
}

void
NEW_on_buttonHelp_clicked (GtkButton * button, gpointer user_data)
{
	GtkWidget *helpWindow;
	helpWindow = create_window_help ();	

	// And show Help Window 
	gtk_widget_show (helpWindow);	
}

void
on_buttonHelp_clicked (GtkButton * button, gpointer user_data)
{
	GtkWidget *helpWindow;
	helpWindow = create_window_help ();

	/* テキストウィンドウにファイル sotsuen_help.txt を読み込む */

	FILE *infile;
	GtkTextIter p, start, end;
	gchar fbuf[FILE_BUF_SIZE];
	gssize l;

	/* Get Text Buffer */
	GtkTextView *textView =
		(GtkTextView *) lookup_widget (helpWindow, "textview1");
	GtkTextBuffer *textBuf = gtk_text_view_get_buffer (textView);
	/* Clear Buffer */
	gtk_text_buffer_get_start_iter (textBuf, &start);
	gtk_text_buffer_get_end_iter (textBuf, &end);
	gtk_text_buffer_delete (textBuf, &start, &end);
	/* Open file */
	infile = fopen (PACKAGE_DOC_DIR "/sotsuen_help.txt", "r");
	if (infile)
	{
		/* Gettextbuf */
		gtk_text_buffer_get_end_iter (textBuf, &p);
    /*============================

            Convert loop

    ============================*/
		while ((l =
			(gssize) fread (fbuf, 1, FILE_BUF_SIZE, infile)) > 0)
		{
			GError *err = NULL;
			gsize br, bw;
			gchar *text;

			/* Convert UTF8 */
			if (!
			    (text =
			     g_locale_to_utf8 (fbuf, l, &br, &bw, &err)))
			{
				g_printerr
					("Failed locale to UTF-8 conversion: %s, fbuf:%s\n",
					 err->message, fbuf);
				g_clear_error (&err);
				break;
			}

			/* Insert converted text */
			gtk_text_buffer_insert (textBuf, &p, text, bw);
			g_free (text);
		}
	/* Close file */
	fclose (infile);
	}
	else
	{
		g_print ("入出力エラー！！");
		g_printerr ("%s: %s\n", "sotsuen_help.txt",
			    g_strerror (errno));

	}
	// And show Help Window 
	gtk_widget_show (helpWindow);
}

void
on_buttonBlog_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	const gchar *cmd = g_strdup_printf (_("firefox http://%s"), myParam.BlogUrl);

	if(!uri_command (cmd))
		g_print ("buttonBlog sippai\n");
}


void
on_colorbuttonText_color_set           (GtkColorButton  *colorbutton,
                                        gpointer         user_data)
{
	GdkColor *color = &myParam.colorText;
	gtk_color_button_get_color (colorbutton, color);
}


void
on_colorbuttonBG_color_set     		    (GtkColorButton  *colorbutton,
                                        gpointer         user_data)
{
	GdkColor *color = &myParam.colorBG;
	gtk_color_button_get_color (colorbutton, color);
}


void
on_colorbuttonText_show                (GtkWidget       *widget,
                                        gpointer         user_data)
{
	GtkColorButton *CB = user_data;
	gtk_color_button_set_color (CB, &myParam.colorText);
}


void
on_buttonCopy_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	if (myParam.Dcopy == 0) return;
		
	GtkWidget *window = (GtkWidget *)user_data;
	
	const gchar *cbStatus = gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "entryStatus")));
	const gchar *cbElapsedTime = gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "entryElapsedTime")));
	const gchar *cbLifeSpan = gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "entryLifeSpan")));
	const gchar *cbSavedMoney = gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "entrySavedMoney")));
	const gchar *cbCountNotSmoked = gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "entryCountNotSmoked")));
	//const gchar *cbTodaysComment = gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "entryTodaysComment")));
	gchar scb[400];
	gchar tmp[100];
	sprintf (tmp, "ステータス：%s\n", cbStatus);
	strcpy (scb, tmp);
	if (myParam.Dcopy == 1)
		sprintf (tmp, "卒煙日： %d年 %d月 %d日\n", myParam.DYear, myParam.DMonth, myParam.DDay);
	if (myParam.Dcopy == 2)
		sprintf (tmp, "卒煙日： %d年 %d月 %d日（%d本-%d年）\n", myParam.DYear, myParam.DMonth, myParam.DDay, myParam.TCount, myParam.DSY);
/*
	if (myParam.Dcopy == 2 && myParam.DBC == FALSE)
		sprintf (tmp, "卒煙日： %d年 %d月 %d日（%d年）\n", myParam.DYear, myParam.DMonth, myParam.DDay, myParam.DSY);
	if (myParam.Dcopy == 2 && myParam.DBC == TRUE)
		sprintf (tmp, "卒煙日： %d年 %d月 %d日（%d本-%d年）\n", myParam.DYear, myParam.DMonth, myParam.DDay, myParam.TCount, myParam.DSY);
*/
	strcat (scb, tmp);
	sprintf (tmp, "卒煙からの日数：%s\n", cbElapsedTime);
	strcat (scb, tmp);
	sprintf (tmp, "延びた寿命：%s\n", cbLifeSpan);
	strcat (scb, tmp);
	sprintf (tmp, "節約できた金額：%s\n", cbSavedMoney);
	strcat (scb, tmp);
	sprintf (tmp, "節煙本数：%s\n", cbCountNotSmoked);
	strcat (scb, tmp);
	
//	strcat (scb, tmp);

//(text data sample)
//ステータス： ケンシロウ
//卒煙日： 2007年 3月 28日（22本-25年）
//卒煙からの日数： 1年 0ヶ月 2日 13時間 21分
//延びた寿命： 30日と23時間15分
//節約できた金額： 121623円（節税分 76689円）
//節煙本数： 8108本 810.82ｍ Burj Dubai（仮）");
	gtk_clipboard_set_text (gtk_clipboard_get(GDK_SELECTION_CLIPBOARD), scb, strlen(scb));
}

gboolean
on_entryElapsedTime_button_press_event (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

	g_print("Button pressed button->%d", event->button);
	if(myParam.DET == 1) {
		myParam.DET = 0;
	}else{
		myParam.DET = 1;
	}
	
	reload_timeout_from_callbacks ();

	return FALSE;
}



void
on_popCopy_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	on_buttonCopy_clicked (NULL, window1);
	//on_buttonCopy_clicked (NULL, user_data);
}


void
on_popBlogOpen_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	on_buttonBlog_clicked (NULL, NULL);
}


void
on_popHelp_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	on_buttonHelp_clicked (NULL, NULL);
}


void
on_popConfig_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	on_buttonConfig_clicked (NULL, window1);
	//on_buttonConfig_clicked (NULL, user_data);
}

void
on_popAbout_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *aboutdialog1;
	//gchar tmp[20];

	aboutdialog1 = create_aboutdialog1 ();
	
	// And show Dialog Box  
	gtk_widget_show (aboutdialog1);

	gint response = gtk_dialog_run (GTK_DIALOG (aboutdialog1));

	switch (response)
	{
	case GTK_RESPONSE_OK:
		g_print (_("aboutdialog1 response- OK\n"));
		break;
	case GTK_RESPONSE_CANCEL:
		g_print (_("aboutdialog1 response- CANCEL\n\n"));
		break;
	}
	
	
	gtk_widget_destroy (aboutdialog1);
}


void
on_popClose_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	sotsu_destroy ();
}


void
on_popModeChange_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (wMode == 0) {
		gtk_widget_hide (window1);
		gtk_widget_show (window2);
		wMode = 1;
	}else{
		gtk_widget_hide (window2);
		gtk_widget_show (window1);
		wMode = 0;
	}	
}


void
on_window2_destroy                     (GtkObject       *object,
                                        gpointer         user_data)
{
	sotsu_destroy ();
}


gboolean
on_fixed1_button_release_event         (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	g_print("fixed1 pressed button->%d", event->button);
	
  return FALSE;
}

