/*
 * JDropableTable.java
 *
 * Created on 2004/12/19, 16:25
 */

package orch;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;

import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/**
 *
 * @author Scientific Open Source projects (Gaku Tanaka)
 * @version 1.0 (2005/02/15)
 */
public class JDropableTable extends JTable implements DropTargetListener, MouseMotionListener, Serializable{
	
	private DropTarget dropTarget = null;
	private boolean dragging;
	private Point startPoint;
	
	/** Creates a new instance of JDropableTable */
	public JDropableTable() {
		super();
		
		setDefaultEditor(Object.class, null);// set unenabled editing a cell but allow to select a cell
		addMouseMotionListener(this);
		
		dropTarget = new DropTarget(this,DnDConstants.ACTION_COPY_OR_MOVE, this, true);
		
	}
	
	public void applyCellSize(){
		TableColumnModel model = getColumnModel();
		for (int i=0; i<getColumnCount(); i++){
			TableColumn Tcol = model.getColumn(i);
			if (i%2==0){
				Tcol.setMinWidth(5);
				Tcol.setPreferredWidth(5);
			}else{
				Tcol.setPreferredWidth(160);
			}
		}
		for (int i=0; i<getRowCount(); i++){
			if (i%2==0){
				setRowHeight(i,5);
			}else{
				setRowHeight(i,120);
			}
		}
	}
	
	public void clearContents(){
		for (int y=0; y<getRowCount(); y++){
			for (int x=0; x<getColumnCount(); x++){
				setValueAt(null, y,x);
			}
		}
	}
	
	private void changeSelectedCell(Point p){
		int rowIndex = rowAtPoint(p);
		int columnIndex = columnAtPoint(p);
		changeSelection(rowIndex,columnIndex,false,false);
	}
	
	public void setTable(int row, int column){
		DefaultTableModel model = (DefaultTableModel)getModel();
		model.setColumnCount(column);
		model.setRowCount(row);
		applyCellSize();
	}
	
	public boolean isDragging(){
		return dragging;
	}
	
	public void setDragging(boolean value){
		dragging = value;
	}
	
	public void removeColumnAndData(int colIndex, int nColumn) {
		DefaultTableModel model = (DefaultTableModel)getModel();
		
		// remove the column
		int oldColumnCount = model.getColumnCount();
		for (int x=colIndex+nColumn; x<getColumnCount(); x++){
			for (int y=0; y<model.getRowCount(); y++){
				Object data = model.getValueAt(y,x);
				model.setValueAt(data,y,x-nColumn);
			}
		}
		model.setColumnCount(oldColumnCount-nColumn);
		applyCellSize();
	}
	
	//	Drag Enter Event Handler
	//
	public void dragEnter(DropTargetDragEvent e) {
		e.acceptDrag(DnDConstants.ACTION_COPY_OR_MOVE);
	}
	
	//	Drop Event Handler
	//
	public void drop(DropTargetDropEvent e) {
		e.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);
		try {
			
			if ((e.getDropAction() & DnDConstants.ACTION_COPY_OR_MOVE) != 0) {
				
				// check droped to the NOT-acceptable cell
				boolean canvasRow = (getSelectedRow()%2==0)?false:true;
				boolean canvasColumn = (getSelectedColumn()%2==0)?false:true;
				if (!canvasRow && !canvasColumn){
					e.dropComplete(true);
					dragging = false;
					return;
				}
				
				// get the dropping object as the file
				File file = null;
				int sourceRowIndex, sourceColumnIndex;
				if (e.isLocalTransfer()){
					sourceRowIndex = rowAtPoint(startPoint);
					sourceColumnIndex = columnAtPoint(startPoint);
					ImagePiece tn = (ImagePiece)(getModel().getValueAt(sourceRowIndex, sourceColumnIndex));
					if (tn!=null && tn.hasImage()){
						file = new File(tn.getPath());
						getModel().setValueAt(null, sourceRowIndex, sourceColumnIndex);// remove the data of the source cell
					}else{
						file = null;
					}
				}else{
					Transferable trans = e.getTransferable();
					List list = (List)trans.getTransferData(DataFlavor.javaFileListFlavor);
					file = (File)list.get(0);
				}
				
				if (file!=null){
					ImagePiece thumbnail = new ImagePiece(160,120,file);
					int targetRow = getSelectedRow();
					int targetColumn = getSelectedColumn();
					if (canvasRow^canvasColumn){
						DefaultTableModel model = (DefaultTableModel)getModel();
						if (canvasRow){
							// add new columns
							int oldColumnCount = model.getColumnCount();
							model.setColumnCount(oldColumnCount+2);
							for (int x=oldColumnCount-2; x>targetColumn; x-=2){
								for (int y=0; y<model.getRowCount(); y++){
									Object data = model.getValueAt(y,x);
									model.setValueAt(data,y,x+2);
								}
							}
							targetColumn++;
							for (int y=0; y<model.getRowCount(); y++){
								model.setValueAt(null,y,targetColumn);
							}
						}else{
							// add new rows
							Object[] obj = new Object[model.getColumnCount()];
							model.insertRow(targetRow,obj);
							model.insertRow(targetRow,obj);
							targetRow++;
						}
						applyCellSize();
					}
					getModel().setValueAt(thumbnail, targetRow, targetColumn);
				}
				e.dropComplete(true);
			} else {
				e.dropComplete(false);
			}
		} catch (Exception ex) {
			ex.printStackTrace();
			e.dropComplete(false);
		}
		
		dragging = false;
	}
	
	// The other events should be ignored
	//
	public void dragExit(DropTargetEvent e) {}
	
	public void dragOver(DropTargetDragEvent e) {
		changeSelectedCell(e.getLocation());
		dragging = true;
	}
	
	public void dropActionChanged(DropTargetDragEvent e) {}
	
	public void mouseDragged(java.awt.event.MouseEvent evt) {
		if (!dragging){
			dragging = true;
			startPoint = evt.getPoint();
		}
	}
	
	public void mouseMoved(java.awt.event.MouseEvent evt) {
		changeSelectedCell(evt.getPoint());
	}
	
}
