/*
 * Decompiled with CFR 0.152.
 */
package sos.math;

import java.util.Arrays;

public class Threshold {
    private static final double LOG2 = Math.log(2.0);
    public int[] thres = new int[3];
    public double[] q = new double[2];
    public double[][] classMu = new double[2][];
    public int min;
    public int max;
    public int offset;
    public int startPoint;
    public int runLength;
    private int[] histogram;
    private double[] omega;
    private double[] rho1;
    private double[] g1;
    final double c = Math.sqrt(Math.PI * 2);
    double likelihood;
    int nInput;
    int nUnit;
    double[] alpha;
    double[] myu;
    double[] var;
    public double[][] p;

    public final void setData(int[] rowData) {
        int i;
        this.initVariables();
        this.min = rowData[0];
        this.max = rowData[0];
        for (i = 0; i < rowData.length; ++i) {
            if (rowData[i] < this.min) {
                this.min = rowData[i];
            }
            if (this.max >= rowData[i]) continue;
            this.max = rowData[i];
        }
        this.offset = this.min;
        this.startPoint = 0;
        this.runLength = this.max - this.min + 1;
        this.histogram = new int[this.runLength];
        for (i = 0; i < rowData.length; ++i) {
            int n = rowData[i] - this.offset;
            this.histogram[n] = this.histogram[n] + 1;
        }
    }

    public final void setData(byte[] rowData) {
        int temp;
        int i;
        this.initVariables();
        this.min = rowData[0] & 0xFF;
        this.max = rowData[0] & 0xFF;
        for (i = 0; i < rowData.length; ++i) {
            temp = rowData[i] & 0xFF;
            if (temp < this.min) {
                this.min = temp;
            }
            if (this.max >= temp) continue;
            this.max = temp;
        }
        this.offset = this.min;
        this.startPoint = 0;
        this.runLength = this.max - this.min + 1;
        this.histogram = new int[this.runLength];
        for (i = 0; i < rowData.length; ++i) {
            int n = temp = rowData[i] & 255 - this.offset;
            this.histogram[n] = this.histogram[n] + 1;
        }
    }

    private final void initVariables() {
        this.thres[0] = 0;
        this.thres[1] = 0;
        this.thres[1] = 0;
        this.q[0] = 0.0;
        this.q[1] = 0.0;
    }

    public final void methodOtsu(boolean doTrinary) {
        int co = this.offset + this.startPoint;
        int nTotal = 0;
        for (int i = 0; i < this.runLength; ++i) {
            nTotal += this.histogram[i + this.startPoint];
        }
        this.omega = new double[this.runLength];
        double[] mu = new double[this.runLength];
        int cumHist = 0;
        int cumArea = 0;
        for (int i = 0; i < this.runLength; ++i) {
            this.omega[i] = (double)(cumHist += this.histogram[i + this.startPoint]) / (double)nTotal;
            mu[i] = (double)(cumArea += (i + co) * this.histogram[i + this.startPoint]) / (double)nTotal;
        }
        double rhoT = 0.0;
        for (int i = 0; i < this.runLength; ++i) {
            double difference = (double)(i + co) - mu[this.runLength - 1];
            rhoT += difference * difference * (double)this.histogram[i + this.startPoint];
        }
        this.classMu[0] = new double[2];
        this.binaryProcess(mu, rhoT /= (double)nTotal);
        if (doTrinary) {
            this.classMu[1] = new double[3];
            this.trinaryProcess(mu, rhoT);
        }
        this.omega = null;
        this.rho1 = null;
        this.g1 = null;
    }

    public final void methodOtsu(int limitMin, int limitMax, boolean doTrinary) {
        if (limitMin < this.offset) {
            limitMin = this.offset;
        }
        if (this.offset + this.histogram.length - 1 < limitMax) {
            limitMax = this.offset + this.histogram.length - 1;
        }
        this.startPoint = limitMin - this.offset;
        this.runLength = limitMax - limitMin + 1;
        this.methodOtsu(doTrinary);
    }

    public final void methodOtsuLog(int limitMin, int limitMax, boolean doTrinary) {
        if (limitMin < this.offset) {
            limitMin = this.offset;
        }
        if (this.offset + this.histogram.length - 1 < limitMax) {
            limitMax = this.offset + this.histogram.length - 1;
        }
        this.startPoint = limitMin - this.offset;
        this.runLength = limitMax - limitMin + 1;
        this.methodOtsuLog(doTrinary);
    }

    public final void methodOtsuLog(boolean doTrinary) {
        int co = this.offset + this.startPoint;
        int nTotal = 0;
        for (int i = 0; i < this.runLength; ++i) {
            nTotal += this.histogram[i + this.startPoint];
        }
        this.omega = new double[this.runLength];
        double[] mu = new double[this.runLength];
        int cumHist = 0;
        double cumArea = 0.0;
        for (int i = 0; i < this.runLength; ++i) {
            this.omega[i] = (double)(cumHist += this.histogram[i + this.startPoint]) / (double)nTotal;
            mu[i] = (cumArea += Math.log(i + co) * (double)this.histogram[i + this.startPoint]) / (double)nTotal;
        }
        double rhoT = 0.0;
        for (int i = 0; i < this.runLength; ++i) {
            double difference = Math.log(i + co) - mu[this.runLength - 1];
            rhoT += difference * difference * (double)this.histogram[i + this.startPoint];
        }
        this.classMu[0] = new double[2];
        this.binaryProcess(mu, rhoT /= (double)nTotal);
        if (doTrinary) {
            this.classMu[1] = new double[3];
            this.trinaryProcess(mu, rhoT);
        }
        this.omega = null;
        this.rho1 = null;
        this.g1 = null;
    }

    private final void binaryProcess(double[] mu, double rhoT) {
        this.rho1 = new double[this.runLength];
        this.g1 = new double[this.runLength];
        int k21 = 0;
        double maxrho = 0.0;
        for (int i = 0; i < this.runLength; ++i) {
            this.rho1[i] = mu[i] * mu[i] / this.omega[i];
            this.g1[i] = (mu[this.runLength - 1] - mu[i]) * (mu[this.runLength - 1] - mu[i]) / (1.0 - this.omega[i]);
            double temp = this.rho1[i] + this.g1[i];
            if (!(temp > maxrho)) continue;
            maxrho = temp;
            k21 = i;
        }
        this.thres[0] = k21 + this.offset + this.startPoint;
        this.classMu[0][0] = mu[k21] / this.omega[k21];
        this.classMu[0][1] = (mu[this.runLength - 1] - mu[k21]) / (1.0 - this.omega[k21]);
        this.q[0] = Math.log((maxrho -= mu[this.runLength - 1] * mu[this.runLength - 1]) / (rhoT - maxrho)) - Math.log(3.0);
    }

    private final void trinaryProcess(double[] mu, double rhoT) {
        int k31 = 0;
        int k32 = 0;
        double maxrho = 0.0;
        int k21 = this.thres[0] - this.offset - this.startPoint;
        for (int j = k21 + 1; j < this.runLength; ++j) {
            for (int i = 0; i <= k21; ++i) {
                double g2;
                double temp;
                if (!(this.omega[j] - this.omega[i] > 0.0) || !((temp = this.rho1[i] + this.g1[j] + (g2 = (mu[j] - mu[i]) * (mu[j] - mu[i]) / (this.omega[j] - this.omega[i]))) > maxrho)) continue;
                maxrho = temp;
                k31 = i;
                k32 = j;
            }
        }
        this.thres[1] = k31 + this.offset + this.startPoint;
        this.thres[2] = k32 + this.offset + this.startPoint;
        this.classMu[1][0] = mu[k31] / this.omega[k31];
        this.classMu[1][1] = (mu[k32] - mu[k31]) / (this.omega[k32] - this.omega[k31]);
        this.classMu[1][2] = (mu[this.runLength - 1] - mu[k32]) / (1.0 - this.omega[k32]);
        this.q[1] = Math.log((maxrho -= mu[this.runLength - 1] * mu[this.runLength - 1]) / (rhoT - maxrho)) - Math.log(8.0);
    }

    public final int methodEM(int n) {
        double preLikelihood;
        int i;
        this.startPoint = 1;
        --this.runLength;
        int co = this.startPoint + this.offset;
        this.nUnit = n;
        this.alpha = new double[this.nUnit];
        this.myu = new double[this.nUnit];
        this.var = new double[this.nUnit];
        this.p = new double[this.runLength][this.nUnit];
        this.nInput = 0;
        for (int i2 = 0; i2 < this.runLength; ++i2) {
            this.nInput += this.histogram[i2 + this.startPoint];
        }
        this.myu[0] = this.min;
        this.myu[1] = this.max;
        int half = this.runLength / 2;
        for (i = 0; i <= half; ++i) {
            this.alpha[0] = this.alpha[0] + (double)this.histogram[i + this.startPoint];
            this.var[0] = this.var[0] + ((double)(i + co) - this.myu[0]) * ((double)(i + co) - this.myu[0]) * (double)this.histogram[i + this.startPoint];
        }
        for (i = half + 1; i < this.runLength; ++i) {
            this.alpha[1] = this.alpha[1] + (double)this.histogram[i + this.startPoint];
            this.var[1] = this.var[1] + ((double)(i + co) - this.myu[1]) * ((double)(i + co) - this.myu[1]) * (double)this.histogram[i + this.startPoint];
        }
        int un = 0;
        while (un < this.nUnit) {
            int n2 = un;
            this.var[n2] = this.var[n2] / this.alpha[un];
            int n3 = un++;
            this.alpha[n3] = this.alpha[n3] / (double)this.nInput;
        }
        this.estimate();
        int iteration = 0;
        do {
            this.maximize();
            preLikelihood = this.likelihood;
            this.estimate();
        } while (this.likelihood - preLikelihood > 1.0E-6 && ++iteration <= 1000);
        int th = 0;
        for (int i3 = this.runLength - 1; i3 >= 0; --i3) {
            if (!(this.p[i3][0] > this.p[i3][1])) continue;
            th = i3 + co;
            break;
        }
        return th;
    }

    private final double gaussian(int i, int un) {
        double dif = (double)i - this.myu[un];
        return Math.exp(-0.5 * dif * dif / this.var[un]) / (this.c * Math.sqrt(this.var[un]));
    }

    private void estimate() {
        int co = this.offset + this.startPoint;
        this.likelihood = 0.0;
        for (int i = 0; i < this.runLength; ++i) {
            int un;
            double sumP = 0.0;
            for (un = 0; un < this.nUnit; ++un) {
                this.p[i][un] = this.alpha[un] * this.gaussian(i + co, un);
                if (this.p[i][un] > 0.0) {
                    sumP += this.p[i][un];
                    continue;
                }
                this.p[i][un] = 0.0;
            }
            this.likelihood += (double)this.histogram[i + this.startPoint] * Math.log(sumP);
            un = 0;
            while (un < this.nUnit) {
                double[] dArray = this.p[i];
                int n = un++;
                dArray[n] = dArray[n] / sumP;
            }
        }
        this.likelihood /= (double)this.nInput;
    }

    private void maximize() {
        int co = this.startPoint + this.offset;
        Arrays.fill(this.alpha, 0.0);
        Arrays.fill(this.myu, 0.0);
        Arrays.fill(this.var, 0.0);
        for (int i = 0; i < this.runLength; ++i) {
            for (int un = 0; un < this.nUnit; ++un) {
                int n = un;
                this.alpha[n] = this.alpha[n] + this.p[i][un] * (double)this.histogram[i + this.startPoint];
                int n2 = un;
                this.myu[n2] = this.myu[n2] + this.p[i][un] * (double)this.histogram[i + this.startPoint] * (double)(i + co);
            }
        }
        for (int un = 0; un < this.nUnit; ++un) {
            if (!(this.alpha[un] > 0.0)) continue;
            int n = un;
            this.myu[n] = this.myu[n] / this.alpha[un];
        }
        for (int i = 0; i < this.runLength; ++i) {
            for (int un = 0; un < this.nUnit; ++un) {
                double dif = (double)(i + co) - this.myu[un];
                int n = un;
                this.var[n] = this.var[n] + this.p[i][un] * (double)this.histogram[i + this.startPoint] * dif * dif;
            }
        }
        int un = 0;
        while (un < this.nUnit) {
            if (this.alpha[un] > 0.0) {
                int n = un;
                this.var[n] = this.var[n] / this.alpha[un];
            }
            int n = un++;
            this.alpha[n] = this.alpha[n] / (double)this.nInput;
        }
    }

    public final double calcEntropy() {
        int nTotal = 0;
        for (int i = 0; i < this.runLength; ++i) {
            nTotal += this.histogram[i + this.startPoint];
        }
        double[] occurence = new double[this.runLength];
        double entropy = 0.0;
        for (int i = 0; i < this.runLength; ++i) {
            occurence[i] = 1.0 * (double)this.histogram[i + this.startPoint] / (double)nTotal;
            if (!(occurence[i] > 0.0)) continue;
            entropy += -occurence[i] * Math.log(occurence[i]) / LOG2;
        }
        return entropy;
    }

    public final int[] getHistogram() {
        return this.histogram;
    }
}

