/*
 * Decompiled with CFR 0.152.
 */
package sos.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JColorChooser;
import sos.awt.JCanvas;

public class JCanvasColor
extends JCanvas {
    private static final Color unenabledColor = new Color(156, 154, 156);
    private Color color = new Color(0, 0, 0);
    private int[] RGB = new int[3];
    private boolean colorChoosable;

    public JCanvasColor() {
        this.setPreferredSize(new Dimension(100, 15));
        this.colorChoosable = true;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                JCanvasColor.this.showJColorChooser();
            }
        });
    }

    private void showJColorChooser() {
        if (this.isEnabled() && this.colorChoosable) {
            Color newColor = JColorChooser.showDialog(this, "Choose color...", this.getColor());
            this.setColor(newColor);
        }
    }

    public Color getColor() {
        return this.color;
    }

    protected int[] getColorArray() {
        return this.RGB;
    }

    public int getColorInt() {
        return this.color.getRGB();
    }

    public void setColor(int[] data) {
        this.RGB = data;
        this.color = new Color(this.RGB[0], this.RGB[1], this.RGB[2]);
        this.updateAndDraw();
    }

    public void setColor(Color value) {
        if (value != null) {
            this.color = value;
            this.RGB[0] = value.getRed();
            this.RGB[1] = value.getGreen();
            this.RGB[2] = value.getBlue();
            this.updateAndDraw();
        }
    }

    public void updateAndDraw() {
        Graphics g = this.getOffGraphics();
        if (g != null) {
            g.clearRect(20, 0, 99, 14);
            if (this.isEnabled()) {
                g.setColor(Color.black);
            } else {
                g.setColor(unenabledColor);
            }
            g.drawString("(" + this.RGB[0] + "," + this.RGB[1] + "," + this.RGB[2] + ")", 20, 11);
            g.drawLine(0, 0, 14, 0);
            g.drawLine(0, 0, 0, 14);
            g.setColor(this.color);
            g.fillRect(1, 1, 14, 14);
            this.repaint();
        }
        g.dispose();
    }

    public void setColorChoosable(boolean colorChoosable) {
        this.colorChoosable = colorChoosable;
    }
}

