#ifndef STRUCT_OPTION_FLAG_H
#define STRUCT_OPTION_FLAG_H

#include "struct_VList.h"

#include <sys/types.h>

typedef enum option_flag
{
	V_FIVE,	/* ベリファイ（MD5） */

	BEFORE,
	AFTER,

	SIZE_OR_TIME,
	NEW_TIME,
	OVERWRITE,
	NO_OVERWRITE,

	DRIVE_SAME,
	DRIVE_DIFFERENT,
	DRIVE_AUTO,

	INTERACTIVE,	/* 上書き確認 */

	LOG,	/* コンペアログ保存 */

	MOVE,	/* 移動モード */

	VERBOS,	/* コピー中ファイル名表示 */

	NOT,	/* オプション無効 */
	EXIST,	/* オプション有り */
} OPFlag;

typedef struct option_and_argument
{
	/* MD5ライブラリの引数がintなので、バッファサイズもintが上限 */
	int buffer_size;
	VList *b_size_list;

	OPFlag CHECK;
	OPFlag CHECK_MODE;	/* 1 or 2 */
	OPFlag WRITE_MODE;	/* 1 or 2 or 3 or 0*/
	OPFlag THREAD_MODE;	/* 1 or 2 or 0 */
	OPFlag I;
	OPFlag L;
	OPFlag M;
	OPFlag V;
	OPFlag EFFECT;

	int argc;	/* 引数の数。main()の仮引数を入れる。 */
	int src_index;	/* getoptのoptindを入れる */
	int dst_index;	/* argv[argc - 1] */
	char **argv;	/* main()の仮引数を入れる。 */
} OPArg;

#endif
