/*
 * ファイルのコピーを行う。
 * 一部、copybench-1.0（New BSD License）を参考にした。
 */
#define _GNU_SOURCE

#ifdef _DEBUG_FLAG
#define USE_O_DIRECT_SIZE 1
#endif
#ifndef _DEBUG_FLAG
#define USE_O_DIRECT_SIZE 1024 * 1024 * 1 + 1
#endif

#define OPEN_CHECK_DST \
{\
	errno = 0;\
	if((is_dio_write == false) || (src_size_local < USE_O_DIRECT_SIZE))\
	{\
		idst = open(cpinfo->dst, O_CREAT | O_WRONLY | O_TRUNC, S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH);\
		is_dio_dst = false;\
	}\
	else \
	{\
		idst = open(cpinfo->dst, O_CREAT | O_WRONLY | O_TRUNC | O_DIRECT, S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH);\
		is_dio_dst = true;\
	}\
\
	if(idst == -1)\
	{\
		is_dio_dst = false;\
		print_error("open", cpinfo->dst, __FILE__, __LINE__, cpdd);\
	}\
	else \
	{\
		write_now = cpinfo->dst;	/* signalハンドラ用 */\
		is_open_dst = true;\
\
		if(cpdd->mk_file_count <= ULLONG_MAX)\
		{\
			cpdd->mk_file_count++;\
		}\
	}\
}

#define MD5_FINISH \
{\
	md5_finish(&state, digest);\
	char *hex_output = xmalloc((16 * 2) + 1);\
\
	for(int di = 0; di < 16; ++di)\
	{\
		sprintf(hex_output + di * 2, "%02x", digest[di]);\
	}\
\
	cpinfo->src_md5 = hex_output;\
}

#include "ch_time_and_mod.h"
#include "gettext.h"
#include "print_error.h"
#include "struct_CPDD.h"
#include "struct_CPInfo.h"
#include "struct_OPArg.h"
#include "xmalloc.h"

#include "md5.h"

#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>

#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <linux/falloc.h>
#include <pthread.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <unistd.h>

struct verify_data
{
	md5_state_t *state;
	void *buffer;
	int len;
};

static void *buf[2];
static off_t src_size_local;
static off_t total_read_local;
static off_t total_write_local;
static int isrc;
static int idst;
static int ri;	// index number
static int wi;	// index number
static _Bool is_write_error;

static long p_size;
static _Bool is_verify;

/* ※注意。グローバル変数。 */
char *write_now;

/* 関数プロトタイプ */
void read_write(const OPArg *oparg, CPInfo *cpinfo, CPDD *cpdd);
static inline void rw(const OPArg *oparg, CPInfo *cpinfo, CPDD *cpdd, _Bool is_dio_src, _Bool is_dio_dst);
static void * write_normal(void *cpcp);
static void * write_dio(void *cpcp);
static void * do_md5_append(void *tmp);

/*******************************************************************************
*******************************************************************************/
void read_write(const OPArg *oparg, CPInfo *cpinfo, CPDD *cpdd)
{
	static _Bool is_check_filesystem = false;
	static _Bool is_support_fallocate = false;
	static _Bool is_dio_write = false;
	static _Bool is_check_verify = false;

	_Bool is_open_src = false;
	_Bool is_open_dst = false;
	_Bool is_stat_src = false;
	_Bool is_dio_src = false;
	_Bool is_dio_dst = false;
	int return_dst_ftruncate = 0;

	src_size_local = 0;
	total_read_local = 0;
	total_write_local = 0;
	isrc = 0;
	idst = 0;
	ri = 0;
	wi = 0;
	is_write_error = false;

	if(p_size == 0)
	{
		p_size = sysconf(_SC_PAGESIZE);
	}

	if(is_check_verify == false)
	{
		if(oparg->CHECK == V_FIVE)
		{
			is_verify = true;
		}

		is_check_verify = true;
	}

	if(is_check_filesystem == false)
	{
		char *tmp = cpinfo->dstfs;

		if(tmp != NULL)
		{
			if
			(
				((tmp[0] == 'e') && (tmp[1] == 'x') && (tmp[2] == 't') && (tmp[3] == '4'))
				||
				((tmp[0] == 'b') && (tmp[1] == 't') && (tmp[2] == 'r') && (tmp[3] == 'f') && (tmp[4] == 's'))
				||
				((tmp[0] == 'o') && (tmp[1] == 'c') && (tmp[2] == 'f') && (tmp[3] == 's') && (tmp[4] == '2'))
			)
			{
				is_support_fallocate = true;
			}
			else if((tmp[0] == 'x') && (tmp[1] == 'f') && (tmp[2] == 's'))
			{
				is_support_fallocate = true;
				is_dio_write = true;
			}
		}

		is_check_filesystem = true;
	}

	if(cpinfo->copy_mode == SAME)
	{
		if(strcmp(cpinfo->src, cpinfo->dst) == 0)
		{
			fprintf(stderr, _("%s と %s は同じファイルです\n"), cpinfo->src, cpinfo->dst);
			return;
		}
	}

	errno = 0;
	if((isrc = open(cpinfo->src, O_RDONLY | O_NOATIME | O_DIRECT)) == -1)
	{
		_Bool b = true;

		if(errno == EPERM) /* O_NOATIME */
		{
			errno = 0;
			if((isrc = open(cpinfo->src, O_RDONLY | O_DIRECT)) == -1)
			{
				b = false;
			}
			else
			{
				is_open_src = true;
				is_dio_src = true;
			}
		}
		else if(errno == EINVAL) /* O_DIRECT */
		{
			errno = 0;
			if((isrc = open(cpinfo->src, O_RDONLY | O_NOATIME)) == -1)
			{
				b = false;
			}
			else
			{
				is_open_src = true;
			}
		}
		else
		{
			print_error("open", cpinfo->src, __FILE__, __LINE__, cpdd);
		}

		if(b == false)
		{
			if((isrc = open(cpinfo->src, O_RDONLY)) == -1)
			{
				print_error("open", cpinfo->src, __FILE__, __LINE__, cpdd);
			}
			else
			{
				is_open_src = true;
			}
		}
	}
	else
	{
		is_open_src = true;
		is_dio_src = true;
	}

	static struct stat stat_buf;

	if(is_open_src == true)
	{
		errno = 0;
		if(fstat(isrc, &stat_buf) == -1)
		{
			print_error("fstat", cpinfo->src, __FILE__, __LINE__, cpdd);
		}
		else
		{
			is_stat_src = true;
			src_size_local = stat_buf.st_size;

			if(src_size_local > 0)
			{
				cpdd->total_source += src_size_local;
			}
		}

		if((cpinfo->file_test == false) || (oparg->WRITE_MODE == OVERWRITE))
		{
			OPEN_CHECK_DST
		}
		else if(is_stat_src == true)
		{
			struct stat stat_dst;

			errno = 0;
			if(stat(cpinfo->dst, &stat_dst) == -1)
			{
				print_error("stat", cpinfo->dst, __FILE__, __LINE__, cpdd);

				if(errno == ENOENT)
				{
					OPEN_CHECK_DST
				}
			}
			else
			{
				if(oparg->WRITE_MODE == SIZE_OR_TIME)
				{
					if((stat_buf.st_size != stat_dst.st_size) || (stat_buf.st_mtime != stat_dst.st_mtime))
					{
						OPEN_CHECK_DST
					}
					else
					{
						cpinfo->dst_para = SKIP;
					}
				}
				else
				{
					if((stat_buf.st_mtime > stat_dst.st_mtime))
					{
						OPEN_CHECK_DST
					}
					else
					{
						cpinfo->dst_para = SKIP;
					}
				}
			}
		}
	}

	/*
	 * ファイルシステムがfallocateをサポートしている場合、それを実行して領域を確保する。
	 * 
	 * posix_fallocateはext4以外の、それをサポートしていないファイルシステムだとかなり遅くなる様子。
	 * ext4だと4秒弱で終わるフォルダのコピーが、
	 * ntfsだと12秒はかかる（何もしないと6秒弱、pwriteだと8秒ほど、ftruncateは何もしない場合とほぼ同じ）。
	 */
	if((src_size_local > 0) && (is_open_dst == true) && (is_support_fallocate == true))
	{
		/* Ubuntu 11.04だとfallocateの第二引数は FALLOC_FL_KEEP_SIZE と FALLOC_FL_PUNCH_HOLE の二つ。linux/falloc.h のincludeが必要。 */
		if(fallocate(idst, FALLOC_FL_KEEP_SIZE, 0, src_size_local) == -1)
		{
			print_error("fallocate", cpinfo->dst, __FILE__, __LINE__, cpdd);

			if(close(isrc) == -1)
			{
				print_error("close", cpinfo->src, __FILE__, __LINE__, cpdd);
			}
			else
			{
				is_open_src = false;
			}

			if(close(idst) == -1)
			{
				print_error("close", cpinfo->dst, __FILE__, __LINE__, cpdd);
			}
			else
			{
				is_open_dst = false;
			}
		}
/*
		if((int i = posix_fallocate(idst, 0, src_size_local)) != 0)
		{
			errno = i;
			print_error("posix_fallocate", __FILE__, __LINE__, cpdd);
		}
*/
	}

	/* コピー開始 */
	if((src_size_local > 0) && (is_open_dst == true))
	{
		if(oparg->V == VERBOS)
		{
			printf(_("%s -> %s\n"), cpinfo->src, cpinfo->dst);
			fflush(stdout);
		}

		rw(oparg, cpinfo, cpdd, is_dio_src, is_dio_dst);

		if((is_dio_dst == true) && (src_size_local < total_write_local))
		{
			if(ftruncate(idst, src_size_local) == -1)
			{
				print_error("ftruncate", cpinfo->dst, __FILE__, __LINE__, cpdd);
			}
		}
	}
	else if((src_size_local == 0) && (is_open_dst == true))
	{
		/* open時にO_TRUNCするようにしたので、ここの処理は必要ない気がする。 */
		if(ftruncate(idst, 0) == -1)
		{
			return_dst_ftruncate = -1;
			print_error("ftruncate", cpinfo->dst, __FILE__, __LINE__, cpdd);
		}

		if(is_verify == true)
		{
			md5_state_t state;
			md5_byte_t digest[16];
			md5_byte_t buffer[1];
			digest[0] = '\0';
			buffer[0] = '\0';

			md5_init(&state);

			md5_append(&state, buffer, 0);

			MD5_FINISH
		}
	}

	if((is_stat_src == true) && (is_open_dst == true))
	{
		ch_time_and_mod(&idst, &stat_buf, cpinfo, cpdd);
	}

/*
 * ext4でfdatasyncするようにしたら、30倍遅くなった。

	if((oparg->CHECK != NOT) && (is_support_fallocate == true))
	{
		if(fdatasync(idst) == -1)
		{
			print_error("fdatasync", __FILE__, __LINE__, cpdd);
		}
	}
*/

	if(is_open_src == true)
	{
		if(is_dio_src == false)
		{
			if(posix_fadvise(isrc, 0, 0, POSIX_FADV_DONTNEED) == -1)
			{
				print_error("posix_fadvise", cpinfo->src, __FILE__, __LINE__, cpdd);
			}
		}

		if(close(isrc) == -1)
		{
			print_error("close", cpinfo->src, __FILE__, __LINE__, cpdd);
		}
	}

	if(is_open_dst == true)
	{
		if(is_dio_dst == false)
		{
			if(posix_fadvise(idst, 0, 0, POSIX_FADV_DONTNEED) == -1)
			{
				print_error("posix_fadvise", cpinfo->dst, __FILE__, __LINE__, cpdd);
			}
		}

		if(close(idst) == -1)
		{
			print_error("close", cpinfo->dst, __FILE__, __LINE__, cpdd);
		}
	}

	write_now = NULL;
	cpinfo->src_size = src_size_local;

	if(total_read_local > 0)
	{
		cpdd->total_read += total_read_local;
	}

	if(total_write_local > 0)
	{
		cpinfo->dst_size = total_write_local;
		cpdd->total_write += total_write_local;
	}

	if(
		((is_open_src == true) && (is_open_dst == true))
		&&
		(((0 < src_size_local) && (src_size_local <= total_write_local)) || ((src_size_local == 0) && (return_dst_ftruncate == 0)))
	)
	{
		cpinfo->dst_para = WRITE;
	}
	else
	{
		cpinfo->dst_para = INITIAL;
	}
}

/*******************************************************************************
*******************************************************************************/
#define SET_READ_SIZE \
	if(read_remainder > buffer_size)\
	{\
		r_size = w_size = buffer_size;\
	}\
	else \
	{\
		surplus = read_remainder % p_size;\
\
		if(surplus == 0)\
		{\
			r_size = w_size = read_remainder;\
		}\
		else if(surplus == read_remainder)\
		{\
			r_size = w_size = p_size;\
		}\
		else \
		{\
			r_size = read_remainder + p_size - surplus;\
			w_size = r_size;\
		}\
	}
/*			r_size = read_remainder - surplus;\*/

/*******************************************************************************
*******************************************************************************/
typedef struct CPInfo_and_CPDD
{
	off_t w_size;
	CPInfo *cpinfo;
	CPDD *cpdd;
} CPCP;

/*******************************************************************************
*******************************************************************************/
static inline void rw(const OPArg *oparg, CPInfo *cpinfo, CPDD *cpdd, _Bool is_dio_src, _Bool is_dio_dst)
{
	int buffer_size;

	{
		VList *b_size_list = oparg->b_size_list;
		b_size_list = b_size_list->tail;

		int *i = (int *)b_size_list->data;
		int low = *i;

		b_size_list = b_size_list->prev;
		int high;

		for(;;)
		{
			i = (int *)b_size_list->data;
			high = *i;

			if(high > src_size_local)
			{
/*				buffer_size = low;*/
				buffer_size = high;
				break;
			}
			else if(b_size_list->prev == NULL)
			{
				buffer_size = oparg->buffer_size;
				break;
			}
			else
			{
				low = high;
				b_size_list = b_size_list->prev;
			}
		}
	}

	if((posix_memalign((void **)&buf[0], p_size, buffer_size) != 0) || (posix_memalign((void **)&buf[1], p_size, buffer_size) != 0))
	{
		print_error("posix_memalign", cpinfo->dst, __FILE__, __LINE__, cpdd);
	}
	else
	{
		md5_state_t state;
		md5_byte_t digest[16];
		digest[0] = '\0';

		if(is_verify == true)
		{
			md5_init(&state);
		}

		off_t read_remainder;
		long surplus; /* p_sizeの型と同じにする */
		off_t r_size;
		off_t w_size;

		read_remainder = src_size_local - total_read_local;

		SET_READ_SIZE

		if(is_dio_src == false)
		{
			if(posix_fadvise(isrc, 0, 0, POSIX_FADV_SEQUENTIAL) == -1)
			{
				print_error("posix_fadvise", cpinfo->src, __FILE__, __LINE__, cpdd);
			}
		}

		ri = 0;
		wi = 1;
		int swap;
		off_t r;

		if((r = read(isrc, buf[ri], r_size)) > 0)
		{
			total_read_local += r;

			_Bool is_file_small = false;
			_Bool is_thread = false;

			if(src_size_local < USE_O_DIRECT_SIZE)
			{
				is_file_small = true;
			}

			if((is_file_small == false) && (cpinfo->copy_mode == DIFFERENT))
			{
				is_thread = true;
				cpdd->thread_mode_count++;
			}

			struct verify_data thread_argument;
			pthread_t t_verify;
			pthread_t t_write;

			for(;;)
			{
				swap = ri;
				ri = wi;
				wi = swap;

				if(is_verify == true)
				{
					thread_argument.state = &state;
					thread_argument.buffer = buf[wi];
					thread_argument.len = r;

					pthread_create(&t_verify, NULL, do_md5_append, (void *)&thread_argument);
				}

				if(is_dio_dst == false)
				{
					CPCP cpcp = {r, cpinfo, cpdd};

					if(is_thread == true)
					{
						pthread_create(&t_write, NULL, write_normal, (void *)&cpcp);
					}
					else
					{
						write_normal((void *)&cpcp);
					}
				}
				else
				{
					CPCP cpcp = {w_size, cpinfo, cpdd};

					if(is_thread == true)
					{
						pthread_create(&t_write, NULL, write_dio, (void *)&cpcp);
					}
					else
					{
						write_dio((void *)&cpcp);
					}
				}

				read_remainder = src_size_local - total_read_local;

				if(read_remainder < 0)
				{
					read_remainder = 0;
				}

				SET_READ_SIZE
/*
				if(is_dio_src == false)
				{
					if(posix_fadvise(isrc, total_read_local, r_size, POSIX_FADV_SEQUENTIAL) == -1)
					{
						print_error("posix_fadvise", __FILE__, __LINE__, cpdd);
						fprintf(stderr, _("error : %s\n"), cpinfo->src);
					}
				}
*/
				r = read(isrc, buf[ri], r_size);

				if(is_verify == true)
				{
					pthread_join(t_verify, NULL);
				}

				if(is_thread == true)
				{
					pthread_join(t_write, NULL);
				}

				if((r == 0) || (is_write_error == true))
				{
					break;
				}
				else if(r == -1)
				{
					print_error("read", cpinfo->src, __FILE__, __LINE__, cpdd);
					break;
				}
				else
				{
					total_read_local += r;
				}
			}
		}
		else if(r == -1)
		{
			print_error("read", cpinfo->src, __FILE__, __LINE__, cpdd);
		}

		if(is_verify == true)
		{
			MD5_FINISH
		}
	}

	if(buf[0] != NULL)
	{
		free(buf[0]);
		buf[0] = NULL;
	}

	if(buf[1] != NULL)
	{
		free(buf[1]);
		buf[1] = NULL;
	}
}

/*******************************************************************************
*******************************************************************************/
static void * write_normal(void *cpcp_tmp)
{
	CPCP *cpcp = cpcp_tmp;
	off_t w;
	char *tmp = buf[wi];
	const char * const endp = tmp + cpcp->w_size;

	while(tmp < endp)
	{
		errno = 0;
		if((w = write(idst, tmp, endp - tmp)) == -1)
		{
			is_write_error = true;
			print_error("write", cpcp->cpinfo->dst, __FILE__, __LINE__, cpcp->cpdd);
			break;
		}

		if(sync_file_range(idst, total_write_local, w, SYNC_FILE_RANGE_WAIT_BEFORE | SYNC_FILE_RANGE_WRITE | SYNC_FILE_RANGE_WAIT_AFTER) == -1)
		{
			print_error("sync_file_range", cpcp->cpinfo->dst, __FILE__, __LINE__, cpcp->cpdd);
		}

		tmp += w;
		total_write_local += w;
	}

	return NULL;
}

/*******************************************************************************
*******************************************************************************/
static void * write_dio(void *cpcp_tmp)
{
	CPCP *cpcp = cpcp_tmp;
	off_t w;

	if((w = write(idst, buf[wi], cpcp->w_size)) == -1)
	{
		is_write_error = true;
		print_error("write", cpcp->cpinfo->dst, __FILE__, __LINE__, cpcp->cpdd);
	}
	else
	{
		total_write_local += w;
	}

	return NULL;
}

/*******************************************************************************
 * ベリファイ用
*******************************************************************************/
static void * do_md5_append(void *tmp)
{
	struct verify_data *vd = tmp;

	md5_append(vd->state, vd->buffer, vd->len);

	return NULL;
}
