#include "append_list.h" // inline
#include "struct_DPath.h"
#include "xmalloc.h" // inline

#include <string.h>

#include <linux/limits.h>

// 関数プロトタイプ
VList * get_drive_list(void);

/*******************************************************************************
 * /etc/mtabを参照してドライブのリストを作成する。
 * 
 * ファイルシステムのチェックをしないなら、
 * いちいちmtab開かなくてもst_devを参照することで同一HDDかどうか調べられるっぽい？
 * ↑試してみたけど、同一HDDでも別ファイルシステムの場合、st_devの値も変わるので×。
 * あとst_devの型はdev_tだが__dev_tのtypedefで、元はlong long intっぽい。
*******************************************************************************/
VList * get_drive_list(void)
{
	DPath *drive_path = NULL;
	VList *drive_list = NULL;
	FILE *mtab;

	if((mtab = fopen("/etc/mtab", "r")) == NULL)
	{
		fprintf(stderr, "mtabのオープンに失敗しました\n");
		exit(EXIT_FAILURE);
	}
	else
	{
		// mtabの一行の最大長をPATH_MAXの3倍と仮定
		int mtab_line = PATH_MAX * 3;
		char mtab_buf[mtab_line];

		while(fgets(mtab_buf, mtab_line, mtab) != NULL)
		{
			if(strncmp("/dev/sd", mtab_buf, 7) == 0)
			{
				char *tmp = strtok(mtab_buf, " ");
				int len = strlen(tmp);
				int lenp1 = (len + 1);
				drive_path = xmalloc(sizeof(drive_path));
				drive_path->device = xmalloc(lenp1);
//				strcpy(drive_path->device, tmp);
				memcpy(drive_path->device, tmp, lenp1);
				// 一文字短く　例：/dev/sda1　→　/dev/sda
				drive_path->device[len - 1] = '\0';

				tmp = strtok(NULL, " ");
				drive_path->mount_point = xmalloc(strlen(tmp) + 1);
				strcpy(drive_path->mount_point, tmp);

				tmp = strtok(NULL, " ");
				drive_path->fs = xmalloc(strlen(tmp) + 1);
				strcpy(drive_path->fs, tmp);

				drive_list = append_list(drive_list, (void *)drive_path);
			}
		}
		fclose(mtab);
	}

	return drive_list;
}
