#include "global.h"
#include "struct.h"
#include "enum.h"

#include "create_symbolink.h"
#include "dir_traverse.h"
#include "log.h"
#include "rw_thread.h"
#include "rw_thread_d.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/stat.h>
#include <glib.h>

// 関数プロトタイプ
void lets_begin(UNList *cp_list);

/*******************************************************************************
連結リストを読み込み、コピー関数に渡す。
*******************************************************************************/
void lets_begin(UNList *cp_list)
{
	UNList *list_temp = cp_list;
	char overwrite = 'i';
	char stdin_buf[PATH_LEN];
	stdin_buf[0] = '\0';
	char *this_dir = NULL;
	for(int loop = 0;;)
	{
		struct cp_target *cp_tmp = (struct cp_target *)list_temp->data;

		if(V == VERBOS)
		{
			printf("type %c : %s", cp_tmp->file_type, cp_tmp->from);
			printf(" -> %s\n", cp_tmp->to);
		}

		if(cp_tmp->file_type == DIRECTORY)
		{
			errno = 0;
			if(g_file_test(cp_tmp->to, G_FILE_TEST_EXISTS) == TRUE)
			{
				// フォルダの作成は行わない
			}
			else if(mkdir(cp_tmp->to, 0755) == -1)
			{
				if((errno != EEXIST) && (errno != 0))
				{
					log_errors(__FILE__, __LINE__, errno, cp_tmp->to);
					fprintf(stderr, "フォルダの作成に失敗しました\n");
					errno = 0;
				}
			}
		}
		else
		{
			// -n（非上書き）モード
			if((N == NOT_OVERWRITE) && (g_file_test(cp_tmp->to, G_FILE_TEST_EXISTS) == TRUE))
			{
				// コピーしない
				cp_tmp->write = NOT_WRITE;
			}
			// -i（上書き確認）モード
			else if((I == INTERACTIVE) && (g_file_test(cp_tmp->to, G_FILE_TEST_EXISTS) == TRUE))
			{
				if(overwrite == 'i')
				{
				// ここの処理はgoto使わずに関数にまとめた方が分かりやすいかもしれない
				INPUT:
					printf("%sは既に存在します。\n", cp_tmp->to);
					puts("上書きしますか? (y: Yes  a: 全てYes  d: このフォルダのみYes  n: No  o: このフォルダのみNo  z: 全てNo)");
					printf(" : ");
					fgets(stdin_buf, PATH_LEN, stdin);
					if((stdin_buf[0] == '\n') || (stdin_buf[0] == '\0'))
					{
						// goto使ってもいいじゃんか
						goto INPUT;
					}
					{
						// バッファチェック
						int a = 0;
						for(int i = 1; i < PATH_LEN; i++)
						{
							if(stdin_buf[i] == '\n')
							{
								a++;
								break;
							}
						}
						if(a == 0)
						{
							// 入力バッファの掃除
							while(getchar() != '\n');
						}
						// ↑のバッファの掃除、Wikipediaにサンプルソースが載ってた↓。

						/* 改行文字が含まれているかの確認 */
						//if (strchr(a, '\n') != NULL) {
						/* 改行文字を終端記号に置換する */
						//a[strlen(a) - 1] = '\0';
						//} else {
						/* 入力ストリームをクリアする */
						//while(getchar() != '\n');
						//}

						// あーそうか、strchrを使えばいいのか。
					}
					// (笑)
					if(stdin_buf[0] != 'y')
					{
						if(stdin_buf[0] != 'a')
						{
							if(stdin_buf[0] != 'd')
							{
								if(stdin_buf[0] != 'n')
								{
									if(stdin_buf[0] != 'o')
									{
										if(stdin_buf[0] != 'z')
										{
											// 入力をループ
											goto INPUT;
										}
									}
								}
							}
						}
					}

					switch(stdin_buf[0])
					{
					// 上書き
					case 'y':
						cp_tmp->write = WRITE;
						if(cp_tmp->file_type == REGULAR)
						{
							(D == NOT) ? rw_thread(cp_tmp) : rw_thread_d(cp_tmp);
						}
						else
						{
							create_symbolink(cp_tmp);
						}
						break;
					// 全て上書き
					case 'a':
						// 上書き確認モード無効
						I = NOT;
						cp_tmp->write = WRITE;
						if(cp_tmp->file_type == REGULAR)
						{
							(D == NOT) ? rw_thread(cp_tmp) : rw_thread_d(cp_tmp);
						}
						else
						{
							create_symbolink(cp_tmp);
						}
						break;
					// このフォルダでのみ上書き
					case 'd':
						overwrite = 'd';
						if(this_dir != NULL)
							free(this_dir);
						this_dir = g_path_get_dirname(cp_tmp->from);
						if(cp_tmp->file_type == REGULAR)
						{
							(D == NOT) ? rw_thread(cp_tmp) : rw_thread_d(cp_tmp);
						}
						else
						{
							create_symbolink(cp_tmp);
						}
						break;
					// 上書きしない
					case 'n':
						cp_tmp->write = NOT_WRITE;
						break;
					// このフォルダでは上書きしない
					case 'o':
						overwrite = 'o';
						cp_tmp->write = NOT_WRITE;
						if(this_dir != NULL)
							free(this_dir);
						this_dir = g_path_get_dirname(cp_tmp->from);
						break;
					// 全て上書きしない
					case 'z':
						// 非上書きモード
						N = NOT_OVERWRITE;
						// 上書き確認モード無効
						I = NOT;
						cp_tmp->write = NOT_WRITE;
						break;
					}
				}
				// このフォルダのみYesモード
				else if(overwrite == 'd')
				{
					if(strstr(cp_tmp->from, this_dir) != NULL)
					{
						cp_tmp->write = WRITE;
						if(cp_tmp->file_type == REGULAR)
						{
							(D == NOT) ? rw_thread(cp_tmp) : rw_thread_d(cp_tmp);
						}
						else
						{
							create_symbolink(cp_tmp);
						}
					}
					else
					{
						// 再び上書き確認モードに
						overwrite = 'i';
						goto INPUT;
					}
				}
				// このフォルダのみNoモード
				else if(overwrite == 'o')
				{
					if(strstr(cp_tmp->from, this_dir) != NULL)
					{
						cp_tmp->write = NOT_WRITE;
					}
					else
					{
						// 再び上書き確認モードに
						overwrite = 'i';
						goto INPUT;
					}
				}
			}
			// 標準（強制上書き）モード
			else
			{
				cp_tmp->write = WRITE;
				if(cp_tmp->file_type == REGULAR)
				{
					(D == NOT) ? rw_thread(cp_tmp) : rw_thread_d(cp_tmp);
				}
				else
				{
					create_symbolink(cp_tmp);
				}
			}
		}

		loop++;
		if(loop == cp_file_count_all)
			break;
		list_temp = list_temp->next;
	}

	if(this_dir != NULL)
		free(this_dir);
}
