#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <getopt.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "param_conv.h"
#include "hex_split.h"

int main(int argc ,char **argv){
	int c;
	int digit_optind = 0;
	int out =0,in =0;
	int this_option_optind ;
	int option_index ;
	//hex_use 
	int ret,i,offset;
	char buff[500];
	unsigned char mem[30000];
	
	while (1) {
		this_option_optind = optind ? optind : 1;
		option_index = 0;
		static struct option long_options[] = {
			{"add", 1, 0, 0},
			{"append", 0, 0, 0},
			{"delete", 1, 0, 0},
			{"verbose", 0, 0, 0},
			{"create", 1, 0, 'c'},
			{"file", 1, 0, 0},
			{0, 0, 0, 0}
		};

		c = getopt_long (argc, argv, "d::i:o:012",
				long_options, &option_index);
		if (c == -1)
			break;

		switch (c) {
			case 0:
				printf ("option %s", long_options[option_index].name);
				if (optarg)
					printf (" with arg %s", optarg);
				printf ("\n");
				break;

			case 'i':
				printf ("option i with value '%s'\n", optarg);
				in = open(optarg,O_RDONLY);
				break;

			case 'o':
				printf ("option o with value '%s'\n", optarg);
				//out = fopen(optarg,O_RDWR);
				out = fopen(optarg,"w+");
				break;

		}
	}
	if(in  < 0){printf("input file err\n"); return -1;}
	if(out < 0){printf("output file err\n"); return -1;}
	else if(out == 0){
		out = stdout;
	}
	while(1){
		ret = read_line(in,buff);
		if(ret < 0){printf("read_line err\n"); return -1;}
		fprintf(stderr,"src =%s\n",buff);
		
		ret = hex_to_mem(buff,mem);
		
		if(ret == STD_END){
			fprintf(stderr,"offset is %x\n",offset);
			for(i=0;i < offset;i++){
				fprintf(out,"%02x",mem[i]);
				if(i%4 ==3)
				fprintf(out,"\n");
			}
			return 0;
		}else{
			fprintf(stderr,"ret is %d\n",ret);
			if(ret < 0){fprintf(stderr,"hex to mem err\n"); return -1;}
			offset = ret;
			fprintf(stderr,"offset is %x\n",offset);
		}
		
	}
	return 0;
}
