module main;
parameter STEP=2;
integer disp=1;
integer i,j,vcd;
reg p_reset, m_clock,mm_clock;
reg [31:0] imem [0:1023];
reg [31:0] dmem [0:1023];
reg [31:0] inst,datai;
reg [7:0] led,sw;
wire [31:0]	datao,iadrs,adrs;

wire	inst_read,inst_write,
	memory_read,memory_write,wb,hlt;

inst_fetch cpu( .p_reset(p_reset), .m_clock(m_clock),.instruction(inst),.mem_in(datai),
	.mem_out(datao), .i_address(iadrs),.mem_address(adrs),
	.instrread(inst_read),.instrwrite(inst_write),
	.wd(wb),.hlt(hlt));

always #(STEP/2) m_clock=~m_clock;
always #(STEP) mm_clock=~mm_clock;

always @(negedge m_clock) begin
	if(disp == 0)
	begin
	$write("PC:%x ",cpu.i_address);
	$write(" -- ");
	$write("inst:%x ",cpu.instruction);
	$write("\n");
	if(cpu.instruction[31:29] == 3'b000) 
	begin
		if(cpu.instruction[28:26] == 3'b000)
		begin
			if(cpu.instruction[6:3] == 3'b101)
			begin
				if(cpu.instruction[2:0] == 3'b000)
					$write("seq %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
				if(cpu.instruction[2:0] == 3'b001)
					$write("sne %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
				if(cpu.instruction[2:0] == 3'b010)
					$write("slt %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
				if(cpu.instruction[2:0] == 3'b011)
					$write("sgt %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
				if(cpu.instruction[2:0] == 3'b100)
					$write("sle %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
				if(cpu.instruction[2:0] == 3'b101)
					$write("sge %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
			end
			if(cpu.instruction[6:3] == 3'b100)
			begin
				if(cpu.instruction[2:0] == 3'b000)
					$write("add %d %d = %d",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
				if(cpu.instruction[2:0] == 3'b001)
					$write("addu %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
				if(cpu.instruction[2:0] == 3'b010)
					$write("sub %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
				if(cpu.instruction[2:0] == 3'b011)
					$write("subu %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
				if(cpu.instruction[2:0] == 3'b100)
					$write("and %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
				if(cpu.instruction[2:0] == 3'b101)
					$write("or %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
				if(cpu.instruction[2:0] == 3'b110)
					$write("xor %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
			end
		end
		if(cpu.instruction[28:26] == 3'b001)
			$write("fpu op ");
	end	
	if(cpu.instruction[31:29] == 3'b001)
	begin
		if(cpu.instruction[28:26] == 3'b000)
			$write("addi %d + %d = %d",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b001)
			$write("addui %d + %d = %d",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b010)
			$write("subi %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b011)
			$write("subui %d %d = %d",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b100)
			$write("andi %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b101)
			$write("ori %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b110)
			$write("xori %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b111)
			$write("LHI %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
	end
	if(cpu.instruction[31:29] == 3'b010)
	begin
		if(cpu.instruction[28:26] == 3'b000)
			$write("addi %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b001)
			$write("addui %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b010)
			$write("subi %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b011)
			$write("subui %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b100)
			$write("andi %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b101)
			$write("ori %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b110)
			$write("xori %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b111)
			$write("LHI %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
	end
	if(cpu.instruction[31:29] == 3'b011)
	begin
		if(cpu.instruction[28:26] == 3'b000)
			$write("seqi %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b001)
			$write("snei %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b010)
			$write("slti %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b011)
			$write("sgti %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b100)
			$write("slei %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b101)
			$write("sgei %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		end
	if(cpu.instruction[31:29] == 3'b100)
	begin
		if(cpu.instruction[28:26] == 3'b000)
			$write("LB    %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b001)
			$write("LH    %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b010)
			$write(" %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b011)
			$write("LW %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b100)
			$write("LBU %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b101)
			$write("LHU %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b110)
			$write("LF %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b111)
			$write("LD %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
	end
	if(cpu.instruction[31:29] == 3'b101)
	begin
		if(cpu.instruction[28:26] == 3'b000)
			$write("SB    %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b001)
			$write("SH    %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b010)
			$write(" %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b011)
			$write("SW %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b100)
			$write("ERR!!!!!!!!!!!!!!!!!!!!!!!!!");
		if(cpu.instruction[28:26] == 3'b101)
			$write("ERR!!!!!!!!!!!!!!!!!!!!!!!!!");
		if(cpu.instruction[28:26] == 3'b110)
			$write("SF %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
		if(cpu.instruction[28:26] == 3'b111)
			$write("SD %x %x = %x",cpu.src_reg_data1,cpu.src_reg_data2,cpu.dist_reg_data1);
	end

	$write("\n");
	end
end

always @(negedge mm_clock)
begin
	if((memory_read)&&(adrs[15]==0))
		datai <= dmem[adrs[31:2]];
	if((memory_read)&&(adrs[15]==1))
		datai <= {'h00,sw};
	if (memory_write)
		if(adrs[31]==0)
			dmem[adrs[31:2]] <= datao;
		else
			led <= datao[7:0];
	end

	always @(negedge m_clock)
	begin

		if(inst_read)
		begin
			//			inst <= {imem[iadrs + 1'h0],imem[iadrs + 1'h1],imem[iadrs + 1'h2],imem[iadrs + 1'h3]};
			inst <= {imem[iadrs[31:2]]};
		end
		/*
		if(wb)
			#(STEP) $display("$0:%x $1:%x $2:%x $3:%x $4:%x $5:%x $6:%x $7:%x\n",
		cpu.reg_selector.r0,cpu.reg_selector.r1,cpu.reg_selector.r2,cpu.reg_selector.r3,
		cpu.reg_selector.r4,cpu.reg_selector.r5,cpu.reg_selector.r6,cpu.reg_selector.r7);
	*/
       if(hlt)
       begin
       		if(disp == 0)
		begin
	       $display("\nHALTED at %8d clock", $time/STEP);
	       for(i=0; i<400; i=i+8)
	       begin
		       $write("%4x: ",i);
		       for(j=0; j<8; j=j+1)
			       $write("%x ",cpu.data_if.mem_array.dmem[i+j]);
		       $display;
	       end
	       $display("SW = %2x: LED = %2x", sw, led);
	       end
	       $finish;
       end
end


initial begin
	$readmemh("org_cpu.mem", imem);
	$readmemh("org_cpu.dmem", dmem);
	$dumpfile("org_cpu.vcd");
	$dumpvars(10,main);
	m_clock=0; mm_clock=0;
	p_reset=1;
	sw = 'h34;
	#(STEP) p_reset=0;
	#(20000*STEP+(STEP/2)) $finish;
end
endmodule

