/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.library;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;

public class Distribution {
    private int[] rangeStart = null;
    private int[] rangeEnd = null;
    private int[] count = null;
    private int maxRangeCount = -1;

    public Distribution(int start, int max, int interval) {
        int size = max / interval;
        if (max % interval != 0) {
            ++size;
        }
        this.initialize(size);
        int i = 0;
        while (i < size) {
            this.setRange(i, interval * i + start, interval * i + interval);
            ++i;
        }
    }

    public Distribution(int rangeCount) {
        this.initialize(rangeCount);
    }

    public void initialize(int rangeCount) {
        this.maxRangeCount = rangeCount;
        this.rangeStart = new int[this.maxRangeCount];
        this.rangeEnd = new int[this.maxRangeCount];
        this.count = new int[this.maxRangeCount];
        this.clear();
    }

    public void terminate() {
        this.count = null;
        this.rangeEnd = null;
        this.rangeStart = null;
    }

    public void finalize() throws Throwable {
        try {
            this.terminate();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public void clear() {
        int i = 0;
        while (i < this.maxRangeCount) {
            this.count[i] = 0;
            ++i;
        }
    }

    public void setRange(int index, int start, int end) {
        this.rangeStart[index] = start;
        this.rangeEnd[index] = end;
    }

    public void addData(int data) {
        int index = -1;
        int i = 0;
        while (i < this.maxRangeCount) {
            if (data >= this.rangeStart[i] && data <= this.rangeEnd[i]) {
                index = i;
                break;
            }
            ++i;
        }
        int n = index;
        this.count[n] = this.count[n] + 1;
    }

    public String getLog() {
        return this.getLog(0);
    }

    public String getLog(int startIndex) {
        StringBuffer buffer = null;
        int sum = 0;
        try {
            int i = startIndex;
            while (i < this.maxRangeCount) {
                sum += this.count[i];
                ++i;
            }
            buffer = new StringBuffer();
            int i2 = startIndex;
            while (i2 < this.maxRangeCount) {
                if (this.rangeStart[i2] != this.rangeEnd[i2]) {
                    Distribution.appendLogPercent(buffer, this.rangeStart[i2] + "-" + this.rangeEnd[i2], this.count[i2], sum);
                } else {
                    Distribution.appendLogPercent(buffer, String.valueOf(this.rangeStart[i2]), this.count[i2], sum);
                }
                ++i2;
            }
            String string = buffer.toString();
            Object var8_7 = null;
            buffer = null;
            return string;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            buffer = null;
            throw throwable;
        }
    }

    private static final void appendLogPercent(StringBuffer buffer, String title, int count, int total) {
        buffer.append(title);
        buffer.append(":\t");
        buffer.append(String.valueOf(count));
        buffer.append("\t");
        buffer.append(SimulatorLibrary.getPercent(count, total));
        buffer.append("\n");
    }
}

