/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.datacounter;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface4Stock;

public abstract class AbstractDataCounter4Stock
extends AbstractDataCounter {
    protected JTextField textInitialStock = null;
    protected JCheckBoxMenuItem rtReport = null;
    protected JCheckBoxMenuItem rtReportNotZero = null;

    protected void initializeGui(JPanel northPanel) {
        this.textInitialStock = new JTextField();
        this.textInitialStock.setPreferredSize(new Dimension(40, 25));
        this.textInitialStock.setText("10");
        northPanel.add(new JLabel("stock"));
        northPanel.add(this.textInitialStock);
        this.rtReport = new JCheckBoxMenuItem("RT \u958b\u59cb\u8868\u793a(\u5e38\u306b)");
        this.rtReportNotZero = new JCheckBoxMenuItem("RT \u958b\u59cb\u8868\u793a(\u30b9\u30c8\u30c3\u30af\u5207\u308c\u306e\u307f)");
        this.addOptionMenu(this.rtReport);
        this.addOptionMenu(this.rtReportNotZero);
    }

    public final void event(int eventId) {
        super.event(eventId);
        switch (eventId) {
            case 8: {
                ((MainBoardInterface4Stock)this.simulator).stock(Integer.parseInt(this.textInitialStock.getText()), ((MainBoardInterface4Stock)this.simulator).getStockType());
                break;
            }
            case 1: {
                this.textInitialStock.setEditable(false);
                break;
            }
            case 2: {
                this.textInitialStock.setEditable(true);
                break;
            }
            case 23: {
                this.eventRtStart();
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        Object source = e.getSource();
        if (source == this.buttonRun && !this.running && this.simulator != null) {
            ((MainBoardInterface4Stock)this.simulator).stock(Integer.parseInt(this.textInitialStock.getText()), ((MainBoardInterface4Stock)this.simulator).getStockType());
        }
    }

    protected void eventRtStart() {
        if (this.menuItemResultOnly.isSelected()) {
            return;
        }
        int currentGameCount = this.getCurrentGameCount();
        if (!this.rtReport.isSelected() && !this.rtReportNotZero.isSelected()) {
            return;
        }
        if (currentGameCount == 0 && !this.rtReport.isSelected()) {
            return;
        }
        this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
        this.appendLog("\tRT\u958b\u59cb");
        int rtFloor = ((MainBoardInterface4Stock)this.simulator).getRtFloor();
        this.appendLog("\tRT=" + rtFloor);
        this.appendLog("\n");
    }

    protected void eventSimulateEnd() {
        this.appendLogStopGameAndTotalGame();
        this.appendLogDenominator("BIG", this.getBigCount(), this.getTotalGameCount());
        this.appendLogDenominator("REG", this.getRegCount(), this.getTotalGameCount());
        this.appendLogDenominator("\u5408\u6210", this.getBigCount() + this.getRegCount(), this.getTotalGameCount());
        this.appendLogPayout();
    }

    protected final int getCurrentMode() {
        return ((MainBoardInterface4Stock)this.simulator).getCurrentMode();
    }

    protected final int getStockCount() {
        return ((MainBoardInterface4Stock)this.simulator).getStockCount();
    }

    protected final int getBreakFactor() {
        return ((MainBoardInterface4Stock)this.simulator).getBreakFactor();
    }

    protected final String getStockBRCount() {
        return ((MainBoardInterface4Stock)this.simulator).getStock().debugOutCount();
    }

    protected final String getStockBR() {
        return ((MainBoardInterface4Stock)this.simulator).getStock().debugOutBonus();
    }
}

