/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.WildWolf;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class WildWolfMainBoard
extends AbstractMainBoard4Stock {
    public static final int MODE_1 = 0;
    public static final int MODE_2 = 1;
    public static final int MODE_3 = 2;
    public static final int MODE_4 = 3;
    public static final int MODE_5 = 4;
    public static final int MODE_6 = 5;
    public static final int BREAK_BELL = 21;
    public static final int BREAK_CHERRY = 22;
    private static final int[][] rtFloorTable = new int[][]{{1, 17, 49, 81, 145, 177, 305, 337, 465, 497, 625, 657, 785, 817, 945, 693, 1105, 1137, 1265, 1297}, {16, 48, 80, 144, 176, 304, 336, 464, 496, 624, 656, 784, 816, 944, 976, 1104, 1136, 1264, 1296, 1424}};
    private static final int[][] rtTable4Big = new int[][]{{1, 0, 0, 5, 10, 14, 2, 20, 34, 24, 4, 26, 34, 24, 4, 20, 34, 0, 0, 0}, {1, 0, 0, 1, 2, 4, 28, 8, 4, 12, 28, 16, 4, 20, 28, 22, 4, 24, 28, 22}, {64, 64, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {64, 64, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 63, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {64, 64, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    private static final int[][] rtTable4Reg = new int[][]{{1, 0, 0, 15, 26, 36, 84, 36, 26, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 5, 44, 18, 12, 28, 44, 32, 44, 28, 0, 0, 0, 0, 0, 0, 0, 0}, {64, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {64, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 63, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {64, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    private static final int[][][] modeMoveByBig = new int[][][]{new int[][]{{51, 51, 22, 0, 4, 0}, {48, 49, 27, 0, 4, 0}, {46, 47, 31, 0, 4, 0}, {44, 44, 36, 0, 4, 0}, {42, 42, 40, 0, 4, 0}, {38, 38, 48, 0, 4, 0}}, new int[][]{{43, 43, 34, 0, 8, 0}, {39, 40, 41, 0, 8, 0}, {36, 36, 48, 0, 8, 0}, {32, 32, 56, 0, 8, 0}, {27, 28, 65, 0, 8, 0}, {22, 22, 76, 0, 8, 0}}, new int[][]{{39, 39, 42, 0, 8, 0}, {38, 38, 44, 0, 8, 0}, {37, 37, 46, 0, 8, 0}, {36, 36, 48, 0, 8, 0}, {35, 35, 50, 0, 8, 0}, {34, 34, 52, 0, 8, 0}}, new int[][]{{0, 0, 22, 106, 0, 0}, {0, 0, 24, 104, 0, 0}, {0, 0, 26, 102, 0, 0}, {0, 0, 28, 100, 0, 0}, {0, 0, 30, 98, 0, 0}, {0, 0, 64, 64, 0, 0}}, new int[][]{{32, 32, 58, 0, 6, 0}, {32, 32, 58, 0, 6, 0}, {32, 32, 58, 0, 6, 0}, {32, 32, 58, 0, 6, 0}, {32, 32, 58, 0, 6, 0}, {32, 32, 58, 0, 6, 0}}, new int[][]{{51, 51, 22, 0, 4, 0}, {48, 49, 27, 0, 4, 0}, {46, 47, 31, 0, 4, 0}, {44, 44, 36, 0, 4, 0}, {42, 42, 40, 0, 4, 0}, {38, 38, 48, 0, 4, 0}}};
    private static final int[][] modeMoveByReg = new int[][]{{60, 60, 2, 0, 0, 6}, {56, 56, 4, 0, 0, 12}, {0, 0, 112, 16, 0, 0}, {0, 0, 16, 112, 0, 0}, {32, 32, 64, 0, 0, 12}, {0, 0, 0, 0, 0, 128}};
    public static final int FLAG_BELL = 4;
    public static final int FLAG_SUIKA = 5;
    public static final int FLAG_CHERRY = 6;
    private int[][] flagTableNormal = new int[][]{{1, 14545, 72, 12, 1450, 112, 192}, {1, 14538, 78, 13, 1450, 112, 192}, {1, 14531, 84, 14, 1450, 112, 192}, {1, 14524, 90, 15, 1450, 112, 192}, {1, 14517, 96, 16, 1450, 112, 192}, {1, 14517, 96, 16, 1450, 112, 192}};
    private int[][] flagTableBig = new int[][]{{1, 16384}, {1, 16384}, {1, 16384}, {1, 16384}, {1, 16384}, {1, 16384}};
    private int[][] flagTableJac = new int[][]{{1, 16384}, {1, 16384}, {1, 16384}, {1, 16384}, {1, 16384}, {1, 16384}};

    public int getStockType() {
        return 1;
    }

    protected void gameRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        if (!this.isBreak && ++this.rtCounter >= this.rtFloor) {
            this.isBreak = true;
            this.breakFactor = -10;
        }
        if (flag != 1) {
            ((AbstractMainBoard)this).isReplay = false;
        }
        switch (flag) {
            case 0: {
                if (this.isBreak) break;
                this.isBreak = true;
                this.breakFactor = -11;
                break;
            }
            case 1: {
                if (SimulatorLibrary.random((int)4096) < 633) {
                    ((AbstractMainBoard)this).isReplay = true;
                    break;
                }
                ((AbstractMainBoard)this).isReplay = false;
                if (!this.isBreak) break;
                this.fireCoinPlus(15);
                this.bonusGet();
                break;
            }
            case 2: {
                this.stock.add(3);
                break;
            }
            case 3: {
                this.stock.add(4);
                break;
            }
            case 4: {
                this.fireCoinPlus(10);
                if (this.isBreak || SimulatorLibrary.random((int)4096) >= 16) break;
                this.isBreak = true;
                this.breakFactor = 21;
                break;
            }
            case 5: {
                this.fireCoinPlus(6);
                break;
            }
            case 6: {
                int random4096 = SimulatorLibrary.random((int)4096);
                if (random4096 < 294) {
                    this.fireCoinPlus(1);
                    if (this.isBreak || random4096 >= 40) break;
                    this.isBreak = true;
                    this.breakFactor = 22;
                    break;
                }
                this.fireCoinPlus(3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown flag - " + flag);
            }
        }
    }

    protected void gameNotRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        if (flag != 1) {
            ((AbstractMainBoard)this).isReplay = false;
        }
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                if (SimulatorLibrary.random((int)4096) < 633) {
                    ((AbstractMainBoard)this).isReplay = true;
                    break;
                }
                ((AbstractMainBoard)this).isReplay = false;
                break;
            }
            case 2: {
                this.stock.add(3);
                this.reset();
                break;
            }
            case 3: {
                this.stock.add(4);
                this.reset();
                break;
            }
            case 4: {
                this.fireCoinPlus(10);
                break;
            }
            case 5: {
                this.fireCoinPlus(6);
                break;
            }
            case 6: {
                int random4096 = SimulatorLibrary.random((int)4096);
                if (random4096 < 294) {
                    this.fireCoinPlus(1);
                    break;
                }
                this.fireCoinPlus(3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown flag - " + flag);
            }
        }
    }

    public void reset() {
        int previousBonus = this.getCurrentBonus();
        if (this.stock.size() > 0) {
            int random128;
            this.noStock = false;
            this.nextBonus = (Integer)this.stock.remove(0);
            int index = -1;
            this.currentMode = previousBonus == 3 ? SimulatorLibrary.getTableIndex((int[])modeMoveByBig[this.currentMode][((AbstractMainBoard)this).settei - 1], (int)128) : (previousBonus == 4 ? SimulatorLibrary.getTableIndex((int[])modeMoveByReg[this.currentMode], (int)128) : ((random128 = SimulatorLibrary.random((int)128)) < 48 ? 0 : (random128 < 48 ? 1 : 5)));
            if (this.nextBonus == 3) {
                index = SimulatorLibrary.getTableIndex((int[])rtTable4Big[this.currentMode], (int)256);
            } else if (this.nextBonus == 4) {
                index = SimulatorLibrary.getTableIndex((int[])rtTable4Reg[this.currentMode], (int)256);
            }
            this.rtFloor = SimulatorLibrary.getRandomPerRange((int)rtFloorTable[0][index], (int)rtFloorTable[1][index]);
        } else {
            this.noStock = false;
        }
        this.rtCounter = 0;
        this.isBreak = false;
        ((AbstractMainBoard)this).isBonus = false;
        this.breakFactor = -12;
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                if (game == 10 || game == 20 || game == 30) {
                    this.fireCoinPlus(15);
                    this.setJacIn();
                    break;
                }
                this.fireCoinPlus(15);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown flag - " + flag);
            }
        }
    }

    public int getRandomMax() {
        return 16384;
    }

    public int[][] getFlagTableHigh() {
        return this.flagTableNormal;
    }

    public int[][] getFlagTableBigGame() {
        return this.flagTableBig;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagTableJac;
    }
}

