/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.ThunderBird;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class ThunderBirdMainBoard
extends AbstractMainBoard4Stock {
    public static final int EVENT_RT_START = 23;
    public static final int EVENT_RT_END = 24;
    public static final int EVENT_TC_START = 25;
    public static final int EVENT_TC_END = 26;
    public static final int BREAK_REP3 = 11;
    public static final int BREAK_REP4 = 12;
    public static final int FLAG_BELL = 4;
    public static final int FLAG_CHERRY = 5;
    public static final int FLAG_SUIKA = 6;
    public static final int FLAG_BIG_BELL = 2;
    public static final int FLAG_BIG_15 = 3;
    protected int[][] flagTable = new int[][]{{1, 14221, 137, 137, 1700, 80, 108}, {1, 14221, 137, 137, 1700, 80, 108}, {1, 14221, 137, 137, 1700, 80, 108}, {1, 14221, 137, 137, 1700, 80, 108}, {1, 14221, 137, 137, 1700, 80, 108}, {1, 14221, 137, 137, 1700, 80, 108}};
    protected int[][] flagTableBig = new int[][]{{1, 4683, 10600, 1100}, {1, 4683, 10600, 1100}, {1, 4683, 10600, 1100}, {1, 4683, 10600, 1100}, {1, 4683, 10600, 1100}, {1, 4683, 10600, 1100}};
    protected int[][] flagTableJac = new int[][]{{2, 16382}, {2, 16382}, {2, 16382}, {2, 16382}, {2, 16382}, {2, 16382}};
    protected int[][] rtTable1 = new int[][]{{156, 28, 8, 8, 8, 8, 10, 10, 10, 10}, {156, 34, 16, 11, 10, 8, 8, 7, 3, 3}, {156, 28, 8, 8, 8, 8, 10, 10, 10, 10}, {156, 34, 16, 11, 10, 8, 8, 7, 3, 3}, {156, 28, 8, 8, 8, 8, 10, 10, 10, 10}, {156, 34, 16, 11, 10, 8, 8, 7, 3, 3}};
    protected int[][] rtTable2 = new int[][]{{32, 96, 16, 16, 16, 16, 16, 16, 16, 16}, {32, 96, 16, 16, 16, 16, 16, 16, 16, 16}, {32, 96, 16, 16, 16, 16, 16, 16, 16, 16}, {32, 96, 16, 16, 16, 16, 16, 16, 16, 16}, {32, 96, 16, 16, 16, 16, 16, 16, 16, 16}, {32, 96, 16, 16, 16, 16, 16, 16, 16, 16}};
    protected int[][] rtG = new int[][]{{1, 129, 257, 385, 513, 641, 769, 897, 1025, 1153}, {128, 256, 384, 512, 640, 768, 896, 1024, 1152, 1280}};
    protected int[] tcHitByCherry = new int[]{58, 51, 98, 96, 156, 237};
    protected int[] tcGameCountDistributioin = new int[]{96, 150, 7, 3};
    protected int[] tcGameCount = new int[]{11, 21, 51, 101};
    private boolean isTc = false;
    private int tcFloor = 0;
    private int tcCounter = 0;
    private int replayContinueCount = 0;
    boolean isShift = false;

    public int getRandomMax() {
        super.getRandomMax();
        return 16384;
    }

    public int getStockType() {
        return 1;
    }

    public int[][] getFlagTableHigh() {
        return this.flagTable;
    }

    public int[][] getFlagTableBigGame() {
        return this.flagTableBig;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagTableJac;
    }

    public void gameRt(int flag) {
        ++this.rtCounter;
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        if (this.rtCounter > this.rtFloor) {
            if (this.breakFactor == -12) {
                this.breakFactor = -10;
            }
            this.isBreak = true;
        }
        if (this.isTc) {
            ++this.tcCounter;
            if (!this.isBreak && this.tcCounter > this.tcFloor) {
                this.isTc = false;
                this.tcCounter = 0;
                this.tcFloor = 0;
                this.fireEvent(26);
            }
        }
        if (flag != 1) {
            ((AbstractMainBoard)this).isReplay = false;
            this.replayContinueCount = 0;
        }
        switch (flag) {
            case 2: {
                this.stock.add((Object)new Integer(3));
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                break;
            }
            case 0: {
                this.breakFactor = -11;
                this.isBreak = true;
                break;
            }
            case 4: {
                this.fireCoinPlus(8);
                break;
            }
            case 5: {
                this.fireCoinPlus(2);
                if (this.isTc || SimulatorLibrary.random((int)256) >= this.tcHitByCherry[((AbstractMainBoard)this).settei - 1]) break;
                this.tcHit();
                break;
            }
            case 6: {
                this.fireCoinPlus(12);
                break;
            }
            case 1: {
                int repIn;
                int random4096 = SimulatorLibrary.random((int)4096);
                int n = repIn = this.isTc ? 1888 : 647;
                if (random4096 < repIn) {
                    ((AbstractMainBoard)this).isReplay = true;
                    ++this.replayContinueCount;
                    break;
                }
                ((AbstractMainBoard)this).isReplay = false;
                this.replayContinueCount = 0;
                if (!this.isBreak) break;
                this.bonusGet();
                this.fireCoinPlus(15);
            }
        }
        if (!this.isBreak && this.replayContinueCount >= 4) {
            this.breakFactor = 12;
            this.isBreak = true;
        } else if (!this.isBreak && this.isTc && this.replayContinueCount >= 3) {
            this.breakFactor = 11;
            this.isBreak = true;
        }
    }

    public void gameNotRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        if (flag != 1) {
            ((AbstractMainBoard)this).isReplay = false;
        }
        switch (flag) {
            case 2: {
                this.stock.add((Object)new Integer(3));
                this.reset();
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                this.reset();
                break;
            }
            case 0: {
                break;
            }
            case 4: {
                this.fireCoinPlus(8);
                break;
            }
            case 5: {
                this.fireCoinPlus(2);
                break;
            }
            case 6: {
                this.fireCoinPlus(12);
            }
            case 1: {
                int random4096 = SimulatorLibrary.random((int)4096);
                ((AbstractMainBoard)this).isReplay = random4096 < 647;
            }
        }
    }

    private void tcHit() {
        int index = SimulatorLibrary.getTableIndex((int[])this.tcGameCountDistributioin, (int)256);
        this.tcFloor = this.tcGameCount[index];
        this.tcCounter = 0;
        this.isTc = true;
        this.fireEvent(25);
    }

    public int getMaxJacInCount() {
        return 2;
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        if (game == 1) {
            this.isShift = false;
        }
        switch (flag) {
            case 0: {
                if (game < 29 || !this.isShift) break;
                this.setJacIn();
                this.fireCoinPlus(9);
                break;
            }
            case 1: {
                if (jacInCount < 1 || game >= 29) {
                    this.setJacIn();
                    this.fireCoinPlus(9);
                    break;
                }
                this.isShift = true;
                break;
            }
            case 2: {
                if (game == 30 && this.isShift) {
                    this.setJacIn();
                    this.fireCoinPlus(9);
                    break;
                }
                this.fireCoinPlus(10);
                break;
            }
            case 3: {
                if (game == 30 && this.isShift) {
                    this.setJacIn();
                    this.fireCoinPlus(9);
                    break;
                }
                this.fireCoinPlus(15);
            }
        }
    }

    public void jacGame(int flag, int gameCount) {
        this.fireCoinMinus(1);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                this.setJacHit();
                this.fireCoinPlus(15);
            }
        }
    }

    public void reset() {
        this.isBreak = false;
        int previousBonus = this.getCurrentBonus();
        int previousBreakFactor = this.breakFactor;
        if (this.stock.size() > 0) {
            this.nextBonus = (Integer)this.stock.get(0) == 3 ? 3 : 4;
            this.stock.remove(0);
            this.noStock = false;
        } else {
            this.nextBonus = -1;
            this.noStock = true;
        }
        if (!this.noStock) {
            this.rtFloor = this._getRtFloor(previousBonus);
            this.rtCounter = 0;
            this.breakFactor = -10;
            super.reset();
            this.fireEvent(23);
            if (previousBonus == 4 || previousBreakFactor == 11) {
                this.tcHit();
            }
        } else {
            this.rtCounter = 0;
            this.breakFactor = -12;
            super.reset();
        }
    }

    private int _getRtFloor(int previousBonus) {
        int index = -1;
        index = previousBonus == 3 ? SimulatorLibrary.getTableIndex((int[])this.rtTable1[((AbstractMainBoard)this).settei - 1], (int)256) : SimulatorLibrary.getTableIndex((int[])this.rtTable2[((AbstractMainBoard)this).settei - 1], (int)256);
        int min = this.rtG[0][index];
        int max = this.rtG[1][index];
        int g = SimulatorLibrary.getRandomPerRange((int)min, (int)max);
        return g;
    }

    public boolean isTc() {
        return this.isTc;
    }

    public int getTcFloor() {
        return this.tcFloor;
    }
}

