/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.SBJ;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class SBJMainBoard
extends AbstractMainBoard4Stock {
    public static final int EVENT_ST_HIT = 20;
    public static final int EVENT_ST_START = 21;
    public static final int EVENT_ST_END = 22;
    public static final int EVENT_RC_HIT = 23;
    public static final int EVENT_RC_START = 24;
    public static final int EVENT_RC_END = 25;
    public static final int BREAK_SUIKA11 = 20;
    public static final int BREAK_KOYAKU6 = 21;
    public static final int BREAK_KOYAKU6_RC = 22;
    public static final int BREAK_NORMAL = 23;
    private boolean isSt = false;
    private int stGameFloor = 0;
    private int stGameCounter = 0;
    private int stCurrentHitFloor = 0;
    private boolean isStSenpuku = false;
    private boolean isRc = false;
    private int rcGameFloor = 0;
    private int rcGameCounter = 0;
    private int rcCurrentHitCount = 0;
    private int rcCount = 0;
    private int koyakuContinueCount = 0;
    private int suikaCount = 0;
    private boolean isSb = false;
    private int sbGameCounter = 0;
    private int sbGameFloor = 0;
    private boolean isZentyouRt = false;
    private int zentyouRtFloor = 0;
    private int zentyouRtCounter = 0;
    private int currentFlag2 = -1;
    private int[] normalBreakRatio = new int[]{156, 162, 176, 176, 204, 274};
    private int[] normalStTable = new int[]{900, 100};
    private int[] normalStGameTable = new int[]{50, 777};
    private int[][] bonusStTable = new int[][]{{600, 330, 20, 20, 10, 10, 10}, {550, 350, 50, 20, 10, 10, 10}, {500, 400, 50, 20, 10, 10, 10}, {400, 450, 100, 20, 10, 10, 10}, {400, 450, 100, 20, 10, 10, 10}, {350, 450, 150, 20, 10, 10, 10}};
    private int[] bonusStGameTable = new int[]{50, 100, 150, 200, 250, 300, 500};
    private int[] rcHitCountTable = new int[]{940, 10, 10, 10, 10, 10, 10};
    private int[] zentyouRtTable = new int[]{103, 205, 256, 58, 58, 58, 58, 57, 57, 57, 57};
    private int[] zentyouRtGameTable = new int[]{2, 8, 12, 13, 14, 15, 16, 17, 18, 19, 20};
    public static final int FLAG_KOYAKU = 4;
    public static final int FLAG_SUIKA = 5;
    public static final int FLAG_CHERRY = 6;
    public static final int FLAG_BELL = 7;
    public static final int FLAG_BELL2 = 8;
    public static final int FLAG_KOYAKU_LOST = 9;
    public static final int FLAG_REPLAY_LOST = 10;
    private int[] pay = new int[]{0, 0, 15, 15, 0, 6, 2, 9};
    private int[][] flagTable = new int[][]{{4, 35948, 272, 112, 28400, 800}, {4, 35948, 272, 112, 28400, 800}, {4, 35948, 272, 112, 28400, 800}, {4, 35948, 272, 112, 28400, 800}, {4, 35948, 272, 112, 28400, 800}, {4, 35948, 272, 112, 28400, 800}};
    public static final int FLAG_BIG_KOYAKU = 2;
    public static final int FLAG_BIG_SUIKA = 3;
    public static final int FLAG_BIG_CHERRY = 4;
    private int[] payBig = new int[]{0, 1, 7, 6, 15};
    private int[][] flagBigTable = new int[][]{{4780, 18000, 40756, 2000}, {4780, 18000, 40756, 2000}, {4780, 18000, 40756, 2000}, {4780, 18000, 40756, 2000}, {4780, 18000, 40756, 2000}, {4780, 18000, 40756, 2000}};
    private int[][] flagJacTable = new int[][]{{4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}};

    protected void gameRt(int flag) {
        int random65536 = 0;
        int random32768 = 0;
        int random1024 = 0;
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        if (flag != 1) {
            ((AbstractMainBoard)this).isReplay = false;
        }
        random65536 = SimulatorLibrary.random((int)65536);
        if (!this.isBreak && random65536 < this.normalBreakRatio[((AbstractMainBoard)this).settei - 1]) {
            this.isBreak = true;
            this.breakFactor = 23;
            this.isZentyouRt = true;
            this.zentyouRtCounter = 0;
            int index = SimulatorLibrary.getTableIndex((int[])this.zentyouRtTable, (int)1024);
            this.zentyouRtFloor = this.zentyouRtGameTable[index];
        }
        if (this.isStSenpuku && SimulatorLibrary.random((int)25) == 0) {
            this.isSt = true;
            this.stGameCounter = 0;
            this.isStSenpuku = false;
            this.fireEvent(21);
        } else if (this.isSt && this.stGameCounter >= this.stGameFloor) {
            this.fireEvent(22);
            this.isSt = false;
            this.stGameCounter = 0;
            this.stGameFloor = 0;
        }
        if (!(this.isRc || this.isStSenpuku || this.isSt || this.rcCount <= 0 || SimulatorLibrary.random((int)25) != 0)) {
            --this.rcCount;
            this.isRc = true;
            this.rcGameCounter = 0;
            this.rcGameFloor = 6;
            this.fireEvent(24);
        } else if (this.isRc && this.rcGameCounter >= this.rcGameFloor) {
            this.fireEvent(25);
            this.isRc = false;
            this.rcGameCounter = 0;
            this.rcGameFloor = 0;
        }
        switch (flag) {
            case 0: {
                if (this.isBreak) break;
                this.isBreak = true;
                this.breakFactor = -11;
                break;
            }
            case 2: {
                this.stock.add(3);
                random32768 = SimulatorLibrary.random((int)32768);
                if (this.isSt && random32768 < 31768) {
                    this.rcHit();
                    break;
                }
                if (random32768 >= 1000) break;
                this.stHit();
                break;
            }
            case 3: {
                this.stock.add(4);
                random32768 = SimulatorLibrary.random((int)32768);
                if (this.isSt && random32768 < 31768) {
                    this.rcHit();
                    break;
                }
                if (random32768 >= 1000) break;
                this.stHit();
                break;
            }
            case 1: {
                if (this.isRc) {
                    ((AbstractMainBoard)this).isReplay = true;
                    break;
                }
                random1024 = SimulatorLibrary.random((int)1024);
                if (random1024 < 102) {
                    ((AbstractMainBoard)this).isReplay = true;
                    if (!this.isSt || SimulatorLibrary.random((int)1000) >= 40) break;
                    this.rcHit();
                    break;
                }
                random32768 = SimulatorLibrary.random((int)32768);
                if (random32768 < 5466) {
                    ((AbstractMainBoard)this).isReplay = true;
                    break;
                }
                flag = 10;
                break;
            }
            case 5: {
                this.fireCoinPlus(6);
                ++this.suikaCount;
                if (this.suikaCount < 11 || this.isBreak) break;
                this.breakFactor = 20;
                this.isBreak = true;
                break;
            }
            case 4: {
                random1024 = SimulatorLibrary.random((int)1024);
                if (random1024 < 11) {
                    flag = 8;
                    this.fireCoinPlus(9);
                    break;
                }
                if (random1024 < 22) {
                    flag = 6;
                    this.fireCoinPlus(2);
                    break;
                }
                if (this.isSt) {
                    this.fireCoinPlus(9);
                    flag = 7;
                    break;
                }
                if (this.isRc) {
                    this.fireCoinPlus(2);
                    flag = 6;
                    break;
                }
                random32768 = SimulatorLibrary.random((int)32768);
                if (random32768 < 6554) {
                    this.fireCoinPlus(9);
                    flag = 7;
                    break;
                }
                if (random32768 < 13107) {
                    this.fireCoinPlus(2);
                    flag = 6;
                    break;
                }
                flag = 9;
            }
        }
        this.currentFlag2 = flag;
        if (this.isZentyouRt) {
            ++this.zentyouRtCounter;
            if (this.zentyouRtCounter >= this.zentyouRtFloor) {
                this.isZentyouRt = false;
            }
        }
        if (this.isBreak && !this.isZentyouRt && (flag == 10 || flag == 9)) {
            this.bonusGet();
        }
        if (!this.isBreak) {
            this.koyakuContinueCount = flag != 7 && flag != 10 && flag != 9 ? ++this.koyakuContinueCount : 0;
        }
        this.fireEvent(0);
        if (!this.isBreak && this.koyakuContinueCount >= 6) {
            this.isBreak = true;
            this.breakFactor = this.isRc ? 22 : 21;
        }
        if (this.isSt) {
            ++this.stGameCounter;
        } else if (this.isRc) {
            ++this.rcGameCounter;
        }
        if (this.isSb && this.isSt) {
            ++this.sbGameCounter;
        }
        if (this.sbGameCounter > this.sbGameFloor) {
            this.isSb = false;
            this.sbGameCounter = 0;
            this.sbGameFloor = 0;
        }
    }

    protected void gameNotRt(int flag) {
        boolean random65536 = false;
        int random32768 = 0;
        int random1024 = 0;
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        if (flag != 1) {
            ((AbstractMainBoard)this).isReplay = false;
        }
        if (this.isStSenpuku && SimulatorLibrary.random((int)25) == 0) {
            this.isSt = true;
            this.stGameCounter = 0;
            this.stGameFloor = 0;
            this.isStSenpuku = false;
            this.fireEvent(21);
        } else if (this.isSt && this.stGameCounter >= this.stGameFloor) {
            this.fireEvent(22);
            this.isSt = false;
            this.stGameCounter = 0;
            this.stGameFloor = 0;
        }
        switch (flag) {
            case 0: {
                break;
            }
            case 2: {
                ++this.koyakuContinueCount;
                this.stock.add(3);
                if (this.isSt && (random32768 = SimulatorLibrary.random((int)32768)) < 31768) {
                    this.rcHit();
                }
                this.reset();
                break;
            }
            case 3: {
                ++this.koyakuContinueCount;
                this.stock.add(4);
                if (this.isSt && (random32768 = SimulatorLibrary.random((int)32768)) < 31768) {
                    this.rcHit();
                }
                this.reset();
                break;
            }
            case 1: {
                if (this.isSt) {
                    ((AbstractMainBoard)this).isReplay = true;
                    break;
                }
                random1024 = SimulatorLibrary.random((int)1024);
                if (random1024 < 102) {
                    ((AbstractMainBoard)this).isReplay = true;
                    break;
                }
                random32768 = SimulatorLibrary.random((int)32768);
                if (random32768 < 5466) {
                    ((AbstractMainBoard)this).isReplay = true;
                    break;
                }
                flag = 10;
                break;
            }
            case 5: {
                this.fireCoinPlus(6);
                break;
            }
            case 4: {
                random1024 = SimulatorLibrary.random((int)1024);
                if (random1024 < 11) {
                    this.fireCoinPlus(9);
                    break;
                }
                if (random1024 < 22) {
                    this.fireCoinPlus(2);
                    break;
                }
                if (this.isSt) {
                    this.fireCoinPlus(9);
                    break;
                }
                random32768 = SimulatorLibrary.random((int)32768);
                if (random32768 < 6554) {
                    this.fireCoinPlus(9);
                    break;
                }
                if (random32768 < 13107) {
                    this.fireCoinPlus(2);
                    break;
                }
                flag = 9;
            }
        }
        if (this.isBreak || this.koyakuContinueCount >= 6) {
            // empty if block
        }
        if (this.isSt) {
            ++this.stGameCounter;
        }
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        switch (flag) {
            case 2: {
                if (this.isSb) {
                    this.fireCoinPlus(15);
                    break;
                }
                this.fireCoinPlus(7);
                break;
            }
            case 5: {
                this.fireCoinPlus(6);
                break;
            }
            case 1: {
                if (this.isSb) {
                    if (jacInCount >= 2 && game <= 24) break;
                    this.fireCoinPlus(1);
                    this.setJacIn();
                    break;
                }
                if (jacInCount >= 2 && game <= 21) break;
                this.fireCoinPlus(1);
                this.setJacIn();
            }
        }
    }

    public void bousGet() {
        this.fireCoinPlus(15);
        super.bonusGet();
    }

    public void rcHit() {
        this.rcCurrentHitCount = SimulatorLibrary.getTableIndex((int[])this.rcHitCountTable, (int)1000) + 1;
        this.rcCount += this.rcCurrentHitCount;
        this.fireEvent(23);
    }

    public void stHit() {
        if (((AbstractMainBoard)this).totalGameCount == 0) {
            return;
        }
        int index = -1;
        if (this.breakFactor != -12) {
            index = SimulatorLibrary.getTableIndex((int[])this.bonusStTable[((AbstractMainBoard)this).settei - 1], (int)1000);
            this.stCurrentHitFloor = this.bonusStGameTable[index];
            this.stGameFloor += this.stCurrentHitFloor;
            this.fireEvent(20);
        } else {
            index = SimulatorLibrary.getTableIndex((int[])this.normalStTable, (int)1000);
            this.stCurrentHitFloor = this.normalStGameTable[index];
            this.stGameFloor += this.stCurrentHitFloor;
            this.fireEvent(20);
            if (this.stCurrentHitFloor == 777) {
                this.isSb = true;
                this.sbGameFloor += 777;
            }
        }
        if (!this.isSt) {
            this.isStSenpuku = true;
        }
    }

    public void setup() {
        super.setup();
        this.nextBonus = -1;
        this.isStSenpuku = false;
        this.isSt = false;
        this.stGameCounter = 0;
        this.stGameFloor = 0;
        this.isRc = false;
        this.rcCount = 0;
        this.rcGameCounter = 0;
        this.rcGameFloor = 0;
        this.isSb = false;
        this.breakFactor = -12;
    }

    public int getStockType() {
        return 1;
    }

    public void reset() {
        int previousBonus = this.nextBonus;
        if (this.stock.size() > 0) {
            this.nextBonus = (Integer)this.stock.get(0);
            this.stock.removeElementAt(0);
        } else {
            this.noStock = true;
        }
        this.koyakuContinueCount = 0;
        this.suikaCount = 0;
        this.isBreak = false;
        ((AbstractMainBoard)this).isBonus = false;
        if (previousBonus == 3) {
            if (SimulatorLibrary.random((int)32768) < 11000) {
                this.stHit();
            }
        } else if (previousBonus == 4 && SimulatorLibrary.random((int)32768) < 1600) {
            this.stHit();
        }
        this.breakFactor = -12;
        super.reset();
    }

    public int[][] getFlagTableHigh() {
        return this.flagTable;
    }

    public int[][] getFlagTableBigGame() {
        return this.flagBigTable;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagJacTable;
    }

    public boolean isRc() {
        return this.isRc;
    }

    public boolean isSt() {
        return this.isSt;
    }

    public boolean isStSenpuku() {
        return this.isStSenpuku;
    }

    public int getKoyakuContinueCount() {
        return this.koyakuContinueCount;
    }

    public int getRcCount() {
        return this.rcCount;
    }

    public int getRcCurrentHitCount() {
        return this.rcCurrentHitCount;
    }

    public int getRcGameCounter() {
        return this.rcGameCounter;
    }

    public int getRcGameFloor() {
        return this.rcGameFloor;
    }

    public int getStCurrentHitFloor() {
        return this.stCurrentHitFloor;
    }

    public int getStGameCounter() {
        return this.stGameCounter;
    }

    public int getStGameFloor() {
        return this.stGameFloor;
    }

    public boolean isSb() {
        return this.isSb;
    }

    public int getCurrentFlag2() {
        return this.currentFlag2;
    }

    public int getSuikaCount() {
        return this.suikaCount;
    }
}

