/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.NeoPlanet;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class NeoPlanetMainBoard
extends AbstractMainBoard4Stock {
    public static final int EVENT_CHERRY2 = 25;
    public static final int EVENT_CHERRY4 = 26;
    public static final int MODE_1 = 1;
    public static final int MODE_2 = 2;
    public static final int MODE_3 = 3;
    public static final int MODE_4 = 4;
    public static final int MODE_5 = 5;
    public static final int MODE_6 = 6;
    public static final int BREAK_CHERRY = 13;
    public static final int BREAK_REPLAY = 14;
    public static final int BREAK_NORMAL = 15;
    public static final int FLAG_BELL = 4;
    public static final int FLAG_CHERRY = 5;
    public static final int FLAG_ORANGE = 6;
    public static final int FLAG_BIG_BELL = 2;
    public static final int FLAG_BIG_CHERRY = 3;
    public static final int FLAG_BIG_PLANET = 4;
    protected int[][] flagTable = new int[][]{{4, 57956, 260, 196, 6240, 672, 208}, {4, 57936, 264, 200, 6240, 672, 220}, {4, 57920, 268, 204, 6240, 672, 228}, {4, 57896, 272, 208, 6240, 672, 244}, {4, 57876, 272, 212, 6240, 672, 260}, {4, 57784, 272, 232, 6240, 672, 332}};
    protected int[][] flagTableBig = new int[][]{{6736, 18000, 28800, 6000, 6000}, {6736, 18000, 28800, 6000, 6000}, {6736, 18000, 28800, 6000, 6000}, {6736, 18000, 28800, 6000, 6000}, {6736, 18000, 28800, 6000, 6000}, {6736, 18000, 28800, 6000, 6000}};
    protected int[][] flagTableJac = new int[][]{{4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}};
    protected int[][][] modeTable = new int[][][]{new int[][]{{219, 3, 33, 0, 0, 1}, {215, 3, 37, 0, 0, 1}, {210, 4, 41, 0, 0, 1}, {205, 4, 46, 0, 0, 1}, {199, 5, 51, 0, 0, 1}, {164, 5, 86, 0, 0, 1}}, new int[][]{{127, 0, 64, 0, 64, 1}, {127, 0, 64, 0, 64, 1}, {127, 0, 64, 0, 64, 1}, {127, 0, 64, 0, 64, 1}, {127, 0, 64, 0, 64, 1}, {127, 0, 64, 0, 64, 1}}, new int[][]{{152, 0, 86, 16, 1, 1}, {152, 0, 86, 16, 1, 1}, {152, 0, 86, 16, 1, 1}, {152, 0, 86, 16, 1, 1}, {152, 0, 86, 16, 1, 1}, {152, 0, 86, 16, 1, 1}}, new int[][]{{0, 0, 207, 47, 1, 1}, {0, 0, 207, 47, 1, 1}, {0, 0, 207, 47, 1, 1}, {0, 0, 207, 47, 1, 1}, {0, 0, 207, 47, 1, 1}, {0, 0, 207, 47, 1, 1}}, new int[][]{{12, 0, 12, 0, 231, 1}, {12, 0, 12, 0, 231, 1}, {12, 0, 12, 0, 231, 1}, {12, 0, 12, 0, 231, 1}, {12, 0, 12, 0, 231, 1}, {12, 0, 12, 0, 231, 1}}, new int[][]{{219, 4, 32, 0, 0, 1}, {219, 4, 32, 0, 0, 1}, {219, 4, 32, 0, 0, 1}, {219, 4, 32, 0, 0, 1}, {219, 4, 32, 0, 0, 1}, {219, 4, 32, 0, 0, 1}}};
    protected int[] resetModeTable = new int[]{182, 0, 0, 10, 0, 64};
    protected int[][] breakRatio = new int[][]{{20, 15, 255, 20, 255, 255}, {23, 15, 255, 23, 255, 255}, {27, 15, 255, 27, 255, 255}, {32, 15, 255, 32, 255, 255}, {38, 15, 255, 38, 255, 255}, {65, 15, 255, 65, 255, 255}};
    protected boolean isZentyou = false;

    public int[][] getFlagTableHigh() {
        return this.flagTable;
    }

    public int[][] getFlagTableBigGame() {
        return this.flagTableBig;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagTableJac;
    }

    public int getStockType() {
        return 1;
    }

    public void gameRt(int flag) {
        ++this.rtCounter;
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        } else {
            ((AbstractMainBoard)this).isReplay = false;
        }
        if (this.rtCounter > this.rtFloor) {
            if (this.isZentyou) {
                this.isBreak = true;
            } else {
                this.rtFloor = this.rtCounter + 5;
                this.isZentyou = true;
            }
        }
        int random1024 = SimulatorLibrary.random((int)1024);
        int random16384 = SimulatorLibrary.random((int)16384);
        if (random16384 < this.breakRatio[((AbstractMainBoard)this).settei - 1][this.currentMode - 1]) {
            this.rtFloor = this.rtCounter + 5;
            this.breakFactor = 15;
            this.isZentyou = true;
        }
        switch (flag) {
            case 2: {
                this.stock.add((Object)new Integer(3));
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                break;
            }
            case 0: {
                this.breakFactor = -11;
                this.isBreak = true;
                break;
            }
            case 4: {
                this.fireCoinPlus(10);
                break;
            }
            case 6: {
                this.fireCoinPlus(6);
                break;
            }
            case 5: {
                if (random1024 < 128) {
                    if (!this.isZentyou) {
                        this.breakFactor = 13;
                        this.isBreak = true;
                    }
                    this.fireCoinPlus(2);
                    this.fireEvent(25);
                    break;
                }
                if (random1024 < 555) {
                    this.fireCoinPlus(2);
                    this.fireEvent(25);
                    break;
                }
                if (random1024 < 597) {
                    if (!this.isZentyou) {
                        this.breakFactor = 13;
                        this.isBreak = true;
                    }
                    this.fireCoinPlus(4);
                    this.fireEvent(26);
                    break;
                }
                this.fireCoinPlus(4);
                this.fireEvent(26);
                break;
            }
            case 1: {
                if (random1024 < 2) {
                    if (this.isZentyou) break;
                    this.breakFactor = 14;
                    this.isBreak = true;
                    break;
                }
                if (random1024 < 161) {
                    ((AbstractMainBoard)this).isReplay = true;
                    break;
                }
                if (!this.isBreak) break;
                if (this.nextBonus == 3) {
                    this.fireCoinPlus(15);
                } else {
                    this.fireCoinPlus(3);
                }
                this.bonusGet();
            }
        }
    }

    public void gameNotRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        } else {
            ((AbstractMainBoard)this).isReplay = false;
        }
        int random1024 = SimulatorLibrary.random((int)1024);
        int random16384 = SimulatorLibrary.random((int)16384);
        switch (flag) {
            case 2: {
                this.stock.add((Object)new Integer(3));
                this.reset();
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                this.reset();
                break;
            }
            case 0: {
                break;
            }
            case 4: {
                this.fireCoinPlus(10);
                break;
            }
            case 6: {
                this.fireCoinPlus(6);
                break;
            }
            case 5: {
                if (random1024 < 128) {
                    this.fireCoinPlus(2);
                    this.fireEvent(25);
                    break;
                }
                if (random1024 < 555) {
                    this.fireCoinPlus(2);
                    this.fireEvent(25);
                    break;
                }
                if (random1024 < 597) {
                    this.fireCoinPlus(4);
                    this.fireEvent(26);
                    break;
                }
                this.fireCoinPlus(4);
                this.fireEvent(26);
                break;
            }
            case 1: {
                if (random1024 < 2 || random1024 >= 161) break;
                ((AbstractMainBoard)this).isReplay = true;
            }
        }
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                if (jacInCount >= 2 && game <= 23) break;
                this.setJacIn();
                this.fireCoinPlus(3);
                break;
            }
            case 2: {
                this.fireCoinPlus(8);
                break;
            }
            case 3: {
                this.fireCoinPlus(4);
                break;
            }
            case 4: {
                this.fireCoinPlus(15);
            }
        }
    }

    public void jacGame(int flag, int gameCount) {
        this.fireCoinMinus(1);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                this.setJacHit();
                this.fireCoinPlus(15);
            }
        }
    }

    public void reset() {
        this.isBreak = false;
        if (this.stock.size() > 0) {
            this.nextBonus = (Integer)this.stock.get(0) == 3 ? 3 : 4;
            this.stock.remove(0);
            this.noStock = false;
        } else {
            this.nextBonus = -1;
            this.noStock = true;
        }
        if (!this.noStock) {
            this.currentMode = this._getNextMode();
            this.rtFloor = 772;
            this.rtCounter = 0;
            this.breakFactor = -10;
            this.isZentyou = false;
            super.reset();
            this.fireEvent(23);
        } else {
            this.rtCounter = 0;
            this.breakFactor = -10;
            this.isZentyou = false;
            super.reset();
        }
    }

    private int _getNextMode() {
        if (this.currentMode < 1) {
            return SimulatorLibrary.getTableIndex((int[])this.resetModeTable, (int)256) + 1;
        }
        int index = -1;
        index = SimulatorLibrary.getTableIndex((int[])this.modeTable[this.currentMode - 1][((AbstractMainBoard)this).settei - 1], (int)256);
        return index + 1;
    }
}

