/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.NeoMagicPulser;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter4Stock;
import jp.sourceforge.slotsimulator.machines.NeoMagicPulser.NeoMagicPulserMainBoard;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface4Stock;

public class NeoMagicPulserDataCounter
extends AbstractDataCounter4Stock {
    protected JCheckBoxMenuItem mzReport = null;
    protected int[] modeStayed = new int[]{0, 0, 0, 0, 0, 0};
    protected int[] modeTotalGame = new int[]{0, 0, 0, 0, 0, 0};
    int beforeBonusCoin = 0;

    public static final void main(String[] args) {
        NeoMagicPulserDataCounter main = null;
        try {
            main = new NeoMagicPulserDataCounter();
            ((Window)((Object)main)).show();
            Object var3_2 = null;
            main = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            main = null;
            throw throwable;
        }
    }

    public NeoMagicPulserDataCounter() {
        this.initialize();
    }

    protected void initializeGui(JPanel north) {
        super.initializeGui(north);
        this.mzReport = new JCheckBoxMenuItem("MZ\u5c65\u6b74");
        this.addOptionMenu(this.mzReport);
    }

    protected Dimension getFrameSize() {
        return new Dimension(500, 550);
    }

    protected String getFrameTitle() {
        return "\u30de\u30b8\u30d1\u30eb\u30b7\u30df\u30e5\u30ec\u30fc\u30bf";
    }

    protected MainBoardInterface getSimulator() {
        return new NeoMagicPulserMainBoard();
    }

    public void processEvent(int eventId) {
        switch (eventId) {
            case 21: {
                this.eventMzStart();
                break;
            }
            case 22: {
                this.eventMzEnd();
                break;
            }
            case 23: {
                this.eventRtStart();
            }
        }
    }

    protected void eventBonusStart() {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        this.beforeBonusCoin = this.getCoin();
    }

    protected void eventBonusEnd() {
        int currentMode = ((MainBoardInterface4Stock)((AbstractDataCounter)this).simulator).getCurrentMode();
        int n = currentMode - 1;
        this.modeStayed[n] = this.modeStayed[n] + 1;
        int n2 = currentMode - 1;
        this.modeTotalGame[n2] = this.modeTotalGame[n2] + this.getCurrentGameCount();
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        int bonusCoin = this.getCoin() - this.beforeBonusCoin;
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        this.appendLog("\t");
        if (((AbstractDataCounter)this).simulator.getCurrentBonus() == 3) {
            this.appendLog("BIG[" + bonusCoin + "]");
        } else {
            this.appendLog("REG");
        }
        this.appendLog("\t");
        int breakFactor = ((NeoMagicPulserMainBoard)((AbstractDataCounter)this).simulator).getBreakFactor();
        switch (breakFactor) {
            case -10: {
                this.appendLog("RT\u30c6\u30fc\u30d6\u30eb");
                break;
            }
            case -11: {
                this.appendLog("\u7d14\u30cf\u30ba\u30ec");
                break;
            }
            case 16: {
                this.appendLog("MZ\u4e2d\u30c1\u30a7\u30ea\u30fc");
                break;
            }
            case 18: {
                this.appendLog("MZ\u4e2d\u30aa\u30ec\u30f3\u30b8");
                break;
            }
            case 17: {
                this.appendLog("MZ\u4e2d\u30ea\u30d7\u30ec\u30a4");
                break;
            }
            case 13: {
                this.appendLog("\u901a\u5e38\u30c1\u30a7\u30ea\u30fc");
                break;
            }
            case 15: {
                this.appendLog("\u901a\u5e38\u30aa\u30ec\u30f3\u30b8");
                break;
            }
            case 14: {
                this.appendLog("\u901a\u5e38\u30ea\u30d7\u30ec\u30a4");
            }
        }
        this.appendLog("\tM" + String.valueOf(currentMode));
        this.appendLog("\t" + this.getCoin());
        this.appendLog("\tstock=" + this.getStockBRCount());
        this.appendLog("\n");
    }

    protected void eventMzStart() {
        if (!this.mzReport.isSelected()) {
            return;
        }
        this.appendLog("\t[" + String.valueOf(this.getCurrentGameCount()) + "]");
        this.appendLog("\tMZ\u7a81\u5165\t");
        int mzFactor = ((NeoMagicPulserMainBoard)((AbstractDataCounter)this).simulator).getMzFactor();
        switch (mzFactor) {
            case 1: {
                this.appendLog("MZ\u5929\u4e95");
                break;
            }
            case 3: {
                this.appendLog("\u30c1\u30a7\u30ea\u30fc");
                break;
            }
            case 2: {
                this.appendLog("\u30ea\u30d7\u30ec\u30a4");
            }
        }
        int mzFloor = ((NeoMagicPulserMainBoard)((AbstractDataCounter)this).simulator).getMzFloor();
        this.appendLog("\t" + mzFloor);
        this.appendLog("\n");
    }

    protected void eventMzEnd() {
        if (!this.mzReport.isSelected()) {
            return;
        }
        this.appendLog("\t[" + String.valueOf(this.getCurrentGameCount()) + "]");
        this.appendLog("\tMZ\u7d42\u4e86");
        int mzFloor = ((NeoMagicPulserMainBoard)((AbstractDataCounter)this).simulator).getMzFloor();
        this.appendLog("\t" + mzFloor);
        this.appendLog("\n");
    }

    protected void eventRtStart() {
        int currentGameCount = this.getCurrentGameCount();
        if (!this.rtReport.isSelected() && !this.rtReportNotZero.isSelected()) {
            return;
        }
        if (currentGameCount == 0 && !this.rtReport.isSelected()) {
            return;
        }
        this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
        this.appendLog("\tRT\u958b\u59cb");
        int mode = ((MainBoardInterface4Stock)((AbstractDataCounter)this).simulator).getCurrentMode();
        this.appendLog("\tM" + mode);
        int rtFloor = ((NeoMagicPulserMainBoard)((AbstractDataCounter)this).simulator).getRtFloor();
        this.appendLog("\t" + rtFloor);
        int mzFloor = ((NeoMagicPulserMainBoard)((AbstractDataCounter)this).simulator).getMzFloor();
        this.appendLog("\tMZ\u5929\u4e95=" + mzFloor);
        this.appendLog("\n");
    }

    protected void eventStart() {
    }

    protected void eventSimulateStart() {
        int i = 0;
        while (i < 6) {
            this.modeStayed[i] = 0;
            this.modeTotalGame[i] = 0;
            ++i;
        }
    }

    protected void eventSimulateEnd() {
        this.appendLogStopGameAndTotalGame();
        this.appendLogDenominator("BIG", this.getBigCount(), this.getTotalGameCount());
        this.appendLogDenominator("REG", this.getRegCount(), this.getTotalGameCount());
        this.appendLogDenominator("\u5408\u6210", this.getBigCount() + this.getRegCount(), this.getTotalGameCount());
        int bonusCount = this.getBigCount() + this.getRegCount();
        this.appendLog("\n\n");
        double stayedRatio = 0.0;
        double breakRatio = 0.0;
        int i = 0;
        while (i < 6) {
            stayedRatio = (double)Math.round((double)(this.modeStayed[i] / bonusCount) * 100.0 * 100.0) / 100.0;
            breakRatio = this.modeStayed[i] != 0 ? (double)Math.round((double)this.modeTotalGame[i] / (double)this.modeStayed[i] * 100.0) / 100.0 : 0.0;
            this.appendLog("M" + (i + 1) + ":\t" + stayedRatio + "%(" + this.modeStayed[i] + ")" + "\t\u5e73\u5747\u89e3\u9664G=" + breakRatio + "\n");
            ++i;
        }
        this.appendLogPayout();
    }

    protected void processActionEvent(ActionEvent e) {
    }
}

