/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.Kyojin;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class KyojinMainBoard
extends AbstractMainBoard4Stock {
    public static final int EVENT_REP3 = 25;
    public static final int EVENT_TOKKUN_START = 26;
    public static final int EVENT_NIGHTER_START = 27;
    public static final int EVENT_NIGHTER_END = 28;
    public static final int EVENT_TOKKUN_HIT = 29;
    public static final int BREAK_REPLAY4 = 10;
    public static final int FLAG_BELL = 4;
    public static final int FLAG_CHERRY = 5;
    public static final int FLAG_SUIKA = 6;
    public static final int FLAG_BIG_CHERRY = 2;
    public static final int FLAG_BIG_SUIKA = 3;
    protected int[][] flagTable = new int[][]{{1, 55577, 551, 551, 7800, 256, 800}, {1, 55577, 551, 551, 7800, 256, 800}, {1, 55577, 551, 551, 7800, 256, 800}, {1, 55577, 551, 551, 7800, 256, 800}, {1, 55577, 551, 551, 7800, 256, 800}, {1, 55577, 551, 551, 7800, 256, 800}};
    protected int[][] flagTableBig = new int[][]{{1, 65522, 3, 10}, {1, 65522, 3, 10}, {1, 65522, 3, 10}, {1, 65522, 3, 10}, {1, 65522, 3, 10}, {1, 65522, 3, 10}};
    protected int[][] flagTableJac = new int[][]{{1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}};
    protected int[][] rtTable = new int[][]{{39, 35, 31, 27, 20, 16, 16, 16, 13, 13, 13, 13, 4}, {39, 35, 31, 27, 20, 16, 16, 16, 13, 13, 14, 12, 4}, {39, 35, 31, 27, 20, 16, 16, 16, 13, 14, 13, 12, 4}, {39, 35, 31, 27, 20, 16, 16, 16, 14, 13, 13, 12, 4}, {40, 36, 32, 28, 20, 16, 16, 16, 12, 12, 12, 12, 4}, {41, 36, 32, 28, 20, 17, 17, 17, 12, 12, 12, 12, 0}};
    protected int[][] rtG = new int[][]{{1, 17, 33, 65, 97, 129, 257, 385, 513, 641, 769, 1025, 1281}, {16, 32, 64, 96, 128, 256, 384, 512, 640, 768, 1024, 1280, 1536}};
    protected int[] tokkunHitTable = new int[]{64, 70, 75, 80, 86, 100};
    protected int[][] tokkunCountTable = new int[][]{{250, 5, 1}, {238, 16, 2}, {219, 33, 4}, {190, 58, 8}, {170, 76, 10}, {140, 116, 0}};
    protected int currentTokkunHitCount = 0;
    protected int replayContinueCount = 0;
    protected int tokkunReplayFloor = 0;
    protected int tokkunReplayCount = 0;
    protected boolean isTokkun = false;
    protected int tokkunCount = 0;

    public int[][] getFlagTableHigh() {
        return this.flagTable;
    }

    public int[][] getFlagTableBigGame() {
        return this.flagTableBig;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagTableJac;
    }

    public int getCurrentTokkunHitCount() {
        return this.currentTokkunHitCount;
    }

    public boolean isTokkun() {
        return this.isTokkun;
    }

    public int getTokkunCount() {
        return this.tokkunCount;
    }

    public void gameRt(int flag) {
        ++this.rtCounter;
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        } else {
            ((AbstractMainBoard)this).isReplay = false;
        }
        if (this.rtCounter >= this.rtFloor) {
            this.isBreak = true;
        }
        if (this.tokkunCount > 0 && this.tokkunReplayCount >= this.tokkunReplayFloor && this.rtFloor - this.rtCounter > 65 && !this.isTokkun) {
            this.isTokkun = true;
            --this.tokkunCount;
            this.tokkunReplayFloor = 0;
            this.fireEvent(26);
        }
        if (flag != 1) {
            this.replayContinueCount = 0;
        }
        int random128 = SimulatorLibrary.random((int)128);
        switch (flag) {
            case 2: {
                this.stock.add((Object)new Integer(3));
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                break;
            }
            case 0: {
                this.breakFactor = -11;
                this.isBreak = true;
                break;
            }
            case 4: {
                this.fireCoinPlus(7);
                break;
            }
            case 5: {
                if (random128 < 64) {
                    this.fireCoinPlus(4);
                    break;
                }
                this.fireCoinPlus(2);
                break;
            }
            case 6: {
                this.fireCoinPlus(10);
                break;
            }
            case 1: {
                boolean isNavi;
                if (random128 < 28) {
                    this.replayContinueCount = 0;
                    if (!this.isBreak) break;
                    this.bonusGet();
                    this.fireCoinPlus(15);
                    break;
                }
                random128 = SimulatorLibrary.random((int)128);
                if (this.isTokkun) {
                    ((AbstractMainBoard)this).isReplay = true;
                    ++this.replayContinueCount;
                    if (this.replayContinueCount != 4) break;
                    this.isBreak = true;
                    this.breakFactor = 10;
                    break;
                }
                boolean bl = isNavi = SimulatorLibrary.random((int)256) < 1;
                if (random128 < 27 || isNavi) {
                    ((AbstractMainBoard)this).isReplay = true;
                    ++this.replayContinueCount;
                    if (this.replayContinueCount == 3 && !isNavi) {
                        if (SimulatorLibrary.random((int)256) < this.tokkunHitTable[((AbstractMainBoard)this).settei - 1]) {
                            int index = SimulatorLibrary.getTableIndex((int[])this.tokkunCountTable[((AbstractMainBoard)this).settei - 1], (int)256);
                            if (index == 0) {
                                this.currentTokkunHitCount = 1;
                            } else if (index == 1) {
                                this.currentTokkunHitCount = 3;
                            } else if (index == 5) {
                                this.currentTokkunHitCount = 5;
                            }
                            this.tokkunCount += this.currentTokkunHitCount;
                            this.tokkunReplayFloor = SimulatorLibrary.random((int)9);
                            this.tokkunReplayCount = 0;
                        }
                        this.fireEvent(25);
                        this.currentTokkunHitCount = 0;
                    } else if (this.replayContinueCount == 4) {
                        this.isBreak = true;
                        this.breakFactor = 10;
                        this.replayContinueCount = 0;
                    }
                    if (this.tokkunCount <= 0) break;
                    ++this.tokkunReplayCount;
                    break;
                }
                this.replayContinueCount = 0;
                if (!this.isBreak) break;
                this.bonusGet();
                this.fireCoinPlus(15);
            }
        }
    }

    public void gameNotRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        } else {
            ((AbstractMainBoard)this).isReplay = false;
        }
        int random128 = SimulatorLibrary.random((int)128);
        switch (flag) {
            case 2: {
                this.stock.add((Object)new Integer(3));
                this.reset();
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                this.reset();
                break;
            }
            case 0: {
                this.breakFactor = -11;
                this.isBreak = true;
                break;
            }
            case 4: {
                this.fireCoinPlus(7);
                break;
            }
            case 5: {
                if (random128 < 64) {
                    this.fireCoinPlus(4);
                    break;
                }
                this.fireCoinPlus(2);
                break;
            }
            case 6: {
                this.fireCoinPlus(10);
                break;
            }
            case 1: {
                if (random128 < 28 || (random128 = SimulatorLibrary.random((int)128)) >= 27) break;
                ((AbstractMainBoard)this).isReplay = true;
            }
        }
    }

    public int getMaxBigGameCount() {
        return 15;
    }

    public int getMaxJacInCount() {
        return 2;
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                if (game == 6 || game == 15) {
                    this.setJacIn();
                    this.fireCoinPlus(3);
                    break;
                }
                this.fireCoinPlus(15);
                break;
            }
            case 2: {
                this.fireCoinPlus(4);
                break;
            }
            case 3: {
                this.fireCoinPlus(10);
            }
        }
    }

    public void jacGame(int flag, int gameCount) {
        this.fireCoinMinus(1);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                this.setJacHit();
                this.fireCoinPlus(15);
            }
        }
    }

    public void reset() {
        this.isBreak = false;
        this.isTokkun = false;
        if (this.tokkunCount > 0) {
            this.tokkunReplayFloor = SimulatorLibrary.random((int)9);
            this.tokkunReplayCount = 0;
        }
        if (this.stock.size() > 0) {
            this.nextBonus = this._getNextBonus();
            this.noStock = false;
        } else {
            this.nextBonus = -1;
            this.noStock = true;
        }
        if (!this.noStock) {
            this.rtFloor = this._getRtFloor();
            this.rtCounter = 0;
            this.breakFactor = -10;
            super.reset();
            this.fireEvent(23);
        } else {
            this.rtCounter = 0;
            this.breakFactor = -10;
            super.reset();
        }
    }

    private int _getRtFloor() {
        int index = -1;
        index = SimulatorLibrary.getTableIndex((int[])this.rtTable[((AbstractMainBoard)this).settei - 1], (int)256);
        int min = this.rtG[0][index];
        int max = this.rtG[1][index];
        int g = SimulatorLibrary.getRandomPerRange((int)min, (int)max);
        return g;
    }

    private int _getNextBonus() {
        int next = -1;
        next = SimulatorLibrary.random((int)256) < 140 ? 3 : 4;
        int index = 0;
        boolean exists = false;
        index = 0;
        while (index < this.stock.size()) {
            if ((Integer)this.stock.get(index) == next) {
                exists = true;
                break;
            }
            ++index;
        }
        if (exists) {
            this.stock.remove(index);
        } else {
            next = (Integer)this.stock.get(0) == 3 ? 3 : 4;
            this.stock.remove(0);
        }
        return next;
    }
}

