/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.Haiena;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;

public class HaienaMainBoard
extends AbstractMainBoard {
    public static final int EVENT_AT_HIT = 24;
    public static final int EVENT_AT_START = 21;
    public static final int EVENT_AT_END = 22;
    public static final int EVENT_NOFLAG = 23;
    public static final int EVENT_SUPERAT_HIT = 25;
    public static final int MODE_S = 0;
    public static final int MODE_A = 1;
    public static final int MODE_B = 2;
    public static final int MODE_C = 3;
    public static final int AT_HIT_FACTOR_NOFLAG = 1;
    public static final int AT_HIT_FACTOR_MODE = 2;
    public static final int AT_HIT_FACTOR_BIG = 3;
    public static final int AT_HIT_FACTOR_FLOOR = 4;
    private int currentBonus = -1;
    private int atHitFactor = -1;
    private int satCount = 0;
    private int atCount = 0;
    private int atGameFloor = 0;
    private boolean isAt = false;
    private boolean isSuper = false;
    private int hazureCount = 0;
    private int tenjou = 0;
    private int senpukuFloor = 0;
    private int currentMode = -1;
    private int[] atHitByMode = new int[]{83, 65, 35, 10};
    private int[] atHitByNoFlag = new int[]{50, 71, 100, 100, 120, 152};
    private int[][] modeMove = new int[][]{{0, 5, 10, 85}, {0, 12, 18, 70}, {0, 15, 20, 65}, {0, 15, 20, 65}, {0, 25, 20, 55}, {0, 30, 20, 50}};
    private int[][] floor = new int[][]{{5, 10, 85}, {5, 15, 80}, {5, 15, 80}, {10, 15, 75}, {10, 15, 75}, {10, 15, 75}};
    private int[][] superAtCount = new int[][]{{80, 18, 2}, {80, 18, 2}, {78, 20, 2}, {78, 20, 2}, {70, 20, 10}, {90, 10, 0}};
    public static final int FLAG_15 = 4;
    public static final int FLAG_12 = 5;
    public static final int FLAG_2 = 6;
    private int[][] flagTableNormal = new int[][]{{488, 8990, 117, 46, 53771, 1062, 1062}, {488, 8990, 120, 46, 53771, 1059, 1062}, {488, 8990, 131, 46, 53771, 1048, 1062}, {488, 8990, 142, 46, 53771, 1037, 1062}, {488, 8990, 152, 46, 53771, 1027, 1062}, {488, 8990, 166, 46, 53771, 1013, 1062}};
    public static final int FLAG_BIG_10 = 2;
    public static final int FLAG_BIG_15 = 3;
    public static final int FLAG_BIG_2 = 4;
    private int[][] flagTableBig = new int[][]{{14552, 14000, 20184, 800, 16000}, {14552, 14000, 20184, 800, 16000}, {14552, 14000, 20184, 800, 16000}, {14552, 14000, 20184, 800, 16000}, {14552, 14000, 20184, 800, 16000}, {14552, 14000, 20184, 800, 16000}};
    private int[][] flagTableJac = new int[][]{{10, 65526}, {10, 65526}, {10, 65526}, {10, 65526}, {10, 65526}, {10, 65526}};
    int[] dummy = new int[]{0, 0, 0, 0, 0, 0};

    public void setup() {
        this.satCount = 0;
        this.atCount = 0;
        this.atGameFloor = 0;
        this.isAt = false;
        this.isSuper = false;
        this.hazureCount = 0;
        this.tenjou = 0;
        this.senpukuFloor = 0;
        this.currentMode = -1;
    }

    public void reset() {
        this.isBonus = false;
        if (this.currentMode == -1) {
            this.currentMode = 0;
            this.tenjou = 768;
            return;
        }
        int previousBonus = this.getCurrentBonus();
        if (this.isAt && previousBonus == 3) {
            this.isAt = true;
            this.atGameFloor = 30;
        }
        if (previousBonus == 3) {
            this.atHitJudge(3);
        }
    }

    public void game(int flag) {
        if (!this.isReplay) {
            this.fireCoinMinus(3);
        }
        if (flag != 1) {
            this.isReplay = false;
        }
        switch (flag) {
            case 0: {
                this.tenjou -= 10;
                this.fireEvent(23);
                this.atHitJudge(1);
                if (!this.isAt) break;
                ++this.hazureCount;
                if (this.hazureCount != 7) break;
                int index = SimulatorLibrary.getTableIndex((int[])this.superAtCount[this.settei - 1], (int)100);
                switch (index) {
                    case 0: {
                        this.satCount += 10;
                        break;
                    }
                    case 1: {
                        this.satCount += 20;
                        break;
                    }
                    case 2: {
                        this.satCount += 40;
                    }
                }
                this.fireEvent(25);
                this.hazureCount = 0;
                break;
            }
            case 1: {
                this.isReplay = true;
                break;
            }
            case 2: {
                this.currentBonus = 3;
                this.currentMode = SimulatorLibrary.getTableIndex((int[])this.modeMove[this.settei - 1], (int)100);
                this.tenjou = this.getNextTenjou();
                this.fireCoinPlus(15);
                this.bonusGet();
                break;
            }
            case 3: {
                this.currentBonus = 4;
                this.fireCoinPlus(15);
                this.bonusGet();
                break;
            }
            case 4: {
                if (this.isAt) {
                    this.fireCoinPlus(15);
                    break;
                }
                if (SimulatorLibrary.random((int)32) == 0) {
                    if (SimulatorLibrary.random((int)12) == 0) {
                        this.fireCoinPlus(15);
                        this.tenjou -= 50;
                        break;
                    }
                    this.tenjou -= 5;
                    break;
                }
                if (SimulatorLibrary.random((int)12) != 0) break;
                this.fireCoinPlus(15);
                break;
            }
            case 5: {
                this.fireCoinPlus(12);
                break;
            }
            case 6: {
                this.fireCoinPlus(2);
            }
        }
        --this.tenjou;
        if (this.tenjou <= 0) {
            if (SimulatorLibrary.random((int)100) < 20) {
                this.currentMode = 0;
            }
            this.atHitJudge(4);
            this.tenjou = this.getNextTenjou();
        }
        if (this.isAt) {
            --this.atGameFloor;
            if (this.atGameFloor < 0) {
                this.fireEvent(22);
                this.isAt = false;
                if (!this.isSuper) {
                    this.atHitJudge(2);
                }
                this.isSuper = false;
                if (this.atCount > 0 || this.satCount > 0) {
                    this.atSenpuku();
                }
            }
        } else if (this.atCount > 0) {
            --this.senpukuFloor;
            if (this.senpukuFloor <= 0) {
                --this.atCount;
                this.isAt = true;
                this.fireEvent(21);
                this.atGameFloor = 30;
            }
        } else if (this.satCount > 0) {
            --this.senpukuFloor;
            if (this.senpukuFloor <= 0) {
                --this.satCount;
                this.isAt = true;
                this.isSuper = true;
                this.fireEvent(21);
                this.atGameFloor = 30;
            }
        }
    }

    public boolean atHitJudge(int factor) {
        boolean hit = false;
        switch (factor) {
            case 1: {
                hit = SimulatorLibrary.random((int)1000) < this.atHitByNoFlag[this.settei - 1];
                break;
            }
            case 2: 
            case 3: {
                hit = SimulatorLibrary.random((int)100) < this.atHitByMode[this.currentMode];
                break;
            }
            case 4: {
                hit = true;
            }
        }
        if (hit) {
            this.atHitFactor = factor;
            if (this.isAt) {
                ++this.atCount;
            } else {
                ++this.atCount;
                this.atSenpuku();
            }
            this.fireEvent(24);
        }
        return hit;
    }

    public void atSenpuku() {
        int random100 = SimulatorLibrary.random((int)100);
        this.senpukuFloor = random100 < 30 ? SimulatorLibrary.random((int)31) + 2 : (random100 < 90 ? 31 : SimulatorLibrary.random((int)87) + 33);
    }

    private int getNextTenjou() {
        int index = SimulatorLibrary.getTableIndex((int[])this.floor[this.settei - 1], (int)100);
        int[] game = new int[]{768, 1024, 1536};
        return game[index];
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        switch (flag) {
            case 1: {
                if (jacInCount >= 2 && game <= 22) break;
                this.fireCoinPlus(6);
                this.setJacIn();
                break;
            }
            case 2: {
                this.fireCoinPlus(10);
                break;
            }
            case 3: {
                this.fireCoinPlus(15);
                break;
            }
            case 4: {
                this.fireCoinPlus(2);
            }
        }
    }

    public int[][] getFlagTableHigh() {
        return this.flagTableNormal;
    }

    public int[][] getFlagTableBigGame() {
        return this.flagTableBig;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagTableJac;
    }

    public int[][] getFlagTableLow() {
        return this.getFlagTableHigh();
    }

    public int getCurrentBonus() {
        return this.currentBonus;
    }

    public int[] genzanchi() {
        return this.dummy;
    }

    public int[] kasanchi() {
        return this.dummy;
    }

    public int getAtCount() {
        return this.atCount;
    }

    public int getAtHitFactor() {
        return this.atHitFactor;
    }

    public int getCurrentMode() {
        return this.currentMode;
    }

    public int getHazureCount() {
        return this.hazureCount;
    }

    public boolean isAt() {
        return this.isAt;
    }

    public boolean isSuper() {
        return this.isSuper;
    }

    public int getSatCount() {
        return this.satCount;
    }

    public int getTenjou() {
        return this.tenjou;
    }
}

