/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.Mogumogu;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class MogumoguMainBoard
extends AbstractMainBoard4Stock {
    public static final int MODE_1 = 1;
    public static final int MODE_2 = 2;
    public static final int MODE_3 = 3;
    public static final int MODE_4 = 4;
    public static final int MODE_5 = 5;
    public static final int REN_MODE_1 = 1;
    public static final int REN_MODE_2 = 2;
    public static final int REN_MODE_3 = 3;
    public static final int REN_MODE_4 = 4;
    protected boolean stateRen = false;
    protected int currentRenCount = 0;
    protected int currentRenMaxCount = 0;
    public static final int FLAG_BELL = 4;
    public static final int FLAG_SUIKA = 5;
    public static final int FLAG_CHERRY = 6;
    public static final int FLAG_BIG_15 = 2;
    public static final int FLAG_BIG_BELL = 3;
    public static final int FLAG_BIG_SUIKA = 4;
    public static final int FLAG_BIG_CHERRY = 5;
    protected int[][] flagTable = new int[][]{{4, 58156, 272, 104, 6120, 800, 80}, {4, 58156, 272, 104, 6120, 800, 80}, {4, 58156, 272, 104, 6120, 800, 80}, {4, 58152, 272, 108, 6120, 800, 80}, {4, 58152, 272, 108, 6120, 800, 80}, {4, 58152, 272, 108, 6120, 800, 80}};
    protected int[][] flagTableBig = new int[][]{{3840, 11916, 49600, 100, 40, 40}, {3840, 11916, 49600, 100, 40, 40}, {3840, 11916, 49600, 100, 40, 40}, {3840, 11916, 49600, 100, 40, 40}, {3840, 11916, 49600, 100, 40, 40}, {3840, 11916, 49600, 100, 40, 40}};
    protected int[][] flagTableJac = new int[][]{{4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}};
    protected int[][] rtTable = new int[][]{{3264, 3264, 6528, 6592, 29504, 0, 0, 0, 0, 16384, 0, 0, 0, 0, 0, 0}, {3264, 3264, 6528, 6592, 16384, 0, 0, 0, 0, 13120, 3264, 3264, 3264, 6592, 0, 0}, {0, 0, 0, 0, 0, 13056, 6592, 6528, 26240, 0, 0, 13120, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 6528, 6528, 6592, 6528, 6592, 6528, 9856, 6528, 9856, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 6528, 6528, 6592, 6528, 6592, 6528, 6528, 6592, 13120}};
    protected int[][] rtG = new int[][]{{129, 161, 193, 257, 321, 385, 449, 513, 577, 641, 705, 769, 833, 897, 961, 1089}, {160, 192, 256, 320, 384, 448, 512, 576, 640, 704, 768, 832, 896, 960, 1088, 1216}};
    protected int[][] rtTable2 = new int[][]{{50, 149, 200, 150, 100, 351, 0, 0, 0, 0}, {50, 50, 50, 50, 51, 250, 199, 150, 150, 0}, {20, 80, 20, 80, 101, 100, 150, 149, 200, 100}, {0, 0, 0, 69, 80, 101, 100, 200, 200, 250}};
    protected int[][] rtG2 = new int[][]{{1, 17, 33, 49, 65, 81, 97, 129, 161, 193}, {16, 32, 48, 64, 80, 96, 128, 160, 192, 256}};
    protected int[][] modeTable = new int[][]{{26240, 13052, 13120, 6592, 6528}, {26240, 13052, 13120, 6592, 6528}, {26240, 13052, 13120, 6592, 6528}, {19648, 19648, 19712, 6528, 0}, {26240, 13052, 13120, 6592, 6528}, {19648, 19648, 19712, 6528, 0}};
    protected int[][][] renTable = new int[][][]{new int[][]{{650, 280, 10, 10, 30, 20, 0, 0, 0, 0, 0}, {600, 300, 30, 20, 30, 0, 20, 0, 0, 0, 0}, {550, 300, 40, 10, 50, 40, 10, 0, 0, 0, 0}, {300, 600, 0, 100, 0, 0, 0, 0, 0, 0, 0}, {450, 250, 150, 50, 50, 0, 50, 0, 0, 0, 0}, {50, 450, 0, 250, 0, 0, 250, 0, 0, 0, 0}}, new int[][]{{550, 320, 30, 30, 30, 10, 10, 5, 5, 5, 5}, {550, 280, 40, 30, 60, 10, 10, 5, 5, 5, 5}, {550, 200, 70, 30, 100, 20, 10, 5, 5, 5, 5}, {0, 750, 0, 200, 50, 0, 0, 0, 0, 0, 0}, {450, 250, 50, 50, 100, 30, 30, 10, 10, 10, 10}, {0, 300, 0, 300, 300, 0, 100, 0, 0, 0, 0}}, new int[][]{{500, 0, 400, 0, 50, 0, 50, 0, 0, 0, 0}, {500, 0, 350, 0, 100, 0, 50, 0, 0, 0, 0}, {450, 0, 350, 0, 150, 0, 50, 0, 0, 0, 0}, {0, 600, 0, 300, 100, 0, 0, 0, 0, 0, 0}, {300, 0, 450, 0, 150, 0, 100, 0, 0, 0, 0}, {0, 0, 0, 700, 150, 0, 150, 0, 0, 0, 0}}, new int[][]{{500, 0, 350, 0, 60, 0, 50, 10, 10, 10, 10}, {500, 0, 300, 0, 100, 0, 60, 10, 10, 10, 10}, {450, 0, 300, 0, 150, 0, 60, 10, 10, 10, 10}, {0, 500, 0, 300, 100, 50, 50, 0, 0, 0, 0}, {300, 0, 450, 0, 100, 0, 50, 30, 20, 30, 20}, {0, 0, 0, 600, 0, 200, 100, 0, 0, 0, 100}}, new int[][]{{0, 500, 350, 0, 90, 10, 10, 10, 10, 10, 10}, {0, 500, 250, 0, 180, 10, 20, 10, 10, 10, 10}, {0, 500, 250, 0, 180, 10, 20, 10, 10, 10, 10}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 400, 300, 0, 180, 20, 20, 20, 20, 20, 20}}};
    protected int[] renCountTable = new int[]{1, 2, 3, 4, 5, 7, 10, 12, 15, 17, 20};

    public int getCurrentRenCount() {
        return this.currentRenCount;
    }

    public int getCurrentRenMaxCount() {
        return this.currentRenMaxCount;
    }

    public int[][] getFlagTableHigh() {
        return this.flagTable;
    }

    public int[][] getFlagTableBigGame() {
        return this.flagTableBig;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagTableJac;
    }

    public void gameRt(int flag) {
        ++this.rtCounter;
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        } else {
            ((AbstractMainBoard)this).isReplay = false;
        }
        if (this.rtCounter > this.rtFloor) {
            this.isBreak = true;
        }
        int random4096 = SimulatorLibrary.random((int)4096);
        switch (flag) {
            case 2: {
                this.stock.add(new Integer(3));
                break;
            }
            case 3: {
                this.stock.add(new Integer(4));
                break;
            }
            case 0: {
                this.breakFactor = -11;
                this.isBreak = true;
                break;
            }
            case 4: {
                this.fireCoinPlus(9);
                break;
            }
            case 6: {
                this.fireCoinPlus(4);
                break;
            }
            case 5: {
                this.fireCoinPlus(12);
                break;
            }
            case 1: {
                if (random4096 < 633) {
                    ((AbstractMainBoard)this).isReplay = true;
                    break;
                }
                if (!this.isBreak) break;
                this.bonusGet();
                this.fireCoinPlus(15);
            }
        }
    }

    public void gameNotRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        } else {
            ((AbstractMainBoard)this).isReplay = false;
        }
        int random4096 = SimulatorLibrary.random((int)4096);
        switch (flag) {
            case 2: {
                this.stock.add(new Integer(3));
                this.reset();
                break;
            }
            case 3: {
                this.stock.add(new Integer(4));
                this.reset();
                break;
            }
            case 0: {
                break;
            }
            case 4: {
                this.fireCoinPlus(9);
                break;
            }
            case 6: {
                this.fireCoinPlus(4);
                break;
            }
            case 5: {
                this.fireCoinPlus(12);
                break;
            }
            case 1: {
                if (random4096 < 633) {
                    ((AbstractMainBoard)this).isReplay = true;
                    break;
                }
                if (!this.isBreak) break;
                this.bonusGet();
                this.fireCoinPlus(15);
            }
        }
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                if (jacInCount < 2 || game > 23) {
                    this.setJacIn();
                    this.fireCoinPlus(15);
                    break;
                }
                this.fireCoinPlus(15);
                break;
            }
            case 2: {
                this.fireCoinPlus(15);
                break;
            }
            case 4: {
                this.fireCoinPlus(15);
                break;
            }
            case 3: {
                this.fireCoinPlus(15);
                break;
            }
            case 5: {
                this.fireCoinPlus(10);
            }
        }
    }

    public void jacGame(int flag, int gameCount) {
        this.fireCoinMinus(1);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                this.setJacHit();
                this.fireCoinPlus(15);
            }
        }
    }

    public void reset() {
        this.isBreak = false;
        if (this.stock.size() > 0) {
            this.nextBonus = (Integer)this.stock.get(0) == 3 ? 3 : 4;
            this.stock.remove(0);
            this.noStock = false;
        } else {
            this.nextBonus = -1;
            this.noStock = true;
        }
        if (!this.noStock) {
            if (this.currentRenMaxCount == this.currentRenCount) {
                this.currentMode = this._getNextMode();
                this.currentRenMaxCount = this._getNextRenMaxCount();
                this.currentRenCount = 1;
                this.rtFloor = this._getRtFloor();
            } else {
                ++this.currentRenCount;
                int renMode = -1;
                renMode = this.currentRenCount == 6 || this.currentRenCount == 11 || this.currentRenCount == 16 ? (this.currentRenMaxCount - this.currentRenCount > 4 ? 4 : 3) : (SimulatorLibrary.random((int)2) < 1 ? 2 : 1);
                this.rtFloor = this._getRenRtFloor(renMode);
                if (this.stock.size() < 2 && SimulatorLibrary.random((int)256) < 255) {
                    this.rtFloor += 400;
                }
            }
            this.rtCounter = 0;
            this.breakFactor = -10;
            super.reset();
            this.fireEvent(23);
        } else {
            this.currentMode = -1;
            this.rtCounter = 0;
            this.breakFactor = -10;
            super.reset();
        }
    }

    private int _getRtFloor() {
        int index = SimulatorLibrary.getTableIndex((int[])this.rtTable[this.currentMode - 1], (int)65536);
        int min = this.rtG[0][index];
        int max = this.rtG[1][index];
        int g = SimulatorLibrary.getRandomPerRange((int)min, (int)max);
        return g;
    }

    private int _getRenRtFloor(int mode) {
        int index = SimulatorLibrary.getTableIndex((int[])this.rtTable2[mode - 1], (int)1000);
        int min = this.rtG2[0][index];
        int max = this.rtG2[1][index];
        int g = SimulatorLibrary.getRandomPerRange((int)min, (int)max);
        return g;
    }

    private int _getNextRenMaxCount() {
        int index = SimulatorLibrary.getTableIndex((int[])this.renTable[this.currentMode - 1][((AbstractMainBoard)this).settei - 1], (int)1000);
        return this.renCountTable[index];
    }

    private int _getNextMode() {
        int index = -1;
        index = SimulatorLibrary.getTableIndex((int[])this.modeTable[((AbstractMainBoard)this).settei - 1], (int)65536);
        return index + 1;
    }
}

