/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.Kyojin;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter4Stock;
import jp.sourceforge.slotsimulator.machines.Kyojin.KyojinMainBoard;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface;

public class KyojinDataCounter
extends AbstractDataCounter4Stock {
    protected JCheckBoxMenuItem tokkunReport = null;
    protected JCheckBoxMenuItem rep3Report = null;
    protected int rep3Count = 0;
    protected int tokkunHitCount = 0;
    int bonusCoin = 0;

    public static final void main(String[] args) {
        KyojinDataCounter main = null;
        try {
            main = new KyojinDataCounter();
            ((Window)((Object)main)).show();
            Object var3_2 = null;
            main = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            main = null;
            throw throwable;
        }
    }

    public KyojinDataCounter() {
        this.initialize();
    }

    protected void initializeGui(JPanel north) {
        super.initializeGui(north);
        this.tokkunReport = new JCheckBoxMenuItem("\u7279\u8a13\u8868\u793a");
        this.tokkunReport.setSelected(true);
        this.rep3Report = new JCheckBoxMenuItem("\u30ea\u30d7\u30ec\u30a43\u9023\u8868\u793a");
        this.addOptionMenu(this.tokkunReport);
        this.addOptionMenu(this.rep3Report);
        this.textInitialStock.setText("10");
    }

    protected Dimension getFrameSize() {
        return new Dimension(500, 550);
    }

    protected String getFrameTitle() {
        return "\u5de8\u4eba\u306e\u661f\u30b7\u30df\u30e5";
    }

    protected MainBoardInterface getSimulator() {
        return new KyojinMainBoard();
    }

    public void processEvent(int eventId) {
        switch (eventId) {
            case 23: {
                this.eventRtStart();
                break;
            }
            case 25: {
                this.eventRep3();
                break;
            }
            case 26: {
                this.eventTokkunStart();
            }
        }
    }

    protected void eventBonusStart() {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        this.bonusCoin = this.getCoin();
    }

    protected void eventBonusEnd() {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        this.bonusCoin = this.getCoin() - this.bonusCoin;
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        this.appendLog("\t");
        if (((AbstractDataCounter)this).simulator.getCurrentBonus() == 3) {
            this.appendLog("BIG[" + this.bonusCoin + "]");
        } else {
            this.appendLog("REG");
        }
        this.appendLog("\t");
        int breakFactor = ((KyojinMainBoard)((AbstractDataCounter)this).simulator).getBreakFactor();
        switch (breakFactor) {
            case -10: {
                this.appendLog("RT\u30c6\u30fc\u30d6\u30eb");
                break;
            }
            case -11: {
                this.appendLog("\u7d14\u30cf\u30ba\u30ec");
                break;
            }
            case 10: {
                if (((KyojinMainBoard)((AbstractDataCounter)this).simulator).isTokkun()) {
                    this.appendLog("\u7279\u8a13");
                    break;
                }
                this.appendLog("\u30ea\u30d7\u30ec\u30a44\u9023");
            }
        }
        this.appendLog("\t");
        this.appendLog("\t" + this.getCoin());
        this.appendLog("\tstock=" + this.getStockBRCount());
        this.appendLog("\n");
    }

    protected void eventStart() {
    }

    protected void eventSimulateStart() {
        this.rep3Count = 0;
        this.tokkunHitCount = 0;
    }

    protected void eventSimulateEnd() {
        this.appendLogStopGameAndTotalGame();
        this.appendLogDenominator("BIG", this.getBigCount(), this.getTotalGameCount());
        this.appendLogDenominator("REG", this.getRegCount(), this.getTotalGameCount());
        this.appendLogDenominator("\u5408\u6210", this.getBigCount() + this.getRegCount(), this.getTotalGameCount());
        this.appendLogDenominator("\u30ea\u30d7\u30ec\u30a43\u9023", this.rep3Count, this.getTotalGameCount());
        this.appendLogDenominator("\u7279\u8a13\u5f53\u9078", this.tokkunHitCount, this.getTotalGameCount());
        this.appendLogPayout();
    }

    protected void eventRep3() {
        int tokkunHit = ((KyojinMainBoard)((AbstractDataCounter)this).simulator).getCurrentTokkunHitCount();
        ++this.rep3Count;
        if (tokkunHit > 0) {
            ++this.tokkunHitCount;
        }
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        if (!this.rep3Report.isSelected() && !this.tokkunReport.isSelected()) {
            return;
        }
        int currentGameCount = this.getCurrentGameCount();
        if (tokkunHit == 0 && this.rep3Report.isSelected()) {
            this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
            this.appendLog("\tReplay3\u9023\n");
        } else if (tokkunHit > 0 && (this.tokkunReport.isSelected() || this.rep3Report.isSelected())) {
            this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
            this.appendLog("\tReplay3\u9023");
            this.appendLog("\t\u7279\u8a13\u5f53\u9078(" + String.valueOf(tokkunHit) + ")\n");
        }
    }

    protected void eventTokkunStart() {
        int currentGameCount = this.getCurrentGameCount();
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        if (!this.tokkunReport.isSelected()) {
            return;
        }
        this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
        this.appendLog("\t\u7279\u8a13\u767a\u52d5");
        int tokkunCount = ((KyojinMainBoard)((AbstractDataCounter)this).simulator).getTokkunCount();
        this.appendLog("\t\u6b8b=" + String.valueOf(tokkunCount) + "\n");
    }

    protected void processActionEvent(ActionEvent e) {
    }
}

