/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.datacounter;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.JFrame;
import jp.sourceforge.slotsimulator.datacounter.DataCounterInterface;
import jp.sourceforge.slotsimulator.datacounter.DataCounterListener;

public class SlumpPanel
extends JFrame
implements DataCounterListener {
    static final double MARGIN_LEFT = 20.0;
    static final double MARGIN_TOP = 80.0;
    static final double MARGIN_BOTTOM = 30.0;
    static final int GAME_UNIT = 1000;
    double MAX_STOCK = 1.0;
    double X_FIRST_POSITION = 50.0;
    double Y_FIRST_POSITION = 300.0;
    static double X_UNIT = 0.08;
    static double Y_UNIT = 0.04;
    private int coinCount = 0;
    private double totalCount = 0.0;
    private int totalIn = 0;
    private int totalOut = 0;
    private int minCoin = 0;
    private int maxCoin = 0;
    private Vector shapes = null;
    private int stockCount = 0;
    private DataCounterInterface sender = null;
    NumberFormat nf = NumberFormat.getInstance();

    public void create(DataCounterInterface sender, String title) {
        try {
            this.setDefaultCloseOperation(1);
            this.shapes = new Vector();
            sender.addListener(this);
            this.sender = sender;
            this.setTitle(title);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            throw throwable;
        }
    }

    public void setPaintInfo(Vector points, double totalCount, int totalIn, int totalOut, int minCoin, int maxCoin) {
        this.shapes = points;
        this.totalCount = totalCount;
        this.totalIn = totalIn;
        this.totalOut = totalOut;
        this.minCoin = minCoin;
        this.maxCoin = maxCoin;
    }

    public void fireStartUp() {
        this.shapes.removeAllElements();
        this.shapes = null;
        this.shapes = new Vector();
        this.totalCount = 0.0;
        this.coinCount = 0;
        this.stockCount = 0;
        this.minCoin = 0;
        this.maxCoin = 0;
        this.X_FIRST_POSITION = 0.0;
        this.Y_FIRST_POSITION = 0.0;
        this.totalIn = 0;
        this.totalOut = 0;
        int maxGameCount = this.sender.getMaxSimulateGame();
        this.MAX_STOCK = maxGameCount > 1000 ? (double)(maxGameCount / 1000) : 1.0;
    }

    public void fireEnd() {
        if (this.isVisible()) {
            this.repaint();
        } else {
            this.show();
        }
    }

    public void finalize() throws Throwable {
        try {
            this.dispose();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public void dispose() {
        if (this.sender != null) {
            this.sender.removeListener(this);
        }
        if (this.shapes != null) {
            this.shapes.clear();
            this.shapes = null;
        }
        this.sender = null;
        super.dispose();
    }

    private void setPosition() {
        double[] point = new double[]{this.totalCount, this.coinCount};
        this.shapes.add(point);
    }

    public void event(int eventId, int currentGameCount, int bigIntervalGameCount) {
        if (eventId == 1) {
            this.fireStartUp();
        }
        ++this.stockCount;
        this.totalCount += 1.0;
        if ((double)this.stockCount >= this.MAX_STOCK) {
            this.setPosition();
            this.stockCount = 0;
        }
        if (eventId == 2) {
            this.fireEnd();
        }
    }

    public void coinMinus(int state, int minus, int currentGameCount, int bigIntervalGameCount) {
        this.totalIn += minus;
        this.coinCount -= minus;
        if (this.minCoin > this.coinCount) {
            this.minCoin = this.coinCount;
        }
    }

    public void coinPlus(int state, int plus, int currentGameCount, int bigIntervalGameCount) {
        this.totalOut += plus;
        this.coinCount += plus;
        if (this.maxCoin < this.coinCount) {
            this.maxCoin = this.coinCount;
        }
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setBackground(Color.white);
        double width = (double)this.getWidth() - 40.0;
        X_UNIT = width / this.totalCount;
        this.X_FIRST_POSITION = 20.0;
        double height = (double)this.getHeight() - 110.0;
        Y_UNIT = height / (double)(this.maxCoin - this.minCoin);
        this.Y_FIRST_POSITION = (double)this.maxCoin * Y_UNIT + 80.0;
        g2.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.drawBaseLine(g2);
        g2.setPaint(Color.blue);
        int size = this.shapes.size();
        double oldx = this.X_FIRST_POSITION;
        double oldy = this.Y_FIRST_POSITION;
        int i = 0;
        while (i < size) {
            double[] point = (double[])this.shapes.get(i);
            double _x = this.X_FIRST_POSITION + point[0] * X_UNIT;
            double _y = this.Y_FIRST_POSITION + point[1] * Y_UNIT * -1.0;
            Line2D.Double s = new Line2D.Double(oldx, oldy, _x, _y);
            oldx = _x;
            oldy = _y;
            g2.draw(s);
            ++i;
        }
        double x = 10.0;
        double y = 25.0;
        double rectWidth = (double)this.getWidth() - x * 2.0;
        double rectHeight = 24.0;
        g2.setPaint(Color.pink);
        g2.fill(new Rectangle2D.Double(x, y, rectWidth, rectHeight));
        g2.draw3DRect((int)x, (int)y, (int)rectWidth, (int)rectHeight, true);
        g2.setPaint(Color.black);
        double real = (double)this.totalOut / (double)this.totalIn * 100.0;
        real = (double)Math.round(real * 100.0) / 100.0;
        StringBuffer buf = new StringBuffer();
        buf.append("PAYOUT: ").append(this.nf.format(real)).append(" [%] ");
        buf.append("  IN: ").append(this.nf.format(this.totalIn)).append(" [\u679a] ");
        buf.append("  OUT: ").append(this.nf.format(this.totalOut)).append(" [\u679a] ");
        g2.drawString(buf.toString(), 20, 40);
        buf = null;
        buf = new StringBuffer();
        buf.append("MAX: ").append(this.nf.format(this.maxCoin)).append("   MIN: ").append(this.nf.format(this.minCoin));
        g2.drawString(buf.toString(), this.getWidth() - buf.length() * 7, 60);
    }

    private void drawBaseLine(Graphics2D g2) {
        int s = 500;
        int count = this.getHeight() / 70;
        int lange = (this.maxCoin - this.minCoin) / count;
        if ((lange = lange / 500 * s) < 0) {
            lange *= -1;
        }
        if (lange == 0) {
            lange = 200;
        }
        if (lange > 1000) {
            lange = lange / 1000 * 1000;
        }
        int min = this.minCoin / lange * lange;
        if (lange > 1000) {
            min = min / 1000 * 1000;
        }
        int line = min;
        while (line < this.maxCoin) {
            this.drawBaseLine(g2, this.nf.format(line), line, Color.black);
            line += lange;
        }
        this.drawBaseLine(g2, "0", 0.0, Color.red);
    }

    private void drawBaseLine(Graphics2D g2, String name, double coin, Color color) {
        g2.setPaint(color);
        int y = (int)(this.Y_FIRST_POSITION + coin * Y_UNIT * -1.0);
        g2.drawString(name, 10, y);
        Line2D.Double line = new Line2D.Double(10.0, y, this.getWidth(), y);
        g2.draw(line);
    }
}

