/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.JSR;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter4Stock;
import jp.sourceforge.slotsimulator.machines.JSR.JSRMainBoard;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface;

public class JSRDataCounter
extends AbstractDataCounter4Stock {
    protected JCheckBoxMenuItem jcReport = null;
    protected JCheckBoxMenuItem modeReport = null;
    protected JCheckBoxMenuItem chanceReport = null;
    protected int jcCount = 0;
    protected int jcCount0 = 0;
    protected int chanceCount = 0;
    protected int koyaku7NoJc = 0;

    public static final void main(String[] args) {
        JSRDataCounter main = null;
        try {
            main = new JSRDataCounter();
            ((Window)((Object)main)).show();
            Object var3_2 = null;
            main = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            main = null;
            throw throwable;
        }
    }

    public JSRDataCounter() {
        this.initialize();
    }

    protected void initializeGui(JPanel north) {
        super.initializeGui(north);
        this.modeReport = new JCheckBoxMenuItem("\u30e2\u30fc\u30c9\u5c65\u6b74");
        this.jcReport = new JCheckBoxMenuItem("JC\u5c65\u6b74", true);
        this.chanceReport = new JCheckBoxMenuItem("\u30c1\u30e3\u30f3\u30b9\u76ee\u8868\u793a");
        this.addOptionMenu(this.modeReport);
        this.addOptionMenu(this.jcReport);
        this.addOptionMenu(this.chanceReport);
        this.textInitialStock.setText("10");
    }

    protected Dimension getFrameSize() {
        return new Dimension(500, 550);
    }

    protected String getFrameTitle() {
        return "\u30b8\u30a7\u30c3\u30c8\u30bb\u30c3\u30c8\u30e9\u30b8\u30aa\u30b7\u30df\u30e5";
    }

    protected MainBoardInterface getSimulator() {
        return new JSRMainBoard();
    }

    public void processEvent(int eventId) {
        switch (eventId) {
            case 25: {
                ++this.chanceCount;
                this.eventChance();
                break;
            }
            case 23: {
                this.eventHighStart();
                break;
            }
            case 24: {
                this.eventHighEnd();
                break;
            }
            case 20: {
                ++this.jcCount0;
                this.eventJcHit();
                break;
            }
            case 21: {
                ++this.jcCount;
                this.eventJcStart();
                break;
            }
            case 22: {
                this.eventJcEnd();
            }
        }
    }

    protected void eventBonusStart() {
        if (((JSRMainBoard)((AbstractDataCounter)this).simulator).getBreakFactor() == 2 && !((JSRMainBoard)((AbstractDataCounter)this).simulator).isJc()) {
            ++this.koyaku7NoJc;
        }
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
    }

    protected void eventBonusEnd() {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        this.appendLog("\t");
        if (((AbstractDataCounter)this).simulator.getCurrentBonus() == 3) {
            this.appendLog("BIG[" + ((AbstractDataCounter)this).currentBonusCoin + "]");
        } else {
            this.appendLog("REG");
        }
        this.appendLog("\t");
        int breakFactor = ((JSRMainBoard)((AbstractDataCounter)this).simulator).getBreakFactor();
        switch (breakFactor) {
            case 2: {
                this.appendLog("\u5c0f\u5f797\u9023");
                break;
            }
            case 3: {
                this.appendLog("\u5c0f\u5f797\u9023(JC)");
                break;
            }
            case 1: {
                this.appendLog("\u76f4\u6483(BIG)");
                break;
            }
            case 0: {
                this.appendLog("\u76f4\u6483(REG)");
            }
        }
        this.appendLog("\t" + this.getCoin());
        this.appendLog("\tstock=" + this.getStockBRCount());
        this.appendLog("\n");
    }

    protected void eventJcHit() {
        int currentGameCount = this.getCurrentGameCount();
        if (!this.jcReport.isSelected()) {
            return;
        }
        this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
        this.appendLog("\t[JC\u5f53\u9078");
        int hitCount = ((JSRMainBoard)((AbstractDataCounter)this).simulator).getCurrentJcHitCount();
        this.appendLog(":" + String.valueOf(hitCount) + "]");
        switch (((JSRMainBoard)((AbstractDataCounter)this).simulator).getJcHitFactor()) {
            case 4: {
                this.appendLog("\t\u5185\u90e8BIG");
                break;
            }
            case 1: {
                this.appendLog("\tBIG\u306f\u305a\u3057");
                break;
            }
            case 6: {
                this.appendLog("\t\u5927AT\u78ba\u5b9a\u76ee");
                break;
            }
            case 3: {
                this.appendLog("\tJAC\u30cf\u30ba\u30ec");
                break;
            }
            case 0: {
                if (((JSRMainBoard)((AbstractDataCounter)this).simulator).isHigh()) {
                    this.appendLog("\t\u7d14\u30cf\u30ba\u30ec(\u9ad8\u78ba)");
                    break;
                }
                this.appendLog("\t\u7d14\u30cf\u30ba\u30ec");
                break;
            }
            case 5: {
                this.appendLog("\t\u5929\u4e95");
                break;
            }
            case 2: {
                this.appendLog("\t1G\u7d14\u30cf\u30ba\u30ec");
            }
        }
        this.appendLog("\n");
    }

    protected void eventJcStart() {
        if (!this.jcReport.isSelected()) {
            return;
        }
        int jcFloor = ((JSRMainBoard)((AbstractDataCounter)this).simulator).getJcFloor();
        this.appendLog("\t[" + String.valueOf(this.getCurrentGameCount()) + "]");
        this.appendLog("\tJC" + jcFloor + "\u767a\u52d5\n");
    }

    protected void eventJcEnd() {
        if (!this.jcReport.isSelected()) {
            return;
        }
        this.appendLog("\t[" + String.valueOf(this.getCurrentGameCount()) + "]");
        this.appendLog("\tJC\u7d42\u4e86\n");
    }

    protected void eventStart() {
    }

    protected void eventSimulateStart() {
        this.jcCount = 0;
        this.jcCount0 = 0;
        this.chanceCount = 0;
        this.koyaku7NoJc = 0;
    }

    protected void eventSimulateEnd() {
        this.appendLogStopGameAndTotalGame();
        this.appendLogDenominator("BIG", this.getBigCount(), this.getTotalGameCount());
        this.appendLogDenominator("REG", this.getRegCount(), this.getTotalGameCount());
        this.appendLogDenominator("\u5408\u6210", this.getBigCount() + this.getRegCount(), this.getTotalGameCount());
        this.appendLogDenominator("JC", this.jcCount, this.getTotalGameCount());
        this.appendLogDenominator("JC\u521d\u5f53", this.jcCount0, this.getTotalGameCount());
        this.appendLogDenominator("\u30c1\u30e3\u30f3\u30b9\u76ee", this.chanceCount, this.getTotalGameCount());
        this.appendLogDenominator("\u81ea\u529b\u5c0f\u5f797\u9023", this.koyaku7NoJc, this.getTotalGameCount());
        this.appendLogPayout();
    }

    protected void eventHighStart() {
        if (!this.modeReport.isSelected()) {
            return;
        }
        int currentGameCount = this.getCurrentGameCount();
        this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
        this.appendLog("\t\u9ad8\u78ba\u958b\u59cb");
        this.appendLog("\t" + ((JSRMainBoard)((AbstractDataCounter)this).simulator).getHighFloor() + "G");
        this.appendLog("\n");
    }

    protected void eventHighEnd() {
        if (!this.modeReport.isSelected()) {
            return;
        }
        int currentGameCount = this.getCurrentGameCount();
        this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
        this.appendLog("\t\u9ad8\u78ba\u7d42\u4e86");
        this.appendLog("\n");
    }

    protected void eventChance() {
        if (!this.chanceReport.isSelected()) {
            return;
        }
        int currentGameCount = this.getCurrentGameCount();
        this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
        if (((JSRMainBoard)((AbstractDataCounter)this).simulator).isHigh()) {
            this.appendLog("\t\u30c1\u30e3\u30f3\u30b9\u76ee(\u9ad8\u78ba)");
        } else {
            this.appendLog("\t\u30c1\u30e3\u30f3\u30b9\u76ee");
        }
        this.appendLog("\n");
    }

    protected void processActionEvent(ActionEvent e) {
    }
}

