/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef WebKitDOMNode_h
#define WebKitDOMNode_h

#include "webkit/webkitdomdefines.h"
#include <glib-object.h>
#include <webkit/webkitdefines.h>
#include "webkit/WebKitDOMObject.h"


G_BEGIN_DECLS
#define WEBKIT_TYPE_DOM_NODE            (webkit_dom_node_get_type())
#define WEBKIT_DOM_NODE(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), WEBKIT_TYPE_DOM_NODE, WebKitDOMNode))
#define WEBKIT_DOM_NODE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),  WEBKIT_TYPE_DOM_NODE, WebKitDOMNodeClass)
#define WEBKIT_DOM_IS_NODE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), WEBKIT_TYPE_DOM_NODE))
#define WEBKIT_DOM_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),  WEBKIT_TYPE_DOM_NODE))
#define WEBKIT_DOM_NODE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),  WEBKIT_TYPE_DOM_NODE, WebKitDOMNodeClass))

struct _WebKitDOMNode {
    WebKitDOMObject parent_instance;
};

struct _WebKitDOMNodeClass {
    WebKitDOMObjectClass parent_class;
};

WEBKIT_API GType
webkit_dom_node_get_type (void);

WEBKIT_API WebKitDOMNode*
webkit_dom_node_insert_before(WebKitDOMNode* self, WebKitDOMNode* new_child, WebKitDOMNode* ref_child, GError **error);

WEBKIT_API WebKitDOMNode*
webkit_dom_node_replace_child(WebKitDOMNode* self, WebKitDOMNode* new_child, WebKitDOMNode* old_child, GError **error);

WEBKIT_API WebKitDOMNode*
webkit_dom_node_remove_child(WebKitDOMNode* self, WebKitDOMNode* old_child, GError **error);

WEBKIT_API WebKitDOMNode*
webkit_dom_node_append_child(WebKitDOMNode* self, WebKitDOMNode* new_child, GError **error);

WEBKIT_API gboolean
webkit_dom_node_has_child_nodes(WebKitDOMNode* self);

WEBKIT_API WebKitDOMNode*
webkit_dom_node_clone_node(WebKitDOMNode* self, gboolean deep);

WEBKIT_API void
webkit_dom_node_normalize(WebKitDOMNode* self);

WEBKIT_API gboolean
webkit_dom_node_is_supported(WebKitDOMNode* self, const gchar* feature, const gchar* version);

WEBKIT_API gboolean
webkit_dom_node_has_attributes(WebKitDOMNode* self);

WEBKIT_API gboolean
webkit_dom_node_is_same_node(WebKitDOMNode* self, WebKitDOMNode* other);

WEBKIT_API gboolean
webkit_dom_node_is_equal_node(WebKitDOMNode* self, WebKitDOMNode* other);

WEBKIT_API gchar*
webkit_dom_node_lookup_prefix(WebKitDOMNode* self, const gchar* namespace_uri);

WEBKIT_API gboolean
webkit_dom_node_is_default_namespace(WebKitDOMNode* self, const gchar* namespace_uri);

WEBKIT_API gchar*
webkit_dom_node_lookup_namespace_uri(WebKitDOMNode* self, const gchar* prefix);

WEBKIT_API gushort
webkit_dom_node_compare_document_position(WebKitDOMNode* self, WebKitDOMNode* other);


/* TODO: event function webkit_dom_node_add_event_listener */


/* TODO: event function webkit_dom_node_remove_event_listener */

WEBKIT_API gboolean
webkit_dom_node_dispatch_event(WebKitDOMNode* self, WebKitDOMEvent* event, GError **error);

WEBKIT_API gchar*
webkit_dom_node_get_node_name(WebKitDOMNode* self);

WEBKIT_API gchar*
webkit_dom_node_get_node_value(WebKitDOMNode* self);

WEBKIT_API void
webkit_dom_node_set_node_value(WebKitDOMNode* self, const gchar* value, GError **error);

WEBKIT_API gushort
webkit_dom_node_get_node_type(WebKitDOMNode* self);

WEBKIT_API WebKitDOMNode*
webkit_dom_node_get_parent_node(WebKitDOMNode* self);

WEBKIT_API WebKitDOMNodeList*
webkit_dom_node_get_child_nodes(WebKitDOMNode* self);

WEBKIT_API WebKitDOMNode*
webkit_dom_node_get_first_child(WebKitDOMNode* self);

WEBKIT_API WebKitDOMNode*
webkit_dom_node_get_last_child(WebKitDOMNode* self);

WEBKIT_API WebKitDOMNode*
webkit_dom_node_get_previous_sibling(WebKitDOMNode* self);

WEBKIT_API WebKitDOMNode*
webkit_dom_node_get_next_sibling(WebKitDOMNode* self);

WEBKIT_API WebKitDOMNamedNodeMap*
webkit_dom_node_get_attributes(WebKitDOMNode* self);

WEBKIT_API WebKitDOMDocument*
webkit_dom_node_get_owner_document(WebKitDOMNode* self);

WEBKIT_API gchar*
webkit_dom_node_get_namespace_uri(WebKitDOMNode* self);

WEBKIT_API gchar*
webkit_dom_node_get_prefix(WebKitDOMNode* self);

WEBKIT_API void
webkit_dom_node_set_prefix(WebKitDOMNode* self, const gchar* value, GError **error);

WEBKIT_API gchar*
webkit_dom_node_get_local_name(WebKitDOMNode* self);

WEBKIT_API gchar*
webkit_dom_node_get_base_uri(WebKitDOMNode* self);

WEBKIT_API gchar*
webkit_dom_node_get_text_content(WebKitDOMNode* self);

WEBKIT_API void
webkit_dom_node_set_text_content(WebKitDOMNode* self, const gchar* value, GError **error);

WEBKIT_API WebKitDOMElement*
webkit_dom_node_get_parent_element(WebKitDOMNode* self);

G_END_DECLS

#endif /* WebKitDOMNode_h */
