/*
 * copyright (c) 1994  Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * Author:  Makoto Ishisone, Software Research Associates, Inc., Japan
 */
/*
 * Ϥʤʬʬǽľޤޤꥸʥ 
 * kinput2 ΥɤĤäƤΤǡҤϾΤ褦ˤʤޤĤȦǤ 
 */
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Xatom.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/SysUtil.h>

#include "im.h"
#include "XimP.h"
#include "commondef.h"
#include "CliMsg.h"
#include "MyDispatch.h"
#include "MyError.h"
#include "HistMgr.h"

/*
 * ߤǤ͡
 */
#define SERVER_NAME			"skkinput"

#define ServerMajorTransportVersion	(0)
#define ServerMinorTransportVersion	(2)
#define XTransportUnitSize		(20)
#define XTransportDividingSize		(XTransportUnitSize * 5)

/*
 * ץȥ
 */
static int dummyDispatcher( IMConnection *conn ) ;
#if defined(DEBUG_AGAIN)
static void dumpBuf( IMBuffer *ibp, char *title ) ;
#endif
static IMConnection *newConnection( Widget protocol ) ;

static void xinput
( XEvent *ev, XtPointer cldata ) ;
static int xdestroy
( XEvent *ev, XtPointer cldata ) ;
#if 0
static int xBrokenPipe
( Display *disp, XErrorEvent *eev, XPointer client_data ) ;
#endif
static int Xim_imFlush
( IMConnection *conn ) ;
static void Xim_imShutdown
( IMConnection *conn ) ;

static void Xim_Initialize
( Widget req, Widget new, ArgList args, Cardinal *num_args ) ;
static void Xim_Realize
( Widget gw, XtValueMask *valuemask, XSetWindowAttributes *values ) ;
static void Xim_Destroy( Widget gw ) ;
static Boolean Xim_SetValues
( Widget current, Widget request, Widget new,
  ArgList args, Cardinal *num_args ) ;

static int Xim_OwnSelection( Widget gw ) ;
static int Xim_getSupportedLocales( Widget gw, unsigned char *string ) ;
static void Xim_getStartConversionKey( Widget gw ) ;
static void Xim_setProperty( Widget gw ) ;
static void Xim_getAtoms( Widget gw ) ;

static void Xim_AcceptXService
( Widget gw, XtPointer client_data, XEvent *xevent,
  Boolean continuep ) ;

static void Xim_SelectionClearEventHandler
( Widget gw, XEvent *xevent, String *params, Cardinal *num_params ) ;
static void Xim_SelectionRequestEventHandler
( Widget gw, XEvent *xevent, String *params, Cardinal *num_params ) ;

/* parseStr.c */
extern int parseXrLikeKeyStrings
( unsigned char *string, struct XrLikeKey *keytbl ) ;

/*
 * Хåؿ
 */
static void ClientMessage_Callback
( Widget gw, caddr_t client, caddr_t caller ) ;
static void ClientMessage_DestroyCallback
( Widget gw, caddr_t client, caddr_t caller ) ;

/*
 * ȤƤؿΥץȥ
 */

extern void IMSendBufInit( void ) ;
/*
 * Хѿ
 */
/* ٥ȤФ륢Υơ֥롣*/
static XtActionsRec ximActionsTable[] = {
  { "xim-selection-request",
    Xim_SelectionRequestEventHandler },
  { "xim-selection-clear",
    Xim_SelectionClearEventHandler },
} ;

static char default_XimTranslations[] =
"<SelReq>:                             xim-selection-request()\n\
 <SelClr>:                             xim-selection-clear()" ;

#define offset(field)  XtOffsetOf(XimRec, xim.field)
#define goffset(field) XtOffsetOf(WidgetRec, core.field)

static XtResource xim_resources[] = {
  { XtNdefaultFontList, XtCFontList, XtRString, sizeof( String ),
    offset( default_fontlist ), XtRImmediate, ( XtPointer )NULL },
  { XtNforeground, XtCForeground, XtRPixel, sizeof ( Pixel ),
      offset( foreground ), XtRString, XtDefaultForeground },
  { XtNstatusWidth, XtCStatusWidth, XtRDimension, sizeof( Dimension ),
      offset( status_width ), XtRImmediate, ( XtPointer )0 },
  /* 饤ȤïȤ褦ȤƤ롩 */
  { XtNdestroyWindowEvent, XtCDestroyWindowEvent, XtRImmediate,
    sizeof( XDestroyWindowEvent * ),
    offset( destroyWindowEvent ), XtRImmediate, ( XtPointer )NULL },
  /* ι*/
  { XtNjisyoDirty, XtCJisyoDirty, XtRImmediate, sizeof (int),
    offset(jisyo_dirty), XtRImmediate, (XtPointer) FALSE },
  /* SeparateWindow, Over-The-Spot-Window Ĥ륳Хå *
   *  KinputWidget ɤɤΤΤʤȤʤΤǡ*
   * ХåηǿƤ˽򤪴ꤤƤ롣*/
  { XtNsetupInputWindowNotify, XtCCallback, XtRCallback,
    sizeof( caddr_t ), offset( setupInputWindowCallback ), XtRCallback,
    ( caddr_t )NULL },
  /* Kinput Protocol Widget ĤθƽФХå*/
  { XtNserverCloseNotify, XtCCallback, XtRCallback, sizeof( caddr_t ),
    offset( serverCloseCallback ), XtRCallback, ( caddr_t )NULL },
  /* Ѵ򳫻Ϥ륭Ͽ롣*/
  { XtNconversionStartKey, XtCConversionStartKey, XtRString,
    sizeof( String ), offset( conversionStartKey ), XtRImmediate, 
    ( XtPointer )"Shift<Key>space,Cntrl<Key>Kanji,Cntrl<Key>Henkan_Mode" },
  /* ݡȤƤ locale Υꥹȡ*/
  { XtNsupportedLocales, XtCSupportedLocales, XtRString,
    sizeof( String ), offset( locales ), XtRImmediate,
    "ja_JP.SJIS,ja_JP.EUC,ja_JP,ja_JP.ujis,japanese,japan,ja,ja_JP.eucJP" },
} ;

#undef offset
#undef goffset

XimClassRec ximClassRec = {
    { /* core fields */
    /* superclass		*/	&widgetClassRec,
    /* class_name		*/	"Xim",
    /* size			*/	sizeof( XimRec ),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize		*/	Xim_Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	Xim_Realize,
    /* actions			*/	ximActionsTable,
    /* num_actions		*/	XtNumber( ximActionsTable ),
    /* resources		*/	xim_resources,
    /* num_resources		*/	XtNumber( xim_resources ),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	Xim_Destroy,
    /* resize			*/	NULL,
    /* expose			*/	NULL,
    /* set_values		*/	Xim_SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	default_XimTranslations,
    /* query_geometry		*/	XtInheritQueryGeometry,
    }
};

WidgetClass ximWidgetClass = ( WidgetClass )&ximClassRec ;

static IMTransportOps XTransportOps = {
  Xim_imFlush,
  Xim_imShutdown,
} ;


#ifdef DEBUG
/*
 * ǥХåΤδؿ
 */
static void dumpBuf( IMBuffer *ibp, char *title )
{
  int len = IMBUFLEN( ibp ) ;
  unsigned char *data = (unsigned char *)IMBUFDATA(ibp) ;
  int i ;

  printf( "%s (%d bytes)", title, len ) ;
  for( i = 0; i < len; i++){
    if( i % 16 == 0 )
      printf( "\n\t" ) ;
    printf( "%02x ", *data++ ) ;
  }
  printf( "\n" ) ;
  fflush( stdout ) ;
  return ;
}
#endif

/*
 * ߡΥ٥ȥϥɥؿ
 *----
 * ºݤˤ˥٥Ȥ뤳Ȥȡ̵뤵롣ʤ
 * ϻפΤ
 */
static int dummyDispatcher( IMConnection *conn )
{
#ifdef DEBUG
  printf("dummyDispatcher -- this function should not be called!\n");
#endif
  return 0 ;	/* for lint */
}

/*
 * δؿ XIM 饤Ȥ׵( XEVENT η )ơ
 * ǥѥå롣ޤ٥ȤǤ뤫ɤĴ٤롣
 * ClientMessage Event ǤȥаƤơġ
 */
static void xinput( XEvent *ev, XtPointer cldata )
{
  XClientMessageEvent *event = ( XClientMessageEvent * )ev ;
  IMConnection *conn = ( IMConnection * )cldata ;
  int cond ;
  Atom msg_type ;

  /* ޤ٥ȤǤ뤫ɤȽǤ롣*/
  if( event->type != ClientMessage ||
      event->window != XtWindow( conn->transport.priv.x.server ) ){
    return ;
  }

#ifdef DEBUG
  printf( "xinput ---- (format: %d)\n", event->format ) ;
#endif

  /* XIM Event  XEvent ФԤ*/
  /* ϲ򤷤ƤΤޤɤʬʤäꤹ롣¿ʬ */
  /* X  Document ˤĤƤѥåȱΤ꤬ΩĤΤ */
  /* ʰ̣ʽ줿Ѹɤ൤ˤϤʤʤ*/
  msg_type = event->message_type ;
  if( event->format == 32 ){
    /*
     * indirect reference -- data resides in a property,
     * whose name is stored in the event.
     */
    Atom propatom = event->data.l[ 1 ] ;
    long offset = 0 ;
    unsigned long remain ;
    
    if( msg_type != 
	( ( XimWidget )( conn->protocol_widget ) )->xim.xim_protocol ){
#ifdef DEBUG
  fprintf( stderr, "Not xim protocol message.\n" ) ;
#endif
      return ;
    }

    do {
      Atom actualtype ;
      int actualformat ;
      unsigned long nitems ;
      char *data = NULL ;

      XGetWindowProperty
	( event->display, event->window, propatom,
	  offset, 1000, True, AnyPropertyType,
	  &actualtype, &actualformat, &nitems,
	  &remain, (unsigned char **)&data ) ;

      if( data == NULL ){
#ifdef DEBUG
	fprintf( stderr, "Data is empty.\n" ) ;
#endif
	return ;
      }

      if( actualformat != 8 ) {
	cond = TRANSPORT_ERROR ;
      } else {
	IMBufAdd( &conn->in_buf, data, (int)nitems ) ;
	offset += nitems ;
	cond = TRANSPORT_OK ;
      }
      XFree( data ) ;

    } while( remain > 0 ) ;

  } else if( event->format == 8 ){
    XimWidget w = ( XimWidget )conn->protocol_widget ;

    if( msg_type != w->xim.xim_protocol &&
        msg_type != w->xim.xim_moredata ){
#ifdef DEBUG
  fprintf( stderr, "Not xim protocol message.\n" ) ;
#endif
      return ;
    }

    IMBufAdd( &conn->in_buf, event->data.b, XTransportUnitSize ) ;
    cond = TRANSPORT_OK ;

  } else {
    /* 褿硢()ʥ٥ȤǤ뤫ΤƤƤ */
    /* ޤ*/
    return ;
  }

#ifdef DEBUG
  dumpBuf( IM_INBUF( conn ), "** input buffer" ) ;
#endif
  /* ٥ȤǥѥåĤĤޤ¹Ԥ˰ܤ*/
  IMDispatch( conn, cond ) ;
  return ;
}

static int xdestroy( XEvent *xevent, XtPointer client )
{
  XDestroyWindowEvent *xdwe = ( XDestroyWindowEvent * )xevent ;
  IMConnection        *conn = ( IMConnection * )client ;

  if( xevent->type != DestroyNotify ||
      xdwe->window != conn->transport.priv.x.client ){
    return False ;
  }
  IMDispatch( conn, TRANSPORT_ERROR ) ;
  /* 饤Ȥ׵ƤåȤ˲롣*/
  XtDestroyWidget( conn->transport.priv.x.server ) ;
  /* ҥȥ˴롣*/
  history_destroy( conn->transport.priv.x.client ) ;
  remove_allmyeventhandler
    ( XtDisplay( conn->protocol_widget ), conn->transport.priv.x.client ) ;
  /* XSafeFlush( XtDisplay( conn->protocol_widget ) ) ; */
  return True ;
}

/*
 * Error Event ȯȤȤ뤬ѴɬפȤĤ
 * ޤäȤƤޤäƤȤꤵ롣Ϥ
 * pipe ڤƤȹͤ뤫 Broken Pipe Ȥ̾ʤ
 * Ǥ礦äơ XErrorEvent ƤӽФؿȤʤäƤ
 * 櫓Ǥ
 */
#if 0
static int xBrokenPipe
( Display *disp, XErrorEvent *eev, XPointer client )
{
  /* 顼٥Ȥ⡢ǤġפȤΤϼºߤʤ */
  /* Ʋoperation褦Ȥ˽ФΤǤ롣*/
  if( eev->error_code == BadWindow ){
    /*
     * Search for the connection using window that caused the error.
     * Note that we cannot pass the connection via client_data,
     * Since the connection might be already destroyed by a previous
     * error.
     */
    XimWidget xw = ( XimWidget )client ;
    Window bad_win = ( Window )eev->resourceid ;
    IMConnection *conn ;
    
    conn = xw->xim.connection_list ;
    while( conn != NULL ){
      if( bad_win == conn->transport.priv.x.client ){
	IMDispatch( conn, TRANSPORT_ERROR ) ;
	break ;
      }
      conn = conn->next ;
    }
    return False ;
  }
  return True ;
}
#endif

/*
 * Ѵ饤Ȱ˥åĤؿ
 */
static void Xim_imSendEvent
( Widget gw, Window client, IMBuffer *outbuf )
{
  XimWidget xw = ( XimWidget )gw ;
  Display *disp = XtDisplay( gw ) ;
  XClientMessageEvent repl ;
  int length ;

  if( ( length = IMBUFLEN( outbuf ) ) < XTransportDividingSize ){
    unsigned char *data = IMBUFDATA( outbuf ) ;
    
    while( length > XTransportUnitSize ){
      repl.type = ClientMessage ;
      repl.window = client ;
      repl.format = 8 ;
      repl.message_type = xw->xim.xim_moredata ;
      
      memcpy( repl.data.b, data, XTransportUnitSize ) ;
      XSafeSendEvent
	( XtDisplay( gw ), client, False,
	  NoEventMask, (XEvent *)&repl ) ;
      data   += XTransportUnitSize ;
      length -= XTransportUnitSize ;
    }
    repl.type         = ClientMessage ;
    repl.window       = client ;
    repl.format       = 8 ;
    repl.message_type = xw->xim.xim_protocol ;
    memset( repl.data.b, 0, XTransportUnitSize ) ;
    memcpy( repl.data.b, data, length ) ;
    XSafeSendEvent
      ( XtDisplay( gw ), client, False, NoEventMask, (XEvent *)&repl ) ;
  } else {
    repl.type         = ClientMessage ;
    repl.window       = client ;
    repl.format       = 32 ;
    repl.message_type = xw->xim.xim_protocol ;
    repl.data.l[ 0 ]  = length ;
    repl.data.l[ 1 ]  = xw->xim.skkcomm_atom ;
    XSafeChangeProperty
      ( disp, client, xw->xim.skkcomm_atom, XA_STRING,
	8, PropModeAppend, IMBUFDATA( outbuf ), length ) ;
    XSafeSendEvent
      ( disp, client, False, NoEventMask, ( XEvent * )&repl ) ;
  }
  return ;
}

/*
 * ѴФѴ饤ȤؤνϥХåեեå夹ؿ
 *-----
 * ա Xim ˤʤ᤿ϼʥץȥʤΤǡФ
 * ȼ˥٥ȤޤɬѴ饤Ȥ饤٥Ȥ
 * 餻ơФֿηǥեå夹褦ˤƲ
 * ˵դʤäǹ󤤤ˤäƤޤäġ(;_;) 뤫
 * ɤƤȤפäġɤƤʥץȥ뤫ʡġ
 */
static int Xim_imFlush( IMConnection *conn )
{
  IMBuffer *outbuf = IM_OUTBUF( conn ) ;
  /* 餫 X Error ɤΥե饰򥯥ꥢƤ*/
  xerror_clearflag() ;
  /* ϥХåեä顢ʤȤˤ롣*/
  if( IMBUFLEN( outbuf ) <= 0 )
    return TRANSPORT_OK ;
  /* ϥХåե֤˥եå夷Ƥ*/
  Xim_imSendEvent
    ( conn->protocol_widget, conn->transport.priv.x.client, outbuf ) ;
  /* ϥХåեˤ롣*/
  IMBufClear( outbuf ) ;
  if( xerror_occured() ){
#ifdef DEBUG
    fprintf( stderr, "(Xim) Broken pipe.\n" ) ;
#endif
    IMDispatch( conn, TRANSPORT_ERROR ) ;
  }
  XFlush( XtDisplay( conn->protocol_widget ) ) ;
  return TRANSPORT_OK ;
}

static void Xim_imShutdown( IMConnection *conn )
{
  /* ߥ˥ΤΥåȤ˴롣*/
  XtDestroyWidget( conn->transport.priv.x.server ) ;
  return ;
}

int IMFlush( IMConnection *conn )
{
#ifdef DEBUG
  dumpOutBuf( conn->out_buf, "** output buffer" ) ;
#endif
  return ( *conn->transport.ops->flush )( conn ) ;
}

void IMShutdown( IMConnection *conn )
{
  ( *conn->transport.ops->shutdown )( conn ) ;
}

void IMCloseConnection( IMConnection *conn )
{
  XimWidget xw = ( XimWidget )( conn->protocol_widget ) ;
  IMConnection *pConn ;
  IMIM *im_ptr ;

  im_ptr = conn->im_list ;
  while( im_ptr != NULL ){
    IMIM *next = im_ptr->next ;
    
    IMDestroyIM( im_ptr ) ;
    im_ptr = next ;
  }

  IMBufClear( &conn->in_buf ) ;
  IMBufClear( &conn->out_buf ) ;
  IMShutdown( conn ) ;

  if( ( pConn = xw->xim.connection_list ) != NULL ){
    /* ꥹȤ鳰*/
    if( pConn == conn ){
      /* ꥹȤƬäν*/
      xw->xim.connection_list = conn->next ;
    } else {
      /* ꥹȤƬʳξν*/
      while( pConn->next != conn && pConn != NULL )
	pConn = pConn->next ;
      /* ꥹȤǤʤСġ*/
      if( pConn != NULL ){
	pConn->next = conn->next ;
      }
    }
  }
  free( conn ) ;
  return ;
}

/*
 * X Event Ѥ Im server 򵯤νԤؿ
 */
static void Xim_Initialize
( Widget req, Widget new, ArgList args, Cardinal *num_args )
{
  XimWidget xw = ( XimWidget )new ;

  xw->xim.server_name         = SERVER_NAME ;
  xw->xim.connection_list     = NULL ;
  xw->xim.no_more_connections = False ;
  xw->xim.scheduler_queue     = NULL ;

  Xim_getSupportedLocales( new, xw->xim.locales ) ;

  /* IM  TCP/UNIX/X ΣĤ³ꤷƤ롣Τɤ */
  /* 뤫ꤹΤsetTransport Ǥ롣*/
#if 0
  Xim_setTransport( new ) ;
#else
  xw->xim.use_x_transport = True ;
#endif
  /* IM Server ȥ饤Ȥ³뤿Υꤹ롣Kinput2  */
  /* Protocol ξˤϡѴ饤ȤꤷIM  */
  /* ˤϥФꤹ롣*/
  Xim_getStartConversionKey( new ) ;
  /*  IMlib ˤȻפɡĤɤʤΤʡ */
  IMInitHash( new ) ;
  /* IM server ȤƳư뤿ɬפʥȥݤ롣*/
  Xim_getAtoms( new ) ;

  /* ͥϤ褦ˡ٥ȤȤ褦ˤ롣*/
  if( xw->xim.use_x_transport ){
#ifdef DEBUG
    fprintf( stderr, "call XtAddEventHandler for X transport.\n" ) ;
#endif
    /* ٥Ȥ褿齦褦˻ؼ롣 realize  */
    /* ٤Ǥϡ */
    XtAddEventHandler
      ( new, NoEventMask, True, 
        ( XtEventHandler )Xim_AcceptXService, ( XtPointer )NULL ) ;
  }
  /* IM Handler Table 롣*/
  IMCompileReq() ;
  /* ϥХåե freelist 롣*/
  IMSendBufInit() ;
  return ;
}

/*
 * ΥåȤβ˸ƤӽФؿ
 */
static void Xim_Realize
( Widget gw, XtValueMask *valuemask, XSetWindowAttributes *values )
{
  CoreWidgetClass super =
    ( CoreWidgetClass )XtClass( gw )->core_class.superclass ;

  /* ޤåȤβ롣νˤꡢΥ */
  /* ȤϼΤĤȤǤ롣ޤXtRealizeWidget ʬˤ */
  /* ȤĤǤ͡*/
  ( *super->core_class.realize )( gw, valuemask, values ) ;

  /* Selection Owner ˤʤ롣*/
  if( !Xim_OwnSelection( gw ) ){
    XtDestroyWidget( gw ) ;
    return ;
  }
  /* Kinput2 Protocol λƱͤˡѴФȤƤħƤ */
  /* 㤨Сover-the-spot ѤǤȤդȤդȤ*/
  Xim_setProperty( gw ) ;
  return ;
}

/*
 * XIM ѴФ뤳Ȥ뤿Ѥؿ
 */
static int Xim_OwnSelection( Widget gw )
{
  XimWidget xw  = ( XimWidget )gw ;

  /*  CONVERSION_REQUEST  OWNER ˤʤ롣*/
  XSetSelectionOwner
    ( XtDisplay( gw ), xw->xim.server_atom, XtWindow( gw ), CurrentTime ) ;
  if( XGetSelectionOwner( XtDisplay( gw ), xw->xim.server_atom ) !=
      XtWindow( gw ) ){
#if defined(DEBUG)
    fprintf( stderr, "cannot own xim selection.\n" ) ;
#endif
    return False ;
  }
#if defined(DEBUG)
  fprintf( stderr, "selection atom:%ld owner: %08lx (%ld)\n",
	   xw->xim.server_atom, XtWindow( gw ), XtWindow(gw) ) ;
#endif
  return True ;
}

/*
 * ¾ѴФ selection ׵򤷤ƤνԤؿ
 */
static void Xim_SelectionRequestEventHandler
( Widget gw, XEvent *xevent, String *params, Cardinal *num_params )
{
  XimWidget               xw     = ( XimWidget )gw ;
  XSelectionRequestEvent *xsrev  = &( xevent->xselectionrequest ) ;
  XSelectionEvent         xev ;

  memset( ( unsigned char * )&xev, 0, sizeof( XSelectionEvent ) ) ;
  xev.type      = SelectionNotify ;
  xev.serial    = xsrev->serial ;
  xev.display   = xsrev->display ;
  xev.requestor = xsrev->requestor ;
  xev.selection = xsrev->selection ;
  xev.target    = xsrev->target ;
  xev.time      = xsrev->time ;
  xev.property  = xsrev->property ;

  if( xsrev->selection == xw->xim.server_atom ){
    if( xsrev->target == XInternAtom
	( XtDisplay( gw ), "TARGETS", False ) ){
      static Atom *targets = NULL ;
      if( targets == NULL ){
	targets = ( Atom * )malloc( sizeof( Atom ) * 2 ) ;
	if( targets != NULL ){
	  targets[ 0 ] = ATOM_LOCALES  ( xw ) ;
	  targets[ 1 ] = ATOM_TRANSPORT( xw ) ;
	}
      }
      if( targets != NULL ){
	XChangeProperty
	  ( XtDisplay( gw ), xsrev->requestor, xsrev->property,
	    XA_ATOM, 32, PropModeReplace, ( char * )targets, 2 ) ;
	XFlush( XtDisplay( gw ) ) ;
      }
    } else if( xsrev->target == ATOM_LOCALES( xw ) ){
      static char *locale_string = NULL ;
      if( xw->xim.locales != NULL ){
	if( locale_string == NULL ){
	  locale_string = malloc( strlen( xw->xim.locales ) + 10 ) ;
	  if( locale_string != NULL )
	    sprintf( locale_string, "@locale=%s", xw->xim.locales ) ;
	}
	if( locale_string != NULL ){
	  XChangeProperty
	    ( XtDisplay( gw ), xsrev->requestor, xsrev->property,
	      xsrev->target, 8, PropModeReplace,
	      locale_string, strlen( ( char * )locale_string ) ) ;
	  XFlush( XtDisplay( gw ) ) ;
	}
      }
    } else if( xsrev->target == ATOM_TRANSPORT( xw ) ){
      static char *transport_string = "@transport=X/" ;
      XChangeProperty
	( XtDisplay( gw ), xsrev->requestor, xsrev->property,
	  xsrev->target, 8, PropModeReplace,
	  transport_string, strlen( ( char * )transport_string ) ) ;
      XFlush( XtDisplay( gw ) ) ;
    }
  }
  XSendEvent
    ( xsrev->display, xsrev->requestor, False,
      NoEventMask, ( XEvent *)&xev ) ;
  return ;
}

static void Xim_SelectionClearEventHandler
( Widget gw, XEvent *xevent, String *params, Cardinal *num_params )
{
  XimWidget xw = ( XimWidget )gw ;
  XSelectionClearEvent *xscev  = &( xevent->xselectionclear ) ;
  
  if( xscev->selection == xw->xim.server_atom ){
    /* Ѵ饤Ȥʤä顢¨¤Ȥ*/
    if( xw->xim.connection_list == NULL ){
      XtDestroyWidget( gw ) ;
      return ;
    }
    /* ʤä顢ʾѴ饤Ȥ³ʤ褦ˤ
     * 롩 */
    xw->xim.no_more_connections = True ;
  }
  return ;
}

/*
 * ΥåȤ˸ƤӽФؿ
 */
static void Xim_Destroy( Widget gw )
{
  XimWidget w = ( XimWidget )gw ;
  IMConnection *conn, *nextConn ;

  /* ³ƤѴ饤Ȥ˽λΤҤüĤ롣*/
  conn = w->xim.connection_list ;
  while( conn != NULL ){
    nextConn = conn->next ;
    IMCloseConnection( conn ) ;
    conn = nextConn ;
  }
  /* ¾malloc Ƥʬ free 롣*/
  if( w->xim.trigger_keys != NULL )
    free( w->xim.trigger_keys ) ;
  if( w->xim.converter.supportedLocaleString != NULL )
    free( w->xim.converter.supportedLocaleString ) ;
  if( w->xim.converter.supportedLocales != NULL )
    free( w->xim.converter.supportedLocales ) ;
  /* ޤ٥Ȥνؿ˴롣*/
  XtRemoveEventHandler
    ( gw, NoEventMask, True, 
      ( XtEventHandler )Xim_AcceptXService, ( XtPointer )NULL ) ;
  /* ʬȤ˴٤ƥåȤ˽׵᤹롣*/
  /* XtCallCallbacks( gw, XtNserverCloseNotify, NULL ) ; */
  return ;
}

/*
 * IM Server ȤƳ뤿ɬפ ATOM ݤؿ
 */
static void Xim_getAtoms( Widget gw )
{
  Display *disp = XtDisplay( gw ) ;
  XimWidget w = ( XimWidget )gw ;
  char buf[ BUFSIZE ] ;

  strcpy( buf, "@server=" ) ;
  strcat( buf, w->xim.server_name ) ;
#if defined(DEBUG)
  fprintf( stderr, "XIM: %s\n", buf ) ;
#endif
#define MAKEATOM(s)	XInternAtom(disp,s,False)
  w->xim.server_atom    = MAKEATOM( buf ) ;
  w->xim.ctext_atom     = MAKEATOM( "COMPOUND_TEXT" ) ;
  w->xim.locales_atom   = MAKEATOM( "LOCALES" ) ;
  w->xim.transport_atom = MAKEATOM( "TRANSPORT" ) ;
  w->xim.skkcomm_atom   = MAKEATOM( "_SKKINPUT_COMM" ) ;
  w->xim.xim_xconnect   = MAKEATOM( "_XIM_XCONNECT" ) ;
  w->xim.xim_protocol   = MAKEATOM( "_XIM_PROTOCOL" ) ;
  w->xim.xim_moredata   = MAKEATOM( "_XIM_MOREDATA" ) ;
#undef MAKEATOM
  return ;
}

/*
 * ѴФȤƤħϿ뤿Ѥؿ
 */
static void Xim_setProperty( Widget gw )
{
  XimWidget w = ( XimWidget )gw ;
  Display *disp ;
  Atom xim_servers, server_atom ;
  Window rootwin ;
  int op_mode ;
  int no_registration = 0 ;
  static unsigned long data ;

  disp = XtDisplay( gw ) ;
  /* 롼ȥɥƤ*/
  rootwin = RootWindow( disp, 0 ) ;
  /* ޤXIM_SERVERS  ATOM ݤ롣*/
  xim_servers = XInternAtom( disp, "XIM_SERVERS", False ) ;
  /* XIM Server ȤƻäƤ ATOMξԤӤΤǤ*/
  server_atom = w->xim.server_atom ;
  op_mode = PropModePrepend ;

#ifndef DEBUG
  XGrabServer( disp ) ;
#endif
  {
    Atom type ;
    int format ;
    unsigned long nitems ;
    unsigned long bytes_after ;
    unsigned char *value ;

    /* ޤ°ꤵƤ뤫ɤɤࡣ*/
    if( XGetWindowProperty
       ( disp, rootwin, xim_servers, 0L, 1024L, False,
	AnyPropertyType, &type, &format, &nitems,
	&bytes_after, &value ) == Success ){
      
      if( type != XA_ATOM || format != 32 ){
	/*
	 * ФФȤƤʤФʤʤ°äƤ
	 * ʤˤ֤Ƥޤ
	 */
	op_mode = PropModeReplace ;
      } else {
	int i ;
	Atom *atoms = ( Atom * )value ;
	
	for( i = 0 ; i < nitems ; i++ ){
	  if( atoms[ i ] == server_atom ){
	    /*
	     * ˥ФȤĥץѥƥѰդƤ뤫顢
	     * ɬפϤʤ
	     */
	    no_registration = 1 ;
	    break ;
	  }
	}
      }
      if( value != NULL )
	XFree( value ) ;
    }
  }
  if( !no_registration ){
#if defined(DEBUG)
    fprintf( stderr, "changing XIM_SERVERS property\n" ) ;
#endif
    data = w->xim.server_atom ;
    XChangeProperty
      ( disp, rootwin, xim_servers, XA_ATOM, 32, op_mode,
       ( unsigned char * )&data, 1 ) ;
  } else {
#if defined(DEBUG)
    fprintf( stderr, "touching XIM_SERVERS property\n" ) ;
#endif
    /* ɤ顢ץѥƥѲ褦˸뤳Ȥˤäơ */
    /* ٥ǡɤ褦˥饤Ȥ鲿餷 */
    /* */
    XChangeProperty
      ( disp, rootwin, xim_servers, XA_ATOM, 32, PropModeAppend,
        ( unsigned char *)&data, 0 ) ;
  }
#ifndef DEBUG
  XUngrabServer( disp ) ;
#endif
  return ;
}

/*
 * ݡȤƤĤΥڤΤ˻Ȥؿ
 */
static int Xim_getSupportedLocales( Widget gw, unsigned char *lstring )
{
  XimWidget w = ( XimWidget )gw ;
  unsigned char **supportedLocales ;
  unsigned char *supportedLocaleList, *ptr, *dptr, *startpoint ;
  int num ;

  /* ޤݡȤƤ locale ̾ƤХåեݤ
     */
  if( ( supportedLocaleList = malloc( strlen( lstring ) + 1 ) ) == NULL ){
    w->xim.converter.supportedLocaleString    = NULL ;
    w->xim.converter.supportedLocales         = NULL ;
    w->xim.converter.numberOfSupportedLocales = 0 ;
    return False ;
  }
  /* ˲ locale ̾äƤΤꤷƤ*/
  num = 1 ;
  for( ptr = lstring ; *ptr != '\0' ; ptr ++ ){
    /* "," ѥ졼ʤΤǡ줬 1 䤹Ǥ⡢ʸ
       Ǹˤ "," ̵Τǡnum  1 Ϥޤ롣*/
    if( *ptr == ',' )
      num ++ ;
  }
  /* ڤФƤΤǡʬΥ
     ݤƤ*/
  supportedLocales = malloc( sizeof( unsigned char * ) * num ) ;
  if( supportedLocales == NULL ){
    free( supportedLocaleList ) ;
    w->xim.converter.supportedLocaleString    = NULL ;
    w->xim.converter.supportedLocales         = NULL ;
    w->xim.converter.numberOfSupportedLocales = 0 ;
    return False ;
  }
  /* ڤФȤԤ*/
  num = 0 ;
  dptr = startpoint = supportedLocaleList ;
  for( ptr = lstring ; *ptr != '\0' ; ptr ++ ){
    if( *ptr == ',' ){
      /* ʸϥåפ롣*/
      if( ptr != startpoint ){
	supportedLocales[ num ++ ] = startpoint ;
      }
      *dptr ++ = '\0' ;
      startpoint = dptr ;
    } else {
      *dptr ++ = *ptr ;
    }
  }
  *dptr = '\0';
  if( dptr != startpoint ){
    /* ֺǸʸ "," ʬΥƤʤΤǡǴ
       롣*/
    supportedLocales[ num ++ ] = startpoint ;
  }
  /* ݡȤƤ locale ̵Τä顢ԡ*/
  if( num <= 0 ){
    free( supportedLocaleList ) ;
    free( supportedLocales ) ;
    w->xim.converter.supportedLocaleString    = NULL ;
    w->xim.converter.supportedLocales         = NULL ;
    w->xim.converter.numberOfSupportedLocales = 0 ;
    return False ;
  }
  /* Ƥ*/
  w->xim.converter.supportedLocaleString    = supportedLocaleList ;
  w->xim.converter.supportedLocales         = supportedLocales ;
  w->xim.converter.numberOfSupportedLocales = num ;
  return True ;
}

/*
 * Resource ɤǡѴ/λڤؤ륭ڤؿġ
 *-----
 * ʤΤ¤ΤȤǽƤʤ
 */
static void Xim_getStartConversionKey( Widget gw )
{
  XimWidget w = ( XimWidget )gw ;
  int num ;
  struct XrLikeKey *startkeys ;

  /* ޤѰդʤȤʤΤ롣*/
  num = parseXrLikeKeyStrings( w->xim.conversionStartKey, NULL ) ;
  if( num <= 0 ){
    w->xim.num_trigger_keys = 0 ;
    w->xim.trigger_keys     = NULL ;
    return ;
  }
  /* ݤ롣*/
  if( ( startkeys = malloc( sizeof( struct XrLikeKey ) * num ) ) == NULL ){
    w->xim.num_trigger_keys = 0 ;
    w->xim.trigger_keys     = NULL ;
    return ;
  }
  /* ٤ϼºݤ˥ɤߡݤ롣*/
  num = parseXrLikeKeyStrings( w->xim.conversionStartKey, startkeys ) ;
  /* Ͽ롣*/
  w->xim.num_trigger_keys = num ;
  w->xim.trigger_keys     = startkeys ;
  return ;
}

/*
 *
 */
static IMConnection *newConnection( Widget gw )
{
  IMConnection *conn ;
  static int connection_serial_number = 0 ;

  if( ( conn = ( IMConnection * )malloc( sizeof( IMConnection ) ) ) == NULL )
    return NULL ;
  
  conn->serial = ++connection_serial_number ;		/* start from 1 */
  
  /* XIM Protocol Ʊ̿ԤᡢڤӼΤΥХåե */
  /* ɬפˤʤ롣νԤ*/
  IMBufInit( &conn->in_buf ) ;
  IMBufInit( &conn->out_buf ) ;
  
  /* ¾ĽƤ٤áǤ*/
  conn->byte_order = ORDER_UNKNOWN ;
  conn->dispatcher = dummyDispatcher ;
  conn->dispatching= False ;
  conn->im_list    = NULL ;
  conn->protocol_widget = gw ;
  
  /* Ϥäĥ塼ɬפɡĤɤȤäƤΤʡ */
  conn->schedule   = 0 ;
  conn->queue_next = NULL ;
  
  conn->next = NULL ;
  
  return conn ;
}

/*
 *
 */
static Widget createCommunicationWidget( Widget gw, IMConnection *conn )
{
  Widget comm_w ;

  comm_w = XtVaCreateWidget
    ( "communicationWindow", cliMsgWidgetClass, gw, 
      XtNheight, 1, XtNwidth, 1, NULL ) ;
  XtAddCallback
    ( comm_w, XtNclientMessageNotify,
      ( XtCallbackProc )ClientMessage_Callback, ( XtPointer )conn ) ;
  XtAddCallback
    ( comm_w, XtNdestroyNotify,
      ( XtCallbackProc )ClientMessage_DestroyCallback, ( XtPointer )conn ) ;
  XtRealizeWidget( comm_w ) ;
  return comm_w ;
}

/*
 * X Event ѤѴ饤Ȥ³׵(⤷ϵ
 * )ؿ
 */
IMConnection *IMXConnection( Widget gw, XEvent *xevent )
{
  XimWidget xw = ( XimWidget )gw ;
  XClientMessageEvent *xcev = ( XClientMessageEvent * )xevent ;
  XClientMessageEvent repl ;
  Display *disp = XtDisplay( gw ) ;
  Window client_window ;
  IMConnection *conn ;
  
  /*
   * ޤѴФФ٥ȤʤΤɤǧ롣
   */
  if( xevent->type != ClientMessage ||
      xcev->display != disp ||
      xcev->window != XtWindow( gw ) ||
      xcev->message_type != xw->xim.xim_xconnect ||
      xcev->format != 32 ){
    return NULL ;
  }
  /* Ѵ饤ȤΥɥɣĤ򵭲Ƥ*/
  client_window = xcev->data.l[ 0 ] ;
  /* Τ褦¸ߤƤΤǤ礦 ⤷Ͷ */
  /* ɣĤ⤷ޤ衩 */
  if( !IsWindowExist( disp, client_window ) )
    return NULL ;
  /* ºݤ˥ͥϤޤ礦*/
  if( ( conn = newConnection( gw ) ) == NULL )
    return NULL ;

  conn->transport.ops = &XTransportOps ;
  conn->transport.priv.x.client = client_window ;
  /* ºݤ X Event Ȥ륦ɥ롣*/
  conn->transport.priv.x.server = createCommunicationWidget( gw, conn ) ;
  
  /* ̵³ǤȤȤѴ饤Ȥ֤*/
  repl.type         = ClientMessage ;
  repl.window       = client_window ;
  repl.message_type = xw->xim.xim_xconnect ;
  repl.format       = 32 ;
  repl.data.l[ 0 ]  = XtWindow( conn->transport.priv.x.server ) ;
  repl.data.l[ 1 ]  = ServerMajorTransportVersion ;
  repl.data.l[ 2 ]  = ServerMinorTransportVersion ;
  repl.data.l[ 3 ]  = XTransportDividingSize ;
  XSendEvent
    ( disp, client_window, False, NoEventMask, ( XEvent *)&repl ) ;

  /* DestroyWindowEvent 褦ˤƤ*/
  add_myeventhandler
    ( disp, client_window, XtWindow( gw ),
      NO_EVENT_HANDLE, StructureNotifyMask ) ;
  return conn ;
}

/*
 *  X ٥Ȥä褿ˤνԤؿ
 */
static void Xim_AcceptXService
( Widget gw, XtPointer client_data, XEvent *xevent, Boolean continuep )
{
  XimWidget xw = ( XimWidget )gw ;
  IMConnection *conn ;

#if defined(DEBUG)
  fprintf( stderr, "XIM_ACCEPT XSERVICE.\n" ) ;
#endif
  /* ޤ饤Ȥ褿åǤʤܡ*/
  if( xevent->type != ClientMessage )
    return ;
  /* Υ٥ȤǥͥϤ롣*/
  conn = IMXConnection( gw, xevent ) ;

  if( conn != NULL ){
    IMSetInitialDispatcher( conn ) ;

    /* ϥͥꥹȤáǤäǤ  */
    /* skkinputs ˲ääƺȤ򤹤Фޤ(Ǹ) */
    conn->next = xw->xim.connection_list ;
    xw->xim.connection_list = conn ;
  }
  return ;
}

static Boolean Xim_SetValues
( Widget current, Widget request, Widget new,
  ArgList args, Cardinal *num_args )
{
  XimWidget curw = ( XimWidget )current ;
  XimWidget reqw = ( XimWidget )request ;
  XimWidget neww = ( XimWidget )new ;
  IMConnection *conn ;

  /* ޤï饤ȤȤ褦ȤƤ롩 */
  if( reqw->xim.destroyWindowEvent != NULL ){
    IMConnection *nextConn ;
    conn = reqw->xim.connection_list ;
    while( conn != NULL ){
      nextConn = conn->next ;
      xdestroy( ( XEvent *)reqw->xim.destroyWindowEvent, conn ) ;
      conn = nextConn ;
    }
    curw->xim.destroyWindowEvent =
      neww->xim.destroyWindowEvent =
      reqw->xim.destroyWindowEvent = NULL ;
    return( FALSE ) ;
  }
  /* νä */
  if( reqw->xim.jisyo_dirty != curw->xim.jisyo_dirty ){
    /* ν֥ɥ㥹Ȥ롣*/
    conn = curw->xim.connection_list ;
    while( conn != NULL ){
      IMIM *imnode = conn->im_list ;
      while( imnode != NULL ){
	IMIC *icnode = imnode->ic_list ;
	while( icnode != NULL ){
	  if( icnode->conversion != NULL )
	    XtVaSetValues
	      ( icnode->conversion, XtNjisyoDirty,
		reqw->xim.jisyo_dirty, NULL ) ;
	  icnode = icnode->next ;
	}
	imnode = imnode->next ;
      }
      conn = conn->next ;
    }
    return FALSE ;
  }
  /* Ǥϲ⤹뤳Ȥʤ*/
  return( FALSE ) ;
}

/*
 * Communication Window 򤹤 Widget ؤΥ٥ȤˤäƸƤӽ
 * 륳Хåؿ
 */
static void ClientMessage_Callback
( Widget gw, caddr_t client, caddr_t caller )
{
  XEvent *xevent = ( XEvent * )caller ;
  IMConnection *conn = ( IMConnection * )client ;

  xinput( xevent, conn ) ;
  return ;
}

/*
 * Communication Window ˴˸ƤӽФ륳Хåؿ
 */
static void ClientMessage_DestroyCallback
( Widget gw, caddr_t client, caddr_t caller )
{
  IMConnection *conn = ( IMConnection *)client ;
  /* Хå˴Ƥ*/
  XtRemoveAllCallbacks
    ( conn->transport.priv.x.server, XtNdestroyNotify ) ;
  XtRemoveAllCallbacks
    ( conn->transport.priv.x.server, XtNclientMessageNotify ) ;
  return ;
}

/*
 *
 */

/*- IMDefaultFontSet: get default font set -*/
char *IMDefaultFontSet( IMIM *imp )
{
  XimWidget xw = 
    ( XimWidget )( imp->connection->protocol_widget ) ;
  return xw->xim.default_fontlist ;
}

/*- IMDefaultForeground: get default foreground color -*/
Pixel IMDefaultForeground( Widget gw )
{
  XimWidget xw = ( XimWidget )gw ;
  return xw->xim.foreground ;
}

/*- IMDefaultBackground: get default background color -*/
Pixel IMDefaultBackground( Widget gw )
{
  XimWidget xw = ( XimWidget )gw ;
  return xw->core.background_pixel ;
}

/*- IMStatusWidth: get default status width -*/
int IMStatusWidth( Widget gw )
{
  XimWidget xw = ( XimWidget )gw ;

  return xw->xim.status_width ;
}

/*- getConverter: look up converter for the specified locale -*/
IMConverter *IMGetConverter( Widget gw, char *locale )
{
  XimWidget xw = ( XimWidget )gw ;
  IMConverter *conv = &( xw->xim.converter ) ;
  int i ;

  for( i = 0 ; i < conv->numberOfSupportedLocales &&
	 conv->supportedLocales[ i ] != NULL ; i++ ){
    if( !strcmp( conv->supportedLocales[ i ], locale ) )
      return conv ;
  }
  return NULL ;
}

/*- IMTriggerKeys: get trigger key list -*/
struct XrLikeKey *IMTriggerKeys
( IMIM *imp, int *num_triggersp )
{
  XimWidget xw = ( XimWidget )( imp->connection->protocol_widget ) ;

  *num_triggersp = xw->xim.num_trigger_keys ;
  return xw->xim.trigger_keys ;
}

