/* # skkinput (Simple Kana-Kanji Input)
 * OverWinP.h --- Over The Spot Window Style
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef OverWinP_h
#define OverWinP_h

#include "commondef.h"
#include "buffers.h"
#include "skkbuf.h"
#include "skkkey.h"
#include "OverWin.h"
#include "HistMgr.h"
#include "FontMgr.h"
#include "attrs.h"
#include <X11/CoreP.h>

typedef struct {
  Pixel		puppixel ;	/* foreground pixel */
  /* fontset ̾ʸ󡣤Ĥ convert  fontset á
   * ळȤˤʤ롣 */
  String	fontset_string ;
  String	minibuf_fontset_string ;
  /* ѤƤեȡΤʤ */
  struct skkinputManagedFont	*fontset[ NUMBER_OF_CHARSET ] ;
  struct skkinputManagedFont	*minibuf_fontset[ NUMBER_OF_CHARSET ] ;
  /* ̤褹ΤѤ GC */
  GC		gc, rgc ;
  GC		minibuf_gc, minibuf_rgc ;
  /* եȤξȴФƤΤϤɤΤǡ*/
  int		font_height, font_ascent ;
  int		mfont_height, mfont_ascent ;
  /* 礭ʸȤϡʸ礭ˤ碌
   * 뤬줬̵äˤɤ٤ˤΤꡣ */
  int		cursor_width ;
  /* minibuffer β*/
  Dimension	minibuf_width ;
  /* ȿžɽ뤫ݤ */
  Boolean	reverse_video ;
  /* kterm ʤɤΥեȤΥѹˤߥ˥ХåեΥեȥ *
   * ⽤뤫ݤ*/
  Boolean	change_minibuffer_font ;
  Boolean	overthespotLikeInput ;
  Colormap	colormap ;
  Pixel		foreground, background ;
  Pixel		oforeground, obackground ;
  Boolean	clearMinibuffer ;
  Boolean	south_cursor ;

  Window	client_window ;
  /* եäƤ륦ɥ*/
  Window	focus_window ;
  Window	input_focus_window ;
  Window	probe_window ;

  /* ƥȤɽϤ٤(եɥǤ *
   * а֤Ǥ롣*/
  Position	spot_x, spot_y ;
  /* Ѵ饤Ȥɽΰ衣*/
  XRectangle	client_area ;
  /* Ѵ饤ȤΥơꥢΰ衣*/
  XRectangle	status_area ;
  /* Ѵ饤ȤΥ롼ȥɥǤа֡ĤȤȤˤ *
   * Ƥ*/
  Position	focus_offset_x, focus_offset_y ;
  Position	client_x, client_y ;
  unsigned long attribute_mask ;
  int		conversion_set_focus, conversion_unset_focus ;

  /* ʸ(Хåե)ɽΤ˻Ȥ WindowĹ򣳤 *
   * Ȥ߹碌ˤʤΤǡ//λɬפˤʤ롣*/
  Window	topline_win, midline_win, botline_win ;
  int		topline_probe, midline_probe, botline_probe ;
  int		topline_width, botline_width ;
  int		canvas_lines ;
  struct myChar *topline_text, *midline_text, *botline_text ;
  int		topline_pos, botline_pos, midline_pos ;
  int		topline_x ;

  /* modeshell ֤-- */
  Window	modeshell_win ;
  int		modeshell_probe ;
  int		modeshell_width, modeshell_height ;
  int		modeshell_border_width ;
  int		fixed_modeshell ;
  int		modeshell_x, modeshell_y;
  String	modeshell_geometry;	
  unsigned long	prevModeStatus ;

  /* ߤδϥ⡼ɤɽ륦ɥ*/
  Widget	minibuffer_popup, minibuffer_canvas ;
  int		minibuffer_probe ;

  Window	minibuffer_win ;
  int		minibuffer_ofstx ;

  /* ɽ֡νɬפݤ*/
  int		iposflag ;
  /* եäƤ뤫ɤ*/
  int		is_focus ;

  /* 饤ȤƤѿ*/
  struct ConvAttrsMesg *camsg ;

  /* Callback Ĥʤ˰դġ*/
  /* Widget ˲ѡ*/
  XtCallbackList endcallback ;
  /* ѴʸΤѡ*/
  XtCallbackList fixcallback ;
  /* 򲡤᤹Τѡ*/
  XtCallbackList keybackcallback ;

  /* μϤ˻Ȥѿ(ݥ)*/
  HistoryListNode *historyAttribute ;

  /* skkinput  buffer */
  struct skkinputBuffer	buffer ;
} OverthespotWinPart ;

/* դ뤤󤹤󤹡 */
typedef struct _OverthespotWinRec {
  CorePart 		core ;
  OverthespotWinPart	overthespotWin ;
} OverthespotWinRec ;

/* New fields for the My widget class record */
typedef struct {
  int dummy ;
} OverthespotWinClassPart ;

/* դ뤯餹 */
typedef struct _OverthespotWinClassRec {
  CoreClassPart			core_class ;
  OverthespotWinClassPart	overthespotWin_class ;
} OverthespotWinClassRec ;

/* 餹ݤ󤿡 */
extern OverthespotWinClassRec overthespotWinClassRec ;

#endif
