/* # skkinput (Simple Kana-Kanji Input)
 * kanji.h
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(kanji_h)
#define kanji_h

struct myChar {
	char			charset ;
	unsigned short	chara ;
} ;

struct MessageBuffer {
  unsigned char		internal [TEXTBUFSIZE] ;
  unsigned char*	buffer ;
  int				usage, bufsize ;
} ;

struct KanjiBuffer {
  struct myChar		internal [TEXTBUFSIZE] ;
  struct myChar*	buffer ;
  int				usage, bufsize ;
} ;

#define ERR		(-1)
#define NOERR 	(0)

enum {
  CHARSET_NOTHING = -1,
  CHARSET_ISO8859_1 = 0,
  CHARSET_ISO8859_2,
  CHARSET_ISO8859_3,
  CHARSET_ISO8859_4,
  CHARSET_ISO8859_5,
  CHARSET_ISO8859_6,
  CHARSET_ISO8859_7,
  CHARSET_ISO8859_8,
  CHARSET_ISO8859_9,
  CHARSET_JISX0201_1976,
  CHARSET_JISX0208_1978,
  CHARSET_JISX0208_1983, 
  CHARSET_JISX0212_1990,
  CHARSET_GB2312_1980,
  CHARSET_KSC5601_1987,
  MAX_CHARSET,
} ;

enum {
  ISO2022JP_CHARSET_NOTDEFINE = -1,
  ISO2022JP_CHARSET_ASCII = 0,
  ISO2022JP_CHARSET_ISO8859_1,
  ISO2022JP_CHARSET_ISO8859_2,
  ISO2022JP_CHARSET_ISO8859_3,
  ISO2022JP_CHARSET_ISO8859_4,
  ISO2022JP_CHARSET_ISO8859_5,
  ISO2022JP_CHARSET_ISO8859_6,
  ISO2022JP_CHARSET_ISO8859_7,
  ISO2022JP_CHARSET_ISO8859_8,
  ISO2022JP_CHARSET_ISO8859_9,
  ISO2022JP_CHARSET_JISX0201_ROMAN,
  ISO2022JP_CHARSET_JISX0201_KATAKANA,
  ISO2022JP_CHARSET_JISX0208_1978,
  ISO2022JP_CHARSET_JISX0208_1983,
  ISO2022JP_CHARSET_JISX0212_1990,
  ISO2022JP_CHARSET_GB2312_1980,
  ISO2022JP_CHARSET_KSC5601_1987,
} ;

/* ISO8859 κȾ̤ѤˤϡCHARSET_ISO8859_1 ˽뤳Ȥ
 * 롣ȡʸɤӤưפˤʤȦ*/
#define CHARSET_ASCII	(CHARSET_ISO8859_1)

/* ʸο*/
#define NUMBER_OF_CHARSET	(MAX_CHARSET)

enum {
  KANJI_CODE_UNKNOWN = -2,		/* ɤΤʤ*/
  KANJI_CODE_EUC_SJIS_UNKNOWN = -1,	/* EUC  SJIS ̤Ǥʤ*/
  KANJI_CODE_JIS = 0,			/* JIS ȻפäƤ롣*/
  KANJI_CODE_SJIS,			/* SJIS ȻפäƤ롣*/
  KANJI_CODE_EUC,			/* EUC ȻפäƤ롣*/
} ;
/* 
 * ()SJIS ȸƤ֤ʡMSɤȸƤ١פȤˤϤߤޤ
 *       ɡǤϺߤƤޤm(_ _)m
 */

/*
 *
 */
#define	IS_ASCII_CHARA( wchara )	\
( ( ( !( (wchara).chara & 0x80 ) ) && \
    ( (wchara).charset >= CHARSET_ISO8859_1 && \
      (wchara).charset <= CHARSET_JISX0201_1976 ) )? True : False )

#define IS_ASCII_EQUAL( wchara, nchara )	\
( ( ( (wchara).chara == (nchara) ) && \
    ( (wchara).charset >= CHARSET_ISO8859_1 && \
      (wchara).charset <= CHARSET_JISX0201_1976 ) )? True : False )

#define IS_END_OF_STRING(wchara)	\
( ( ( (wchara).chara == '\0' ) && \
    ( (wchara).charset == CHARSET_ASCII ) )? \
  True : False )

#define MYCHAR_IS_ALPHABETIC(wchara)	\
( ( ( ( (wchara).charset >= CHARSET_ISO8859_1 && \
	(wchara).charset <= CHARSET_JISX0201_1976 ) ) && \
    ( ( (wchara).chara >= 'a' && (wchara).chara <= 'z' ) || \
      ( (wchara).chara >= 'A' && (wchara).chara <= 'Z' ) || \
      ( (wchara).chara >= '0' && (wchara).chara <= '9' ) ) )? True : False )

#define MYCHAR_IS_LOWERCASE(wchara) \
  ( ( ( ( (wchara).charset >= CHARSET_ISO8859_1 && \
	  (wchara).charset <= CHARSET_JISX0201_1976 ) ) && \
      ( ( (wchara).chara >= 'a' && (wchara).chara <= 'z' ) ) )? True : False )

#define MYCHAR_IS_UPPERCASE(wchara) \
  ( ( ( ( (wchara).charset >= CHARSET_ISO8859_1 || \
	  (wchara).charset <= CHARSET_JISX0201_1976 ) ) && \
      ( ( (wchara).chara >= 'A' && (wchara).chara <= 'Z' ) ) )? True : False )

#define MYCHAR_SET_END_OF_STRING(wchara)	\
  do { (wchara).charset = CHARSET_ASCII ; (wchara).chara = '\0' ; } while(0)

#define MYCHAR_SET_CHARA(wchara,nchara)	\
do { (wchara).charset = CHARSET_ASCII ; (wchara).chara = nchara ; } while(0)
  
#define MYCHAR_SET_JISX0208_1983(wchara,jchara) \
do { (wchara).charset = CHARSET_JISX0208_1983 ; (wchara).chara = jchara ; } while(0)

/*
 * ץȥ
 */
void init_kanjibuffer
( struct KanjiBuffer *buf ) ;
void add_kanjibuffer
( struct KanjiBuffer *buf, struct myChar chara ) ;
void add_kanjiStringToKanjiBuffer
( struct KanjiBuffer *buf, struct myChar *string, int length ) ;
void close_kanjibuffer
( struct KanjiBuffer *buf ) ;

int extendedUnixCode_stringToMycharset
( unsigned char *string, struct myChar **wstring ) ;

int myCharStrlen( struct myChar *string ) ;
int myCharStrncmp
( struct myChar *string1, struct myChar *string2, int count ) ;
int myCharStrcmp
( struct myChar *string1, struct myChar *string2 ) ;
int myCharStrcpy
( struct myChar *string1, struct myChar *string2 ) ;
int myCharKatakanaStrcpy
( struct myChar *string1, struct myChar *string2 ) ;
int myCharStrncpy
( struct myChar *string1, struct myChar *string2, int length ) ;
int myCharCharStrcpy
( struct myChar *string1, unsigned char *string2 ) ;
int myCharCharStrncpy
( struct myChar *string1, unsigned char *string2, int number ) ;
int myCharHiraganaStrncpy
( struct myChar *string1, struct myChar *string2, int length ) ;
int myCharHiraKataStrnncpy
( struct myChar *string1, int length1, struct myChar *string2, int length2 ) ;
int myCharCharStrncmp
( struct myChar *string1, unsigned char *string2, int length ) ;
int myCharCharStrcmp
( struct myChar *string1, unsigned char *string2 ) ;
int myCharStrcat
( struct myChar *string1, struct myChar *string2 ) ;
int myCharStrncat
( struct myChar *string1, struct myChar *string2, int length ) ;
int myCharHiraganaStrncat
( struct myChar *string1, struct myChar *string2, int length ) ;
int myCharHiraKataStrnncat
( struct myChar *string1, int length1, struct myChar *string2, int length2 ) ;
int myCharCharStrncat
( struct myChar *string1, unsigned char *string2, int length ) ;
int myCharCharStrcat
( struct myChar *string1, unsigned char *string2 ) ;
int myCharItoa( struct myChar *string, int value ) ;
int myCharFputEUCc( struct myChar chara, FILE *fp ) ;
void myCharFputstring( FILE *fp, struct myChar *string ) ;

void init_messagebuffer( struct MessageBuffer *buf ) ;
void add_messagebuffer( struct MessageBuffer *buf, int chara ) ;
void close_messagebuffer( struct MessageBuffer *buf ) ;

struct myChar *mychar_readOneLine( FILE *fp, int coding_system ) ;
int check_kanjiCode( unsigned char *text, int length ) ;

int myCharAtoi( struct myChar *string ) ;
unsigned char *myCharStringToAsciiString( struct myChar *string ) ;
void myCharFputstrning( FILE *fp, struct myChar *string, int len ) ;
#endif
