/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (XIMInputContext_h)
#define	XIMInputContext_h

struct tagXIMInputContext ;
typedef struct tagXIMInputContext	XIMInputContext ;

#include "XIMInputMethod.h"
#include "XIMPacket.h"

/*	XIM Input Context  Synchronous Mode
 */
#define	XIMClientSync		((unsigned int)1 << 0)
#define	XIMSyncNormal		((unsigned int)1 << 1)
/*	XIM_PREEDIT_START ڤ XIM_PREEDIT_CARET  Synchronous 
 *	ưʤФʤʤ
 */
#define	XIMSyncPreeditStart	((unsigned int)1 << 2)
#define	XIMSyncPreeditCaret	((unsigned int)1 << 3)

#define	XIMSyncAny			(XIMSyncNormal | XIMSyncPreeditStart | XIMSyncPreeditCaret)

/*	ץȥ
 */
XIMInputContext*	XIMInputContext_Create	(XIMInputMethod*, int) ;
void				XIMInputContext_SetNext	(XIMInputContext*, XIMInputContext*) ;
XIMInputContext*	XIMInputContext_GetNext	(XIMInputContext*) ;

int			XIMInputContext_GetID			(XIMInputContext*) ;
Boolean		XIMInputContext_Alivep			(XIMInputContext*) ;
Boolean		XIMInputContext_StartConversion	(XIMInputContext*) ;
Boolean		XIMInputContext_EndConversion	(XIMInputContext*) ;
Boolean		XIMInputContext_ResetConversion	(XIMInputContext*) ;
Boolean		XIMInputContext_ForwardEvent	(XIMInputContext*, XEvent*) ;

unsigned	XIMInputContext_GetSyncMode		(XIMInputContext*) ;
void		XIMInputContext_SetSyncMode		(XIMInputContext*, unsigned) ;
void		XIMInputContext_UnsetSyncMode	(XIMInputContext*, unsigned) ;
Boolean		XIMInputContext_SpoolPacket			(XIMInputContext*, XIMPacket*) ;
XIMPacket*	XIMInputContext_GetSpooledPacket	(XIMInputContext*) ;
int			XIMInputContext_GetNumberOfSpooledPacket	(XIMInputContext*) ;

Boolean		XIMInputContext_SetFocus		(XIMInputContext*) ;
Boolean		XIMInputContext_UnsetFocus		(XIMInputContext*) ;

XIMStyle	XIMInputContext_GetInputStyle	(XIMInputContext*) ;
Window		XIMInputContext_GetClientWindow	(XIMInputContext*) ;
Window		XIMInputContext_GetFocusWindow	(XIMInputContext*) ;
CARD32		XIMInputContext_GetFilterEvents	(XIMInputContext*) ;
XIMResetState	XIMInputContext_GetResetState	(XIMInputContext*) ;
XIMPreeditState	XIMInputContext_GetPreeditState	(XIMInputContext*) ;

Boolean		XIMInputContext_SetInputStyle	(XIMInputContext*, XIMStyle) ;
Boolean		XIMInputContext_SetClientWindow	(XIMInputContext*, Window) ;
Boolean		XIMInputContext_SetFocusWindow	(XIMInputContext*, Window) ;
Boolean		XIMInputContext_SetResetState	(XIMInputContext*, Window) ;
Boolean		XIMInputContext_SetPreeditState	(XIMInputContext*, Window) ;

Boolean		XIMInputContext_GetPreeditArea			(XIMInputContext*, XRectangle*) ;
Boolean		XIMInputContext_GetPreeditAreaNeeded	(XIMInputContext*, XRectangle*) ;
Boolean		XIMInputContext_GetSpotLocation			(XIMInputContext*, XPoint*) ;
Colormap	XIMInputContext_GetPreeditColormap		(XIMInputContext*) ;
Atom		XIMInputContext_GetPreeditStdColormap	(XIMInputContext*) ;
unsigned long	XIMInputContext_GetPreeditForeground	(XIMInputContext*) ;
unsigned long	XIMInputContext_GetPreeditBackground	(XIMInputContext*) ;
Pixmap		XIMInputContext_GetPreeditBackgroundPixmap	(XIMInputContext*) ;
const char*	XIMInputContext_GetPreeditFontSet		(XIMInputContext*) ;
int			XIMInputContext_GetPreeditLineSpacing	(XIMInputContext*) ;
Cursor		XIMInputContext_GetPreeditCursor		(XIMInputContext*) ;

Boolean		XIMInputContext_SetPreeditArea			(XIMInputContext*, const XRectangle*) ;
Boolean		XIMInputContext_SetPreeditAreaNeeded	(XIMInputContext*, const XRectangle*) ;
Boolean		XIMInputContext_SetSpotLocation			(XIMInputContext*, const XPoint*) ;
Boolean		XIMInputContext_SetPreeditColormap		(XIMInputContext*, Colormap) ;
Boolean		XIMInputContext_SetPreeditStdColormap	(XIMInputContext*, Colormap) ;
Boolean		XIMInputContext_SetPreeditForeground	(XIMInputContext*, unsigned long) ;
Boolean		XIMInputContext_SetPreeditBackground	(XIMInputContext*, unsigned long) ;
Boolean		XIMInputContext_SetPreeditBackgroundPixmap	(XIMInputContext*, Pixmap) ;
Boolean		XIMInputContext_SetPreeditFontSet		(XIMInputContext*, const char*, int) ;
Boolean		XIMInputContext_SetPreeditLineSpacing	(XIMInputContext*, int) ;
Boolean		XIMInputContext_SetPreeditCursor		(XIMInputContext*, Cursor) ;

Boolean		XIMInputContext_GetStatusArea			(XIMInputContext*, XRectangle*) ;
Boolean		XIMInputContext_GetStatusAreaNeeded		(XIMInputContext*, XRectangle*) ;
Colormap	XIMInputContext_GetStatusColormap		(XIMInputContext*) ;
Atom		XIMInputContext_GetStatusStdColormap	(XIMInputContext*) ;
unsigned long	XIMInputContext_GetStatusForeground (XIMInputContext*) ;
unsigned long	XIMInputContext_GetStatusBackground (XIMInputContext*) ;
Pixmap		XIMInputContext_GetStatusBackgroundPixmap	(XIMInputContext*) ;
const char*		XIMInputContext_GetStatusFontSet 	(XIMInputContext*) ;
int			XIMInputContext_GetStatusLineSpacing	(XIMInputContext*) ;
Cursor		XIMInputContext_GetStatusCursor 		(XIMInputContext*) ;

Boolean		XIMInputContext_SetStatusArea			(XIMInputContext*, const XRectangle*) ;
Boolean		XIMInputContext_SetStatusAreaNeeded		(XIMInputContext*, const XRectangle*) ;
Boolean		XIMInputContext_SetStatusColormap		(XIMInputContext*, Colormap) ;
Boolean		XIMInputContext_SetStatusStdColormap	(XIMInputContext*, Colormap) ;
Boolean		XIMInputContext_SetStatusForeground		(XIMInputContext*, unsigned long) ;
Boolean		XIMInputContext_SetStatusBackground		(XIMInputContext*, unsigned long) ;
Boolean		XIMInputContext_SetStatusBackgroundPixmap	(XIMInputContext*, Pixmap) ;
Boolean		XIMInputContext_SetStatusFontSet		(XIMInputContext*, const char*, int) ;
Boolean		XIMInputContext_SetStatusLineSpacing	(XIMInputContext*, int) ;
Boolean		XIMInputContext_SetStatusCursor			(XIMInputContext*, Cursor) ;

/*	Target Widget Ʊ롣
 */
Boolean		XIMInputContext_UpdatePreeditAttributes	(XIMInputContext*) ;
Boolean		XIMInputContext_UpdateStatusAttributes	(XIMInputContext*) ;

void		XIMInputContext_Destroy					(XIMInputContext*) ;

Boolean		XIMInputContext_Activate				(XIMInputContext*, Boolean) ;

#endif

