<?php
/*
* Quick.Cart by OpenSolution.org
* www.opensolution.org
*/
extract( $_GET );
session_start( );

if( !isset( $_SESSION['iCustomer'] ) )
  $_SESSION['iCustomer'] = time( ).rand( 100, 999 );

define( 'CUSTOMER_PAGE', true );

require_once './libraries/jcode.php';
require_once 'config/general.php';
require_once DB_CONFIG_LANG;

if( !isset( $p ) || $p == '' ){
  $p  = $config['start_page'];
}
else
  $p = htmlspecialchars( $p );

if( strstr( $p, 'Gallery' ) ){
  $p          = ereg_replace( 'Gallery', '', $p );
  $bGallery   = true;
  $sBlockPage = '_GALLERY';
}

if( !isset( $iCategory ) )
  $iCategory = null;

require_once DIR_LANG.LANGUAGE.'.php';

require_once DIR_LIBRARIES.'TplParser.php';
require_once DIR_LIBRARIES.'FileJobs.php';
require_once DIR_LIBRARIES.'FlatFiles.php';
require_once DIR_LIBRARIES.'Trash.php';
ob_start( 'changeCharset' );

if( isset( $sWord ) && !empty( $sWord ) )
  $sWord = trim( JcodeConvert(htmlspecialchars( changeSpecialChars( stripslashes( $sWord ) ) ) ,0,1));      //for japanese

/*
* Add-ons functions
*/
if( filesize( DIR_PLUGINS.'plugins.php' ) > 30 )
  require DIR_PLUGINS.'plugins.php';

$tpl    = new TplParser;
$oFF    = new FlatFiles;
$content= null;
$tpl->setDir( TPL );

require_once DIR_CORE.'other.php';
require_once DIR_CORE.'categories-'.DB_TYPE.'.php';
require_once DIR_CORE.'categories.php';

/*
* Add-ons actions
*/
if( filesize( DIR_PLUGINS.'actions_client.php' ) > 30 )
  require DIR_PLUGINS.'actions_client.php';

getAction( $p, 'actions_client/' );

if( is_file( $sActionFile ) )
  require_once $sActionFile;
else{
  if( !isset( $bDisplayedPage ) ){
    require_once DIR_CORE.'files-'.DB_TYPE.'.php';
    require_once DIR_CORE.'files.php';

    if( strlen( $p ) > 2 )
      $iCategory = substr( $p, 2 );

    if( !is_numeric( $iCategory ) )
      $iCategory = $config['contact_page'];

    $aData = throwCategory( $iCategory, true, true );

    if( !isset( $aData['sDescriptionFull'] ) ){
      $iCategory  = $config['contact_page'];
      $aData      = throwCategory( $iCategory, true, true );
    }

    $sTitleBefore   = $aData['sName'].' - ';
    if( checkTypeShowSub( $aData['iType'] ) )
      $sSubcategories = listCategoriesChildren( $iCategory, 'contents_details.tpl', true );
    else
      $sSubcategories = null;
    $aFiles         = listFiles( $iCategory, 'contents_details.tpl', 2 );

    if( $iCategory == $config['contact_page'] ){
      if( isset( $_POST['sSend'] ) )
        $sContactContent = sendEmail( $_POST, 'contact.tpl' );
      else
        $sContactContent = $tpl->tbHtml( 'contact.tpl', 'FORM' );

      $sData1 = $tpl->tbHtml( 'contact.tpl', 'CONTACT' );
    }

    if( checkCategoryProducts( $iCategory ) ){
      require_once DIR_CORE.'files-'.DB_TYPE.'.php';
      require_once DIR_CORE.'files.php';

      require_once DIR_CORE.'products-'.DB_TYPE.'.php';
      require_once DIR_CORE.'products.php';

      $sProductsList  = listProducts( 'products_list.tpl' );
    }

    if( !empty( $sProductsList ) )
      $sPrintLink     = null;
    else
      $sPrintLink = $tpl->tbHtml( 'contents_details.tpl', 'PRINT_LINK' );

    $content .= $tpl->tbHtml( 'contents_details.tpl', 'SHOW' );
  }
}

if( !isset( $sBlockPage ) ){
  if( !isset( $sMenu1 ) ){
    $sMenu1 = listCategories( 'menu_1.tpl', 1, true, Array( $iCategory ) );
    if( !isset( $sMenu1 ) )
      $sMenu1 = $tpl->tbHtml( 'menu_1.tpl', 'NOT_FOUND' );
  }
  if( !isset( $sMenu2 ) ){
    $sMenu2 = listCategories( 'menu_2.tpl', 2, true, Array( $iCategory ) );
    if( !isset( $sMenu2 ) )
      $sMenu2 = $tpl->tbHtml( 'menu_2.tpl', 'NOT_FOUND' );
  }
  if( !isset( $sMenu3 ) ){
    $sMenu3 = listCategories( 'menu_3.tpl', 3, true, Array( $iCategory ) );
    if( !isset( $sMenu3 ) )
      $sMenu3 = $tpl->tbHtml( 'menu_3.tpl', 'NOT_FOUND' );
  }
  $sBlockPage = null;
}

echo $tpl->tbHtml( 'page.tpl', 'HEAD' ).$tpl->tbHtml( 'page.tpl', 'BODY'.$sBlockPage ).$content.$tpl->tbHtml( 'page.tpl', 'FOOT'.$sBlockPage );
ob_end_flush( );
?>