<?php
if( !function_exists( 'listProducts' ) ){
  /**
  * List products and return content
  * @return string
  * @param string $sFile
  * @param int    $iList
  */
  function listProducts( $sFile = 'products_list.tpl', $iList = null ){

    if( !isset( $GLOBALS['iPage'] ) || !is_numeric( $GLOBALS['iPage'] ) || $GLOBALS['iPage'] < 1 ) 
      $GLOBALS['iPage'] = 1;

    $aParams[0] = throwStatus( );
    $sPage      = $GLOBALS['p'];
    if( !isset( $iList ) ){
      if( defined( 'CUSTOMER_PAGE' ) )
        $iList = PRODUCTS_LIST;
      else
        $iList = ADMIN_LIST;        
    }

    if( isset( $GLOBALS['iCategory'] ) && is_numeric( $GLOBALS['iCategory'] ) ){
      $aParams[1] = $GLOBALS['iCategory'];
    }
    
    if( isset( $GLOBALS['sWord'] ) && throwStrlen( $GLOBALS['sWord'] ) > 0 ){
      $aParams[2] = $GLOBALS['sWord'];
      $sPage      .= '&amp;sWord='.$GLOBALS['sWord'];
    }

    $aData = dbListProducts( $aParams, $iList  );

    if( isset( $aData ) && is_array( $aData ) )
      return throwProductsData( $sFile, $aData, $sPage, $iList );
    else
      return null;
  } // end function listProducts
}

if( !function_exists( 'throwProductsData' ) ){
  /**
  * Create products list from array
  * @return string
  * @param string $sFile
  * @param array  $aData
  * @param string $sPage
  * @param int    $iList
  */
  function throwProductsData( $sFile, $aData, $sPage, $iList ){
    global $tpl, $aList, $oFF;
    
    $aPhoto       = throwFirstPhoto( 1 );
    $iCount       = count( $aData );
    $content      = null;
    $aCategories  = throwProductsCategories( );

    for( $i = 0; $i < $iCount; $i++ ){  
      list( $aList['iProduct'], $aList['sName'], $aList['fPrice'], $aList['sDescriptionShort'], $aList['iStatus'], $aList['iPosition'] ) = $aData[$i];

      $aList['sNameUrl'] = change2Url( $aList['sName'] );

      if( isset( $aPhoto[$aList['iProduct']] ) && is_file( DIR_FILES.$aPhoto[$aList['iProduct']]['sPhoto'] ) ){
        $aName = $oFF->throwNameExtOfFile( $aPhoto[$aList['iProduct']]['sPhoto'] );
        $aList['sFile']       = $aPhoto[$aList['iProduct']]['sPhoto'];
        $aList['sPhotoSmall'] = DIR_FILES.$aName[0].'_m.'.$aName[1];
        $aList['sPhotoBig']   = DIR_FILES.$aPhoto[$aList['iProduct']]['sPhoto'];
        $aList['sPhoto']      = $tpl->tbHtml( $sFile, 'PHOTO' );
      }
      else{
        $aList['sPhoto'] = $tpl->tbHtml( $sFile, 'NO_PHOTO' );
      }

      $aList['iStyle'] = ( $i % 2 ) ? 0: 1;
      $aList['sStyle'] = ( $i == ( $iCount - 1 ) ) ? 'L': $i + 1;

      if( !empty( $aList['sDescriptionShort'] ) )
        $aList['sDescriptionShort'] = ereg_replace( '\|n\|', '', $aList['sDescriptionShort'] );
      else
        $aList['sDescriptionShort'] = '&nbsp;';


      if( isset( $aCategories[$aList['iProduct']] ) )
        $aList['sCategories'] = throwTreeForProduct( $aCategories[$aList['iProduct']], $sFile );

      $aList['sPrice'] = changePriceFormat( $aList['fPrice'] );

      $content .= $tpl->tbHtml( $sFile, 'LIST_LIST' );

    } // end for

    $aList['sPages'] = countPages( $aData[0]['iFindAll'], $iList, $GLOBALS['iPage'], $sPage, null );
    return $tpl->tbHtml( $sFile, 'LIST_HEAD' ).$content.$tpl->tbHtml( $sFile, 'LIST_FOOT' );
  } // end function throwProductsData
}

if( !function_exists( 'throwProduct' ) ){
  /**
  * Return product data
  * @return array
  * @param int  $iProduct
  */
  function throwProduct( $iProduct ){
    $iStatus      = throwStatus( );
    $aData        = dbThrowProduct( $iProduct, $iStatus );
    $aCategories  = throwProductCategories( $iProduct );
    if( isset( $aData ) && ( $iStatus === 0 || ( isset( $aCategories ) && is_array( $aCategories ) ) ) ){
      $aList = dbThrowProductExt( $iProduct );

      $aList['sDescriptionFull'] = $aList[1];
      list( $aList['iProduct'], $aList['sName'], $aList['fPrice'], $aList['sDescriptionShort'], $aList['iStatus'], $aList['iPosition'] ) = $aData;

      $aList['aCategories'] = $aCategories;
      $aList['sPrice']      = changePriceFormat( $aList['fPrice'] );

      return $aList;
    }
    else
      return null;
  } // end function throwProduct
}

if( !function_exists( 'throwProducts' ) ){
  /**
  * Returns products in array
  * index - iProduct
  * value - sName
  * @return array
  */
  function throwProducts( ){
    return dbThrowProducts( );
  } // end function throwProducts
}

if( !function_exists( 'throwProductCategories' ) ){
  /**
  * Returns categories defined to product
  * @return array
  * @param int  $iProduct
  */
  function throwProductCategories( $iProduct ){
    $aData = dbThrowProductsCategories( );
    if( isset( $aData[$iProduct] ) )
      return $aData[$iProduct];
  } // end function throwProductCategories
}

if( !function_exists( 'throwProductsCategories' ) ){
  /**
  * Returns categories defined to products
  * @return array
  */
  function throwProductsCategories( ){
    return dbThrowProductsCategories( );
  } // end function throwProductsCategories
}
?>