<?php
//error_reporting( E_ALL );

/*
* Language
*/
$config['default_lang']		= "ja";

/*
* List of directories 
*/
$config['dir_config']           = 'config/';
$config['dir_core']             = 'core/';
$config['dir_db']               = 'db/';
$config['dir_js']               = 'js/';
$config['dir_libraries']        = 'libraries/';
$config['dir_tpl']              = 'templates/';
$config['dir_files']            = 'files/';
$config['dir_ext']              = 'ext/';
$config['dir_plugins']          = 'plugins/';
$config['dir_lang']             = 'lang/';

if( isset( $sLang ) && is_file( $config['dir_lang'].$sLang.'.php' ) && strlen( $sLang ) == 2 ){
  setCookie( 'sLanguage', $sLang, time( ) + 86400 );
  define( 'LANGUAGE', $sLang );
}
else{
  if( isset( $_COOKIE['sLanguage'] ) )
    define( 'LANGUAGE', $_COOKIE['sLanguage'] );
  else
    define( 'LANGUAGE', $config['default_lang'] );
}

$config['language']		= LANGUAGE;

/*
* List of database files 
*/
$config['db_products']            = $config['dir_db'].LANGUAGE.'_products.php';
$config['db_products_files']      = $config['dir_db'].LANGUAGE.'_products_files.php';
$config['db_products_ext']        = $config['dir_db'].LANGUAGE.'_products_ext.php';
$config['db_products_categories'] = $config['dir_db'].LANGUAGE.'_products_categories.php';

$config['db_categories']          = $config['dir_db'].LANGUAGE.'_categories.php';
$config['db_categories_ext']      = $config['dir_db'].LANGUAGE.'_categories_ext.php';
$config['db_categories_files']    = $config['dir_db'].LANGUAGE.'_categories_files.php';

$config['db_couriers']            = $config['dir_db'].LANGUAGE.'_couriers.php';

$config['db_orders']              = $config['dir_db'].'orders.php';
$config['db_orders_ext']          = $config['dir_db'].'orders_ext.php';
$config['db_orders_products']     = $config['dir_db'].'orders_products.php';

$config['db_config']         = $config['dir_config'].'general.php';
$config['db_config_lang']    = $config['dir_config'].'lang_'.$config['language'].'.php';

$config['products_photo_size']		= "100";
$config['categories_photo_size']		= "100";

$config['max_dimension_of_image'] = 900;
$config['foto_jobs_ratio'] = 0.80;

$config['products_list']		= 5;
$config['admin_list']		= 20;

$config['time_diff']		= 0;

/*
* Information on mail about new order true/false
*/
$config['mail_informing']		= true;

$config['hidden_shows']		= true;

$config['login']		= "admin";
$config['pass']		= "admin";

$config['version'] = '2.2jp04';

#####################
# Dont change below #
#####################

$config['db_type'] = 'ff';

define( 'DIR_CONFIG',           $config['dir_config'] );
define( 'DIR_CORE',             $config['dir_core'] );
define( 'DIR_DB',               $config['dir_db'] );
define( 'DIR_FILES',            $config['dir_files'] );
define( 'DIR_LIBRARIES',        $config['dir_libraries'] );
define( 'DIR_PLUGINS',          $config['dir_plugins'] );
define( 'DIR_LANG',             $config['dir_lang'] );
define( 'TPL',                  $config['dir_tpl'] );

define( 'PRODUCTS_LIST',        $config['products_list'] );
define( 'ADMIN_LIST',           $config['admin_list'] );

define( 'PRODUCTS_PHOTO_SIZE',   $config['products_photo_size'] );
define( 'CATEGORIES_PHOTO_SIZE', $config['categories_photo_size'] );

define( 'MAX_DIMENSION_OF_IMAGE', $config['max_dimension_of_image'] );

define( 'DB_PRODUCTS',              $config['db_products'] );
define( 'DB_PRODUCTS_EXT',          $config['db_products_ext'] );
define( 'DB_PRODUCTS_FILES',        $config['db_products_files'] );
define( 'DB_PRODUCTS_CATEGORIES',   $config['db_products_categories'] );

define( 'DB_CATEGORIES',        $config['db_categories'] );
define( 'DB_CATEGORIES_EXT',    $config['db_categories_ext'] );
define( 'DB_CATEGORIES_FILES',  $config['db_categories_files'] );

define( 'DB_COURIERS',        $config['db_couriers'] );

define( 'DB_ORDERS',          $config['db_orders'] );
define( 'DB_ORDERS_EXT',      $config['db_orders_ext'] );
define( 'DB_ORDERS_PRODUCTS', $config['db_orders_products'] );

define( 'DB_TYPE',        $config['db_type'] );
define( 'DB_CONFIG',      $config['db_config'] );
define( 'DB_CONFIG_LANG', $config['db_config_lang'] );
define( 'HIDDEN_SHOWS',   $config['hidden_shows'] );
define( 'VERSION',        $config['version'] );
?>