<?php
/*
* Quick.Cart by OpenSolution.org
*
* Contact: info@opensolution.org
* www.opensolution.org
*/
session_start( );

include("./libraries/jcode.php");
require 'config/general.php';

if( !isset( $_GET['p'] ) || $_GET['p'] == '' )
  $_GET['p']  = $config['start_page'];

if( !isset( $_GET['iCategory'] ) )
  $_GET['iCategory'] = null;

extract( $_GET );

require_once DIR_LANG.LANGUAGE.'.php';

require_once DIR_LIBRARIES.'TplParser.php';
require_once DIR_LIBRARIES.'FileJobs.php';
require_once DIR_LIBRARIES.'FotoJobs.php';
require_once DIR_LIBRARIES.'FlatFiles.php';
require_once DIR_LIBRARIES.'Trash.php';

if( !isset( $_SESSION['iCustomer'] ) )
  $_SESSION['iCustomer'] = time( ).rand( 100, 999 );

/*
* Add-ons functions
*/
if( filesize( DIR_PLUGINS.'plugins.php' ) > 30 )
  require DIR_PLUGINS.'plugins.php';

require_once DIR_CORE.'categories-'.$config['db_type'].'.php';
require_once DIR_CORE.'categories.php';
require_once DIR_CORE.'other.php';

$tpl    = new TplParser;
$oFoto  = new FotoJobs;
$oFF    = new FlatFiles;

$content =  null;
$tpl->setDir( TPL.TEMPLATE );

/*
* Add-ons actions
*/
if( filesize( DIR_PLUGINS.'actions_client.php' ) > 30 )
  require DIR_PLUGINS.'actions_client.php';

if( isset( $_GET['sWord'] ) && !empty( $_GET['sWord'] ) )
  $_GET['sWord'] = JcodeConvert(htmlspecialchars( changeSpecialChars( $_GET['sWord'] ) ),0,1);       //for japanese

getAction( $p, 'actions_client/' );  

if( is_file( $sActionFile ) )
  require_once $sActionFile;
else{
  require_once DIR_CORE.'files-'.$config['db_type'].'.php';
  require_once DIR_CORE.'files.php';

  if( !isset( $bDisplayedPage ) ){
    if( strlen( $p ) > 2 )
      $iCategory = substr( $p, 2 );

    if( !is_numeric( $iCategory ) )
      $iCategory = $config['contact_page'];

    $sContentLeft = throwCategoryContent( $iCategory );

    if( !isset( $sContentLeft ) ){
      $iCategory    = $config['contact_page'];
      $sContentLeft = throwCategoryContent( $iCategory );
    }

    $sSubcategories = listCategoriesChildren( $iCategory, 'content_list_sub.tpl', true );

    if( $iCategory == $config['contact_page'] ){
      if( isset( $send ) )
        $sContentRight =  sendEmail( $_POST, 'contact_send.tpl' );
      else
        $sContentRight =  $tpl->tHtml( 'contact_form.tpl' );
      $content .= $tpl->tHtml( 'contact.tpl' );
    }
    else{
      $aFilesContent = listFiles( $iCategory, 'content_list.tpl', 2 );
      $sContentRight = null;
      if( isset( $aFilesContent['default_photo'] ) )
        $sContentRight = $aFilesContent['default_photo'];
      if( isset( $aFilesContent['photos'] ) )
        $sContentRight .= $aFilesContent['photos'];
      if( isset( $sContentRight ) && !empty( $sContentRight ) )
        $content .= $tpl->tHtml( 'columns_two.tpl' );
      else
        $content .= $tpl->tHtml( 'columns_one.tpl' );
    }
  }
}

if( ereg( 'Window', $p ) ){
  echo $tpl->tHtml( 'head_print.tpl' ).$content.$tpl->tHtml('footer_print.tpl');
}
else{
  if( !isset( $sMenuCategories ) )
    $sMenuCategories= listCategories( 'categories_menu.tpl', 1, true, $iCategory );
  if( !isset( $sContentSites ) )
    $sContentSites  = listCategories( 'content_list.tpl', 2, true, $iCategory );
  echo $tpl->tHtml( 'head.tpl' ).$content.$tpl->tHtml('footer.tpl');  
}
?>