<?php

if( !function_exists( 'sendEmail' ) ){
  /**
  * Wysanie e-maila
  * @return string
  * @param array  $aForm
  * @param string $sFile
  * @param string $sTargetMail
  */
  function sendEmail( $aForm, $sFile = 'contact_send.tpl', $sTargetEmail = null ){
    global $oCheckForm, $tpl;
    extract( $aForm );
    
    if( checkLength( $sTopic, 2 ) === true && checkLength( $sMailContent, 2 ) === true && checkEmail( $sSender ) === true ){
      $sMailContent = changePolishToIso( $sMailContent );
      $sTopic =       changePolishToIso( $sTopic );

      //for japanese
      $sTopic = JcodeConvert($sTopic,0,3);
      $sTopic = mb_encode_mimeheader($sTopic, "ISO-2022-JP", "B");
      $sMailContent = JcodeConvert($sMailContent,0,3);
      //

      if( !isset( $sTargetEmail ) )
        $sTargetEmail = EMAIL;

      //for japanese
      $headers = "MIME-Version: 1.0\r\n";
      $headers .= "Content-Language: content=ja\r\n";
      $headers .= "Content-type: text/plain; charset=ISO-2022-JP\r\n";
      $headers .= "From: ".$sSender;
      //

      if( @mail( $sTargetEmail, $sTopic, $sMailContent, $headers ) ){      //for japanese change $headers
        $content = $tpl->tbHtml( $sFile, 'SEND_GOOD' );
      }
      else
        $content = $tpl->tbHtml( $sFile, 'SEND_ALERT' );
    }
    else
      $content = $tpl->tbHtml( $sFile, 'WRONG_WORD' );
    return $content;
  } // end function sendEmail
}

if( !function_exists( 'tPrice' ) ){
  /**
  * Zwracanie ceny
  * @return float
  * @param float  $fPrice
  */
  function tPrice( $fPrice ){
    return sprintf( '%d', $fPrice );        //for japanese '%01.2f' -> '%d'
  } // end function tPrice
}

if( !function_exists( 'throwLastId' ) ){
  /**
  * Zwracanie ostatniego id
  * @return int
  * @param  string  $sDb
  * @param  int     $iPosition
  */
  function throwLastId( $sDb = null, $iPosition = 2 ){
    if( !isset( $sDb ) )
      $sDb = DB_PRODUCTS;
    return dbThrowLastId( $sDb, $iPosition );
  } // end function throwLastId
}

if( !function_exists( 'dbThrowLastId' ) ){
  /**
  * Zwracanie ostatniego id
  * @return int
  * @param  string  $sDb
  * @param  int     $iPosition
  */
  function dbThrowLastId( $sDb, $iPosition ){
    return $GLOBALS['oFF']->throwLastId( DIR_DB.$sDb, $iPosition );
  } // end function dbThrowLastId
}

if( !function_exists( 'checkEmail' ) ){
  /**
  * Sprawdzanie poprawnosci adresu e-mail
  * @return bool
  * @param  string  $sEmail
  */
  function checkEmail( $sEmail ){
    if( eregi( "^[a-z0-9_.-]+([_\\.-][a-z0-9]+)*@([a-z0-9_\.-]+([\.][a-z]{2,4}))+$", $sEmail ) )
      return true;
    else
      return false;
  } // end function checkEmail
}

if( !function_exists( 'checkTel' ) ){
  /**
  * Sprawdzanie poprawnosci telefonu
  * @return bool
  * @param  string  $sEmail
  */
  function checkTel( $sTel ){
    if( eregi( "^[0-9() \-\+]{7,}$", $sTel ) )
      return true;
    else
      return false;
  } // end function checkTel
}

if( !function_exists( 'throwIconsFromExt' ) ){
  /**
  * Pobieranie ikonek rozszerzen
  * @return array
  */
  function throwIconsFromExt( ){
    
    $aExt['rar'] = 'zip';
    $aExt['zip'] = 'zip';
    $aExt['bz2'] = 'zip';
    $aExt['gz']  = 'zip';
  
    $aExt['fla'] = 'fla';
  
    $aExt['mp3']  = 'media';
    $aExt['mpeg'] = 'media';
    $aExt['mpe']  = 'media';
    $aExt['mov']  = 'media';
    $aExt['mid']  = 'media';
    $aExt['midi'] = 'media';
    $aExt['asf']  = 'media';
    $aExt['avi']  = 'media';
    $aExt['wav']  = 'media';
    $aExt['wma']  = 'media';
  
    $aExt['msg']  = 'msg';
    $aExt['eml']  = 'msg';
  
    $aExt['pdf']  = 'pdf';
  
    $aExt['jpg']  = 'pic';
    $aExt['jpeg'] = 'pic';
    $aExt['jpe']  = 'pic';
    $aExt['gif']  = 'pic';
    $aExt['bmp']  = 'pic';
    $aExt['tif']  = 'pic';
    $aExt['tiff'] = 'pic';
    $aExt['wmf']  = 'pic';
  
    $aExt['png']  = 'png';
  
    $aExt['chm']  = 'chm';
    $aExt['hlp']  = 'chm';
  
    $aExt['psd']  = 'psd';
  
    $aExt['swf']  = 'swf';
  
    $aExt['pps']  = 'pps';
    $aExt['ppt']  = 'pps';
  
    $aExt['sys']  = 'sys';
    $aExt['dll']  = 'sys';
  
    $aExt['txt']  = 'txt';
    $aExt['doc']  = 'txt';
    $aExt['rtf']  = 'txt';
  
    $aExt['vcf']  = 'vcf';
  
    $aExt['xls']  = 'xls';
  
    $aExt['xml']  = 'xml';
  
    $aExt['tpl']  = 'web';
    $aExt['html'] = 'web';
    $aExt['htm']  = 'web';
    $aExt['com']  = 'exe';
    $aExt['bat']  = 'exe';
    $aExt['exe']  = 'exe';
  
    return $aExt;
  } // end function throwIconsFromExt
}
?>