<?php
if( !function_exists( 'saveOrderStatus' ) ){
  /**
  * Zapisywanie zamowienia
  * @return void
  * @param int    $iOrder
  * @param array  $aForm
  */
  function saveOrderStatus( $iOrder, $aForm ){
    $aForm['iOrder'] = $iOrder;
    dbSaveOrderStatus( $aForm );
  } // end function saveOrderStatus
}

if( !function_exists( 'listOrders' ) ){
  /**
  * Wyswietlanie spisu zamowien
  * @return string
  * @param string $sFile
  * @param string $sOption
  */
  function listOrders( $sFile = 'orders_list.tpl', $sOption = 'list' ){
    global $tpl, $aList;
    
    if( !isset( $_GET['page'] ) || !is_numeric( $_GET['page'] ) || $_GET['page'] < 1 ) 
      $_GET['page'] = 1;

    if( $sOption == 'status' ){
      $aData = dbListOrdersStatus( $_GET['iStatus'] );
      $sPage = $_GET['p'].'&amp;iStatus='.$_GET['iStatus'];
    }
    elseif( $sOption == 'search' ){
      $aData = dbListOrdersSearch( trim( $_GET['sWord'] ) );
      $sPage = $_GET['p'].'&amp;sWord='.$_GET['sWord'];
    }
    else{
      $aData = dbListOrders( );
      $sPage = $_GET['p'];  
    }

    $content  = null;

    if( isset( $aData ) ){
      $iCount = count( $aData );
      for( $i = 0; $i < $iCount; $i++ ){  
        list( $aList['iOrder'], $aList['iClient'], $aList['iStatus'], $aList['iCourier'], $aList['sFirstName'], $aList['sLastName'], $aList['sCompanyName'], $aList['sStreet'], $aList['sZipCode'], $aList['sCity'], $aList['sTelephone'], $aList['sEmail'], $aList['iTime'], $aList['sIp'], $aList['sComment'] ) = $aData[$i];
        
        if( $i % 2 )
          $aList['sColor'] = '#f3f3f3';
        else
          $aList['sColor'] = '#ffffff';

        $aList =            changeMassTxt( $aList, '' );
        $aList['sDate'] =   date( 'Y-m-d H:i:s', $aList['iTime'] );
        $aList['sStatus']=  throwOrderStatus( $aList['iStatus'] );

        if( $aList['iStatus'] == 1 )
          $aList['sStatus'] = '<b>'.$aList['sStatus'].'</b>';

        $content .= $tpl->tbHtml( $sFile, 'LIST_LIST' );
      } // end for

      $aList['pages'] = countPages( $aData[0]['iFindAll'], ORDERS_LIST, $_GET['page'], $sPage );
      
      return $tpl->tbHtml( $sFile, 'LIST_HEAD' ).$content.$tpl->tbHtml( $sFile, 'LIST_FOOTER' );
    }
    else
      return $tpl->tbHtml( $sFile, 'NOT_FOUND' );
  } // end function listOrders
}

if( !function_exists( 'delOrderMass' ) ){
  /**
  * Usuwanie zamowien starszych niz 24h i nie skonczonych
  * @return void
  */
  function delOrderMass( ){
    dbDelOrderMass( );
  } // end function delOrderMass
}

if( !function_exists( 'throwOrderStatus' ) ){
  /**
  * Zwracanie stanu zamowienia
  * @return string
  * @param int    $iStatus
  * @param bool   $bCount
  */
  function throwOrderStatus( $iStatus = 1, $bCount = null ){
    global $lang;
    $aStatus[1] = $lang['Pending'];
    $aStatus[2] = $lang['Processing'];
    $aStatus[3] = $lang['Finished'];
    $aStatus[4] = $lang['Canceled'];
    if( isset( $bCount ) )
      return count( $aStatus );
    else
      return $aStatus[$iStatus];
  } // end function throwOrderStatus
}

if( !function_exists( 'throwOrderStatusSelect' ) ){
  /**
  * Zwracanie select'a stanu zamowienia
  * @return string
  * @param int  $iStatus
  */
  function throwOrderStatusSelect( $iStatus = null ){
    $iCount =   throwOrderStatus( null, true );  
    $sOption =  null;

    for( $i = 1; $i <= $iCount; $i++ ){
      if( isset( $iStatus ) && $iStatus == $i )
        $sSelected = 'selected="selected"';
      else
        $sSelected = null;

      $sOption .= '<option value="'.$i.'" '.$sSelected.' >'.throwOrderStatus( $i ).'</option>'."\n";
    } // end for

    return $sOption;
  } // end function throwOrderStatusSelect
}
?>