<?php
if( !function_exists( 'listCouriers' ) ){
  /**
  * Wyswietlanie spisu kurierow
  * @return string
  * @param string $sFile
  */
  function listCouriers( $sFile = 'couriers_list.tpl' ){
    global $tpl, $aCouriers;

    $aData  = dbListCouriers( );

    if( isset( $aData ) && is_array( $aData ) ){
      $iCount   = count( $aData );
      $content  = null;

      for( $i = 0; $i < $iCount; $i++ ){
        list( $aCouriers['name'], $aCouriers['id'], $aCouriers['price'] ) = $aData[$i];
        
        if( $i % 2 )
          $aCouriers['color'] = '#f3f3f3';
        else
          $aCouriers['color'] = '#ffffff';

        $content .= $tpl->tbHtml( $sFile, 'LIST_LIST' );
      } // end for

      return $tpl->tbHtml( $sFile, 'LIST_HEAD' ).$content.$tpl->tbHtml( $sFile, 'LIST_FOOTER' );
    }
    else
      return $tpl->tbHtml( $sFile, 'NOT_FOUND' );
  } // end function listCouriers
}

if( !function_exists( 'throwCourier' ) ){
  /**
  * Zwracanie danych kuriera
  * @return array
  * @param int  $iCourier
  */
  function throwCourier( $iCourier ){
    $aData =  dbThrowCourier( $iCourier );
    if( isset( $aData ) ){
      list( $aCourier['name'], $aCourier['id'], $aCourier['price'] ) = $aData;
      return $aCourier;
    }
    else
      return null;

  } // end function throwCourier
}
?>