<?php
if( !function_exists( 'addCourier' ) ){
  /**
  * Dodawanie kuriera
  * @return void
  * @param array  $aForm
  */
  function addCourier( $aForm ){
    $aForm['iCourier'] = throwLastId( DB_COURIERS, 1 ) + 1;

    $aForm['sName']  = JcodeConvert(changeTxt( $aForm['sName'] ),0,1);    //for japanese
    $aForm['fPrice'] = ereg_replace( ',', '.', $aForm['fPrice'] );
    $aForm['fPrice'] = tPrice( $aForm['fPrice'] );
    
    dbAddCourier( $aForm );
  } // end function addCourier
}

if( !function_exists( 'changeCourier' ) ){
  /**
  * Zmiana danych kuriera
  * @return void
  * @param array  $aForm
  */
  function changeCourier( $aForm ){

    $aForm['sName']  = JcodeConvert(changeTxt( $aForm['sName'] ),0,1);     //for japanese
    $aForm['fPrice'] = ereg_replace( ',', '.', $aForm['fPrice'] );
    $aForm['fPrice'] = tPrice( $aForm['fPrice'] );

    dbChangeCourier( $aForm );
  } // end function changeCourier
}

if( !function_exists( 'delCourier' ) ){
  /**
  * Usuwanie kuriera
  * @return void
  * @param int  $iCourier
  */
  function delCourier( $iCourier ){
    dbDelCourier( $iCourier );
  } // end function delCourier
}
?>