<?php
# iPosition, iType, iCategory, iParent, sName, sShortDescription, sFullDescription

if( !function_exists( 'dbThrowCategory' ) ){
  /**
  * Zwraca dane dla kategorii
  * @return array
  * @param int $iCategory
  */
  function dbThrowCategory( $iCategory ){
    return $GLOBALS['oFF']->throwData( DIR_DB.DB_CATEGORIES, $iCategory, 2 );
  } // end function dbThrowCategory
}

if( !function_exists( 'dbSaveCategory' ) ){
  /**
  * Zapisanie danych kategorii
  * @return void
  * @param array $aForm
  */
  function dbSaveCategory( $aForm ){
    global $oFF, $oCategory;
    
    if( !isset( $aForm['iType'] ) || empty( $aForm['iType'] ) ){
      if( is_numeric( $aForm['iParent'] ) && is_array( $oCategory->aData[$aForm['iParent']] ) ){
        $aForm['iType'] = $oCategory->aData[$aForm['iParent']]['iType'];
      }
      else{
        $aForm['iType'] = 1;
      }
    }

    if( isset( $aForm['iCategory'] ) && is_numeric( $aForm['iCategory'] ) ){
      $oFF->setRow( Array( $aForm['iPosition'], $aForm['iType'], $aForm['iCategory'], $aForm['iParent'], $aForm['sName'], $aForm['sShortDescription'], $aForm['sFullDescription'] ) );
      $oFF->changeInFile( DIR_DB.DB_CATEGORIES, $aForm['iCategory'], 2 );
    }
    else{
      $aForm['iCategory'] = throwLastId( DB_CATEGORIES, 2 ) + 1;
      $oFF->setRow( Array( $aForm['iPosition'], $aForm['iType'], $aForm['iCategory'], $aForm['iParent'], $aForm['sName'], $aForm['sShortDescription'], $aForm['sFullDescription'] ) );
      $oFF->addToFile( DIR_DB.DB_CATEGORIES, 'end' );
    }

    return $aForm['iCategory'];
  } // end function dbSaveCategory
}

if( !function_exists( 'dbListCategories' ) ){
  /**
  * Zwraca tablice ze spisem kategorii
  * @return void
  */
  function dbListCategories( ){
    $aFile =  file( DIR_DB.DB_CATEGORIES );
    $iCount = count( $aFile );
    $aData =  null;
    for( $i = 1; $i < $iCount; $i++ ){
      $aExp =     explode( '$', $aFile[$i] );
      $aData[] =  Array( $aExp[0], $aExp[4], $aExp[2], $aExp[3], $aExp[1], $aExp[5], $aExp[6] );
    } // end for
  
    if( is_array( $aData ) )
      sort( $aData );
    
    $GLOBALS['oCategory']->listCategoriesToArray( $aData );
  } // end function dbListCategories
}

if( !function_exists( 'dbDelCategory' ) ){
  /**
  * Usuwanie kategorii
  * @return void
  * @param int $iCategory
  */
  function dbDelCategory( $iCategory ){
    $GLOBALS['oFF']->deleteInFile( DIR_DB.DB_CATEGORIES, $iCategory, 2 );
  } // end function dbDelCategory
}
?>