<?php

if( !function_exists( 'saveCategory' ) ){
  /**
  * Zapisanie danych kategorii
  * @return int
  * @param array $aForm
  */
  function saveCategory( $aForm ){

    ## ZAPISYWANIE TRESCI ##
    $aForm['sName'] =             JcodeConvert(changeTxt( $aForm['sName'] ),0,1);				//for japanese
    $aForm['sShortDescription'] = JcodeConvert(changeTxt( $aForm['sShortDescription'], 'BrNdsTag' ),0,1);	//for japanese
    $aForm['sFullDescription'] =  JcodeConvert(changeTxt( $aForm['sFullDescription'],  'BrNds' ),0,1);		//for japanese
    if( !isset( $aForm['iPosition'] ) || !is_numeric( $aForm['iPosition'] ) || $aForm['iPosition'] < -99 || $aForm['iPosition'] > 999 )
      $aForm['iPosition'] = 0;

    $iCategory = dbSaveCategory( $aForm );

    ## OPERACJE NA PLIKACH ##
    if( isset( $aForm['aFileDescriptionChange'] ) && is_array( $aForm['aFileDescriptionChange'] ) ){
      foreach( $aForm['aFileDescriptionChange'] as $iKey => $sValue ){
        dbChangeFileDescription( Array( $iKey, $iCategory, $aForm['aFileNameChange'][$iKey], changeTxt( ereg_replace( '\'', '', $sValue ) ), $aForm['aFileType'][$iKey] ), 2 );
      }
    }

    if( isset( $aForm['aDelFile'] ) && is_array( $aForm['aDelFile'] ) ){
      $iCount = count( $aForm['aDelFile'] );
      for( $i = 0; $i < $iCount; $i++ )
        delFile( $aForm['aDelFile'][$i], 2 );
    }

    if( isset( $_FILES['sFile'] ) )
      addFiles( $aForm, $iCategory, CATEGORIES_FOTO_SIZE, 2 );

    return $iCategory;
  } // end function saveCategory
}


if( !function_exists( 'delCategory' ) ){
  /**
  * Usuwanie kategorii
  * @return void
  * @param array $iCategory
  */
  function delCategory( $iCategory ){
    delFiles( $iCategory, 2 );
    dbDelCategory( $iCategory );
    delCategoryChildren( $iCategory );
  } // end function delCategory
}

if( !function_exists( 'delCategoryChildren' ) ){
  /**
  * Usuwa podkategorie danej
  * @return void
  * @param int    $iParent
  */
  function delCategoryChildren( $iParent ){
    global $oCategory;
    
    if( isset( $oCategory->aByParent[$iParent] ) )
      $aCategories = $oCategory->aByParent[$iParent];

    $content =  null;
    if( isset( $aCategories ) && is_array( $aCategories ) ){
      $iCount =   count( $aCategories );
      for( $i = 0; $i < $iCount; $i++ ){

        $iCategory = $aCategories[$i];
        delFiles( $iCategory, 2 );
        dbDelCategory( $iCategory );

      } // end for
    }
  } // end function delCategoryChildren
}
?>