/* Copyright (c) 2020-2023 The Creators of Simphone

   See the file COPYING.LESSER.txt for copying permission.
*/

#ifndef _PROXIES_H_
#define _PROXIES_H_

#include "simtypes.h"

/* save proxies file */
int proxy_list_save (void);

/* blacklist proxy by ip and port */
int proxy_blacklist (const char *address, unsigned ip, int port);

/* check if proxy is blacklisted */
simbool proxy_check_blacklisted (unsigned ip, int port);

#define PROXY_PROBE_DHT 0       /* ip and port came from the DHT (need to be checked) */
#define PROXY_PROBE_IP 1        /* this is a live proxy which serves one of my contacts */
#define PROXY_PROBE_CONTACT 2   /* one of my contacts is online and has incoming connectivity */
#define PROXY_PROBE_NOCONTACT 3 /* one of my contacts is unreachable */

/* check for a proxy or/and add it to list. probe is PROXY_PROBE_xxx */
void proxy_probe (const char *address, unsigned ip, int port, unsigned probe);

/* cancel proxy probes from the given sender ip and sleep for the given number of seconds (if timeout is positive) */
void proxy_cancel_probe_ (unsigned senderip, int seconds);

#define PROXY_SCORE_INIT (-1) /* reset the score */
#define PROXY_SCORE_NOK 0     /* verification failed (check) */
#define PROXY_SCORE_OK 1      /* verification succeeded */

/* update proxy score. score is PROXY_SCORE_xxx */
void proxy_set_score (simcontact contact, int error, int score);

/* initialize and deinitialize proxy */
int proxy_list_init_ (void);
int proxy_list_uninit_ (void);

/* debug logging */
void proxy_log_lists (const char *module, int level);

#endif
