/* Copyright (c) 2020-2023 The Creators of Simphone

   See the file COPYING.LESSER.txt for copying permission.
*/

#ifndef _ERROR_H_
#define _ERROR_H_

/* positive error codes from the system (see errno.h) */

#define SIM_OK 0 /* success */

#define SIM_CRYPT_BAD_CIPHER (-1)     /* unknown cipher */
#define SIM_CRYPT_BAD_RSA_KEY (-2)    /* bad RSA public key */
#define SIM_CRYPT_NO_RSA_DECRYPT (-3) /* RSA decryption error */
#define SIM_CRYPT_BAD_PACKET (-4)     /* authentication failed */
#define SIM_CRYPT_BAD_TABLE (-5)      /* corrupted but authenticated hash table */
#define SIM_CRYPT_BAD_KEY (-6)        /* falsified public key */
#define SIM_CRYPT_RSA_VERIFY (-7)     /* RSA authentication error */
#define SIM_CRYPT_BAD_HANDSHAKE (-8)  /* unknown handshake type */
#define SIM_CRYPT_NO_CIPHERS (-9)     /* no preferred ciphers */
#define SIM_CRYPT_NO_RANDOM (-10)     /* no random generator */

#define SIM_SSL_ERROR (-50)        /* check the openssl error stack */
#define SIM_SSL_NO_PREMASTER (-51) /* premaster key generation failed */
#define SIM_SSL_NO_MASTER (-52)    /* master key generation failed */
#define SIM_SSL_NO_HANDSHAKE (-53) /* handshake did not complete */
#define SIM_SSL_BAD_TMP_KEY (-54)  /* bad ephemeral EC key */

#define SIM_KEY_NO_KEY (-150)     /* no key available for auto-login */
#define SIM_KEY_BAD_TYPE (-151)   /* invalid key type */
#define SIM_KEY_NO_SAVE (-152)    /* key save not allowed */
#define SIM_KEY_NO_PRIVATE (-153) /* private key is missing */
#define SIM_KEY_TOO_LARGE (-154)  /* key too big for use with this system */
#define SIM_KEY_TOO_SLOW (-155)   /* system is too busy to use this key */
#define SIM_KEY_NOT_SECURE (-156) /* key file has been revoked */
#define SIM_KEY_NO_ENTROPY (-157) /* not enough entropy collected */
#define SIM_KEY_EXISTS (-158)     /* key already exists */
#define SIM_KEY_NO_CONTACT (-159) /* you do not exist in your contact list */
#define SIM_KEY_NO_SAVED (-160)   /* no saved key found */
#define SIM_KEY_BAD_KEY (-161)    /* insecure RSA private key */

#define SIM_SOCKET_NO_ERROR (-200)     /* internal (unknown) socket error */
#define SIM_SOCKET_BAD_PACKET (-201)   /* received packet is bad */
#define SIM_SOCKET_BAD_LENGTH (-202)   /* tried to send a packet too large */
#define SIM_SOCKET_END (-203)          /* connection closed by peer */
#define SIM_SOCKET_CANCELLED (-204)    /* connect was cancelled */
#define SIM_SOCKET_BAD_PORT (-205)     /* invalid port number */
#define SIM_SOCKET_TIMEOUT (-206)      /* connect failed to complete */
#define SIM_SOCKET_RECV_TIMEOUT (-207) /* recv failed to complete */
#define SIM_SOCKET_SEND_TIMEOUT (-208) /* send failed to complete */
#define SIM_SOCKET_EXCEEDED (-209)     /* maximal data size exceeded */
#define SIM_SOCKET_CONNECT (-210)      /* socks proxy failed to connect */
#define SIM_SOCKET_ACCEPT (-211)       /* retry blocked accept */
#define SIM_SOCKET_BLOCKED (-212)      /* socket is busy */
#define SIM_SOCKET_RECV_FAILED (-213)  /* SIM_SOCKET_RECV_TIMEOUT inside SSL packet */
#define SIM_SOCKET_RECV_ERROR (-214)   /* SIM_SOCKET_RECV_TIMEOUT was not handled */

#define SIM_FILE_LOCKED (-250)    /* program already running */
#define SIM_FILE_ERROR (-251)     /* file is corrupted */
#define SIM_FILE_END (-252)       /* file is truncated */
#define SIM_FILE_NO_SPACE (-253)  /* disk full */
#define SIM_FILE_BAD_KEY (-254)   /* key file is corrupted */
#define SIM_FILE_BAD_TABLE (-255) /* tried to save a corrupted table */
#define SIM_FILE_NO_KEY (-256)    /* tried to encrypt a file with no key */
#define SIM_FILE_BAD_NAME (-257)  /* invalid file name */
#define SIM_FILE_START (-258)     /* beginning of file has been reached */
#define SIM_FILE_NO_SEEK (-259)   /* lseek failure */
#define SIM_FILE_BAD_SIZE (-260)  /* invalid file size */
#define SIM_FILE_BAD_TYPE (-261)  /* invalid file type */

#define SIM_CONTACT_UNKNOWN (-300)     /* contact does not exist */
#define SIM_CONTACT_BLOCKED (-301)     /* contact is not authorized */
#define SIM_CONTACT_BAD_ID (-302)      /* invalid contact identifier */
#define SIM_CONTACT_BAD_ADDRESS (-303) /* invalid contact address */
#define SIM_CONTACT_BAD_NICK (-304)    /* invalid nick name */
#define SIM_CONTACT_NO_KEY (-305)      /* contact public key is missing */
#define SIM_CONTACT_OVERFLOW (-306)    /* too many contacts */
#define SIM_CONTACT_BAD_VERIFY (-307)  /* invalid verification code */
#define SIM_CONTACT_REVOKED (-308)     /* public key has been revoked */
#define SIM_CONTACT_DROPPED (-309)     /* contact disconnected by user */
#define SIM_CONTACT_EXISTS (-310)      /* contact already exists */

#define SIM_PARAM_UNKNOWN_KEY (-350) /* undefined configuration parameter */
#define SIM_PARAM_BAD_KEY (-351)     /* invalid configuration parameter */
#define SIM_PARAM_BAD_TYPE (-352)    /* invalid configuration value type */
#define SIM_PARAM_BAD_VALUE (-353)   /* invalid configuration value */

#define SIM_LIMIT_NO_ERROR (-450)       /* internal (unknown) limit error */
#define SIM_LIMIT_BLOCKED (-451)        /* proxy customer is blacklisted */
#define SIM_LIMIT_NO_CLIENTS (-452)     /* too many clients */
#define SIM_LIMIT_NO_BANDWIDTH (-453)   /* proxy has no available bandwidth */
#define SIM_LIMIT_NO_SPEED (-454)       /* proxy has been overloaded with data */
#define SIM_LIMIT_NO_HANDSHAKE (-455)   /* too many proxy clients per server */
#define SIM_LIMIT_NO_SOCKETS (-456)     /* proxy has no available new sockets */
#define SIM_LIMIT_NO_SERVERS (-457)     /* proxy has no available socket for a new server */
#define SIM_LIMIT_NO_CUSTOMERS (-458)   /* proxy has no available socket for a new client */
#define SIM_LIMIT_NO_CONNECTIONS (-459) /* too many connections per ip address */
#define SIM_LIMIT_CPU_LOAD (-460)       /* maximal cpu load exceeded */
#define SIM_LIMIT_DHT_DISABLE (-461)    /* DHT has been suspended */
#define SIM_LIMIT_DHT_ENABLE (-462)     /* DHT has been resumed */
#define SIM_LIMIT_DHT_BLACKLIST (-463)  /* DHT has been restricted */

#define SIM_PROXY_LOCAL (-500)         /* proxy local customer */
#define SIM_PROXY_NO_CUSTOMER (-501)   /* requested connection to unknown customer */
#define SIM_PROXY_NO_CLIENTS (-502)    /* too many proxy clients */
#define SIM_PROXY_NAT_CLOSE (-503)     /* traversal connection to proxy closed */
#define SIM_PROXY_END_LOCAL (-504)     /* connection closed by local server */
#define SIM_PROXY_END_PROXY (-505)     /* connection closed by proxy */
#define SIM_PROXY_END_CLIENT (-506)    /* connection closed by proxy client */
#define SIM_PROXY_END_SERVER (-507)    /* connection closed by proxy server */
#define SIM_PROXY_REVERSE (-508)       /* reverse connection to proxy customer */
#define SIM_PROXY_NOT_SERVING (-509)   /* not serving any customers */
#define SIM_PROXY_NOT_NEEDED (-510)    /* incoming connection succeeded */
#define SIM_PROXY_NOT_PREFERRED (-511) /* switching to a preferred proxy */
#define SIM_PROXY_OFFLINE (-512)       /* proxy has logged off */
#define SIM_PROXY_BLOCKED (-513)       /* proxy blocked by user */
#define SIM_PROXY_BLACKLISTED (-514)   /* proxy is blacklisted */
#define SIM_PROXY_DROPPED (-515)       /* proxy disconnected by user */
#define SIM_PROXY_RECONNECT (-516)     /* old customer was disconnected */

#define SIM_NAT_TRAVERSE_TIMEOUT (-550)   /* traversal timeout */
#define SIM_NAT_TRAVERSE_CANCELLED (-551) /* traversal was cancelled */
#define SIM_NAT_REVERSE_PROXY (-552)      /* reversal found a proxy */
#define SIM_NAT_REVERSE_DENIED (-553)     /* reversal rejected */
#define SIM_NAT_REVERSE_CANCELLED (-554)  /* reversal was cancelled */
#define SIM_NAT_REVERSE_ABANDONED (-555)  /* reversal was abandoned */
#define SIM_NAT_REVERSE_NO_PROXY (-556)   /* proxy connection not found */
#define SIM_NAT_REVERSE_QUIT (-557)       /* reversal has failed */
#define SIM_NAT_TRAVERSE_QUIT (-558)      /* traversal has failed */
#define SIM_NAT_TRAVERSE_FAILED (-559)    /* traversal has not succeeded (yet) */
#define SIM_NAT_REVERSE_FINISHED (-560)   /* reversal has finished */
#define SIM_NAT_TRAVERSE_ATTEMPT (-561)   /* traversal attempt initiated */
#define SIM_NAT_REVERSE_RETRY (-562)      /* retry reversal attempt */

#define SIM_CLIENT_INIT (-600)        /* client already initialized */
#define SIM_CLIENT_UNKNOWN (-601)     /* not currently connected to contact */
#define SIM_CLIENT_NOT_FOUND (-602)   /* contact is offline */
#define SIM_CLIENT_BAD_VERSION (-603) /* handshake failed */
#define SIM_CLIENT_SELF (-604)        /* connected to self */
#define SIM_CLIENT_CANCELLED (-605)   /* client is logging off */
#define SIM_CLIENT_CONNECTED (-606)   /* already connected to client */
#define SIM_CLIENT_DROPPED (-607)     /* reconnected to contact */
#define SIM_CLIENT_IDLE (-608)        /* client was idle */
#define SIM_CLIENT_OFFLINE (-609)     /* client has logged off */
#define SIM_CLIENT_ONLINE (-610)      /* contact was already found */
#define SIM_CLIENT_LOCAL (-611)       /* client local customer */

#define SIM_SERVER_INIT (-650)      /* server already/not initialized */
#define SIM_SERVER_EXIT (-651)      /* server has closed the connection */
#define SIM_SERVER_PORT (-652)      /* server cannot allocate port */
#define SIM_SERVER_TIMEOUT (-653)   /* connection timed out */
#define SIM_SERVER_RECONNECT (-654) /* need to reconnect */
#define SIM_SERVER_DROPPED (-655)   /* client was dropped */
#define SIM_SERVER_OFFLINE (-656)   /* server has logged you off */
#define SIM_SERVER_CONTACT (-657)   /* SSL contact request */

#define SIM_CALL_NO_AUDIO (-700)          /* no audio devices */
#define SIM_CALL_BAD_AUDIO (-701)         /* bad audio device */
#define SIM_CALL_TALKING (-702)           /* already talking */
#define SIM_CALL_HANGUP (-703)            /* not talking */
#define SIM_CALL_BAD_CODEC (-704)         /* unknown audio codec */
#define SIM_CALL_BAD_SAMPLE (-705)        /* invalid sample rate */
#define SIM_CALL_BAD_SOUND (-706)         /* no such sound */
#define SIM_CALL_NO_SAMPLE (-707)         /* no such sample rate */
#define SIM_CALL_INVALID_AUDIO (-708)     /* invalid audio device */
#define SIM_CALL_NO_ECHO_CANCELLER (-709) /* echo cancellation not allowed */
#define SIM_CALL_NO_AUDIO_INPUT (-710)    /* no input audio data */
#define SIM_CALL_NO_AUDIO_OUTPUT (-711)   /* no output audio data */

#define SIM_MSG_OVERFLOW (-750)   /* memory full */
#define SIM_MSG_BAD_LENGTH (-751) /* message too long */
#define SIM_MSG_BAD_CHAR (-752)   /* invalid character */
#define SIM_MSG_BAD_INDEX (-753)  /* invalid message index */
#define SIM_MSG_NO_EDIT (-754)    /* original message missing */
#define SIM_MSG_BAD_FILE (-755)   /* history file out of sync */

#define SIM_XFER_NO_ERROR (-800)  /* file has been received */
#define SIM_XFER_PAUSED (-801)    /* paused file transfer */
#define SIM_XFER_CANCELLED (-802) /* cancelled file transfer */
#define SIM_XFER_NO_RECV (-803)   /* names buffer overflow */
#define SIM_XFER_NO_SEND (-804)   /* not resending file */
#define SIM_XFER_NO_RESIZE (-805) /* not resending resized file */
#define SIM_XFER_NO_RESEND (-806) /* not resending changed file */
#define SIM_XFER_NO_RESUME (-807) /* invalid file offset */

#define SIM_XFER_NO_FILE (-810)    /* file not found */
#define SIM_XFER_NO_CREATE (-811)  /* permission denied */
#define SIM_XFER_NO_RENAME (-812)  /* rename failed */
#define SIM_XFER_NO_NAME (-813)    /* no file name available */
#define SIM_XFER_NO_SAVE (-814)    /* no download directory */
#define SIM_XFER_BAD_HANDLE (-815) /* invalid file transfer handle */
#define SIM_XFER_BAD_ID (-816)     /* invalid computer identifier */
#define SIM_XFER_BAD_SIZE (-817)   /* file too large */

#define SIM_API_INIT (-900)              /* bad initialization state */
#define SIM_API_EXIT (-901)              /* terminated by user */
#define SIM_API_INSTALL_CANCELLED (-902) /* installation cancelled by user */
#define SIM_API_INSTALL_FAILED (-903)    /* installation failed */
#define SIM_API_NO_RIGHT (-904)          /* invalid communication mode */
#define SIM_API_BAD_VERSION (-905)       /* invalid library version */
#define SIM_API_BAD_STATUS (-906)        /* invalid status */
#define SIM_API_BAD_SEED (-907)          /* invalid password */
#define SIM_API_BAD_TYPE (-908)          /* invalid type or number of bits */
#define SIM_API_BAD_PARAM (-909)         /* invalid parameter */

#define SIM_MAIN_INIT (-950)         /* DHT already/not initialized */
#define SIM_CONSOLE_QUIT_CMD (-951)  /* console quit command */
#define SIM_CONSOLE_NO_PARAM (-952)  /* command parameter missing */
#define SIM_CONSOLE_BAD_CMD (-953)   /* unknown console command */
#define SIM_CONSOLE_BAD_PARAM (-954) /* invalid command parameter */
#define SIM_CONSOLE_BAD_VALUE (-955) /* invalid parameter value */

#define SIM_NO_ERROR (-999) /* impossible error */

#endif
