/* Copyright (c) 2020-2023 The Creators of Simphone

   See the file COPYING.LESSER.txt for copying permission.
*/

#ifndef SEEDGEN_H
#define SEEDGEN_H

#include "consoledialog.h"

namespace Ui {
class SeedGen;
}

class SeedGen : public LoginDialog
{
  Q_OBJECT

  typedef LoginDialog Parent;

public:
  explicit SeedGen(QWidget * parent, QEvent * event, int bits, int type);
  ~SeedGen() Q_DECL_OVERRIDE;

  void generate();
  QString getSeed(int num) const { return m_seed[m_seed[num].isEmpty() ? 0 : num]; }

public Q_SLOTS:
  void closeEvent(QCloseEvent * event) Q_DECL_OVERRIDE;
  void changeEvent(QEvent * event) Q_DECL_OVERRIDE;
  void showEvent(QShowEvent * event) Q_DECL_OVERRIDE;

public slots:
  void on_okButton_clicked();

  void on_actionQuit_triggered() { Parent::on_actionQuit_triggered(); }
  void on_actionConsole_triggered();
  void on_actionAudioDevices_triggered() { Parent::on_actionAudioDevices_triggered(); }

  void on_actionEnglish_triggered();
  void on_actionFrench_triggered();
  void on_actionGerman_triggered();
  void on_actionUserManual_triggered() { Parent::on_actionUserManual_triggered(); }
  void on_actionAbout_triggered() { Parent::on_actionAbout_triggered(); }

  void onSignalSpeech(unsigned, int error, int probability, int percent);
  void onSignalContactAudioChanged(unsigned, SimAudioState newState);

private:
  Ui::SeedGen * ui;

  int m_err;
  unsigned m_type;
  int m_bits;
  bool m_started;

  QEvent * m_event;
  MouseEntropyCollector * m_collector;

  QString m_seed[2];
};

#endif
