QT += core gui widgets network

# dump all variables
#for(var, $$list($$enumerate_vars())) message($$var=$$eval($$var))

TARGET = qsimphone
TEMPLATE = app

TRANSLATIONS += translations/qsimphone_fr.ts translations/qsimphone_de.ts

SOURCES += main.cpp qtfix.cpp simcore.cpp sounds.cpp data.cpp qmodels.cpp \
           chatframe.cpp chatwindow.cpp contactinfo.cpp contacts.cpp settings.cpp transfers.cpp usermanual.cpp about.cpp \
           logindialog.cpp generate.cpp seedgen.cpp showseed.cpp login.cpp keygen.cpp consoledialog.cpp \
           ../qtsingleapplication/qtlocalpeer.cpp ../qtsingleapplication/qtsingleapplication.cpp

HEADERS += qtfix.h simcore.h sounds.h data.h qmodels.h \
           chatframe.h chatwindow.h contactinfo.h contacts.h settings.h transfers.h usermanual.h about.h \
           logindialog.h generate.h seedgen.h showseed.h login.h keygen.h consoledialog.h \
           ../qtsingleapplication/qtlockedfile.cpp ../qtsingleapplication/qtlockedfile_unix.cpp \
           ../qtsingleapplication/qtlockedfile_win.cpp ../qtsingleapplication/qtlocalpeer.h \
           ../qtsingleapplication/qtlockedfile.h ../qtsingleapplication/qtsingleapplication.h

FORMS += contacts.ui chatframe.ui chatwindow.ui contactinfo.ui settings.ui transfers.ui usermanual.ui about.ui \
         seedgen.ui login.ui generate.ui showseed.ui keygen.ui consoledialog.ui

RESOURCES += qsimphone.qrc icons.qrc flags.qrc
!CONFIG(noips): RESOURCES += ips.qrc

win32-g++ {
  QMAKE_CFLAGS_RELEASE += -g
  QMAKE_CXXFLAGS_RELEASE += -g
  QMAKE_CFLAGS_DEBUG += -Werror
  QMAKE_CXXFLAGS_DEBUG += -Werror
  QMAKE_LFLAGS = -g -L/usr/local/lib -L/usr/lib
  CONFIG(rlink) {
    QMAKE_LINK = python ../build/rlink/rlink.py $$QMAKE_LINK
    QMAKE_LINK_OBJECT_MAX = 100
  }
} else:!win32 {
  QMAKE_CFLAGS_RELEASE += -g
  QMAKE_CXXFLAGS_RELEASE += -g
  QMAKE_CFLAGS_DEBUG += -Werror
  QMAKE_CXXFLAGS_DEBUG += -Werror
  !isEmpty(SIMCFLAGS) {
    QMAKE_CFLAGS_RELEASE += $$SIMCFLAGS
    QMAKE_CXXFLAGS_RELEASE += $$SIMCFLAGS
    QMAKE_CFLAGS_DEBUG += $$SIMCFLAGS
    QMAKE_CXXFLAGS_DEBUG += $$SIMCFLAGS
  }
  macx-g++ {
    QT_CONFIG += c++11
    QMAKE_CXXFLAGS_CXX11 =
#    QMAKE_MAC_SDK = macosx
    !isEmpty(MACOSXSDK): QMAKE_MACOSX_DEPLOYMENT_TARGET = $$MACOSXSDK
    QMAKE_LFLAGS_STATIC_LIB -= -all_load
    QMAKE_LFLAGS = -g -dead_strip
  } else {
    QMAKE_LFLAGS += $$SIMLFLAGS
    !isEmpty(QMAKE_INCDIR_X11): QMAKE_CXXFLAGS += -I$$QMAKE_INCDIR_X11
    !isEmpty(QMAKE_LIBDIR_X11): QMAKE_LFLAGS += -L$$QMAKE_LIBDIR_X11
  }
#  QMAKE_LFLAGS += -L/usr/local/lib
}

!win32-g++ {
  CONFIG(debug) {
    qtPrepareTool(LRELEASE, lrelease)
    !exists($$LRELEASE): LRELEASE = lrelease
    system($$LRELEASE -version) {
      translations = $$files(translations/*.ts)
      lrelease.input = translations
      lrelease.output = resources/${QMAKE_FILE_BASE}.qm
      lrelease.commands = $$LRELEASE -nounfinished -removeidentical ${QMAKE_FILE_IN} -qm resources/${QMAKE_FILE_BASE}.qm
      lrelease.CONFIG += no_link target_predeps
      QMAKE_EXTRA_COMPILERS += lrelease
    }
  }
}

!macx-g++ {
  CONFIG(debug, release|debug): DEFINES += _DEBUG
  CONFIG(freebsd): QMAKE_RPATHDIR += $$QMAKE_DEFAULT_LIBDIRS
}

CORELIBS = ../simcore/simcore.a ../openssl/libssl.a ../openssl/libcrypto.a ../cryptopp/libcryptopp.a
!CONFIG(nominiupnpc): CORELIBS += ../miniupnpc/build/libminiupnpc.a
!CONFIG(noexpat): CORELIBS += ../expat/.libs/libexpat.a
!CONFIG(nocares): CORELIBS += ../cares/src/lib/.libs/libcares.a

!CONFIG(noaudio) {
  !CONFIG(nospeex) {
    CORELIBS += ../speex/libspeex/.libs/libspeex.a ../speexdsp/libspeexdsp/.libs/libspeexdsp.a
  }
  !CONFIG(noportaudio) {
    CORELIBS += ../portaudio/lib/.libs/libportaudio.a
    CONFIG(linux): CORELIBS += -lasound
    CONFIG(netbsd): CORELIBS += -lossaudio
  } else {
    CORELIBS += -lportaudio
  }
  !CONFIG(noudev) {
    CONFIG(linux): CORELIBS += ../udev/libudev/.libs/libudev.a
  }
}

win32-g++ {
  RC_FILE = qsimphone.rc
} else:win32 {
  RC_FILE = qsimphone.rc
  CORELIBS = ../simcore/simcore.lib user32.lib comdlg32.lib mpr.lib
} else:macx-g++ {
  ICON = icons/qsimphone.icns
  QMAKE_TARGET_BUNDLE_PREFIX = org
} else:!contains(QT_CONFIG, xcb-sm) {
  message("********************************************")
  message("*                                          *")
  message("*    WARNING: NO Qt SESSION MANAGEMENT!    *")
  message("*   SHUTDOWN/REBOOT WILL CAUSE DATA LOSS   *")
  message("*                                          *")
  message("********************************************")
  QMAKE_CXXFLAGS += -DSIM_QT_XCB_NO_SM
}

LIBS += $$CORELIBS

win32-g++ {
  !CONFIG(noaudio): LIBS += -lwinmm
  LIBS += -lgdi32 -lws2_32 -lole32 -loleaut32 -lshell32 -lshlwapi -liphlpapi -lcomdlg32 -lmpr
} else:macx-g++ {
  !CONFIG(noaudio): LIBS += -framework CoreAudio -framework AudioToolBox -framework AudioUnit
  LIBS += -framework Security -framework Carbon -framework IOKit
} else:!win32 {
  !CONFIG(openbsd): QT += dbus
}

QMAKE_CXXFLAGS += $$SIMDEFS
LIBS += $$SIMLIBS

contains(SIMLIBS, -lboundscheck) {
  QMAKE_CXXFLAGS_GNUCXX11 =
  QMAKE_CXXFLAGS_CXX11 =
}

QMAKE_RESOURCE_FLAGS += -compress 9
QMAKE_RESOURCE_FLAGS += -threshold 30
