/** Copyright (c) 2020-2023 The Creators of Simphone

    class Generate (LoginDialog): choose key size

    See the file COPYING.LESSER.txt for copying permission.
**/

#include "generate.h"
#include "ui_generate.h"

#include "qtfix.h"
#include "simcore.h"

Generate::Generate(QWidget * parent)
  : Parent(parent), ui(new Ui::Generate)
{
  ui->setupUi(this);
  ui->suffixLabel->setText(qtfix::fixColorString(ui->suffixLabel->text(), SimParam::getColorString(false)));
  prepareLanguage(ui->menuHelp, ui->actionEnglish, ui->actionFrench, ui->actionGerman);

  qtfix::fixPointSize(ui->generateButton, font().pointSize());
  qtfix::fixPointSize(ui->prefixLabel, font().pointSize());
  qtfix::fixPointSize(ui->suffixLabel, font().pointSize());
  qtfix::fixPointSize(ui->highRadio, font().pointSize());
  qtfix::fixPointSize(ui->higherRadio, font().pointSize());
  qtfix::fixPointSize(ui->highestRadio, font().pointSize());
  qtfix::fixRadioButtonIcon(ui->highRadio, font());
  qtfix::fixRadioButtonIcon(ui->higherRadio, font());
  qtfix::fixRadioButtonIcon(ui->highestRadio, font());
  qtfix::fixCheckBoxIcon(ui->seedlessBox, font());

  setWindowFlags(Qt::MSWindowsFixedSizeDialogHint);
  ui->highestRadio->setChecked(false);
  ui->higherRadio->setChecked(false);
  ui->highRadio->setChecked(false);
  switch (abs(SimParam::get("crypto.entropy"))) {
    case 256: ui->highestRadio->setChecked(true); break;
    case 192: ui->higherRadio->setChecked(true); break;
    default: ui->highRadio->setChecked(true);
  }
  ui->seedlessBox->setChecked(SimParam::get("crypto.entropy") < 0);
  sim_audio_hangup_(0);

  ui->label->setPixmap(QPixmap(":/welcome") /*.scaledToWidth(width() - 80, Qt::SmoothTransformation)*/);
  qtfix::fixMenuBar(ui->menubar, adjustToBiggerSize(), ui->verticalLayout);
}

Generate::~Generate()
{
  delete ui;
}

int Generate::setBits() const
{
  int bits = 0;
  if (ui->highRadio->isChecked()) {
    bits = 128;
  } else if (ui->higherRadio->isChecked()) {
    bits = 192;
  } else if (ui->highestRadio->isChecked()) {
    bits = 256;
  }

  SimParam::set("crypto.entropy", ui->seedlessBox->isChecked() ? -bits : bits, true);
  return bits;
}

void Generate::changeEvent(QEvent * event)
{
  switch (int(event->type())) {
    case QEvent::FontChange:
      setBits();
      break;

    case QEvent::PaletteChange:
      prepareLanguage(ui->menuHelp, ui->actionEnglish, ui->actionFrench, ui->actionGerman);
      break;

    case QEvent::LanguageChange:
      ui->retranslateUi(this);
      ui->label->setPixmap(QPixmap(":/welcome"));
  }
  Parent::changeEvent(event);
}

void Generate::on_generateButton_clicked()
{
  if (setBits()) accept();
}

void Generate::on_loginButton_clicked()
{
  setBits();
  done(2);
}

void Generate::on_actionEnglish_triggered()
{
  Parent::on_actionEnglish_triggered(ui->actionEnglish, ui->actionFrench, ui->actionGerman);
}

void Generate::on_actionFrench_triggered()
{
  Parent::on_actionFrench_triggered(ui->actionEnglish, ui->actionFrench, ui->actionGerman);
}

void Generate::on_actionGerman_triggered()
{
  Parent::on_actionGerman_triggered(ui->actionEnglish, ui->actionFrench, ui->actionGerman);
}
