/* Copyright (c) 2020-2023 The Creators of Simphone

   See the file COPYING.LESSER.txt for copying permission.
*/

#ifndef CONTACTINFO_H
#define CONTACTINFO_H

#include <QDialog>
#include <QTimer>

namespace Ui {
class ContactInfo;
}

class ContactInfo : public QDialog
{
  Q_OBJECT

  typedef QDialog Parent;

public:
  explicit ContactInfo(QWidget * parent, class Contact * contact);
  ~ContactInfo() Q_DECL_OVERRIDE;

  void copySelection();

  bool eventFilter(QObject * obj, QEvent * event) Q_DECL_OVERRIDE;
  void changeEvent(QEvent * event) Q_DECL_OVERRIDE;

private slots:
  void onSignalFontChanged();

  void on_okButton_clicked();

  void onItemDoubleClicked(const QModelIndex &);

  void onTimerTimeout();

  void onSignalLogout();

  void onRowClicked(const QModelIndex & index);
  void onRowDoubleClicked(const QModelIndex & index);

  void onCustomContextMenu(const QPoint & pos);

private:
  void setPalette() const;
  void setToolTip(int row, const QString & toolTip);
  void setInfo(int row, const QString & name, const QString & value, const QString & toolTip,
               const QString & pixmapName = QString());
  void setInfo(int row, const QString & name, const QString & value, const QString & toolTip, const QColor & color);

  static QString getFlagNames(int flag1, int flag2, const char * name, const char * name1, const char * name2);

  Ui::ContactInfo * ui;
  Contact * m_contact;

  QTimer m_timer;
  bool m_resize;

  int m_nickRow;
  int m_settingsRow;
  int m_statsRow;
  int m_lastRow;
};

#endif
