/* Copyright (c) 2020-2023 The Creators of Simphone

   See the file COPYING.LESSER.txt for copying permission.
*/

#ifndef CONSOLEDIALOG_H
#define CONSOLEDIALOG_H

#include "simcore.h"

#include <QElapsedTimer>

namespace Ui {
class ConsoleDialog;
}

class MouseEntropyCollector : public QObject
{
  Q_OBJECT

public:
  explicit MouseEntropyCollector(QWidget * parent = 0);

  void start();
  QByteArray stop();

  void clearEntropy();
  QByteArray getEntropy() const;
  void addEntropy(unsigned value);

public slots:
  void onTimerTimeout();

private:
  int m_posX, m_posY;
  int m_count;
  QTimer m_timer;
  QElapsedTimer m_elapsedTime;
  QByteArray m_entropy;
};

class ConsoleDialog : public QDialog
{
  Q_OBJECT

  typedef QDialog Parent;

public:
  explicit ConsoleDialog(QWidget * parent, bool collect);
  ~ConsoleDialog() Q_DECL_OVERRIDE;

public slots:
  void onSignalSpeech(unsigned, int, int probability, int);
  void onSignalContactAudioChanged(unsigned, SimAudioState newState);

private:
  bool checkKey(QKeyEvent * event);
  bool eventFilter(QObject * obj, QEvent * event) Q_DECL_OVERRIDE;
  void keyPressEvent(QKeyEvent *) Q_DECL_OVERRIDE;

  Ui::ConsoleDialog * ui;
  MouseEntropyCollector * m_collector;
};

#endif
