/** Copyright (c) 2020-2023 The Creators of Simphone

    class About (QDialog): display help-about window

    See the file COPYING.LESSER.txt for copying permission.
**/

#include "about.h"
#include "ui_about.h"

#include "qtfix.h"
#include "contacts.h"

About::About(QWidget * parent)
  : QDialog(parent), ui(new Ui::About)
{
  ui->setupUi(this);
  setAttribute(Qt::WA_DeleteOnClose);
  m_font = ui->label->font();
  onSignalFontChanged();

  simtype versions = sim_list_versions();
  simwalker ctxVersions;
  QString qs = "<center>" + ui->label->text() + "<br/>";

  if (sim_table_walk_first(&ctxVersions, versions)) {
    unsigned i = 0;
    simtype name;
    simtype version = sim_table_walk_next_string(&ctxVersions, &name);

    while (sim_get_pointer(name)) {
      if (++i == 4 || sim_table_count(versions) == i + 2) qs.append("<br/>");
      qs.append("<br/>");
      if (i == 1) qs.append("<b>");
      if (!strcmp(sim_get_pointer(name), SIM_VERSION_BAD)) {
        qs.append(qtfix::fixColorString("<span style=\" color:#ff0000;\">", SimParam::getColorString(false)));
      }
      if (sim_get_length(name) && *sim_get_pointer(name) != '_') {
        qs.append(sim_get_pointer(name)).append(tr(" version "));
      }
      qs.append(sim_get_pointer(version));
      if (!strcmp(sim_get_pointer(name), SIM_VERSION_BAD)) qs.append("</span>");
      if (i == 1) qs.append("</b>");
      version = sim_table_walk_next_string(&ctxVersions, &name);
    }
  }
  sim_list_free(versions);

  ui->label->setText(qs.append("<br/></center>"));
  adjustSize();

  connect(Contacts::get(), SIGNAL(signalFontChanged()), this, SLOT(onSignalFontChanged()));
}

About::~About()
{
  delete ui;
}

void About::onSignalFontChanged()
{
  ui->label->setFont(m_font);
  qtfix::fixPointSize(ui->label, font().pointSize());
}

void About::changeEvent(QEvent * event)
{
  if (event->type() == QEvent::FontChange && qApp->styleSheet().isEmpty()) onSignalFontChanged();
  Parent::changeEvent(event);
}
