#include "../../simcore/logger.h"
#include "../../simcore/error.h"
#include "../../simcore/table.h"

#define SIM_MODULE "audio"

#define OVERRIDE_SPEEX_FATAL
static inline void _speex_fatal(const char *str, const char *file, int line)
{
   LOG_FATAL_(SIM_OK, "SPEEX %s(%d): %s\n", file, line, str);
}

#define OVERRIDE_SPEEX_WARNING
static inline void speex_warning(const char *str)
{
   LOG_WARN_("SPEEX %s\n", str);
}

#define OVERRIDE_SPEEX_WARNING_INT
static inline void speex_warning_int(const char *str, int val)
{
   LOG_WARN_("SPEEX %s %d\n", str, val);
}

#define OVERRIDE_SPEEX_NOTIFY
static inline void speex_notify(const char *str)
{
   LOG_NOTE_("SPEEX %s\n", str);
}
