/* Copyright (c) 2020-2021 The Creators of Simphone

   See the file COPYING.LESSER.txt for copying permission.
*/

#ifndef LOGINDIALOG_H
#define LOGINDIALOG_H

#include <QCoreApplication>
#include <QDialog>

class LoginDialog : public QDialog
{
  Q_DECLARE_TR_FUNCTIONS(LoginDialog)

  typedef QDialog Parent;

public:
  explicit LoginDialog(QWidget * parent = 0);
  ~LoginDialog();

  void savePosition();
  void restorePosition();

  void adjustToBiggerSize();

  int exec() Q_DECL_OVERRIDE;

  void showEvent(QShowEvent * event) Q_DECL_OVERRIDE;
  void hideEvent(QHideEvent * event) Q_DECL_OVERRIDE;

  virtual bool checkKbd(QKeyEvent * event);
  bool eventFilter(QObject * obj, QEvent * event) Q_DECL_OVERRIDE;
  void keyPressEvent(QKeyEvent * event) Q_DECL_OVERRIDE;

  static void initLanguage(QAction * english, QAction * french, QAction * german);
  static void setLanguage(const QString & name, QAction * language0, QAction * language1, QAction * language2);

  static void on_actionEnglish_triggered(QAction * english, QAction * french, QAction * german);
  static void on_actionFrench_triggered(QAction * english, QAction * french, QAction * german);
  static void on_actionGerman_triggered(QAction * english, QAction * french, QAction * german);

public slots:
  void on_actionQuit_triggered();
  void on_actionConsole_triggered();
  void on_actionAudioDevices_triggered();
  void on_actionUserManual_triggered();
  void on_actionAbout_triggered();

protected:
  static int mc_modal;
};

#endif
