/*SIE-SVG without Plugin under LGPL2.1 & GPL2.0 & Mozilla Public Lisence
 *公式ページは http://sie.sourceforge.jp/
 */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Mozilla SVG Cairo Renderer project.
 *
 * The Initial Developer of the Original Code is IBM Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Parts of this file contain code derived from the following files(s)
 * of the Mozilla SVG project (these parts are Copyright (C) by their
 * respective copyright-holders):
 *    layout/svg/renderer/src/libart/nsSVGLibartBPathBuilder.cpp
 *
 * Contributor(s):DHRNAME revulo bellbind
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */
/*
 *Copyright (c) 2008-2010 Pivotal Labs

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

describe("SVG Spec in JavaScript", function() {
  /*Refer to W3C SVG1.1 (second edition)*/
  var doc, svg;
  beforeEach(function() {
    /*前もって実行しておく変数(The variable 'doc' is a document node, and the 'svg' is a root element node.)*/
    doc = DOMImplementation.createDocument("http://www.w3.org/2000/svg", "svg");
    svg = doc.documentElement;
  });
  describe("SVG Unit :: SVG Length", function() {
    var s;
    beforeEach(function() {
      s = svg.createSVGLength();
    });
    /*まずは、あるべきデフォルト値かどうかをチェックしていく(Checking the default value of a SVGLength interface.)*/
    it("for the default value on the property of SVGLength", function() {
      /*See http://www.w3.org/TR/SVG/struct.html#InterfaceSVGDocument
       * *createSVGLength()
       * *Creates an SVGLength object outside of any document trees. The object is initialized to the value of 0 user units.
       *see also http://www.w3.org/TR/SVG/types.html#InterfaceSVGLength
       * *SVG_LENGTHTYPE_NUMBER (unsigned short)
       * *No unit type was provided (i.e., a unitless value was specified), which indicates a value in user units.
       */
      expect(s.value).toBe(0);
      expect(s.valueInSpecifiedUnits).toBe(0);
      expect(s.unitType).toBe(1);
    });
    /*境界条件を調べておく (limit value analysis)*/
    it("should be this for the value, when it calls a newValueSpecifiedUnits method", function() {
      var t = [Number.MAX_VALUE, Number.MIN_VALUE, 0, Number.MAX_VALUE/2, -Number.MIN_VALUE];
      for (var i=0,tli=t.length;i<tli;++i) {
        s.newValueSpecifiedUnits(1, t[i]);
        expect(s.valueInSpecifiedUnits).toBe(t[i]);
        expect(s.value).toBe(t[i]);
        expect(s.valueAsString).toBe(t[i]+"");
        expect(s.unitType).toBe(1);
      }
      t = null;
    });
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value, when it calls a newValueSpecifiedUnits method", function() {
      var t = [Math.PI, 10/3], num = (t[0]+"").length - 1; //無理数を作って、ぎりぎりの有効数字の桁数numをはじき出しておく
      for (var i=1;i<num;++i) {
        t[t.length] = Math.pow(10, i);
        t[t.length] = Math.pow(10, -i);
        t[t.length] = Math.pow(10, i);
        t[t.length] = Math.pow(10, -i);
      }
      for (var i=0,tli=t.length;i<tli;++i) {
        s.newValueSpecifiedUnits(1, t[i]);
        expect(s.valueInSpecifiedUnits).toBe(t[i]);
        expect(s.value).toBe(t[i]);
        expect(s.valueAsString).toBe(t[i]+"");
        expect(s.unitType).toBe(1);
      }
      t = null;
    });
    /*同値分割をして、無効同値クラスを調べておく (equivalence partitioning, the following is the invalid partion)*/
    it("should throw a DOMException 'Not Supported Error', when it calls a newValueSpecifiedUnits method", function() {
      var t = [Number.NEGATIVE_INFINITY, Number.POSITIVE_INFINITY, Number.NaN, {}, [], "", "1", "-1", undefined, null, 0, -1, 11, 1.1, 10.1];
      for (var i=0,tli=t.length;i<tli;++i) {
        var ti = t[i], sn = function() {
          s.newValueSpecifiedUnits(ti, 0);
        };
        expect(sn).toThrow();
        ti = sn = null;
      }
      t = null;
    });
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value, when it calls a convertToSpecifiedUnits method", function() {
      var unit = ["", "%", "em", "ex", "px", "cm", "mm", "in", "pt", "pc"];
      for (var i=1,tli=11;i<tli;++i) {
        s.convertToSpecifiedUnits(i);
        expect(s.valueInSpecifiedUnits).toBe(0);
        expect(s.value).toBe(0);
        expect(s.valueAsString).toBe("0" + unit[i-1]);
        expect(s.unitType).toBe(i);
      }
      /*2cmにまず設定しておいて、その後、convertToSpecifiedUnitsメソッドで"mm"単位に変換する。
       * (The 's' value set to "2cm", and convert from "cm" to "mm" unit in convertToSpecifiedUnits method.
       */
      s.newValueSpecifiedUnits(6, 2);
      var sv = s.value;
      s.convertToSpecifiedUnits(7);
      expect(s.valueInSpecifiedUnits).toBe(20);
      expect(s.value).toBe(sv);
      expect(s.valueAsString).toBe("20mm");
      expect(s.unitType).toBe(7);
      unit = sv = null;
    });
    /*同値分割をして、無効同値クラスを調べておく (equivalence partitioning, the following is the invalid partion)*/
    it("should throw a DOMException 'Not Supported Error', when it calls a convertToSpecifiedUnits method", function() {
      var t = [Number.NEGATIVE_INFINITY, Number.POSITIVE_INFINITY, Number.NaN, {}, [], "", "1", "-1", undefined, null, 0, -1, 11, 1.1, 10.1];
      for (var i=0,tli=t.length;i<tli;++i) {
        var ti = t[i], sn = function() {
          s.convertToSpecifiedUnits(ti);
        };
        expect(sn).toThrow();
        ti = sn = null;
      }
      t = null;
    });
  });
  describe("SVG Unit :: SVG Matrix", function() {
    var s;
    beforeEach(function() {
      s = svg.createSVGMatrix();
    });
    it("for the default value on the property of SVGMatrix", function() {
      /*See http://www.w3.org/TR/SVG/struct.html#InterfaceSVGSVGElement
       * *The object is initialized to the identity matrix.
       *以下では、createSVGElementが単位行列を返しているかどうかをチェック
       */
      expect(s.a).toBe(1);
      expect(s.b).toBe(0);
      expect(s.c).toBe(0);
      expect(s.d).toBe(1);
      expect(s.e).toBe(0);
      expect(s.f).toBe(0);
    });
    /*境界条件を調べておく (limit value analysis about a 'multiply')*/
    it("should be this for the value, when it calls a 'multiply' method", function() {
      var t = [Number.MAX_VALUE, Number.MIN_VALUE, 0, Number.MAX_VALUE/2, Number.MIN_VALUE, 0];
      for (var i=0,tli=t.length;i<tli;++i) {
        var n = svg.createSVGMatrix();
        n.a = t[i];
        n.b = t[i];
        n.c = t[i];
        n.d = t[i];
        n.e = t[i];
        s.multiply(n);
        n = null;
      }
      t = null;
    });
    it("should return the SVGMatrix Object, when it calls a 'multiply' method", function() {
      var t = s.multiply(svg.createSVGMatrix());
      expect(t.a).toBe(1);
      expect(t.b).toBe(0);
      expect(t.c).toBe(0);
      expect(t.d).toBe(1);
      expect(t.e).toBe(0);
      expect(t.f).toBe(0);
      /*See http://www.w3.org/TR/SVG/coords.html#InterfaceSVGMatrix
       * *..returning the resulting new matrix.
       *以下では新しいSVGMatrixオブジェクトを返しているかどうかをチェック
       */
      expect(t).toNotBe(s);
      var u = svg.createSVGMatrix();
      t.a = u.a = 2;
      t.b = u.b = 2;
      t.c = u.c = 2;
      t.d = u.d = 2;
      t.e = u.e = 2;
      t.f = u.f = 2;
      var m = t.multiply(u);
      expect(m.a).toBe(8);
      expect(m.b).toBe(8);
      expect(m.c).toBe(8);
      expect(m.d).toBe(8);
      expect(m.e).toBe(10);
      expect(m.f).toBe(10);
    });
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value", function() {
      var t = [Math.PI, 10/3], num = (t[0]+"").length - 1; //無理数を作って、ぎりぎりの有効数字の桁数numをはじき出しておく
      for (var i=1;i<num;++i) {
        t[t.length] = Math.pow(10, i);
        t[t.length] = Math.pow(10, -i);
        t[t.length] = Math.pow(10, i);
        t[t.length] = Math.pow(10, -i);
      }
      for (var i=0,tli=t.length;i<tli;++i) {
        var n = svg.createSVGMatrix(), ti = t[i];
        n.a = ti;
        n.b = ti;
        n.c = ti;
        n.d = ti;
        n.e = ti;
        n.f = ti;
        var d = s.multiply(n);
        /*注:sが単位行列であることに注意すること (Note that the variable 's' is a identity matrix)*/
        expect(d.a).toBe(ti);
        expect(d.b).toBe(ti);
        expect(d.c).toBe(ti);
        expect(d.d).toBe(ti);
        expect(d.e).toBe(ti);
        expect(d.f).toBe(ti);
        n = d = null;
      }
      t = null;
    });
    /*同値分割をして、無効同値クラスを調べておく (equivalence partitioning, the following is the invalid partion)*/
    it("should throw an Error, when it calls a 'multiply' method", function() {
      var t = [Number.NEGATIVE_INFINITY,
               Number.POSITIVE_INFINITY,
               Number.NaN,
               undefined];
      for (var i=0,tli=t.length;i<tli;++i) {
        var ti = t[i], sn = function() {
          var n = svg.createSVGMatrix();
          n.a = 0;
          n.b = 0;
          n.c = 0;
          n.d = 0;
          n.e = 0;
          n.f = ti;
          s.multiply(n);
        };
        expect(sn).toThrow();
        ti = sn = null;
      }
      t = null;
    });
    /*逆行列に関する境界条件を調べておく (limit value analysis about a 'inverse')*/
    it("should be this for the value, when it calls a 'inverse' method ((limit value analysis)", function() {
      var si = s.inverse(), t = [s.multiply(si), si.multiply(s)];
      s.a = -1;
      si = s.inverse();
      t[t.length] = s.multiply(si);
      t[t.length] = si.multiply(s);
      s.a = 1;
      s.d = -1;
      si = s.inverse();
      t[t.length] = s.multiply(si);
      t[t.length] = si.multiply(s);
      s.b = -1;
      s.c = 1;
      s.d = 1;
      si = s.inverse();
      t[t.length] = s.multiply(si);
      t[t.length] = si.multiply(s);
      s.b = 1;
      s.c = -1;
      si = s.inverse();
      t[t.length] = s.multiply(si);
      t[t.length] = si.multiply(s);
      for (var i=0;i<t.length;++i) {
        var d = t[i];
        expect(d.a).toBe(1);
        expect(d.b).toBe(0);
        expect(d.c).toBe(0);
        expect(d.d).toBe(1);
        expect(d.e).toBe(0);
        expect(d.f).toBe(0);
        d = null;
      }
      si = t = null;
    });
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value, when it calls a 'inverse' method (Equivalence partitioning, the following is the valid partion)", function() {
      var si = s.inverse(), t = [];
      s.a = -1;
      s.e = 0;
      s.f = 1;
      si = s.inverse();
      t[t.length] = s.multiply(si);
      t[t.length] = si.multiply(s);
      s.a = 1;
      s.d = -1;
      s.e = 10000;
      s.f = -10000;
      si = s.inverse();
      t[t.length] = s.multiply(si);
      t[t.length] = si.multiply(s);
      s.b = -1;
      s.c = 1;
      s.d = 1;
      s.e = 0.0001;
      s.f = -0.0001;
      si = s.inverse();
      t[t.length] = s.multiply(si);
      t[t.length] = si.multiply(s);
      s.b = 1;
      s.c = -1;
      s.d = 1;
      s.e = 1;
      s.f = 1;
      si = s.inverse();
      t[t.length] = s.multiply(si);
      t[t.length] = si.multiply(s);
      for (var i=0;i<t.length;++i) {
        var d = t[i];
        expect(d.a).toBe(1);
        expect(d.b).toBe(0);
        expect(d.c).toBe(0);
        expect(d.d).toBe(1);
        expect(d.e).toBe(0);
        expect(d.f).toBe(0);
        d = null;
      }
      si = t = null;
    });
    it("should throw an Error, when it calls a 'inverse' method", function() {
      /*以下では行列式が0なので、逆行列が成り立たない (it is invalid　in these cases because the determint is zero)*/
      var t = [1, 1, 1, 1,
               0, 0, 0, 0,
               2, 4, 2, 4,
               2.5, -1, 2.5, -1];
      for (var i=0;i<t.length;i+=4) {
        s.a = t[i];
        s.b = t[i+1];
        s.c = t[i+2];
        s.d = t[i+3];
      };
      expect(s.inverse).toThrow();
      t = null;
    });
    /*併進変換に関する境界条件を調べておく (limit value analysis about the 'translate')*/
    it("should be this for the value, when it calls the 'translate' method", function() {
      var t = [0, 0,
               -1, 0,
               1, -1,
               Number.MAX_VALUE, Number.MIN_VALUE];
      for (var i=0;i<t.length;i+=2) {
        var d = s.translate(t[i], t[i+1]);
        expect(d.a).toBe(1);
        expect(d.b).toBe(0);
        expect(d.c).toBe(0);
        expect(d.d).toBe(1);
        expect(d.e).toBe(t[i]);
        expect(d.f).toBe(t[i+1]);
        expect(d).toNotBe(s);
      }
    });
    /*伸縮変換に関する境界条件を調べておく (limit value analysis about the 'scale')*/
    it("should be this for the value, when it calls the 'scale' method", function() {
      var t = [0,
               -1,
               1,
               Number.MAX_VALUE,
               Number.MIN_VALUE];
      for (var i=0;i<t.length;i+=2) {
        var d = s.scale(t[i]);
        expect(d.a).toBe(t[i]);
        expect(d.b).toBe(0);
        expect(d.c).toBe(0);
        expect(d.d).toBe(t[i]);
        expect(d.e).toBe(0);
        expect(d.f).toBe(0);
        expect(d).toNotBe(s);
      }
    });
    /*比率の違う伸縮変換に関する境界条件を調べておく (limit value analysis about the 'scaleNonUniform')*/
    it("should be this for the value, when it calls the 'scaleNonUniform' method", function() {
      var t = [0, 0,
               -1, 0,
               1, -1,
               Number.MAX_VALUE, Number.MIN_VALUE];
      for (var i=0;i<t.length;i+=2) {
        var d = s.scaleNonUniform(t[i], t[i+1]);
        expect(d.a).toBe(t[i]);
        expect(d.b).toBe(0);
        expect(d.c).toBe(0);
        expect(d.d).toBe(t[i+1]);
        expect(d.e).toBe(0);
        expect(d.f).toBe(0);
        expect(d).toNotBe(s);
      }
    });
    /*回転変換に関する境界条件を調べておく (limit value analysis about the 'rotate')*/
    it("should be this for the value, when it calls the 'rotate' method", function() {
      var t = [0,
               -1,
               1,
               Number.MAX_VALUE,
               Number.MIN_VALUE];
      for (var i=0;i<t.length;i+=2) {
        var d = s.rotate(t[i]);
        expect(d.a).toBe(Math.cos(t[i] / 180 * Math.PI));
        expect(d.b).toBe(Math.sin(t[i] / 180 * Math.PI));
        expect(d.c).toBe(-Math.sin(t[i] / 180 * Math.PI));
        expect(d.d).toBe(Math.cos(t[i] / 180 * Math.PI));
        expect(d.e).toBe(0);
        expect(d.f).toBe(0);
        expect(d).toNotBe(s);
      }
    });
    /*座標指定による回転変換に関する境界条件を調べておく (limit value analysis about the 'rotateFromVector')*/
    it("should be this for the value, when it calls the 'rotateFromVector'", function() {
      var t = [1, 1,
               -1, -1,
               1, -1,
               -1, 1,
               Number.MAX_VALUE, Number.MIN_VALUE];
      for (var i=0;i<t.length;i+=2) {
        var d = s.rotateFromVector(t[i], t[i+1]);
        expect(d.a).toBe(Math.cos(Math.atan2(t[i+1], t[i])));
        expect(d.b).toBe(Math.sin(Math.atan2(t[i+1], t[i])));
        expect(d.c).toBe(-Math.sin(Math.atan2(t[i+1], t[i])));
        expect(d.d).toBe(Math.cos(Math.atan2(t[i+1], t[i])));
        expect(d.e).toBe(0);
        expect(d.f).toBe(0);
        expect(d).toNotBe(s);
      }
    });
    /*座標指定による回転変換に関して同値分割をして、無効同値クラスを調べておく (equivalence partitioning, the following is the invalid partion)*/
    it("should throw an SVG Invalid Value Error, when it calls the 'rotateFromVector' method", function() {
      var t = [0,
               Number.NEGATIVE_INFINITY,
               Number.POSITIVE_INFINITY,
               Number.NaN,
               undefined];
      for (var i=0;i<t.length;++i) {
        var f = function() {
          var d = s.rotateFromVector(t[i], 1);
        };
        expect(f).toThrow();
        f = function() {
          var d = s.rotateFromVector(1, t[i]);
        };
        expect(f).toThrow();
      }
      t = f = null;
    });
    /*x軸によって向き合わせとなる変換に関する境界条件を調べておく (limit value analysis about the 'flipX')*/
    it("should be this for the value, when it calls the 'flipX' method", function() {
      var t = [0,
               -1,
               1,
               Number.MAX_VALUE,
               Number.MIN_VALUE];
      for (var i=0;i<t.length;++i) {
        s.a = t[i];
        s.d = t[i];
        var d = s.flipX();
        expect(d.a).toBe(-t[i]);
        expect(d.b).toBe(0);
        expect(d.c).toBe(0);
        expect(d.d).toBe(t[i]);
        expect(d.e).toBe(0);
        expect(d.f).toBe(0);
        expect(d).toNotBe(s);
      }
    });
    /*y軸によって向き合わせとなる変換に関する境界条件を調べておく (limit value analysis about the 'flipY')*/
    it("should be this for the value, when it calls the 'flipY' method", function() {
      var t = [0,
               -1,
               1,
               Number.MAX_VALUE,
               Number.MIN_VALUE];
      for (var i=0;i<t.length;++i) {
        s.a = t[i];
        s.d = t[i];
        var d = s.flipY();
        expect(d.a).toBe(t[i]);
        expect(d.b).toBe(0);
        expect(d.c).toBe(0);
        expect(d.d).toBe(-t[i]);
        expect(d.e).toBe(0);
        expect(d.f).toBe(0);
        expect(d).toNotBe(s);
      }
    });
    /*横の傾き変換に関する境界条件を調べておく (limit value analysis about the 'skewX')*/
    it("should be this for the value, when it calls the 'skewX' method", function() {
      var t = [0,
               -1,
               1,
               Number.MAX_VALUE,
               Number.MIN_VALUE];
      for (var i=0;i<t.length;i+=2) {
        var d = s.skewX(t[i]);
        expect(d.a).toBe(1);
        expect(d.b).toBe(0);
        expect(d.c).toBe(Math.tan(t[i] / 180 * Math.PI));
        expect(d.d).toBe(1);
        expect(d.e).toBe(0);
        expect(d.f).toBe(0);
        expect(d).toNotBe(s);
      }
    });
    /*縦の傾き変換に関する境界条件を調べておく (limit value analysis about the 'skewY')*/
    it("should be this for the value, when it calls the 'skewY' method", function() {
      var t = [0,
               -1,
               1,
               Number.MAX_VALUE,
               Number.MIN_VALUE];
      for (var i=0;i<t.length;i+=2) {
        var d = s.skewY(t[i]);
        expect(d.a).toBe(1);
        expect(d.b).toBe(Math.tan(t[i] / 180 * Math.PI));
        expect(d.c).toBe(0);
        expect(d.d).toBe(1);
        expect(d.e).toBe(0);
        expect(d.f).toBe(0);
        expect(d).toNotBe(s);
      }
    });
  });
  describe("SVG Unit :: SVG Transform", function() {
    var s;
    beforeEach(function() {
      s = svg.createSVGTransform();
    });
    it("for the default value on the property of SVGTransform", function() {
      /*5.11.2 Interface SVGSVGElement
       *http://www.w3.org/TR/SVG/struct.html#InterfaceSVGSVGElement
       *
       * *The object is initialized to an identity matrix transform (SVG_TRANSFORM_MATRIX).
       */
      expect(s.type).toBe(1); //SVG_TRANSFORM_MATRIX = 1
      expect(s.angle).toBe(0);
      var d = s.matrix;
      expect(d.a).toBe(1);
      expect(d.b).toBe(0);
      expect(d.c).toBe(0);
      expect(d.d).toBe(1);
      expect(d.e).toBe(0);
      expect(d.f).toBe(0);
      d = null;
    });
    /*境界条件を調べておく (limit value analysis about the 'setMatrix')*/
    it("should be this for the value, when it calls the 'setMatrix' method", function() {
      /*7.14.4 Interface SVGTransform
       *http://www.w3.org/TR/SVG/coords.html#InterfaceSVGTransform
       *
       * *void setMatrix(in SVGMatrix matrix)
       * *values from the parameter matrix are copied, the matrix parameter does not replace SVGTransform::matrix.
       */
      var m = svg.createSVGMatrix(), t = [0,
                                          -1,
                                          1,
                                          Number.MAX_VALUE,
                                          Number.MIN_VALUE,
                                          -Number.MIN_VALUE];
      for (var i=0;i<t.length;++i) {
        m.a = t[i];
        m.b = t[i];
        m.c = t[i];
        m.d = t[i];
        m.e = t[i];
        m.f = t[i];
        s.setMatrix(m);
        expect(s.type).toBe(1);
        expect(s.angle).toBe(0);
        var d = s.matrix;
        expect(d.a).toBe(m.a);
        expect(d.b).toBe(m.b);
        expect(d.c).toBe(m.c);
        expect(d.d).toBe(m.d);
        expect(d.e).toBe(m.e);
        expect(d.f).toBe(m.f);
        expect(d).toNotBe(m);
      }
      d = m = null;
    });
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value, when it calls a 'setMatrix' method", function() {
      var t = [Math.PI, 10/3], num = (t[0]+"").length - 1;
      for (var i=1;i<num;++i) {
        t[t.length] = Math.pow(10, i);
        t[t.length] = Math.pow(10, -i);
        t[t.length] = Math.pow(10, i);
        t[t.length] = Math.pow(10, -i);
      }
      for (var i=0,tli=t.length;i<tli;++i) {
        var n = svg.createSVGMatrix(), ti = t[i];
        n.a = ti;
        n.b = ti;
        n.c = ti;
        n.d = ti;
        n.e = ti;
        n.f = ti;
        s.setMatrix(n);
        s.setMatrix(n); //二重に指定しても問題はないはず (No problem is to call the 'setMatirx' method twice)
        expect(s.type).toBe(1);
        expect(s.angle).toBe(0);
        var d = s.matrix;
        /*注:sが単位行列であることに注意すること (Note that the variable 's' is a identity matrix)*/
        expect(d.a).toBe(ti);
        expect(d.b).toBe(ti);
        expect(d.c).toBe(ti);
        expect(d.d).toBe(ti);
        expect(d.e).toBe(ti);
        expect(d.f).toBe(ti);
        expect(d).toNotBe(n);
        n = d = null;
      }
      t = null;
    });
    /*境界条件を調べておく (limit value analysis about the 'setTranslate')*/
    it("should be this for the value, when it calls the 'setTranslate' method", function() {
      var t = [0,
               -1,
               1,
               Number.MAX_VALUE,
               Number.MIN_VALUE,
               -Number.MIN_VALUE];
      for (var i=0;i<t.length;++i) {
        s.setTranslate(t[i], t[i]);
        expect(s.type).toBe(2); //SVG_TRANSFORM_TRANSLATE = 2
        expect(s.angle).toBe(0);
        var d = s.matrix;
        expect(d.a).toBe(1);
        expect(d.b).toBe(0);
        expect(d.c).toBe(0);
        expect(d.d).toBe(1);
        expect(d.e).toBe(t[i]);
        expect(d.f).toBe(t[i]);
      }
      d = m = null;
    });
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value, when it calls a 'setTranslate' method", function() {
      var t = [Math.PI, 10/3], num = (t[0]+"").length - 1;
      for (var i=1;i<num;++i) {
        t[t.length] = Math.pow(10, i);
        t[t.length] = Math.pow(10, -i);
        t[t.length] = Math.pow(10, i);
        t[t.length] = Math.pow(10, -i);
      }
      for (var i=0,tli=t.length;i<tli;++i) {
        var ti = t[i];
        s.setTranslate(ti, ti);
        s.setTranslate(ti, ti);
        expect(s.type).toBe(2);
        expect(s.angle).toBe(0);
        var d = s.matrix;
        expect(d.a).toBe(1);
        expect(d.b).toBe(0);
        expect(d.c).toBe(0);
        expect(d.d).toBe(1);
        expect(d.e).toBe(ti);
        expect(d.f).toBe(ti);
        ti = n = d = null;
      }
      t = null;
    });
    /*境界条件を調べておく (limit value analysis about the 'setScale')*/
    it("should be this for the value, when it calls the 'setScale' method", function() {
      var t = [0,
               -1,
               1,
               Number.MAX_VALUE,
               Number.MIN_VALUE,
               -Number.MIN_VALUE];
      for (var i=0;i<t.length;++i) {
        s.setScale(t[i], t[i]);
        expect(s.type).toBe(3); //SVG_TRANSFORM_SCALE = 3
        expect(s.angle).toBe(0);
        var d = s.matrix;
        expect(d.a).toBe(t[i]);
        expect(d.b).toBe(0);
        expect(d.c).toBe(0);
        expect(d.d).toBe(t[i]);
        expect(d.e).toBe(0);
        expect(d.f).toBe(0);
      }
      d = null;
    });
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value, when it calls a 'setScale' method", function() {
      var t = [Math.PI, 10/3], num = (t[0]+"").length - 1;
      for (var i=1;i<num;++i) {
        t[t.length] = Math.pow(10, i);
        t[t.length] = Math.pow(10, -i);
        t[t.length] = Math.pow(10, i);
        t[t.length] = Math.pow(10, -i);
      }
      for (var i=0,tli=t.length;i<tli;++i) {
        var ti = t[i];
        s.setScale(ti, ti);
        s.setScale(ti, ti);
        expect(s.type).toBe(3);
        expect(s.angle).toBe(0);
        var d = s.matrix;
        expect(d.a).toBe(ti);
        expect(d.b).toBe(0);
        expect(d.c).toBe(0);
        expect(d.d).toBe(ti);
        expect(d.e).toBe(0);
        expect(d.f).toBe(0);
        ti = n = d = null;
      }
      t = null;
    });
    /*境界条件を調べておく (limit value analysis about the 'setRotate')*/
    it("should be this for the value, when it calls the 'setRotate' method", function() {
      var t = [0,
               -1,
               1];
      for (var i=0;i<t.length;++i) {
        s.setRotate(10, t[i], t[i]);
        var m = svg.createSVGMatrix();
        m = m.rotate(10);
        m.e = (1-m.a)*t[i] - m.c*t[i];
        m.f = -m.b*t[i] + (1-m.d)*t[i];
        expect(s.type).toBe(4); //SVG_TRANSFORM_ROTATE = 4
        expect(s.angle).toBe(10);
        var d = s.matrix;
        expect(d.a).toBe(m.a);
        expect(d.b).toBe(m.b);
        expect(d.c).toBe(m.c);
        expect(d.d).toBe(m.d);
        expect(d.e).toBe(m.e);
        expect(d.f).toBe(m.f);
      }
      d = m = null;
    });
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value, when it calls a 'setRotate' method", function() {
      var t = [Math.PI, 10/3], num = (t[0]+"").length - 1;
      for (var i=1;i<num;++i) {
        t[t.length] = Math.pow(10, i);
        t[t.length] = Math.pow(10, -i);
        t[t.length] = Math.pow(10, i);
        t[t.length] = Math.pow(10, -i);
      }
      for (var i=0,tli=t.length;i<tli;++i) {
        var ti = t[i], m = svg.createSVGMatrix();
        m = m.rotate(10);
        m.e = (1-m.a)*ti - m.c*ti;
        m.f = -m.b*ti + (1-m.d)*ti;
        s.setRotate(10, ti, ti);
        s.setRotate(10, ti, ti);
        expect(s.type).toBe(4);
        expect(s.angle).toBe(10);
        var d = s.matrix;
        expect(d.a).toBe(m.a);
        expect(d.b).toBe(m.b);
        expect(d.c).toBe(m.c);
        expect(d.d).toBe(m.d);
        expect(d.e).toBe(m.e);
        expect(d.f).toBe(m.f);
        ti = n = d = null;
      }
      t = null;
    });
    /*境界条件を調べておく (limit value analysis about the 'setSkewX')*/
    it("should be this for the value, when it calls the 'setSkewX' method", function() {
      var t = [0,
               -1,
               1,
               Number.MAX_VALUE,
               Number.MIN_VALUE,
               -Number.MIN_VALUE];
      for (var i=0;i<t.length;++i) {
        s.setSkewX(t[i]);
        var m = svg.createSVGMatrix();
        m = m.skewX(t[i]);
        expect(s.type).toBe(5); //SVG_TRANSFORM_SKEWX = 5
        expect(s.angle).toBe(t[i]);
        var d = s.matrix;
        expect(d.a).toBe(m.a);
        expect(d.b).toBe(m.b);
        expect(d.c).toBe(m.c);
        expect(d.d).toBe(m.d);
        expect(d.e).toBe(m.e);
        expect(d.f).toBe(m.f);
      }
      t = null;
    });
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value, when it calls a 'setSkewX' method", function() {
      var t = [Math.PI, 10/3], num = (t[0]+"").length - 1;
      for (var i=1;i<num;++i) {
        t[t.length] = Math.pow(10, i);
        t[t.length] = Math.pow(10, -i);
        t[t.length] = Math.pow(10, i);
        t[t.length] = Math.pow(10, -i);
      }
      for (var i=0,tli=t.length;i<tli;++i) {
        var ti = t[i], m = svg.createSVGMatrix();
        m = m.skewX(ti);
        s.setSkewX(ti);
        s.setSkewX(ti);
        expect(s.type).toBe(5);
        expect(s.angle).toBe(ti);
        var d = s.matrix;
        expect(d.a).toBe(m.a);
        expect(d.b).toBe(m.b);
        expect(d.c).toBe(m.c);
        expect(d.d).toBe(m.d);
        expect(d.e).toBe(m.e);
        expect(d.f).toBe(m.f);
        ti = n = d = null;
      }
      t = null;
    });
    /*境界条件を調べておく (limit value analysis about the 'setSkewY')*/
    it("should be this for the value, when it calls the 'setSkewY' method", function() {
      var t = [0,
               -1,
               1,
               Number.MAX_VALUE,
               Number.MIN_VALUE,
               -Number.MIN_VALUE];
      for (var i=0;i<t.length;++i) {
        s.setSkewY(t[i]);
        var m = svg.createSVGMatrix();
        m = m.skewY(t[i]);
        expect(s.type).toBe(6); //SVG_TRANSFORM_SKEWY = 6
        expect(s.angle).toBe(t[i]);
        var d = s.matrix;
        expect(d.a).toBe(m.a);
        expect(d.b).toBe(m.b);
        expect(d.c).toBe(m.c);
        expect(d.d).toBe(m.d);
        expect(d.e).toBe(m.e);
        expect(d.f).toBe(m.f);
      }
      t = null;
    });
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value, when it calls a 'setSkewY' method", function() {
      var t = [Math.PI, 10/3], num = (t[0]+"").length - 1;
      for (var i=1;i<num;++i) {
        t[t.length] = Math.pow(10, i);
        t[t.length] = Math.pow(10, -i);
        t[t.length] = Math.pow(10, i);
        t[t.length] = Math.pow(10, -i);
      }
      for (var i=0,tli=t.length;i<tli;++i) {
        var ti = t[i], m = svg.createSVGMatrix();
        m = m.skewY(ti);
        s.setSkewY(ti);
        s.setSkewY(ti);
        expect(s.type).toBe(6);
        expect(s.angle).toBe(ti);
        var d = s.matrix;
        expect(d.a).toBe(m.a);
        expect(d.b).toBe(m.b);
        expect(d.c).toBe(m.c);
        expect(d.d).toBe(m.d);
        expect(d.e).toBe(m.e);
        expect(d.f).toBe(m.f);
        ti = n = d = null;
      }
      t = null;
    });
  });
  describe("SVG Unit :: SVGNumber", function() {
    var s;
    beforeEach(function() {
      s = svg.createSVGNumber();
    });
    /*デフォルト値かどうかをチェックしていく(Checking the default value of a SVGNumber interface.)*/
    it("for the default value on the property of SVGNumber", function() {
      expect(s.value).toBe(0);
    });
  });
  describe("SVG Unit :: SVGAngle", function() {
    var s;
    beforeEach(function() {
      s = svg.createSVGAngle();
    });
    /*デフォルト値かどうかをチェックしていく(Checking the default value of a SVGNumber interface.)*/
    it("for the default value on the property of SVGAngle", function() {
      expect(s.value).toBe(0);
      expect(s.valueInSpecifiedUnits).toBe(0);
      expect(s.unitType).toBe(1);
    });
    /*境界条件を調べておく (limit value analysis)*/
    it("should be this for the value, when it calls a newValueSpecifiedUnits method (limit value analysis)", function() {
      var t = [Number.MAX_VALUE, Number.MIN_VALUE, 0, Number.MAX_VALUE/2, -Number.MIN_VALUE];
      for (var i=0,tli=t.length;i<tli;++i) {
        s.newValueSpecifiedUnits(1, t[i]);
        expect(s.valueInSpecifiedUnits).toBe(t[i]);
        expect(s.value).toBe(t[i]);
        expect(s.valueAsString).toBe(t[i]+"");
        expect(s.unitType).toBe(1);
      }
      t = null;
    });
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value, when it calls a newValueSpecifiedUnits method (the valid partion)", function() {
      var t = [Math.PI, 10/3], num = (t[0]+"").length - 1; //無理数を作って、ぎりぎりの有効数字の桁数numをはじき出しておく
      for (var i=1;i<num;++i) {
        t[t.length] = Math.pow(10, i);
        t[t.length] = Math.pow(10, -i);
        t[t.length] = Math.pow(10, i);
        t[t.length] = Math.pow(10, -i);
      }
      for (var i=0,tli=t.length;i<tli;++i) {
        s.newValueSpecifiedUnits(1, t[i]);
        expect(s.valueInSpecifiedUnits).toBe(t[i]);
        expect(s.value).toBe(t[i]);
        expect(s.valueAsString).toBe(t[i]+"");
        expect(s.unitType).toBe(1);
      }
      t = null;
    });
    /*同値分割をして、無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should throw a DOMException 'Not Supported Error', when it calls a newValueSpecifiedUnits method (the invalid partion)", function() {
      var t = [Number.NEGATIVE_INFINITY, Number.POSITIVE_INFINITY, Number.NaN, {}, [], "", "1", "-1", undefined, null, 0, -1, 11, 1.1, 10.1];
      for (var i=0,tli=t.length;i<tli;++i) {
        var ti = t[i],
            sn = function() {
              s.newValueSpecifiedUnits(ti, 0);
            };
        expect(sn).toThrow();
        ti = sn = null;
      }
      t = null;
    });
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value, when it calls a convertToSpecifiedUnits method (the valid partion)", function() {
      var unit = ["", "deg", "rad", "grad"];
      for (var i=1,tli=4;i<tli;++i) {
        s.convertToSpecifiedUnits(i);
        expect(s.valueInSpecifiedUnits).toBe(0);
        expect(s.value).toBe(0);
        expect(s.valueAsString).toBe("0" + unit[i-1]);
        expect(s.unitType).toBe(i);
      }
      /*2gradにまず設定しておいて、その後、convertToSpecifiedUnitsメソッドで"deg"単位に変換する。
       * (The 's' value set to "2cm", and convert from "cm" to "mm" unit in convertToSpecifiedUnits method.
       */
      s.newValueSpecifiedUnits(4, 2);
      var sv = s.value;
      s.convertToSpecifiedUnits(2);
      expect(s.valueInSpecifiedUnits).toBe(1.8);
      expect(s.value).toBe(sv);
      expect(s.valueAsString).toBe("1.8deg");
      expect(s.unitType).toBe(2);
      unit = sv = null;
    });
    /*同値分割をして、無効同値クラスを調べておく (equivalence partitioning, the following is the invalid partion)*/
    it("should throw a DOMException 'Not Supported Error', when it calls a convertToSpecifiedUnits method (the invalid partion)", function() {
      var t = [Number.NEGATIVE_INFINITY, Number.POSITIVE_INFINITY, Number.NaN, {}, [], "", "1", "-1", undefined, null, 0, -1, 11, 1.1, 10.1];
      for (var i=0,tli=t.length;i<tli;++i) {
        var ti = t[i], sn = function() {
          s.convertToSpecifiedUnits(ti);
        };
        expect(sn).toThrow();
        ti = sn = null;
      }
      t = null;
    });
  });
  describe("SVG Unit :: SVGColor (the SVGColor interface is deprecated by W3C)", function() {
    /*SVGColorインターフェースは廃止予定　(The SVGColor interface is deprecated by W3C.)*/
    var s;
    beforeEach(function() {
      svg.style.setProperty("stop-color", "white");
      s = svg.style.getPropertyCSSValue("stop-color"); //stop-colorプロパティはSVGColor型オブジェクトを返す
    });
    /*デフォルト値かどうかをチェックしていく(Checking the default value of the SVGColor interface.)*/
    it("for the default value on the property of SVGColor", function() {
      expect(s.rgbColor.red.getFloatValue(1)).toBe(255);
      expect(s.rgbColor.green.getFloatValue(1)).toBe(255);
      expect(s.rgbColor.blue.getFloatValue(1)).toBe(255);
      expect(s.colorType).toBe(1);
    });
    /*境界条件を調べておく (limit value analysis, when it calls a setRGBColor method)*/
    it("should be this for the value, when it calls a setRGBColor method (limit value analysis)", function() {
      var cls = ["black", "rgb(0, 0, 0)", "#000000", "#000", "rgb(0%, 0%, 0%)", "white", "rgb(255, 255, 255)", "#ffffff", "#fff", "rgb(100%, 100%, 100%)"];
      for (var i=0;i<5;++i) {
        /*すべて黒色を示す値  (All value indicate a black color)*/
        s.setRGBColor(cls[i]);
        expect(s.rgbColor.red.getFloatValue(1)).toBe(0);
        expect(s.rgbColor.green.getFloatValue(1)).toBe(0);
        expect(s.rgbColor.blue.getFloatValue(1)).toBe(0);
        expect(s.colorType).toBe(1);
      }
      for (var i=5;i<10;++i) {
        /*すべて白色を示す値  (All value indicate a white color)*/
        s.setRGBColor(cls[i]);
        expect(s.rgbColor.red.getFloatValue(1)).toBe(255);
        expect(s.rgbColor.green.getFloatValue(1)).toBe(255);
        expect(s.rgbColor.blue.getFloatValue(1)).toBe(255);
        expect(s.colorType).toBe(1);
      }
    });
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion, when it calls a setRGBColor method)*/
    it("should be this for the value, when it calls a setRGBColor method (the valid partion)", function() {
      var cls = ["gainsboro", "rgb(220, 220, 220)", "#dcdcdc", "magenta", "rgb(255, 0, 255)", "#ff00ff", "#f0f", "rgb(100%, 0%, 100%)"];
      for (var i=0;i<3;++i) {
        /*すべてgainsboro色を示す値  (All value indicate a gainsboro color)*/
        s.setRGBColor(cls[i]);
        expect(s.rgbColor.red.getFloatValue(1)).toBe(220);
        expect(s.rgbColor.green.getFloatValue(1)).toBe(220);
        expect(s.rgbColor.blue.getFloatValue(1)).toBe(220);
        expect(s.colorType).toBe(1);
      }
      for (var i=3;i<8;++i) {
        /*すべてgainsboro色を示す値  (All value indicate a gainsboro color)*/
        s.setRGBColor(cls[i]);
        expect(s.rgbColor.red.getFloatValue(1)).toBe(255);
        expect(s.rgbColor.green.getFloatValue(1)).toBe(0);
        expect(s.rgbColor.blue.getFloatValue(1)).toBe(255);
        expect(s.colorType).toBe(1);
      }
      s.setRGBColor("rgb(20%, 40%, 99%)");
      expect(s.rgbColor.red.getFloatValue(1)).toBe(51);
      expect(s.rgbColor.green.getFloatValue(1)).toBe(102);
      expect(s.rgbColor.blue.getFloatValue(1)).toBe(252);
      expect(s.colorType).toBe(1);
    });
    /*setRGBColorメソッドの同値分割をして、無効同値クラスを調べておく (equivalence partitioning, the following is the invalid partion)*/
    it("should throw a DOMException 'SVG_INVALID_VALUE_ERR', when it calls a setRGBColor method (the invalid partion)", function() {
      var t = [Number.NEGATIVE_INFINITY, Number.POSITIVE_INFINITY, Number.NaN, {}, [], "", "1", "-1", undefined, null, 0, -1, 11, 1.1, 10.1];
      for (var i=0,tli=t.length;i<tli;++i) {
        var ti = t[i], sn = function() {
          s.setRGBColor(ti);
        };
        expect(sn).toThrow();
        ti = sn = null;
      }
      t = null;
    });
    /*setColorメソッドの境界条件を調べておく (limit value analysis, when it calls a setColor method)*/
    it("should be this for the value, when it calls a setColor method (limit value analysis)", function() {
      var cls = ["black", "rgb(0, 0, 0)", "#000000", "#000", "rgb(0%, 0%, 0%)", "white", "rgb(255, 255, 255)", "#ffffff", "#fff", "rgb(100%, 100%, 100%)"];
      for (var i=0;i<5;++i) {
        /*すべて黒色を示す値  (All value indicate a black color)*/
        s.setColor(/*SVG_COLORTYPE_RGBCOLOR*/ 1, cls[i], null);
        expect(s.rgbColor.red.getFloatValue(1)).toBe(0);
        expect(s.rgbColor.green.getFloatValue(1)).toBe(0);
        expect(s.rgbColor.blue.getFloatValue(1)).toBe(0);
        expect(s.colorType).toBe(1);
      }
      for (var i=5;i<10;++i) {
        /*すべて白色を示す値  (All value indicate a white color)*/
        s.setColor(/*SVG_COLORTYPE_RGBCOLOR*/ 1, cls[i], null);
        expect(s.rgbColor.red.getFloatValue(1)).toBe(255);
        expect(s.rgbColor.green.getFloatValue(1)).toBe(255);
        expect(s.rgbColor.blue.getFloatValue(1)).toBe(255);
        expect(s.colorType).toBe(1);
      }
      s.setColor(/*SVG_COLORTYPE_CURRENTCOLOR*/ 3, null, null);
      expect(s.colorType).toBe(3);
    });
    /*setColorメソッドの同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion, when it calls a setColor method)*/
    it("should be this for the value, when it calls a setColor method (the valid partion)", function() {
      var cls = ["gainsboro", "rgb(220, 220, 220)", "#dcdcdc", "magenta", "rgb(255, 0, 255)", "#ff00ff", "#f0f", "rgb(100%, 0%, 100%)"];
      for (var i=0;i<3;++i) {
        /*すべてgainsboro色を示す値  (All value indicate a gainsboro color)*/
        s.setColor(/*SVG_COLORTYPE_RGBCOLOR*/ 1, cls[i], null);
        expect(s.rgbColor.red.getFloatValue(1)).toBe(220);
        expect(s.rgbColor.green.getFloatValue(1)).toBe(220);
        expect(s.rgbColor.blue.getFloatValue(1)).toBe(220);
        expect(s.colorType).toBe(1);
      }
      for (var i=3;i<8;++i) {
        /*すべてgainsboro色を示す値  (All value indicate a gainsboro color)*/
        s.setColor(/*SVG_COLORTYPE_RGBCOLOR*/ 1, cls[i], null);
        expect(s.rgbColor.red.getFloatValue(1)).toBe(255);
        expect(s.rgbColor.green.getFloatValue(1)).toBe(0);
        expect(s.rgbColor.blue.getFloatValue(1)).toBe(255);
        expect(s.colorType).toBe(1);
      }
      s.setColor(/*SVG_COLORTYPE_RGBCOLOR*/ 1, "rgb(20%, 40%, 99%)", null);
      expect(s.rgbColor.red.getFloatValue(1)).toBe(51);
      expect(s.rgbColor.green.getFloatValue(1)).toBe(102);
      expect(s.rgbColor.blue.getFloatValue(1)).toBe(252);
      expect(s.colorType).toBe(1);
    });
    /*setColorメソッドの同値分割をして、無効同値クラスを調べておく (equivalence partitioning, the following is the invalid partion)*/
    it("should throw a DOMException 'SVG_INVALID_VALUE_ERR', when it calls a setColor method (the invalid partion)", function() {
      var t = [Number.NEGATIVE_INFINITY, Number.POSITIVE_INFINITY, Number.NaN, {}, [], "", "1", "-1", undefined, null, 0, -1, 11, 1.1, 10.1];
      var cls = ["gainsboro", "rgb(220, 220, 220)", "#dcdcdc", "magenta", "rgb(255, 0, 255)", "#ff00ff", "#f0f", "rgb(100%, 0%, 100%)"];
      for (var i=0,tli=t.length;i<tli;++i) {
        var ti = t[i], sn = function() {
          s.setColor(/*SVG_COLORTYPE_RGBCOLOR*/ 1, ti, null);
        };
        expect(sn).toThrow();
        ti = sn = null;
      }
      for (var i=0,tli=cls.length;i<tli;++i) {
        var ci = cls[i], sn = function() {
          s.setColor(/*SVG_COLORTYPE_RGBCOLOR*/ 1, ci, ci);
        };
        expect(sn).toThrow();
        ci = sn = null;
      }
      for (var i=0,tli=cls.length;i<tli;++i) {
        var ci = cls[i], sn = function() {
          s.setColor(/*SVG_COLORTYPE_RGBCOLOR*/ 1, null, ci);
        };
        expect(sn).toThrow();
        ci = sn = null;
      }
      for (var i=0,tli=t.length,ci=cls[0];i<tli;++i) {
        var ti = t[i], sn = function() {
          s.setColor(/*SVGColor.SVG_COLORTYPE_RGBCOLOR_ICCCOLOR*/ 2, null, ti);
          s.setColor(/*SVGColor.SVG_COLORTYPE_RGBCOLOR_ICCCOLOR*/ 2, ci, ti);
        };
        expect(sn).toThrow();
        ti = sn = null;
      }
      for (var i=0,tli=cls.length;i<tli;++i) {
        var ci = cls[i], sn = function() {
          s.setColor(/*SVGColor.SVG_COLORTYPE_UNKNOWN*/ 0, ci, null);
          s.setColor(/*SVGColor.SVG_COLORTYPE_UNKNOWN*/ 0, ci, ci);
        };
        expect(sn).toThrow();
        ci = sn = null;
      }
      t = cls = null;
    });
  });
  describe("SVG Unit :: SVG Point", function() {
    /*http://www.w3.org/TR/SVG/coords.html#InterfaceSVGPoint
     * 7.15.1 Interface SVGPoint
     *  An SVGPoint is an (x, y) coordinate pair.
     */
    var s;
    beforeEach(function() {
      s = svg.createSVGPoint();
    });
    it("for the default value on the property of SVGPoint", function() {
      /*http://www.w3.org/TR/SVG/struct.html#InterfaceSVGSVGElement
       * SVGPoint createSVGPoint()
       * 'The object is initialized to the point (0,0) in the user coordinate system.'
       */
      expect(s.x).toBe(0);
      expect(s.y).toBe(0);
    });
    /*境界条件を調べておく (limit value analysis, when it calls a matrixTransform method)*/
    it("should be this for the value, when it calls a matrixTransform method (limit value analysis)", function() {
      var matrix = svg.createSVGMatrix(), t = [0,
                                               -1,
                                               1,
                                               Number.MAX_VALUE,
                                               Number.MIN_VALUE,
                                               -Number.MIN_VALUE],
          n;
      for (var i=0;i<t.length;++i) {
        matrix.a = t[i];
        matrix.c = t[i];
        n = s.matrixTransform(matrix);
        expect(n.x).toBe(0);
        expect(n.y).toBe(0);
      }
      for (var i=0;i<t.length;++i) {
        matrix.e = t[i];
        matrix.f = t[i];
        n = s.matrixTransform(matrix);
        expect(n.x).toBe(t[i]);
        expect(n.y).toBe(t[i]);
      }
    });
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value, when it calls a matrixTransform method (the valid partion)", function() {
      var matrix = svg.createSVGMatrix(),
          t = [Math.PI, 10/3], num = (t[0]+"").length - 1; //無理数を作って、ぎりぎりの有効数字の桁数numをはじき出しておく
      for (var i=1;i<num;++i) {
        t[t.length] = Math.pow(10, i);
        t[t.length] = Math.pow(10, -i);
        t[t.length] = Math.pow(10, i);
        t[t.length] = Math.pow(10, -i);
      }
      for (var i=0,tli=t.length;i<tli;++i) {
        matrix.a = t[i];
        matrix.c = t[i];
        n = s.matrixTransform(matrix);
        expect(n.x).toBe(0);
        expect(n.y).toBe(0);
      }
      for (var i=0;i<t.length;++i) {
        matrix.e = t[i];
        matrix.f = t[i];
        n = s.matrixTransform(matrix);
        expect(n.x).toBe(t[i]);
        expect(n.y).toBe(t[i]);
      }
    });
    /*同値分割をして、無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should throw a Error, when it calls a matrixTransform method (the invalid partion)", function() {
      var matrix = svg.createSVGMatrix(),
          t = [Number.NEGATIVE_INFINITY, Number.POSITIVE_INFINITY, Number.NaN, {}];
      for (var i=0,tli=t.length;i<tli;++i) {
        var ti = t[i],
            sn = function() {
              s.matrixTransform(ti);
            },
            stn = function() {
              s.matrixTransform();
            },
            an = function() {
              matrix.a = ti;
              s.matrixTransform(matrix);
            },
            bn = function() {
              matrix.a = 0;
              matrix.b = ti;
              s.matrixTransform(matrix);
            },
            cn = function() {
              matrix.b = 0;
              matrix.c = ti;
              s.matrixTransform(matrix);
            },
            dn = function() {
              matrix.c = 0;
              matrix.d = ti;
              s.matrixTransform(matrix);
            },
            en = function() {
              matrix.d = 0;
              matrix.e = ti;
              s.matrixTransform(matrix);
            },
            fn = function() {
              matrix.e = 0;
              matrix.f = ti;
              s.matrixTransform(matrix);
            };
        expect(sn).toThrow();
        expect(stn).toThrow();
        expect(an).toThrow();
        expect(bn).toThrow();
        expect(cn).toThrow();
        expect(dn).toThrow();
        expect(en).toThrow();
        expect(fn).toThrow();
        ti = sn = an = bn = cn = dn = en = fn = null;
      }
    });
  });
  describe("SVG Element :: SVG TextContent Element", function() {
    var s;
    beforeEach(function() {
      s = doc.createElementNS("http://www.w3.org/2000/svg", "text");
    });
    /*まずは、あるべきデフォルト値かどうかをチェックしていく(Checking the default value of a SVGTextContentElement interface.)*/
    it("for the default value on the property of SVGTextContentElement", function() {
      expect(s.getAttributeNS(null, "textLength")).toBeNull();
      expect(s.getNumberOfChars()).toBe(0);
    });
    /*境界条件を調べておく (limit value analysis)*/
    it("should be this for the value(limit value analysis)", function() {
      var t = [0,
               1,
               100],
          str = "";
      for (var i=0;i<t.length;++i) {
        /*文字列の生成 (created a string for the test)*/
        for (var j=0, ti=t[i];j<ti;++j) {
          str += "nん曖昧模糊@";
        }
        s.appendChild(s.ownerDocument.createTextNode(str));
        expect(s.getNumberOfChars()).toBe(s.firstChild.length);
        s.removeChild(s.firstChild);
        s.appendChild(s.ownerDocument.createElementNS("http://sie.sourceforge.jp", "hoge"))
         .appendChild(s.ownerDocument.createTextNode(str));
        expect(s.getNumberOfChars()).toBe(s.firstChild.firstChild.length);
        s.removeChild(s.firstChild);
        s.appendChild(s.ownerDocument.createElementNS("http://www.w3.org/svg/2000", "a"))
         .appendChild(s.ownerDocument.createElementNS("http://www.w3.org/svg/2000", "tspan"))
         .appendChild(s.ownerDocument.createTextNode(str));
        expect(s.getNumberOfChars()).toBe(str.length);
        s.firstChild.appendChild(s.ownerDocument.createTextNode(str));
        expect(s.getNumberOfChars()).toBe(str.length*2);
        s.removeChild(s.firstChild);
        str = "";
      }
    });
    it("a getStartPositionOfChar method", function() {
      expect(function(){
        s.getStartPositionOfChar(1);
      }).toThrow();
      var str = "hoge",
          doc = s.ownerDocument;
      doc.documentElement.appendChild(s);
      s.setAttributeNS(null, "font-size", "20");
      s.appendChild(doc.createTextNode(str));
      expect(s.getStartPositionOfChar(0).x).toBe(0);
      expect(s.getStartPositionOfChar(1).x).toBe(11);

      s.insertBefore(doc.createElementNS("http://www.w3.org/2000/svg", "a"), s.firstChild);
      s.firstChild.appendChild(doc.createTextNode(str));
      expect(s.getStartPositionOfChar(1).x).toBe(11);

      /*a要素の前にテキストノードがない場合*/
      s.insertBefore(doc.createElementNS("http://www.w3.org/2000/svg", "a"), s.firstChild);
      var a = s.firstChild;
      a.appendChild(doc.createElementNS("http://www.w3.org/2000/svg", "tspan"));
      a.firstChild.appendChild(doc.createTextNode(str+str));
      expect(s.getStartPositionOfChar(1).x).toBe(11);
      expect(s.getStartPositionOfChar(5).x).toBe(55);

      /*a要素の前にテキストノードがある場合*/
      s.insertBefore(doc.createElementNS("http://www.w3.org/2000/svg", "a"), s.firstChild);
      var a = s.firstChild;
      a.appendChild(doc.createTextNode(str));
      a.appendChild(doc.createElementNS("http://www.w3.org/2000/svg", "tspan"));
      a.lastChild.appendChild(doc.createTextNode(str));
      expect(s.getStartPositionOfChar(1).x).toBe(11);
      expect(s.getStartPositionOfChar(5).x).toBe(55);
    });
  });
  describe("DOM level 2 Core :: Node", function() {
    var s, t;
    beforeEach(function() {
      s = doc.createElementNS("http://www.w3.org/2000/svg", "text");
      t = doc.createElementNS("http://sie.sourceforge.jp/", "hoge");
    });
    /*まずは、あるべきデフォルト値かどうかをチェックしていく(Checking the default value of a Node interface.)*/
    it("for the default value on the property of Node", function() {
      expect(s.firstChild).toBeNull();
      expect(s.lastChild).toBeNull();
      expect(s.nextSibling).toBeNull();
      expect(s.previousSibling).toBeNull();
      expect(s.parentNode).toBeNull();
    });
    /*insertBeforeメソッドの境界条件を調べておく (limit value analysis, when it calls a insertBefore method)*/
    it("should be this for the value, when it calls a insertBefore method (limit value analysis)", function() {
      s.insertBefore(t, null);
      expect(s.firstChild).toBe(t);
      expect(s.lastChild).toBe(t);
      expect(s.childNodes.item(0)).toBe(t);
      expect(s.nextSibling).toBeNull();
      expect(s.previousSibling).toBeNull();
      expect(s.parentNode).toBeNull();
      expect(t.parentNode).toBe(s);
      expect(t.nextSibling).toBeNull();
      expect(t.previousSibling).toBeNull();
      expect(t.firstChild).toBeNull();
      expect(t.lastChild).toBeNull();

      var u = doc.createElementNS("http://sie.sourceforge.jp/", "ho");
      s.insertBefore(u, null);
      s.insertBefore(t, u);
      expect(s.firstChild).toBe(t);
      expect(s.lastChild).toBe(u);
      expect(s.childNodes.item(0)).toBe(t);
      expect(s.childNodes.item(1)).toBe(u);
      expect(s.nextSibling).toBeNull();
      expect(s.previousSibling).toBeNull();
      expect(s.parentNode).toBeNull();
      expect(t.parentNode).toBe(s);
      expect(t.nextSibling).toBe(u);
      expect(t.previousSibling).toBeNull();
      expect(t.firstChild).toBeNull();
      expect(t.lastChild).toBeNull();

      u.insertBefore(t, null);
      expect(s.firstChild).toBe(u);
      expect(s.lastChild).toBe(u);
      expect(s.childNodes.item(0)).toBe(u);
      expect(s.nextSibling).toBeNull();
      expect(s.previousSibling).toBeNull();
      expect(s.parentNode).toBeNull();
      expect(u.firstChild).toBe(t);
      expect(u.lastChild).toBe(t);
      expect(u.childNodes.item(0)).toBe(t);
      expect(u.nextSibling).toBeNull();
      expect(u.previousSibling).toBeNull();
      expect(u.parentNode).toBe(s);
      expect(t.parentNode).toBe(u);
      expect(t.nextSibling).toBeNull();
      expect(t.previousSibling).toBeNull();
      expect(t.firstChild).toBeNull();
      expect(t.lastChild).toBeNull();
      u = void 0;
    });
    /*appendChildメソッドの境界条件を調べておく (limit value analysis, when it calls a appendChild method)*/
    it("should be this for the value, when it calls a appendChild method (limit value analysis)", function() {
      s.appendChild(t);
      expect(s.firstChild).toBe(t);
      expect(s.lastChild).toBe(t);
      expect(s.childNodes.item(0)).toBe(t);
      expect(s.nextSibling).toBeNull();
      expect(s.previousSibling).toBeNull();
      expect(s.parentNode).toBeNull();
      expect(t.parentNode).toBe(s);
      expect(t.nextSibling).toBeNull();
      expect(t.previousSibling).toBeNull();
      expect(t.firstChild).toBeNull();
      expect(t.lastChild).toBeNull();
    });
    /*removeChildメソッドの境界条件を調べておく (limit value analysis, when it calls a removeChild method)*/
    it("should be this for the value, when it calls a removeChild method (limit value analysis)", function() {
      s.insertBefore(t, null);
      s.removeChild(t);
      expect(s.firstChild).toBeNull();
      expect(s.lastChild).toBeNull();
      expect(s.childNodes.item(0)).toBeNull();
      expect(s.nextSibling).toBeNull();
      expect(s.previousSibling).toBeNull();
      expect(s.parentNode).toBeNull();
      expect(t.parentNode).toBeNull();
      expect(t.nextSibling).toBeNull();
      expect(t.previousSibling).toBeNull();
      expect(t.firstChild).toBeNull();
      expect(t.lastChild).toBeNull();
    });
    /*replaceChildメソッドの境界条件を調べておく (limit value analysis, when it calls a replaceChild method)*/
    it("should be this for the value, when it calls a replaceChild method (limit value analysis)", function() {
      var u = doc.createElementNS("http://sie.sourceforge.jp/", "ho");
      s.insertBefore(t, null);
      s.replaceChild(u, t);
      expect(s.firstChild).toBe(u);
      expect(s.lastChild).toBe(u);
      expect(s.childNodes.item(0)).toBe(u);
      expect(s.nextSibling).toBeNull();
      expect(s.previousSibling).toBeNull();
      expect(s.parentNode).toBeNull();
      expect(u.parentNode).toBe(s);
      expect(u.nextSibling).toBeNull();
      expect(u.previousSibling).toBeNull();
      expect(u.firstChild).toBeNull();
      expect(u.lastChild).toBeNull();
      expect(t.parentNode).toBeNull();
      expect(t.nextSibling).toBeNull();
      expect(t.previousSibling).toBeNull();
      expect(t.firstChild).toBeNull();
      expect(t.lastChild).toBeNull();
    });
    /*hasChildNodesメソッドの境界条件を調べておく (limit value analysis, when it calls a hasChildNodes method)*/
    it("should be this for the value, when it calls a hasChildNodes method (limit value analysis)", function() {
      expect(s.hasChildNodes()).toBe(false);
      s.appendChild(t);
      expect(s.hasChildNodes()).toBe(true);
      s.removeChild(t);
      expect(s.hasChildNodes()).toBe(false);
    });
    /*cloneNodeメソッドの境界条件を調べておく (limit value analysis, when it calls a cloneNode method)*/
    it("should be this for the value, when it calls a cloneNode method (limit value analysis)", function() {
      s.appendChild(t);
      var u = s.cloneNode(false),
          v = s.cloneNode(true);
      expect(u).toNotBe(s);
      expect(u.firstChild).toBeNull();
      expect(u.lastChild).toBeNull();
      expect(u.childNodes.item(0)).toBeNull();
      expect(u.nextSibling).toBeNull();
      expect(u.previousSibling).toBeNull();
      expect(u.parentNode).toBeNull();
      expect(v).toNotBe(s);
      expect(v.hasChildNodes()).toBe(true);
      expect(v.firstChild.parentNode).toBe(v);
      expect(v.lastChild.parentNode).toBe(v);
      expect(v.childNodes.item(0).parentNode).toBe(v);
      expect(v.nextSibling).toBeNull();
      expect(v.previousSibling).toBeNull();
      expect(v.parentNode).toBeNull();
    });
    /*normalizeメソッドの境界条件を調べておく (limit value analysis, when it calls a normalize method)*/
    it("should be this for the value, when it calls a normalize method (limit value analysis)", function() {
      var text, ttext,
          tle = [doc.createTextNode(""), doc.createTextNode("0"), doc.createTextNode("a")];
      s.normalize();
      expect(s.firstChild).toBeNull();
      expect(s.lastChild).toBeNull();
      s.appendChild(tle[0]);
      s.normalize();
      expect(s.firstChild).toNotBe(null);
      expect(s.lastChild).toNotBe(null);
      expect(s.firstChild.nodeValue).toBe("");
      for (var i=0; i<tle.legnth-1; ++i) {
        text = tle[i],
        ttext = tle[i+1];
        s.appendChild(text);
        s.appendChild(ttext);
        expect(s.firstChild).toBe(text);
        expect(s.lastChild).toBe(ttext);
        s.norbalize();
        expect(s.firstChild.nodeValue).toBe(text.nodeValue+ttext.nodeValue);
        expect(s.firstChild).toNotBe(text);
        expect(s.lastChild).toNotBe(ttext);
      }
    });
    /*hasAttributesメソッドの境界条件を調べておく (limit value analysis, when it calls a hasAttributes method)*/
    it("should be this for the value, when it calls a hasAttributes method (limit value analysis)", function() {
      expect(s.hasAttributes()).toBe(false);
      s.setAttributeNS(null, "a", "b");
      expect(s.hasAttributes()).toBe(true);
      expect(t.hasAttributes()).toBe(false);
      t.setAttributeNS(null, "c", "d");
      expect(t.hasAttributes()).toBe(true);
    });

    /*insertBeforeメソッドの同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value, when it calls a insertBefore method (the valid partion)", function() {
      var ti = [10, 500, 1000];
      for (var i=0;i<ti.length;++i) {
        for (var j=0,tili=ti[i];j<tili;++j) {
          s.insertBefore(t, null);
        }
      }
      expect(s.firstChild).toBe(t);
      expect(s.lastChild).toBe(t);
      expect(s.childNodes.item(0)).toBe(t);
      expect(s.nextSibling).toBeNull();
      expect(s.previousSibling).toBeNull();
      expect(s.parentNode).toBeNull();
      expect(t.parentNode).toBe(s);
      expect(t.nextSibling).toBeNull();
      expect(t.previousSibling).toBeNull();
      expect(t.firstChild).toBeNull();
      expect(t.lastChild).toBeNull();

      var u = doc.createElementNS("http://sie.sourceforge.jp/", "ho");
      s.insertBefore(u, null);
      for (var i=0;i<ti.length;++i) {
        for (var j=0,tili=ti[i];j<tili;++j) {
          s.insertBefore(t, u);
        }
      }
      expect(s.firstChild).toBe(t);
      expect(s.lastChild).toBe(u);
      expect(s.childNodes.item(0)).toBe(t);
      expect(s.childNodes.item(1)).toBe(u);
      expect(s.nextSibling).toBeNull();
      expect(s.previousSibling).toBeNull();
      expect(s.parentNode).toBeNull();
      expect(t.parentNode).toBe(s);
      expect(t.nextSibling).toBe(u);
      expect(t.previousSibling).toBeNull();
      expect(t.firstChild).toBeNull();
      expect(t.lastChild).toBeNull();

      for (var i=0;i<ti.length;++i) {
        for (var j=0,tili=ti[i];j<tili;++j) {
          u.insertBefore(t, null);
        }
      }
      expect(s.firstChild).toBe(u);
      expect(s.lastChild).toBe(u);
      expect(s.childNodes.item(0)).toBe(u);
      expect(s.nextSibling).toBeNull();
      expect(s.previousSibling).toBeNull();
      expect(s.parentNode).toBeNull();
      expect(u.firstChild).toBe(t);
      expect(u.lastChild).toBe(t);
      expect(u.childNodes.item(0)).toBe(t);
      expect(u.nextSibling).toBeNull();
      expect(u.previousSibling).toBeNull();
      expect(u.parentNode).toBe(s);
      expect(t.parentNode).toBe(u);
      expect(t.nextSibling).toBeNull();
      expect(t.previousSibling).toBeNull();
      expect(t.firstChild).toBeNull();
      expect(t.lastChild).toBeNull();
      u = void 0;
    });
    /*appendChildメソッドの同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value, when it calls a appendChild method (the valid partion)", function() {
      var u = doc.createElementNS("http://sie.sourceforge.jp/", "ho");
      s.appendChild(t);
      s.appendChild(u);
      expect(s.firstChild).toBe(t);
      expect(s.lastChild).toBe(u);
      expect(s.childNodes.item(0)).toBe(t);
      expect(s.childNodes.item(1)).toBe(u);
      expect(s.nextSibling).toBeNull();
      expect(s.previousSibling).toBeNull();
      expect(s.parentNode).toBeNull();
      expect(t.parentNode).toBe(s);
      expect(t.nextSibling).toBe(u);
      expect(t.previousSibling).toBeNull();
      expect(t.firstChild).toBeNull();
      expect(t.lastChild).toBeNull();
      expect(u.parentNode).toBe(s);
      expect(u.nextSibling).toBeNull();
      expect(u.previousSibling).toBe(t);
      expect(u.firstChild).toBeNull();
      expect(u.lastChild).toBeNull();
      u = void 0;
    });
    /*removeChildメソッドの同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value, when it calls a removeChild method (the valid partion)", function() {
      s.insertBefore(t, null);
      s.removeChild(t);
      var u = doc.createElementNS("http://sie.sourceforge.jp/", "ho");
      s.appendChild(u);
      s.removeChild(u);
      expect(s.firstChild).toBeNull();
      expect(s.lastChild).toBeNull();
      expect(s.childNodes.item(0)).toBeNull();
      expect(s.nextSibling).toBeNull();
      expect(s.previousSibling).toBeNull();
      expect(s.parentNode).toBeNull();
      expect(t.parentNode).toBeNull();
      expect(t.nextSibling).toBeNull();
      expect(t.previousSibling).toBeNull();
      expect(t.firstChild).toBeNull();
      expect(t.lastChild).toBeNull();
      for (var i=0;i<50;++i) {
        s.appendChild(u);
        s.removeChild(u);
      }
      expect(s.firstChild).toBeNull();
      expect(s.lastChild).toBeNull();
      expect(s.childNodes.item(0)).toBeNull();
      expect(s.nextSibling).toBeNull();
      expect(s.previousSibling).toBeNull();
      expect(s.parentNode).toBeNull();
      expect(t.parentNode).toBeNull();
      expect(t.nextSibling).toBeNull();
      expect(t.previousSibling).toBeNull();
      expect(t.firstChild).toBeNull();
      expect(t.lastChild).toBeNull();
      u = void 0;
    });
    /*replaceChildメソッドの同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value, when it calls a replaceChild method (the valid partion)", function() {
      var u = doc.createElementNS("http://sie.sourceforge.jp/", "ho");
      s.insertBefore(t, null);
      s.replaceChild(u, t);
      s.replaceChild(t, u);
      s.replaceChild(u, t);
      expect(s.firstChild).toBe(u);
      expect(s.lastChild).toBe(u);
      expect(s.childNodes.item(0)).toBe(u);
      expect(s.nextSibling).toBeNull();
      expect(s.previousSibling).toBeNull();
      expect(s.parentNode).toBeNull();
      expect(u.parentNode).toBe(s);
      expect(u.nextSibling).toBeNull();
      expect(u.previousSibling).toBeNull();
      expect(u.firstChild).toBeNull();
      expect(u.lastChild).toBeNull();
      expect(t.parentNode).toBeNull();
      expect(t.nextSibling).toBeNull();
      expect(t.previousSibling).toBeNull();
      expect(t.firstChild).toBeNull();
      expect(t.lastChild).toBeNull();
    });
    /*hasChildNodesメソッドの同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value, when it calls a hasChildNodes method (the valid partion)", function() {
      for (var i=0;i<10;++i) {
        s.appendChild(t);
        expect(s.hasChildNodes()).toBe(true);
        s.appendChild(t);
        expect(s.hasChildNodes()).toBe(true);
        s.removeChild(t);
        expect(s.hasChildNodes()).toBe(false);
      }
    });
    /*cloneNodeメソッドの同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value, when it calls a cloneNode method (the valid partion)", function() {
      s.appendChild(t);
      var u = s.cloneNode(false),
          v = s.cloneNode(true);
      for (var i=0;i<10;++i) {
        u = u.cloneNode(false);
        v = v.cloneNode(true);
      }
      expect(u).toNotBe(s);
      expect(u.firstChild).toBeNull();
      expect(u.lastChild).toBeNull();
      expect(u.childNodes.item(0)).toBeNull();
      expect(u.nextSibling).toBeNull();
      expect(u.previousSibling).toBeNull();
      expect(u.parentNode).toBeNull();
      expect(v).toNotBe(s);
      expect(v.hasChildNodes()).toBe(true);
      expect(v.firstChild.parentNode).toBe(v);
      expect(v.lastChild.parentNode).toBe(v);
      expect(v.childNodes.item(0).parentNode).toBe(v);
      expect(v.nextSibling).toBeNull();
      expect(v.previousSibling).toBeNull();
      expect(v.parentNode).toBeNull();
    });
    /*hasAttributesメソッドの同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value, when it calls a hasAttributes method (the valid partion)", function() {
      s.setAttributeNS(null, "a", "b");
      s.setAttributeNS(null, "c", "b");
      expect(s.hasAttributes()).toBe(true);
    });

    /*insertBeforeメソッドの同値分割をして、無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value, when it calls a insertBefore method (the invalid partion)", function() {
      var sn = function() {
          s.insertBefore(t, null);
          /*HIERARCHY_REQUEST_ERR DOMException */
          t.insertBefore(s, null);
        },
        tn = function() {
          /*WRONG_DOCUMENT_ERR DOMException*/
          s.insertBefore(DOMImplementation.createDocument("svg", "svg").createElementNS("o","n"), null);
        },
        un = function() {
          /*NOT_FOUND_ERR DOMException*/
          s.insertBefore(t, t.cloneNode(false));
        };
      expect(sn).toThrow();
      expect(tn).toThrow();
      expect(un).toThrow();
    });
    /*appendChildメソッドの同値分割をして、無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value, when it calls a appendChild method (the invalid partion)", function() {
      var sn = function() {
        s.appendChild(t);
        /*HIERARCHY_REQUEST_ERR DOMException */
        t.appendChild(s);
      },
      tn = function() {
        /*WRONG_DOCUMENT_ERR DOMException*/
        s.appendChild(DOMImplementation.createDocument("svg", "svg").createElementNS("o","n"));
      };
      expect(sn).toThrow();
      expect(tn).toThrow();
    });
    /*removeChildメソッドの同値分割をして、無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value, when it calls a removeChild method (the invalid partion)", function() {
      var sn = function() {
        s.removeChild(s.cloneNode(false));
      },
      tn = function() {
        /*NOT_FOUND_ERR DOMException*/
        s.removeChild(DOMImplementation.createDocument("svg", "svg").createElementNS("o","n"));
      };
      expect(sn).toThrow();
      expect(tn).toThrow();
    });
    /*replaceChildメソッドの同値分割をして、無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value, when it calls a replaceChild method (the invalid partion)", function() {
      s.appendChild(t);
      t.appendChild(t.cloneNode(false));
      var sn = function() {
        /*HIERARCHY_REQUEST_ERR DOMException */
        t.replaceChild(s, t.firstChild);
      },
      tn = function() {
        /*WRONG_DOCUMENT_ERR DOMException*/
        s.replaceChild(DOMImplementation.createDocument("svg", "svg").createElementNS("o","n"), s.firstChild);
      },
      un = function() {
        /*NOT_FOUND_ERR DOMException*/
        s.replaceChild(t, t.cloneNode(false));
      };
      expect(sn).toThrow();
      expect(tn).toThrow();
      expect(un).toThrow();
    });
  });
  describe("DOM level 2 Core :: Document", function() {
    /*まずは、あるべきデフォルト値かどうかをチェックしていく(Checking the default value of a Document interface.)*/
    it("for the default value on the property of Document", function() {
      expect(doc.doctype).toBeNull();
      expect(doc.nodeName).toBe("#document");
      expect(doc.nodeValue).toBeNull();
      expect(doc.attributes).toBeNull();
      expect(svg.ownerDocument).toBe(doc);
      expect(svg.nodeName).toBe("svg");
      expect(svg.namespaceURI).toBe("http://www.w3.org/2000/svg");
    });
    /*getElementByIdメソッドの境界条件を調べておく (limit value analysis, when it calls a getElementById method)*/
    it("should be this for the value, when it calls a getElementById method (limit value analysis)", function() {
      expect(doc.getElementById("a")).toBeNull();
      svg.setAttributeNS(null, "id", "a");
      expect(doc.getElementById("a")).toBe(svg);
      svg.setAttributeNS(null, "id", "x");
      expect(doc.getElementById("x")).toBe(svg);
      expect(doc.getElementById("a")).toBeNull();
      expect(doc.getElementById("")).toBeNull();
    });
    /*getElementsByTagNameメソッドの境界条件を調べておく (limit value analysis, when it calls a getElementsByTagName method)*/
    it("should be this for the value, when it calls a getElementsByTagName method (limit value analysis)", function() {
      expect(doc.getElementsByTagName("a")).toBeNull();
    });
    /*getElementsByTagNameNSメソッドの境界条件を調べておく (limit value analysis, when it calls a getElementsByTagNameNS method)*/
    it("should be this for the value, when it calls a getElementsByTagNameNS method (limit value analysis)", function() {
      var svgns = "http://www.w3.org/2000/svg",
          ele = doc.createElementNS(svgns, "a");
      expect(doc.getElementsByTagNameNS(svgns, "a")).toBeNull();
      expect(doc.getElementsByTagNameNS("http://www.d.hatena.jp/dhrname", "a")).toBeNull();
      expect(doc.getElementsByTagNameNS("*", "a")).toBeNull();
      expect(doc.getElementsByTagNameNS("*", "*").item(0)).toBe(svg);
      expect(doc.getElementsByTagNameNS(svgns, "svg").item(0)).toBe(svg);
      expect(doc.getElementsByTagNameNS(svgns, "b")).toBeNull();
      expect(doc.getElementsByTagNameNS("http://www.d.hatena.jp/dhrname", "b")).toBeNull();
      expect(doc.getElementsByTagNameNS("*", "b")).toBeNull();
      expect(doc.getElementsByTagNameNS("*", "b")).toBeNull();
      svg.appendChild(ele);
      expect(doc.getElementsByTagNameNS(svgns, "a").item(0)).toBe(ele);
      expect(doc.getElementsByTagNameNS("http://www.d.hatena.jp/dhrname", "a")).toBeNull();
      expect(doc.getElementsByTagNameNS("*", "a").item(0)).toBe(ele);
      expect(doc.getElementsByTagNameNS(svgns, "b")).toBeNull();
      expect(doc.getElementsByTagNameNS("http://www.d.hatena.jp/dhrname", "b")).toBeNull();
      expect(doc.getElementsByTagNameNS("*", "b")).toBeNull();
      expect(doc.getElementsByTagNameNS("*", "b")).toBeNull();

      expect(doc.getElementsByTagNameNS("", "a")).toBeNull();
      expect(doc.getElementsByTagNameNS(svgns, "")).toBeNull();
      svgns = ele = void 0;
    });
    /*importNodeメソッドの境界条件を調べておく (limit value analysis, when it calls a importNode method)*/
    it("should be this for the value, when it calls a importNode method (limit value analysis)", function() {      var ele = doc.createElementNS("http://www.w3.org/2000/svg", "a");
      var ele = doc.createElementNS("http://www.w3.org/2000/svg", "a"),
          cdoc = doc.implementation.createDocument("http://", "a"),
          cele = cdoc.importNode(doc.documentElement);
      expect(cele.nodeName).toBe("svg");
      expect(cele.namespaceURI).toBe("http://www.w3.org/2000/svg");
      expect(cele.ownerDocument).toBe(cdoc);
      expect(cele.firstChild).toBeNull();
      doc.documentElement.appendChild(ele);
      expect(cele.firstChild).toBeNull();

      ele = cdoc.importNode(doc.documentElement.firstChild);
      expect(ele.nodeName).toBe("a");
      expect(ele.namespaceURI).toBe("http://www.w3.org/2000/svg");
      expect(ele.ownerDocument).toBe(cdoc);
      cdoc.documentElement.appendChild(ele);
      expect(cdoc.documentElement.firstChild).toBe(ele);
   });
    /*getElementByIdメソッドの同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value, when it calls a getElementById method (the valid partion)", function() {
      expect(doc.getElementById("ax")).toBeNull();
      expect(doc.getElementById("hoge-hoge")).toBeNull();
      expect(doc.getElementById("a102930")).toBeNull();
      svg.setAttributeNS(null, "id", "ax");
      expect(doc.getElementById("ax")).toBe(svg);
      svg.setAttributeNS(null, "id", "hoge-hoge");
      expect(doc.getElementById("hoge-hoge")).toBe(svg);
      svg.setAttributeNS(null, "id", "a102930");
      expect(doc.getElementById("a102930")).toBe(svg);
    });
    /*getElementsByTagNameNSメソッドの同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value, when it calls a getElementsByTagNameNS method (the valid partion)", function() {
      var svgns = "http://www.w3.org/2000/svg",
          ele = doc.createElementNS(svgns, "a"),
          a;
      for (var i=0;i<10;++i) {
        doc.documentElement.appendChild(ele.cloneNode(true));
      }
      a = doc.getElementsByTagNameNS(svgns, "a");
      expect(a.length).toBe(10);
      for (var i=0;i<10;++i) {
        expect(a.item(i).nodeName).toBe("a");
        expect(a.item(i).namespaceURI).toBe(svgns);
      }
      /*深い階層の要素を作っておく*/
      a = a[0];
      for (var i=0;i<10;++i) {
        a.appendChild(ele.cloneNode(true));
        a = a.firstChild;
      }
      a = doc.getElementsByTagNameNS(svgns, "a");
      expect(a.length).toBe(20);
      for (var i=0;i<20;++i) {
        expect(a.item(i).nodeName).toBe("a");
        expect(a.item(i).namespaceURI).toBe(svgns);
      }
      ele = doc.createElementNS("http:://www", "st");
      ele.appendChild(doc.documentElement.lastChild);
      doc.documentElement.appendChild(ele);
      a = doc.getElementsByTagNameNS(svgns, "a");
      expect(a.length).toBe(20);
      for (var i=0;i<20;++i) {
        expect(a.item(i).nodeName).toBe("a");
        expect(a.item(i).namespaceURI).toBe(svgns);
      }
    });
    /*importNodeメソッドの同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value, when it calls a importNode method (the valid partion)", function() {
      var ele = doc.createElementNS("http://www.w3.org/2000/svg", "a"),
          cdoc = doc.implementation.createDocument("http://", "a"),
          c = cdoc.importNode(ele);
      ele.appendChild(doc.createTextNode("abc"));
      ele.appendChild(doc.createElementNS("http://", "x:ab"));
      expect(c.firstChild).toBeNull();
      expect(c.lastChild).toBeNull();

      c = cdoc.importNode(ele, true);
      expect(c.firstChild.data).toBe("abc");
      expect(c.lastChild.namespaceURI).toBe("http://");
      expect(c.lastChild.localName).toBe("ab");
      expect(c.firstChild).not.toBe(ele.firstChild);
      expect(c.lastChild).not.toBe(ele.lastChild);

      c = cdoc.importNode(ele, false);
      expect(c.firstChild).toBeNull();
      expect(c.lastChild).toBeNull();

      ele.appendChild(doc.createTextNode("abc"));
      expect(c.firstChild).toBeNull();
      expect(c.lastChild).toBeNull();

      var ds = doc.createElementNS("http://oo", "t:abc");
      ds.appendChild(doc.createTextNode("def"));
      ele.appendChild(ds);
      c = cdoc.importNode(ele, true);
      expect(c.lastChild.firstChild.data).toBe("def");
      expect(c.lastChild.namespaceURI).toBe("http://oo");
      expect(c.lastChild.localName).toBe("abc");
      expect(c.firstChild).not.toBe(ele.firstChild);
      expect(c.lastChild).not.toBe(ele.lastChild);
    });
    /*getElementByIdメソッドの同値分割をして、無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value, when it calls a getElementById method (the invalid partion)", function() {
      var t = [Number.NEGATIVE_INFINITY, Number.POSITIVE_INFINITY, Number.NaN, {}, [], undefined, null, 0, -1, 11, 1.1, 10.1];
      for (var i=0;i<t.length;++i) {
        var ti = t[i];
        expect(doc.getElementById(ti)).toBeNull();
      }
    });
    /*getElementsByTagNameNSメソッドの同値分割をして、無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value, when it calls a getElementsByTagNameNS method (the invalid partion)", function() {
      var t = [Number.NEGATIVE_INFINITY, Number.POSITIVE_INFINITY, Number.NaN, {}, [], undefined, null, 0, -1, 11, 1.1, 10.1];
      for (var i=0;i<t.length;++i) {
        var ti = t[i];
        expect(function(){
          doc.getElementsByTagNameNS(ti, ti);
        }).toThrow();
      }
    });
    /*importNodeメソッドの同値分割をして、無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value, when it calls a importNode method (the invalid partion)", function() {
    });
  });
  describe("DOM level 2 Core :: Element", function() {
    var s, t;
    beforeEach(function() {
      s = doc.createElementNS("http://www.w3.org/2000/svg", "text");
      t = doc.createElementNS("http://sie.sourceforge.jp/", "hoge");
    });
    /*まずは、あるべきデフォルト値かどうかをチェックしていく(Checking the default value of a Node interface.)*/
    it("for the default value on the property of Element", function() {
      expect(s.nodeType).toBe( /*Node.ELEMENT_NODE*/ 1);
      expect(s.nodeValue).toBeNull();
      expect(t.nodeType).toBe( /*Node.ELEMENT_NODE*/ 1);
      expect(t.nodeValue).toBeNull();
      expect(s.attributes.length).toBe(0);
    });

    /*setAttributeNodeNSメソッドの境界条件を調べておく (limit value analysis, when it calls a setAttributeNodeNS method)*/
    it("should be this for the value, when it calls a setAttributeNodeNS method (limit value analysis)", function() {
      expect(function() {
        s.setAttributeNodeNS();
      }).toThrow();
      var attr = s.ownerDocument.createAttributeNS(null, "h"),
          sat = s.attributes;
      s.setAttributeNodeNS(attr);
      expect(sat.length).toBe(1);
      expect(sat.getNamedItemNS(null, "h")).toBe(attr);
      /*同じことを繰り返して試行処理*/
      s.setAttributeNodeNS(attr);
      expect(sat.length).toBe(1);
      expect(sat.getNamedItemNS(null, "h")).toBe(attr);
      attr = s.ownerDocument.createAttributeNS("urn:wo", "h");
      s.setAttributeNodeNS(attr);
      expect(sat.length).toBe(2);
      expect(sat.getNamedItemNS("urn:", "h")).toBeNull();
    });
    /*setAttributeNodeNSメソッドの同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value, when it calls a setAttributeNodeNS method (the valid partion)", function() {
      for (var i=0;i<10;++i) {
        var attr = s.ownerDocument.createAttributeNS(null, "h"),
            sat = s.attributes;
        s.setAttributeNodeNS(attr);
      }
      expect(sat.length).toBe(1);
      expect(sat.getNamedItemNS(null, "h")).toBe(attr);
      for (var i=0;i<10;++i) {
        attr = s.ownerDocument.createAttributeNS("urn:" +i+ "o", "h");
        s.setAttributeNodeNS(attr);
      }
      expect(sat.length).toBe(11);
      expect(sat.getNamedItemNS("urn:9o", "h")).toBe(attr);

      attr = s.ownerDocument.createAttributeNS("urn:wo", "0");
      s.setAttributeNodeNS(attr);
      expect(sat.getNamedItemNS("urn:wo", "0")).toBe(attr);
    });
    /*setAttributeNodeNSメソッドの同値分割をして、無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value, when it calls a setAttributeNodeNS method (the invalid partion)", function() {
      var attr = s.ownerDocument.createAttributeNS(null, "h"),
          sat = s.attributes;
      s.setAttributeNodeNS(attr);
      expect(function() {
        /*すでに使われている属性ノードを別の要素に移した場合はエラー*/
        t.setAttrributeNodeNS(attr);
      }).toThrow();

      attr = s.ownerDocument.implementation
              .createDocument("http://www.w3.org/svg/2000", "svg")
              .createAttributeNS("urn:", "h");
      expect(function() {
        /*別の文書ノードに属する属性ノードを設定した場合はエラー*/
        t.setAttrributeNodeNS(attr);
      }).toThrow();
    });
  });
});
describe("SMIL Animation Spec", function() {
  describe("$frame object", function() {
    var frame = base("$frame");
    beforeEach( function() {
        frame.timelines = [];
    } );
    afterEach( function() {
        frame.timelines = [];
    } );
    /*境界条件を調べておく (limit value analysis)*/
    it("should be this for the value  (limit value analysis)", function() {
      expect(typeof frame.setFrame).toBe("function");
      expect(frame.timelines.length).toBe(0);
      expect(frame.startTime).toBeGreaterThan(-1);
      expect(frame.rank).toBe(0);
      frame.setFrame();
      frame.setFrame(0);
      /*負の値も許される*/
      frame.setFrame(-1);
      
      expect(frame.addLine()).toBe(false);
      expect(frame.addLine({})).toBe(false);
      expect(frame.addLine({
        begin: 0
      })).toBe(false);
      expect(frame.addLine({
        activeTime: 1
      })).toBe(false);
      
      expect(frame.removeLine()).toBeUndefined();
      expect(frame.removeLine({})).toBeUndefined();
      
      frame.setFrame(0);
      expect(frame.currentFrame).toBe(0);
      frame.setFrame(1);
      expect(frame.currentFrame).toBe(1);
    });
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value (the valid partion)", function() {
      frame.setFrame(0);
      expect(frame.currentFrame).toBe(0);
      frame.startTime = Date.now();
      for (var i=0;i<100000;i++) {
        /*負荷をかけて、時間を進める*/
        1;
      }
      expect(frame.begin).toBe(0);
      expect(frame.activeTime).toBe(Number.MAX_VALUE);
      frame.begin = 10;
      frame.setFrame(0);
      frame.begin = -10;
      frame.setFrame(0);

      expect(frame.addLine( {
        begin: 0,
        activeTime: 0
      })).toBe(true);
      expect(frame.addLine( {
        begin: null,
        activeTime: null
      })).toBe(false);
      expect(frame.addLine( {
        begin: 0,
        activeTime: null
      })).toBe(false);
      expect(frame.addLine( {
        begin: null,
        activeTime: 0
      })).toBe(false);
      
      expect(frame.timelines.length).toBe(1);
      var timeline = frame.timelines[0];
      expect(timeline.begin).toBe(0);
      expect(timeline.activeTime).toBe(0);
      /*timelineの再追加*/
      expect(frame.timelines[0]).toBe(timeline);
      frame.addLine({begin:1, activeTime:1});
      expect(frame.timelines[1]).not.toBe(timeline);
      frame.addLine(timeline);
      expect(frame.timelines[0]).not.toBe(timeline);
      expect(frame.timelines[1]).toBe(timeline);

      timeline = frame.timelines[0];
      frame.removeLine({});
      expect(frame.timelines[0]).toBe(timeline);
      frame.removeLine(timeline);
      expect(frame.timelines[0]).not.toBe(timeline);
      
      frame.addLine(frame.up().mix( {
        timelines: [] 
        } ));
      expect(frame.timelines).not.toBe(frame.$1.timelines);
      
      frame.timelines.length = 0;
      frame.addLine( {
        begin: 1,
        activeTime: 1,
        rank:2
      } );
      frame.addLine( {
        begin: 1,
        activeTime: 1,
        rank:1
      } );
      expect(frame.timelines[0].rank).toBe(1);
      expect(frame.timelines[1].rank).toBe(2);
    });
    /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value (the invalid partion)", function() {
      expect(frame.addLine(12)).toBeFalsy();
      /*循環参照にならず、スタック領域不足にならない*/
      frame.addLine(frame);
      frame.setFrame(0);
    });
  } );
  
  describe("$begin object", function() {
    var begin = base("$frame").$begin.up();
    /*境界条件を調べておく (limit value analysis)*/
    it("should be this for the value  (limit value analysis)", function() {
      expect(begin.string).toBe("");
      expect(begin.isResolved).toBeFalsy();
      expect(begin.eventTarget).toBe(document.documentElement);
      expect(typeof begin.listener).toBe("function");
      expect(begin.eventOffset).toBe(0);
      expect(begin.repeat).toBe(0);
      expect(begin.accessKey).toBe("");
    } );
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value (the valid partion)", function() {
      begin.string = " hoge ";
      expect(begin.string).toBe(" hoge ");
    } );
    /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value (the invalid partion)", function() {
    } );
    
    describe("A trim method in $begin object", function() {
      /*境界条件を調べておく (limit value analysis)*/
      beforeEach( function() {
        begin.string = "";
      } );
      it("should be this for the value  (limit value analysis)", function() {
        delete begin.string;
        expect(begin.trim(" ")).toBe("");
        expect( function() {
          begin.trim();
        } ).toThrow();
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion)", function() {
        expect(begin.trim(" hoge ")).toBe("hoge");
        expect(begin.trim(" h o g e ")).toBe("hoge");
        expect(begin.trim(" h  o  g     e ")).toBe("hoge");
        expect(begin.trim("   h  o  g    12 +  e   ")).toBe("hog12+e");
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion)", function() {
        expect( function() {
          begin.trim(1);
        } ).toThrow();
        expect( function() {
          begin.trim({});
        } ).toThrow();
      } );
    } );

    describe("An offset method in $begin object", function() {
      beforeEach( function() {
        begin.string = "";
      } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect(begin.offset(begin.trim(" "))).toBe(0);
        expect(begin.offset(begin.trim(" 0 "))).toBe(0);
        expect(begin.offset(begin.trim("+0ms"))).toBe(0);
        expect(begin.offset(begin.trim("-0ms"))).toBe(0);
        expect(begin.offset(begin.trim("1ms"))).toBe(1);
        expect(begin.offset(begin.trim("-1ms"))).toBe(-1);

        expect(begin.offset("+0s")).toBe(0);
        expect(begin.offset("-0s")).toBe(0);
        expect(begin.offset("1s")).toBe(1000);
        expect(begin.offset("-1s")).toBe(-1000);

        expect(begin.offset("+0min")).toBe(0);
        expect(begin.offset("-0min")).toBe(0);
        expect(begin.offset("1min")).toBe(60000);
        expect(begin.offset("-1min")).toBe(-60000);

        expect(begin.offset("+0h")).toBe(0);
        expect(begin.offset("-0h")).toBe(0);
        expect(begin.offset("1h")).toBe(60*60*1000);
        expect(begin.offset("-1h")).toBe(-3600000);

        expect(begin.offset("00:0")).toBe(0);
        expect(begin.offset("00:00:0.0")).toBe(0);
        expect(begin.offset("-00:0")).toBe(0);
        expect(begin.offset("-00:00:0.0")).toBe(0);
        expect(begin.offset("00:1")).toBe(1000);
        expect(begin.offset("-00:1")).toBe(-1000);
        expect(begin.offset("00:00:1")).toBe(1000);
        expect(begin.offset("-00:00:1")).toBe(-1000);

        expect(begin.offset()).toBe(0);
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion)", function() {
        expect(begin.offset(begin.trim(" + 0 ms"))).toBe(0);
        expect(begin.offset(begin.trim(" -1m s "))).toBe(-1);
        expect(begin.offset(begin.trim("1000ms"))).toBe(1000);
        expect(begin.offset(begin.trim(" -1212ms"))).toBe(-1212);

        expect(begin.offset("+100s")).toBe(100 * 1000);
        expect(begin.offset("-121s")).toBe(-121 * 1000);
        expect(begin.offset("1.25s")).toBe(1.25 * 1000);
        expect(begin.offset("-0.20s")).toBe(-0.20 * 1000);
        expect(begin.offset(".20s")).toBe(0.20 * 1000);

        expect(begin.offset("+100min")).toBe(100 * 60000);
        expect(begin.offset("-121min")).toBe(-121 * 60000);
        expect(begin.offset("1.25min")).toBe(1.25 * 60000);
        expect(begin.offset("-0.20min")).toBe(-0.20 * 60000);
        expect(begin.offset(".20min")).toBe(0.20 * 60000);

        expect(begin.offset("+100h")).toBe(100 * 3600000);
        expect(begin.offset("-121h")).toBe(-121 * 3600000);
        expect(begin.offset("1.25h")).toBe(1.25 * 3600000);
        expect(begin.offset("-0.20h")).toBe(-0.20 * 3600000);
        expect(begin.offset(".20h")).toBe(0.20 * 3600000);

        expect(begin.offset("01:0")).toBe(60000);
        expect(begin.offset("-01:0")).toBe(-60000);
        expect(begin.offset("00:00:1")).toBe(1000);
        expect(begin.offset("-00:00:1")).toBe(-1000);
        expect(begin.offset("00:01:0")).toBe(60000);
        expect(begin.offset("-00:01:0")).toBe(-60000);
        expect(begin.offset("01:00:0")).toBe(3600000);
        expect(begin.offset("-01:00:0")).toBe(-3600000);
        expect(begin.offset("00:10")).toBe(10000);
        expect(begin.offset("00:0.01")).toBe(10);
        expect(begin.offset("01:0.01")).toBe(60010);
        expect(begin.offset("10:0")).toBe(600000);
        expect(begin.offset("-00:10")).toBe(-10000);
        expect(begin.offset("-00:0.01")).toBe(-10);
        expect(begin.offset("-01:0.01")).toBe(-60010);
        expect(begin.offset("-10:0")).toBe(-600000);
        expect(begin.offset("00:00:20")).toBe(20000);
        expect(begin.offset("00:11:20")).toBe(11*60*1000 + 20000);
        expect(begin.offset("12:11:20")).toBe(12*60*60*1000 + 11*60*1000 + 20000);
        expect(begin.offset("-10:0")).toBe(-600000);
        expect(begin.offset("-01:01:0.1")).toBe(-1*60*60*1000 - 60000 - 100);
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion)", function() {
        expect(begin.offset(begin.trim(" h  o  g     1e "))).toBe(0);
        expect(begin.offset("ms")).toBe(0);
        expect(begin.offset(".s")).toBe(0);
        expect(begin.offset("10:")).toBe(0);
        expect(begin.offset("::")).toBe(0);
        expect(begin.offset("-:0")).toBe(0);
        expect(begin.offset("-::0")).toBe(0);
      } );
    } );
    describe("An event method in $begin object", function() {
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        var evt = begin.event();
        expect(evt.id).toBe("");
        expect(evt.event).toBe("");
        evt = begin.event("");
        expect(evt.id).toBe("");
        expect(evt.event).toBe("");
        evt = begin.event(".");
        expect(evt.id).toBe("");
        expect(evt.event).toBe("");

        evt = begin.event("a");
        expect(evt.id).toBe("");
        expect(evt.event).toBe("a");
        evt = begin.event("a.b");
        expect(evt.id).toBe("a");
        expect(evt.event).toBe("b");
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion)", function() {
        var evt = begin.event("id.event");
        expect(evt.id).toBe("id");
        expect(evt.event).toBe("event");
        evt = begin.event("event");
        expect(evt.id).toBe("");
        expect(evt.event).toBe("event");
        
        evt = begin.event("event+0s");
        expect(evt.id).toBe("");
        expect(evt.event).toBe("event");
        evt = begin.event("event-0s");
        expect(evt.id).toBe("");
        expect(evt.event).toBe("event");
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion)", function() {
        evt = begin.event("...");
        expect(evt.id).toBe("");
        expect(evt.event).toBe("");
        evt = begin.event(".event");
        expect(evt.id).toBe("");
        expect(evt.event).toBe("");
        evt = begin.event("id.");
        expect(evt.id).toBe("");
        expect(evt.event).toBe("");
      } );
    } );
    
    describe("An parse method in $begin object", function() {
       beforeEach( function() {
        begin.string = "";
      } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect(begin.parse().begin).toBe(0);
        begin.string="+0";
        expect(begin.parse().begin).toBe(0);
        begin.string = "+1";
        expect(begin.parse().begin).toBe(1000*begin.fpms);
        begin.string = " ";
        expect(begin.parse().begin).toBe(0);
        begin.string = "1";
        expect(begin.parse().begin).toBe(1000*begin.fpms);
        begin.string = "+0ms";
        expect(begin.parse().begin).toBe(0);
        begin.string = "-0ms";
        expect(begin.parse().begin).toBe(0);
        
        expect(begin.eventOffset).toBe(0);
        begin.string = "click";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        expect(begin.repeat).toBe(0);
        expect(begin.accessKey).toBe("");
        begin.string = "id.click";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        expect(begin.repeat).toBe(0);
        expect(begin.accessKey).toBe("");
        
        begin.string = "repeat";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        expect(begin.repeat).toBe(0);
        expect(begin.accessKey).toBe("");
        begin.string = "repeat(1)";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        expect(begin.repeat).toBe(1);
        expect(begin.accessKey).toBe("");
        
        begin.string = "accessKey(a)";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        expect(begin.repeat).toBe(0);
        expect(begin.accessKey).toBe("a");
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion)", function() {
        begin.string = " 1 0 0 m s";
        expect(begin.parse().begin).toBe(Math.floor(100*begin.fpms));

        begin.string = "1ms";
        begin.isResolved = false;
        expect(begin.parse().begin).toBe(Math.floor(1*begin.fpms));
        expect(begin.isResolved).toBeTruthy();
        expect(begin.eventOffset).toBe(0);

        begin.string="click+0";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        begin.string = "click+1";
        expect(begin.parse().begin).toBe(1000*begin.fpms);
        expect(begin.eventOffset).toBe(1000*begin.fpms);
        begin.string = " click ";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        begin.string = "click+0ms";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        begin.string = "click-0ms";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        begin.string = "click+100ms";
        expect(begin.parse().begin).toBe(Math.floor(100*begin.fpms));
        expect(begin.eventOffset).toBe(Math.floor(100*begin.fpms));
        begin.string = "click-100ms";
        expect(begin.parse().begin).toBe(Math.floor(-100*begin.fpms));
        expect(begin.eventOffset).toBe(Math.floor(-100*begin.fpms));

        begin.string="id.click+0";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        begin.string = "id.click+1";
        expect(begin.parse().begin).toBe(1000*begin.fpms);
        expect(begin.eventOffset).toBe(1000*begin.fpms);
        begin.string = " id . click ";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        begin.string = "id.click+0ms";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        begin.string = "id.click-0ms";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        begin.string = "id.click+100ms";
        expect(begin.parse().begin).toBe(Math.floor(100*begin.fpms));
        expect(begin.eventOffset).toBe(Math.floor(100*begin.fpms));
        begin.string = "id.click-100ms";
        expect(begin.parse().begin).toBe(Math.floor(-100*begin.fpms));
        expect(begin.eventOffset).toBe(Math.floor(-100*begin.fpms));
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion)", function() {
        begin.string = "ms";
        begin.isResolved = false;
        expect(begin.parse().begin).toBe(0);
        expect(begin.isResolved).toBeFalsy();
        
        begin.string = "indefinite";
        expect(begin.parse().begin).toBe(Math.floor( Number.MAX_VALUE * begin.fpms));
        expect(begin.isResolved).toBeFalsy();
      } );
    } );
    
    describe("A listener method in $begin object", function() {
      var obj = begin.up();
       beforeEach( function() {
        begin.string = "";
        /*配列は初期化しておく*/
        begin.timelines.length = 0;
        obj.$activate = begin.$activate.up();
        obj.startTime = Date.now();
        obj.setFrame(0);
      } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        obj.isResolved = true;
        obj.listener();
        expect(obj.begin).toBe(0);
        
        obj.listener( {
            timeStamp: Date.now()
        } );
        expect(obj.begin).toBe(0);
        expect(obj.activeTime).toBeGreaterThan(0);
        expect(obj.timelines.length).toBe(1);

        obj.isResolved = false;
        obj.listener( {
            timeStamp: Date.now()
        } );
        expect(obj.begin).toBe(0);
        expect(obj.activeTime).toBeGreaterThan(0);
        expect(obj.timelines.length).toBe(1);
        /*配列を初期化*/
        obj.timelines.length = 0;

        obj.up().mix( {
                begin: 1,
                eventOffset: 1,
                $activate: begin.$activate.up().mix( {
                    dur: "12"
                  } )
              })
              .listener( {
                timeStamp: Date.now()
              } );
        expect(obj.$1.begin).toBe(1);
        expect(obj.$1.activeTime).toBe(Math.floor(12000*obj.fpms));
        expect(obj.$1.$activate.begin).toBe(obj.$1.begin);
        expect(obj.timelines[0]).toBe(obj.$1);
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion)", function() {
        obj.up().mix( {
                begin: 1,
                eventOffset: 1,
                $activate: begin.$activate.up().mix( {
                    end: begin.$activate.end.up().mix( {
                       string: "1s"
                      } )
                  } )
              })
              .listener( {
                timeStamp: Date.now()
              } );
        expect(obj.$1.begin).toBe(1);
        expect(obj.$1.activeTime).toBe(Math.floor(1000*obj.fpms) - 1);
        expect(obj.$1.$activate.begin).toBe(obj.$1.begin);
        expect(obj.timelines[0]).toBe(obj.$1);

        obj.up().mix( {
                begin: 1,
                eventOffset: 1,
                $activate: begin.$activate.up().mix( {
                    end: begin.$activate.end.up().mix( {
                       string: "1s"
                      } )
                  } )
              })
              .listener( {
                timeStamp: Date.now()
              } );
        expect(obj.$1.begin).toBe(1);
        expect(obj.$1.activeTime).toBe(Math.floor(1000*obj.fpms) - 1);
        expect(obj.$1.$activate.begin).toBe(obj.$1.begin);
        expect(obj.timelines[1]).toBe(obj.$1);
        obj.$1.listener( {
          timeStamp: (Date.now() + 500)
        } );
        expect(obj.$1.begin).toBe(Math.floor(500*obj.fpms) + 1);
        expect(obj.$1.activeTime).toBe(Math.floor(1000*obj.fpms) - Math.floor(500*obj.fpms) - 1);
        expect(obj.$1.$activate.begin).toBe(obj.$1.begin);
        expect(obj.timelines[1]).toBe(obj.$1);
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion)", function() {
        expect( function() {
          obj.listener({});
        } ).toThrow();
      } );
    } );
  } );
  describe("A $end object", function() {
    var end = base("$frame").$begin.$end.up();
    end.startTime = 0;
    beforeEach( function() {
      end.string = "";
      end.startTime = Date.now();
      end.setFrame(0);
    } );
    /*境界条件を調べておく (limit value analysis)*/
    it("should be this for the value  (limit value analysis)", function() {
      expect(end.up().call()).toBeNull();
      end.string = "0";
      expect(end.up().call()).toBe(0);
      end.string = "hoge";
      expect(end.up().call()).toBe("indefinite");
      
    } );
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value (the valid partion)", function() {
      end.string = "hoge+0";
      expect(end.up().call()).toBe("indefinite");
      end.string = "12ms";
      expect(end.up().call()).toBe(Math.floor(12*end.fpms));
      end.string = "hoge+12ms";
      expect(end.up().call()).toBe("indefinite");

    } );
    /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value (the invalid partion)", function() {
      end.string = null;
      expect(end.up().call()).toBeNull();
    } );

    describe("A listener method in $end object", function() {
      var obj,
          begin = base("$frame").$begin;
       beforeEach( function() {
        end.string = "";
        /*配列は初期化しておく*/
        end.timelines.length = 0;
        obj = end.up();
        obj.$begin = begin.up().mix( {
          begin: 12,
          activeTime: 120
        } );
        obj.$begin.$activate = begin.$activate.up();
        obj.addLine(obj.$begin);
      } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect(obj.timelines[0]).toBe(obj.$begin);
        expect(obj.timelines[0]).not.toBe(obj);
        obj.listener();
        expect(obj.timelines[0]).not.toBe(obj.$begin);

        obj.addLine(obj.$begin.mix( {
          begin: 12,
          activeTime: 120
        } ) );
        obj.listener({
          timeStamp: (Date.now() + 12)
        } );
        expect(obj.timelines[0]).not.toBe(obj.$begin);
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion)", function() {
        obj.$begin.$activate.begin = 0;
        obj.mix( {
          string: "event"
        } ).parse();
        obj.listener({
          timeStamp: (Date.now() + 120)
        } );
        expect(obj.timelines[0]).not.toBe(obj.$begin);
        expect(obj.begin).toBe(Math.ceil(120*obj.fpms));
        expect(obj.$begin.activeTime).toBe(Math.ceil(120*obj.fpms));

        obj.addLine(obj.$begin.mix( {
          begin: 12,
          activeTime: 120
        } ) );
        obj.$begin.$activate.begin = 0;
        obj.mix( {
          string: "event+1000ms"
        } ).parse();
        obj.listener({
          timeStamp: (Date.now() + 12)
        } );
        expect(obj.timelines[0]).toBe(obj.$begin);
        expect(obj.begin).toBe(Math.ceil(1012*obj.fpms));
        expect(obj.$begin.activeTime).toBe(Math.ceil(1012*obj.fpms));
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion)", function() {
        expect(function() {
          obj.listener({});
        } ).toThrow();
      } );
    } )
  } );
  describe("A $activate object", function() {
    var act = base("$frame").$begin.$activate.up();
     beforeEach( function() {
      act.dur = "indefinite";
      act.begin = 0;
      act.repeatCount = null;
      act.repeatDur = null;
      act.end = act.$begin.$end;
      act.simpleDur = base("$frame").$begin.$activate.simpleDur;
    } );
    /*境界条件を調べておく (limit value analysis)*/
    it("should be this for the value  (limit value analysis)", function() {
      expect(act.dur).toBe("indefinite");
      expect(typeof act.resolvedTime).toBe("function");
      expect(act.end).toBe(act.$begin.$end);
      expect(act.repeatCount).toBeNull();
      expect(act.repeatDur).toBeNull();
      expect(act.simpleDur()).toBeNull();
      expect(act.min).toBe("0");
      expect(act.max).toBe("indefinite");

      act.up("$a");
      expect(act.$a.call()).toBeNull();
      expect(act.$a.end).toBeNull();
    } );
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value (the valid partion)", function() {
      expect(act.resolvedTime()).toBe((+new Date()));

      /*Activate Duration = dur*/
      act.up("$b");
      act.$b.dur = "132ms";
      var abc = act.$b.call();
      expect(abc).toBe(Math.floor(132*act.fpms));
      expect(abc).toBe(act.$b.simpleDur);
      act.dur = null;
      expect(act.up().call()).toBeNull();
      
      /*AD = end -begin*/
      act.begin = 1;
      act.up("$eb").end = act.end.up().mix( {string: "120ms" } );
      expect( act.$eb.mix( {
        dur: "indefinite",
        simpleDur: act.simpleDur,
        repeatCount: 12,
        repeatDur: null,
      } ).call() ).toBe(Math.floor(120*act.fpms) - 1);
      expect( act.$eb.mix( {
        dur: "12",
        repeatCount: "indefinite",
        repeatDur: null,
      } ).call() ).toBe(Math.floor(120*act.fpms) - 1);
      expect( act.$eb.mix( {
        dur: "12",
        simpleDur: act.simpleDur,
        repeatCount: null,
        repeatDur: "indefinite",
      } ).call() ).toBe(Math.floor(120*act.fpms) - 1);
      act.$eb.end *= 3;
      expect( act.$eb.mix( {
        dur: "12",
        simpleDur: act.simpleDur,
        repeatCount: "indefinite",
        repeatDur: "indefinite",
      } ).call() ).toBe(Math.floor(120*act.fpms)*3 - 1);

      /*AD = Min(dur, end - begin)*/
      act.up("$c").end = act.end.up().mix( { string: "12" } );
      act.$c.mix( {
        dur: "10",
        simpleDur: act.simpleDur,
        repeatCount: null,
        repeatDur: null
      } );
      expect(act.$c.call()).toBe(Math.floor(10000*act.fpms));
      expect(act.$c.call()).toBe(act.$c.simpleDur);
      act.$c.mix( {
        dur: "15",
        simpleDur: act.simpleDur,
        repeatCount: null,
        repeatDur: null
      } );
      expect(act.$c.call()).toBe(Math.floor(12000*act.fpms) - 1);
      expect(act.$c.simpleDur).toBe(Math.floor(15000*act.fpms));

      /*AD = Min(repeatCount*dur, end - begin)*/
      expect(act.$c.end).toBe(Math.floor(12000*act.fpms));
      act.$c.mix( {
        dur: "10",
        simpleDur: act.simpleDur,
        repeatCount: 2,
        repeatDur: null
      } );
      expect(act.$c.call()).toBe(Math.floor(12000*act.fpms) - 1);
      expect(act.$c.simpleDur).toBe(Math.floor(10000*act.fpms));
      act.$c.mix( {
        dur: "10",
        simpleDur: act.simpleDur,
        repeatCount: 1,
        repeatDur: null
      } );
      expect(act.$c.call()).toBe(Math.floor(10000*act.fpms));
      expect(act.$c.simpleDur).toBe(Math.floor(10000*act.fpms));

      /*AD = Min(repeatDur, end - begin)*/
      act.$c.mix( {
        dur: "indefinite",
        simpleDur: act.simpleDur,
        repeatCount: 2,
        repeatDur: "15"
      } );
      expect(act.$c.call()).toBe(Math.floor(12000*act.fpms) - 1);
      expect(act.$c.simpleDur).toBeNull();
      act.$c.mix( {
        dur: "indefinite",
        simpleDur: act.simpleDur,
        repeatCount: 2,
        repeatDur: "10"
      } );
      expect(act.$c.call()).toBe(Math.floor(10000*act.fpms));
      expect(act.$c.simpleDur).toBeNull();
      act.$c.mix( {
        dur: "10",
        simpleDur: act.simpleDur,
        repeatCount: null,
        repeatDur: "15"
      } );
      expect(act.$c.call()).toBe(Math.floor(12000*act.fpms) - 1);
      expect(act.$c.simpleDur).toBe(Math.floor(10000*act.fpms));
      act.$c.mix( {
        dur: "10",
        simpleDur: act.simpleDur,
        repeatCount: null,
        repeatDur: "11"
      } );
      expect(act.$c.call()).toBe(Math.floor(11000*act.fpms));
      expect(act.$c.simpleDur).toBe(Math.floor(10000*act.fpms));
      
      /*AD = Min(repeatCount*d, repeatDur, end - begin)*/
      act.$c.mix( {
        dur: "10",
        simpleDur: act.simpleDur,
        repeatCount: 2,
        repeatDur: "15"
      } );
      expect(act.$c.call()).toBe(Math.floor(12000*act.fpms) - 1);
      expect(act.$c.simpleDur).toBe(Math.floor(10000*act.fpms));
      act.$c.mix( {
        dur: "10",
        simpleDur: act.simpleDur,
        repeatCount: 1,
        repeatDur: "15"
      } );
      expect(act.$c.call()).toBe(Math.floor(10000*act.fpms));
      expect(act.$c.simpleDur).toBe(Math.floor(10000*act.fpms));
      act.$c.mix( {
        dur: "11",
        simpleDur: act.simpleDur,
        repeatCount: 1,
        repeatDur: "9"
      } );
      expect(act.$c.call()).toBe(Math.floor(9000*act.fpms));
      expect(act.$c.simpleDur).toBe(Math.floor(11000*act.fpms));

      /*AD = repeatDur,*/
      act.$c.mix( {
        end: null,
        dur: "10",
        simpleDur: act.simpleDur,
        repeatCount: null,
        repeatDur: "15"
      } );
      expect(act.$c.call()).toBe(Math.floor(15000*act.fpms));
      expect(act.$c.simpleDur).toBe(Math.floor(10000*act.fpms));
      act.$c.mix( {
        dur: "indefinite",
        simpleDur: act.simpleDur,
        repeatCount: 2,
        repeatDur: "10"
      } );
      expect(act.$c.call()).toBe(Math.floor(10000*act.fpms));
      expect(act.$c.simpleDur).toBeNull();

      act.end.string = null;
      act.up("$cd").mix( {
        dur: "10",
        end: act.end,
        repeatCount: 2
      } );
      expect(act.$cd.call()).toBe(Math.floor(10000*act.fpms) * 2);
      
      act.$cd.end = act.end;
      act.$cd.repeatCount = null;
      act.$cd.repeatDur = "12";
      expect(act.$cd.call()).toBe(Math.floor(12000*act.fpms));
      
      act.up("$d").mix( {
        min: "2",
        max: "3",
        dur: "1",
        simpleDur: act.simpleDur
      } );
      expect(act.$d.call()).toBe(Math.floor(2000*act.fpms));
      act.up("$d").mix( {
        min: "1",
        max: "2",
        dur: "12",
        simpleDur: act.simpleDur
      } );
      expect(act.$d.call()).toBe(Math.floor(2000*act.fpms));
      
      /*endで0が指定されている場合*/
      act.begin = 0;
      act.end = 0;
      act.repeatDur = null;
      act.repeatCount = "indefinite";
      act.dur = "1";
      expect(act.call()).toBe(0);
      act.repeatCount = null;
      act.repeatDur = "indefinite";
      act.dur = "1";
      expect(act.call()).toBe(0);
      act.repeatDur = "indefinite";
      act.repeatCount = "indefinite";
      act.dur = "1";
      expect(act.call()).toBe(0);
    } );
    /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value (the invalid partion)", function() {
      /*min > max*/
      act.up("$d").mix( {
        min: "3",
        max: "2",
        dur: "1",
        simpleDur: act.simpleDur
      } );
      expect(act.$d.call()).toBe(Math.floor(1000*act.fpms));
      
      act.repeatDur = null;
      act.repeatCount = "indefinite";
      act.dur = "1";
      expect(act.call()).toBeNull();
      act.repeatCount = null;
      act.repeatDur = "indefinite";
      act.dur = "1";
      expect(act.call()).toBeNull();
      act.repeatDur = "indefinite";
      act.repeatCount = "indefinite";
      act.dur = "1";
      expect(act.call()).toBeNull();
    } );
  } );
  describe("A $from object", function() {
    var from = base("$from");
     beforeEach( function() {
       from = base("$from").up();
       from.from = from.from.up();
       from.string = "";
     } );
    /*境界条件を調べておく (limit value analysis)*/
    it("should be this for the value  (limit value analysis)", function() {
      expect(from.string).toBe("");
      expect(from.numList()).toEqual([]);
      expect(from.strList()).toBeNull();

      from.string = "0";
      expect(from.numList()[0]).toBe(0);
      expect(from.strList()).toBeNull();
      
      from.string = " 0 ";
      expect(from.numList()[0]).toBe(0);
      expect(from.strList().join("")).toBe("  ");

      from.string = "a";
      expect(from.numList()).toEqual([]);
      expect(from.strList()[0]).toBe("a");
      
      from.string = null;
      expect( function() {
        from.numList();
      } ).toThrow();
      expect( function() {
        from.strList();
      } ).toThrow();
      
      expect(from.additive[0]).toBe(0);
      expect(from.accumulate[0]).toBe(0);
    } );
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value (the valid partion)", function() {
      from.string = "0a";
      expect(from.numList()[0]).toBe(0);
      expect(from.strList()[0]).toBe("a");

      from.string = "a0";
      expect(from.numList()[0]).toBe(0);
      expect(from.strList()[0]).toBe("a");

      from.string = "0.1";
      expect(from.numList()[0]).toBe(0.1);
      expect(from.strList()).toBeNull();

      from.string = "+0.1";
      expect(from.numList()[0]).toBe(0.1);
      expect(from.strList()).toBeNull();

      from.string = "-0.1";
      expect(from.numList()[0]).toBe(-0.1);
      expect(from.strList()).toBeNull();

      from.string = "1e-1";
      expect(from.numList()[0]).toBe(1e-1);
      expect(from.strList()).toBeNull();

      from.string = "1E-1";
      expect(from.numList()[0]).toBe(1E-1);
      expect(from.strList()).toBeNull();

      from.string = "0,0";
      expect(from.numList().toString()).toBe("0,0");
      expect(from.strList().join("")).toBe(",");

      from.string = "a00a";
      expect(from.numList()[0]).toBe(0);
      expect(from.strList().join("")).toBe("aa");

      from.string = "a0b0a";
      expect(from.numList().toString()).toBe("0,0");
      expect(from.strList().join("")).toBe("aba");

      from.string = "0b0a";
      expect(from.numList().toString()).toBe("0,0");
      expect(from.strList().join("")).toBe("ba");

      from.string = "0b-1.0a";
      expect(from.numList()[1]).toBe(-1);
      expect(from.strList().join("")).toBe("ba");

      expect(from.up().call()).toBe(from.$1.numList);
      expect(from.$1.numList[1]).toBe(-1);
      expect(from.$1.strList.join("")).toBe("ba");

      from.string = "あ　0b-1.0a１２";
      expect(from.numList()[1]).toBe(-1);
      expect(from.strList().join("")).toBe("あ　ba１２");

      from.string = "0b-1.0a0";
      expect(from.numList().join(",")).toBe("0,-1,0");
      expect(from.strList().join("")).toBe("ba");

      from.string = "0b .1a";
      expect(from.numList()[1]).toBe(0.1);
      expect(from.strList().join("")).toBe("b a");
    } );
    /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value (the invalid partion)", function() {
      from.string = NaN;
      expect(function(){
        from.numList();
      } ).toThrow();
      expect(function(){
        from.strList();
      } ).toThrow();      
      
      from.string = "currentColor";
      expect(from.numList()).toEqual([]);
      expect(from.strList()[0]).toBe("currentColor");

      from.string = "eE";
      expect(from.numList()).toEqual([]);
      expect(from.strList()[0]).toBe("eE");
      expect(from.strList()[0]).toBe("eE");
    } )
  } );
  describe("A $to object", function() {
    var from = base("$from");
     beforeEach( function() {
       from = base("$from").up();
       from.up("$to");
       from.string = "";
     } );
    /*境界条件を調べておく (limit value analysis)*/
    it("should be this for the value  (limit value analysis)", function() {
      expect(from.$to instanceof from.constructor).toBeTruthy();
      expect(from.up().call()).toBe(from.$1.numList);
      expect(from.$to.up().call()).toBe(from.$to.$1.numList);
    } );
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value (the valid partion)", function() {
      from.up("$to");
      from.$to.from = from;
      from.$to.string = "12cm-7";
      expect(from.$to.numList().join(",")).toBe("12,-7");
      expect(from.$to.strList().toString()).toBe("cm");
      
      from.string = "7cm+8";
      from.$to.call();
      expect(from.call()).toBe(from.numList);
      expect(from.$to.numList.join(",")).toBe("12,-7");
      expect(from.$to.strList.join("")).toBe("cm");
      expect(from.numList.join(",")).toBe("7,8");
      expect(from.strList.join("")).toBe("cm");
      expect(from.$to.from).toBe(from.numList);

    } );
    /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value (the invalid partion)", function() {
      from.call();
      from.up("$to").mix( function() {
        this.string = "12cm";
        this.call();
        expect(this.numList).toEqual([]);
        expect(this.strList).toBeNull();
      } );
    } );
    
    describe("An advance method", function() {
      var from = base("$from");
       beforeEach( function() {
         from = base("$from").up();
         from.string = "";
         from.up("$to");
         from.$to.from = from;
       } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect(from.advance()).toBe("");
        expect(from.$to.advance()).toBe("");
        expect(from.$to.advance(0)).toBe("");
        expect(from.$to.advance(1)).toBe("");
        expect(function(){
          from.$to.advance(1.01);
        }).toThrow("An Invalid Number Error");
        expect(function(){
          from.$to.advance(-0.01);
        }).toThrow("An Invalid Number Error");
        
        from.string = "0";
        from.$to.string = "1";
        expect(from.$to.call()).toBe(from.$to.numList);
        expect(from.$to.numList[0]).toBe(1);
        expect(from.$to.strList).toBeNull();
        expect(from.numList[0]).toBe(0);
        expect(from.strList).toBeNull();
        expect(from.advance(0)).toBe("");
        expect(from.$to.from).toBe(from.numList);
        expect(from.$to.advance(0)).toBe("0");       
        expect(from.call()).toBe(from.numList);
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion)", function() {
        var deg = 3;
        
        from.string = "0s";
        from.$to.string = "1s";
        expect(from.$to.call()).toBe(from.$to.numList);
        expect(from.$to.numList[0]).toBe(1);
        expect(from.$to.strList[0]).toBe("");
        expect(from.numList[0]).toBe(0);
        expect(from.strList[0]).toBe("");
        expect(from.advance(0)).toBe("");
        expect(from.$to.from).toBe(from.numList);
        expect(from.$to.advance(0)).toBe("0s");
        from.$to.degit = deg;
        for (var i=0;i<1;i+=0.01) {
          expect(from.$to.advance(i)).toBe(i.toFixed(deg)+"s");
        }
        expect(from.call()).toBe(from.numList);
        
        from = base("$from").up();
        from.up("$to");
        from.string = "a0S";
        from.$to.string = "a1S";
        from.$to.from = from;
        expect(from.$to.call()).toBe(from.$to.numList);
        expect(from.$to.numList[0]).toBe(1);
        expect(from.$to.strList[0]).toBe("a");
        expect(from.numList[0]).toBe(0);
        expect(from.strList[0]).toBe("a");
        expect(from.advance(0)).toBe("");
        expect(from.$to.from).toBe(from.numList);
        expect(from.$to.advance(0)).toBe("a0S");

        from.$to.degit = deg;
        for (var i=0;i<1;i+=0.01) {
          expect(from.$to.advance(i)).toBe("a" +i.toFixed(deg)+ "S");
        }
        expect(from.call()).toBe(from.numList);
        
        from = base("$from").up();
        from.up("$to");
        from.string = "a-10s1.5";
        from.$to.string = "a10s-3";
        from.$to.from = from;
        from.$to.call();
        from.$to.degit = 1;
        expect(from.$to.advance(0)).toBe("a-10.0s1.5");
        expect(from.$to.advance(0.4)).toBe("a-2.0s-0.3");
        expect(from.$to.advance(1)).toBe("a10.0s-3.0");
        
        from.$to.additive[0] = 1;
        from.$to.accumulate[1] = 2;
        expect(from.$to.advance(0.4)).toBe("a-1.0s1.7");
        from.$to.additive[0] = 0.5;
        from.$to.accumulate[1] = 0.8;
        expect(from.$to.advance(1)).toBe("a10.5s-2.2");
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion)", function() {
        expect(function(){
          from.$to.advance(10);
        }).toThrow("An Invalid Number Error");
        expect(function(){
          from.$to.advance(-10);
        }).toThrow("An Invalid Number Error");
      } );
    } )
  } );
  describe("A distance method", function() {
      var from = base("$from");
       beforeEach( function() {
         from = base("$from").up();
         from.string = "";
         from.up("$to");
       } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect(from.distance()).toBe(0)
        expect(from.$to.distance()).toBe(0);
        
        from.string = "0";
        from.$to.string = "1";
        expect(from.distance()).toBe(0);
        expect(from.$to.distance(from)).toBe(1);
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion)", function() {
        from.string = "s 0 s 12";
        from.$to.string = "s 0 s 0";
        expect(from.distance()).toBe(0);
        expect(from.$to.distance(from)).toBe(12);
        expect(from.$to.distance(from)).toBe(12);
        expect(from.$to.distance(from.call())).toBe(12);
  
        from = base("$from").up();
        from.up("$to");
        from.string = "rgb(1, 0, 0)";
        from.$to.string = "rgb(0, 0, 1)";
        expect(from.distance()).toBe(0);
        expect(from.$to.distance(from)).toBe(Math.sqrt(2));
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion)", function() {
        from.string = "s";
        from.$to.string = "s";
        expect(from.$to.distance(from)).toBe(0);
      } );
  } );
  describe("A setAdditive method", function() {
      var from = base("$from");
       beforeEach( function() {
         from = base("$from").up();
         from.string = "";
         from.up("$to");
       } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect(from.setAdditive()).toBe(0);
        expect(from.setAdditive("")).toBe(0);
        expect(from.additive).toEqual([0]);
        expect(from.setAdditive("1")).toEqual([1]);
        expect(from.additive).toEqual([1]);
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion)", function() {
        expect(from.setAdditive("1 2, 3")).toEqual([1, 2, 3]);
        expect(from.additive).toEqual([1, 2, 3]);
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion)", function() {
      } );
  } );
  describe("A setAccumulate method", function() {
      var from = base("$from");
       beforeEach( function() {
         from = base("$from").up();
         from.string = "0 1";
         from.up("$to");
         from.call();
       } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect(from.setAccumulate()).toBe(0);
        expect(from.setAccumulate(0)).toBe(0);
        expect(from.accumulate).toEqual([0, 0]);
        expect(from.setAccumulate(1)).toEqual([0, 1]);
        expect(from.accumulate).toEqual([0, 1]);
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion)", function() {
        expect(from.setAccumulate(2)).toEqual([0, 2]);
        expect(from.accumulate).toEqual([0, 2]);
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion)", function() {
        expect(from.setAccumulate(NaN)).toEqual(0);
      } );
  } );
  describe("A $calcMode object", function() {
    var calc = base("$calcMode"),
        to = calc.to,
        from;
     beforeEach( function() {
       calc = base("$calcMode").up();
       calc.to = base("$from").up().mix( {string: "1"} );
       from = calc.to.from = base("$from").up().mix( {string: "0"} );
     } );
    /*境界条件を調べておく (limit value analysis)*/
    it("should be this for the value  (limit value analysis)", function() {
      expect(calc.mode).toBe("linear");
      expect(calc.keyTime).toBe(1);
      expect(calc.keySplines).toBeNull();
      expect(calc.string).toBe("");

      expect(calc.call()(0)).toBe("0");
      expect(calc.keyTime).toBe(1);
      expect(calc.call()(1)).toBe("1");
      
      calc.keyTime = 0;
      expect(calc.call()(1)).toBe("0");
      
      /*paced mode*/
      calc.mode = "paced";
      expect(calc.norm).toBe(1);
      calc.to.from = from;
      expect(calc.call()(0)).toBe("0");
      expect(calc.keyTime).toBe(1);
      calc.to.from = from;
      expect(calc.call()(1)).toBe("1");
      
      calc.keyTime = 0;
      calc.to.from = from;
      expect(calc.call()(1)).toBe("1");
      
      /*discrete mode*/
      calc.mode = "discrete";
      calc.to.from = from;
      calc.keyTime = 1;
      expect(calc.call()(0)).toBe("0");
      expect(calc.call()(1)).toBe("0");
    } );
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value (the valid partion)", function() {
      calc.mode = "linear";
      calc.keyTime = 0.5;
      calc.to.degit = 1;
      expect(calc.call()(0.2)).toBe("0.4");
      expect(calc.call()(0.3)).toBe("0.6");
      /*もう一度確かめる*/
      expect(calc.call()(0.2)).toBe("0.4");
      
      calc = base("$calcMode").up();
      calc.keyTime = 0.2;
      calc.to = base("$from").up();
      calc.to.from = base("$from").up();    
      calc.to.from.string = "0s";
      calc.to.string = "1s";
      calc.to.degit = 1;
      expect(calc.call()(0.1)).toBe("0.5s");

      calc = base("$calcMode").up();
      calc.keyTime = 0.5;
      calc.to = base("$from").up();
      calc.to.from = base("$from").up();    
      calc.to.from.string = "rgb(100, 20, 32)";
      calc.to.string = "rgb(0, 10, 50)";
      expect(calc.call()(0.25)).toBe("rgb(50, 15, 41)");
      
      /*paced mode*/
      calc.to = base("$from").up();
      calc.to.from = base("$from").up();    
      calc.mode = "paced";
      calc.norm = 100;
      calc.to.from.string = "0s";
      calc.to.string = "20s";
      calc.to.degit = 1;
      expect(calc.call()(0.1)).toBe("10.0s");
      expect(calc.keyTime).toBe(0.2);

      calc.to = base("$from").up();
      calc.to.from = base("$from").up();    
      calc.mode = "paced";
      calc.norm = 100;
      calc.to.from.string = "rgb(0, 0, 20)";
      calc.to.string = "rgb(0, 0, 0)";
      expect(calc.call()(0.1)).toBe("rgb(0, 0, 10)");
      expect(calc.keyTime).toBe(0.2);
      
      /*discrete mode*/
      calc.to = base("$from").up();
      calc.to.from = base("$from").up();    
      calc.mode = "discrete";
      calc.keyTime = 0.5;
      calc.to.degit = 1;
      calc.to.string = "1";
      calc.to.from.string = "0.5";
      expect(calc.call()(0.2)).toBe("0.5");
      expect(calc.call()(0.3)).toBe("0.5");
      /*もう一度確かめる*/
      expect(calc.call()(0.2)).toBe("0.5");
    } );
    /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value (the invalid partion)", function() {
      calc.keyTime = null;
      expect(calc.call()(1)).toBe(calc.string);
      
      calc.keyTime = 1/0;
      expect(calc.call()(1)).toBe(calc.string);

      expect(calc.call()()).toBe(calc.string);

      calc = base("$calcMode").up();
      calc.mode = "paced";
      calc.to.from = from;
      expect(calc.call()()).toBe(calc.string);
      
      calc = base("$calcMode").up();
      calc.mode = "discrete";
      expect(calc.call()()).toBe(calc.string);
    } );
    
    /*splineモードの境界条件を調べておく (limit value analysis)*/
    it("should be this for the value  (spline mode limit value analysis)", function() {
      /*3次ベジェ曲線の数式はこのページを参考にした　http://opentype.jp/fontguide_doc3.htm*/
      var x = 0,
          y = 0,
          bezier = function (x1, y1, x2, y2, x3, y3, x4, y4) {
            return function (t) {
              x = (x4-3*(x3-x2)-x1)*t*t*t + 3*(x3-2*x2+x1)*t*t + 3*(x2-x1)*t + x1;
              y = (y4-3*(y3-y2)-y1)*t*t*t + 3*(y3-2*y2+y1)*t*t + 3*(y2-y1)*t + y1;
              return y;
            };
          };
      expect(calc.keySplines).toBeNull();
      calc.mode = "spline";
      expect( calc.call()("undef")).toBe(Math.PI);
      calc.keySplines = [0, 0, 1, 1];
      calc.to.degit = 1;
      calc.to.from = from;
      expect(calc.call()(0)).toBe(bezier(0,0, 0,0, 1,1, 1,1)(0)+".0");
      calc.to.from = from;
      expect(calc.call()(1)).toBe(bezier(0,0, 0,0, 1,1, 1,1)(1)+".0");
      calc.to.from = from;
      expect(calc.call()(0.5)).toBe(bezier(0,0, 0,0, 1,1, 1,1)(0.5)+"");
      
      df(0,0, 0,0, 1,1, 1,1, 0.1);
      df(0,0, 0,0, 1,1, 1,1, 0.5);
      df(0,0, 0,0, 1,1, 1,1, 0.8);
      df(0,0, 0,0, 1,1, 1,1, 0.9);
      df(0,0, 0.75,0, 0,0.75, 1,1, 0.1);
      df(0,0, 0.75,0, 0,0.75, 1,1, 0.5);
      df(0,0, 0.75,0, 0,0.75, 1,1, 0.8);
      df(0,0, 0.75,0, 0,0.75, 1,1, 0.9);
      function df (x1, y1, x2, y2, x3, y3, x4, y4, t) {
      /*自作のニュートン法*/
        var a = y4-3*(y3-y2)-y1,
            b = 3*(y3-2*y2+y1),
            c = 3*(y2-y1),
            d = y1 - bezier.apply(null, arguments)(t);
        expect(Math.abs(Math.qubicnewton(a, b, c, d, t) - t)).toBeLessThan(1e-5);
      };
    } );
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value (the valid partion on a spline mode )", function() {
      var x = 0,
          y = 0,
          bezier = function (x1, y1, x2, y2, x3, y3, x4, y4) {
            return function (t) {
              return {
                  x: (x4-3*(x3-x2)-x1)*t*t*t + 3*(x3-2*x2+x1)*t*t + 3*(x2-x1)*t + x1,
                  y: (y4-3*(y3-y2)-y1)*t*t*t + 3*(y3-2*y2+y1)*t*t + 3*(y2-y1)*t + y1
                };
            };
          };
      calc.mode = "spline";
      calc.keySplines = [0, 0.5, 0.5, 1];
      calc.to.degit = 1;
      var b = bezier(0,0, 0,0.5, 0.5,1, 1,1);
      expect(calc.call()(0)).toBe(b(0).y+".0");
      calc.to.from = from;
      expect(calc.call()(1)).toBe(b(1).y+".0");
      calc.to.from = from;
      expect(calc.call()( b(0.5).x )).toBe(b(0.5).y.toFixed(1));
      
      var ff = function(k) {
        calc.keySplines = k;
        calc.to.degit = 10;
        var b = bezier(0,0, k[0],k[1], k[2],k[3], 1,1),
            epsilon = 1e-5; //誤差
        expect(calc.call()(0)).toBe(b(0).y.toFixed(10));
        calc.to.from = from;
        expect(calc.call()(1)).toBe(b(1).y.toFixed(10));
        calc.to.from = from;
        b = b(Math.random());
        expect(Math.abs(calc.call()(b.x) - b.y.toFixed(10))).toBeLessThan(epsilon);
      };
      for (var i=0;i<10000;++i) {
        var rand = [Math.random(), Math.random(), Math.random(), Math.random()].sort(function(a,b){return a-b;});
        ff(rand);
      }
    } );
    /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value (the invalid partion on a spline mode )", function() {
      calc.mode = "spline";
      calc.keySplines = [0, NaN, 1, 1];
      calc.to.degit = 1;
      calc.to.from = from;
      expect( calc.up().call()("undef")).toBe(Math.PI);

      
      calc.keySplines = [0, 0, 1, 2];
      calc.to.degit = 1;
      calc.to.from = from;
      expect( calc.up().call()("undef")).toBe(Math.PI);
      
      calc.keySplines = null;
      calc.to.degit = 1;
      calc.to.from = from;
      expect( calc.up().call()("undef")).toBe(Math.PI);
    } );
  } );
  describe("A $attribute object", function() {
    describe("A push method", function() {
      var attr, s;
      beforeEach( function() {
        attr = base("$calcMode").$attribute.up("width");
        base("$frame").timelines.length = 0;
        s = document.createElementNS("http:///www.w3.org/2000/svg", "animate");
      } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect(attr.element).toBeNull();
        expect(attr.push()).toBeNull();
        expect(attr.element).toBeNull();
        expect(base("$frame").timelines.length).toBe(0);
        
        expect(attr.push(s)).toBeNull();
        expect(attr.element).toBeNull();
        expect(base("$frame").timelines.length).toBe(0);
        
        var p = document.createElement("g");
        p.appendChild(s);
        expect(attr.push(s)).toBeNull();
        expect(attr.element).toBe(p);
        expect(base("$frame").timelines.length).toBe(0);
        
        s.setAttribute("end", "0");
        check("from", 1);
        check("to", 2);
        check("by", 3);
        check("values", 4);
        function check(attrName, num) {
          s.setAttribute(attrName, "1");
          expect(s.hasAttributeNS(null, attrName)).toBeTruthy();
          var l = attr.push(s);
          expect(attr.element).toBe(p);
          var timelines = base("$frame").timelines;
          expect(timelines.length).toBe(num);
          var line = timelines[num-1];
          expect(line.string).toBe("0");
          expect(line).toBe(l); //タイムラインのオブジェクトを返す
          var act = line.$activate;
          expect(act.dur).toBeNull();
          expect(act.end).toBe(0);
          expect(act.repeatCount).toBeNull();
          expect(act.repeatDur).toBeNull();
          expect(act.min).toBe("0");
          expect(act.max).toBe("indefinite");
          expect(act.simpleDur).toBeNull();
          
          s.removeAttribute(attrName);
          expect(s.hasAttributeNS(null, attrName)).toBeFalsy();
          attr.push(s);
          expect(attr.element).toBe(p);
          expect(timelines.length).toBe(num);
        };
          
        /*targetElement属性のサポート*/
        var p2 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        document.documentElement.appendChild(p2);
        p2.setAttributeNS(null, "id", "p23");
        s.setAttributeNS(null, "targetElement", "p23");
        attr.push(s);
        expect(attr.element).toBe(p2);
        
        /*ハイパーリンクのサポート*/
        var p3 = document.createElementNS("http://www.w3.org/2000/svg", "a");
        document.documentElement.appendChild(p3);
        p3.setAttributeNS(null, "id", "p34");
        s.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#p34");
        attr.push(s);
        expect(attr.element).toBe(p3);
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion on a spline mode )", function() {
        s.setAttribute("from", "1");
        var p = document.createElement("g");
        p.appendChild(s);
        var values = [ "0",
                      "0", null, null, null, 
                      "0", "indefinite", null
                    ];
        values[7] = 0;
        check2("dur", "0");
        check2("begin", "0");
        values[0] = "1";
        check2("begin", "1");
        values[2] = 0;
        check2("end", "0");
        values[3] = "0";
        check2("repeatCount", "0");
        values[4] = "0";
        check2("repeatDur", "0");
        values[5] = "0";
        check2("min", "0");
        values[6] = "0";
        check2("max", "0");
        values[0] = "12";
        check2("begin", "12");
        values[7] = 1000 * base("$frame").fpms;
        values[1] = "1";
        check2("dur", "1");
        function check2(attrName, value) {
          s.setAttribute(attrName, value);
          expect(s.hasAttributeNS(null, attrName)).toBeTruthy();
          attr.push(s);
          expect(attr.element).toBe(p);
          var timelines = base("$frame").timelines;
          var line = timelines[timelines.length-1];
          expect(line.string).toBe(values[0]);
          var act = line.$activate;
          expect(act.dur).toBe(values[1]);
          expect(act.end).toBe(values[2]);
          expect(act.repeatCount).toBe(values[3]);
          expect(act.repeatDur).toBe(values[4]);
          expect(act.min).toBe(values[5]);
          expect(act.max).toBe(values[6]);
          expect(act.simpleDur).toBe(values[7]);
        };
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion )", function() {
        var p = document.createElement("g");
        p.appendChild(s);
        
        s.setAttributeNS(null, "begin", "1");
        attr.push(s);
        var timelines = base("$frame").timelines;
        expect(timelines.length).toBe(0);
        s.setAttributeNS(null, "from", "1");
        attr.push(s);
        expect(timelines.length).toBe(1);
        expect(attr.push(12)).toBeNull();
      } );
    } );
    describe("A setValues method", function() {
      var attr, s;
      beforeEach( function() {
        attr = base("$calcMode").$attribute.up("width");
        base("$frame").timelines.length = 0;
        s = document.createElement("animate");
      } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect(attr.$from).not.toBeUndefined();
        expect(attr.setValues()).toBeNull();
        expect(attr.setValues("")).toBeNull();

        expect(attr.setValues("0;1")[0].to.string).toBe("1");
        expect(attr.setValues("0;1")[0].to.from.string).toBe("0");
        expect(attr.setValues("0;1", "0", "1", "1")[0].to.from.string).toBe("0");
        expect(attr.setValues("0;1", null, "1", "0")[0].to.from.string).toBe("0"); 
               
        /*from-to アニメーション*/
        expect(attr.setValues(null, "0", "1")[0].to.string).toBe("1");
        expect(attr.setValues(null, "0", "1")[0].to.from.string).toBe("0");
        
        /*from-by アニメーション*/
        expect(attr.setValues(null, "1", null, "1")[0].to.string).toBe("1");
        expect(attr.setValues(null, "1", null, "1")[0].to.from[0]).toBe(1);
        expect(attr.setValues(null, "1", null, "1")[0].to.numList[0]).toBe(2);
        
        /*fromなしto アニメーション*/
        expect(attr.setValues(null, null, "1")[0].to.string).toBe("1");
        expect(attr.setValues(null, null, "1")[0].to.from.string).toBe("0");
        var aset = attr.setValues(null, null, "1")[0].to;
        aset.call();
        expect(aset.from[0]).toBe(0);
        
        /*fromなしby アニメーション*/
        expect(attr.setValues(null, null, null, "1")[0].to.string).toBe("1");
        expect(attr.setValues(null, null, null, "1")[0].to.from[0]).toBe(0);
        var aset = attr.setValues(null, null, null, "1")[0].to;
        aset.call();
        expect(aset.from[0]).toBe(0);
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion on a spline mode )", function() {
        attr.$from.degit = 1;
        var setv = attr.setValues("0;1")[0].call();
        expect(setv(0.5)).toBe("0.5");
        expect(setv(1)).toBe("1.0");
        
        setv = attr.setValues(" 0;1; 2 ")[0].call();
        expect(setv(0.5)).toBe("0.5");
        expect(setv(1)).toBe("1.0");
        setv = attr.setValues("0;1;2")[1].call();
        expect(setv(0.4)).toBe("1.4");
        expect(setv(1)).toBe("2.0");
        
        attr.$from.degit = 2;
        setv = attr.setValues("1;1;1;1 ;1;15.1")[4].call();
        expect(setv(0.5)).toBe("8.05");
        expect(setv(1)).toBe("15.10");
        
        var v = attr.setValues("1;1;2;1;1;15.1");
        setv = v[4].mix( {
         keyTime: 0.1
        } ).call();
        expect(setv(0.05)).toBe("8.05");
        expect(setv(0.1)).toBe("15.10");
        setv = v[3].mix( {
         keyTime: 0.1
        } ).call();
        expect(setv(0.01)).toBe("1.00");
        expect(setv(0.1)).toBe("1.00");
        setv = v[2].mix( {
         keyTime: 0.5
        } ).call();
        expect(setv(0.25)).toBe("1.50");
        expect(setv(0.5)).toBe("1.00");
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion on a spline mode )", function() {
        attr.$from.degit = 1;
        expect(attr.setValues("")).toBeNull();
        expect(attr.setValues(null, null, null, null)).toBeNull();
      } );
    } );
    describe("A setKey method", function() {
      var attr, s;
      beforeEach( function() {
        attr = base("$calcMode").$attribute.up("width");
        base("$frame").timelines.length = 0;
        s = document.createElement("animate");
        document.createElement("g").appendChild(s);
      } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect(attr.setKey(s)).toBeNull();
        
        s.setAttributeNS(null, "from", "0");
        attr.setKey(s);
        s.setAttributeNS(null, "to", "0");
        expect(attr.setKey(s)[0].to.from.string).toBe("0");
        expect(attr.setKey(s)[0].to.string).toBe("0");
        s.setAttributeNS(null, "by", "0");
        attr.setKey(s);
        s.setAttributeNS(null, "values", "0;2");
        expect(attr.setKey(s)[0].to.from.string).toBe("0");
        expect(attr.setKey(s)[0].to.string).toBe("2");
        
        s.setAttributeNS(null, "keyTimes", "0;0.1");
        expect(attr.setKey(s)[0].keyTime).toBe(0.1);
        
        s.setAttributeNS(null, "keySplines", "0,0.1,0.3,0.4");
        expect(attr.setKey(s)[0].keySplines[0]).toBe(0);
        expect(attr.setKey(s)[0].keySplines[1]).toBe(0.1);
        expect(attr.setKey(s)[0].keySplines[2]).toBe(0.3);
        expect(attr.setKey(s)[0].keySplines[3]).toBe(0.4);
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion on a spline mode )", function() {
        s.setAttributeNS(null, "values", "0;2;12;30");
        expect(attr.setKey(s)[0].keyTime.toFixed(3)).toBe("0.333");
        s.setAttributeNS(null, "keyTimes", "0;0.1;0.2;1");
        expect(attr.setKey(s)[0].keyTime).toBe(0.1);
        expect(attr.setKey(s)[1].keyTime).toBe(0.1);
        expect(attr.setKey(s)[2].keyTime).toBe(0.8);
        s.setAttributeNS(null, "values", " 0; 2;12 ;30 ");
        s.setAttributeNS(null, "keyTimes", " 0; 0.1; 0.2 ; 1 ");
        expect(attr.setKey(s)[0].keyTime).toBe(0.1);
        expect(attr.setKey(s)[1].keyTime).toBe(0.1);
        expect(attr.setKey(s)[2].keyTime).toBe(0.8);
        
        s.setAttributeNS(null, "keySplines", " 0,0.1,0.3,1; 0.1,0.4,0.5,0.7; 0.2,0.2,0.1  , 1 ;");
        f(0, 0,0.1,0.3,1);
        f(1, 0.1,0.4,0.5,0.7);
        f(2, 0.2,0.2,0.1,1);
        function f (i, a, b, c, d) {
          var splines = attr.setKey(s)[i].keySplines;
          expect(splines[0]).toBe(a);
          expect(splines[1]).toBe(b);
          expect(splines[2]).toBe(c);
          expect(splines[3]).toBe(d);
        };
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion on a spline mode )", function() {
        s.setAttributeNS(null, "keyTimes", "0;0.1;0.2;1");
        expect(attr.setKey(s)).toBeNull();
        s.setAttributeNS(null, "values", "0;2;12");
        expect(attr.setKey(s)).toBeNull();
        s.setAttributeNS(null, "values", "0;2;12;20");
        s.setAttributeNS(null, "keyTimes", "0;0.1;0.2");
        expect(attr.setKey(s)).toBeNull();
      } );
    } );
  } );
  describe("A $setElemenet object", function() {
    describe("A timeline property", function() {
      var $set, ele, frame;
      beforeEach( function() {
        $set = base("$calcMode").$attribute.$setElement.up();
        var p = document.createElementNS("http://www.w3.org/2000/svg", "g");
        ele = document.createElementNS("http://www.w3.org/2000/svg", "set");
        p.appendChild(ele);
        frame = base("$frame");
      } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect($set.timeline).toBe(frame.$begin);
        
        $set.init();
        expect($set.timeline).toBe(frame.$begin);
        expect($set.element).toBeNull();
      } );
    } );
      describe("An init method", function() {
      var $set, ele, frame;
      beforeEach( function() {
        $set = base("$calcMode").$attribute.$setElement.up();
        var p = document.createElementNS("http://www.w3.org/2000/svg", "g");
        ele = document.createElementNS("http://www.w3.org/2000/svg", "set");
        p.appendChild(ele);
        frame = base("$frame");
      } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect($set.to).toBe("");
        expect($set.attrName).toBe("");
        expect($set.defaultValue).toBe("");
        expect($set.isDefault).toBeFalsy();
        expect($set.attrNameSpace).toBeNull();
        $set.init();
        expect($set.timeline).toBe(frame.$begin);
        $set.init(ele);
        expect($set.to).toBe("");
        expect($set.attrName).toBe("");
        expect($set.isDefault).toBeFalsy();
        expect($set.attrNameSpace).toBeNull();
        expect($set.timeline).toBe(frame.$begin);
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion on a spline mode )", function() {
        ele.setAttributeNS(null, "to", "t1");
        $set.init(ele);
        expect($set.to).toBe("t1");
        expect($set.attrName).toBe("");
        expect($set.defaultValue).toBe("");

        ele.setAttributeNS(null, "attributeName", "tt1");
        $set.init(ele);
        expect($set.to).toBe("t1");
        expect($set.attrName).toBe("tt1");
        expect($set.defaultValue).toBe("");

        ele.parentNode.setAttributeNS(null, "tt1", "undef");
        $set.init(ele);
        expect($set.defaultValue).toBe("undef");
        expect($set.isDefault).toBeTruthy();

        ele.setAttributeNS(null, "attributeName", "font-size");
        ele.parentNode.style.setProperty("font-size", "12px");
        $set.init(ele);
        expect($set.defaultValue).toBe("12px");
        expect($set.isDefault).toBeFalsy();
        
        ele.setAttributeNS(null, "attributeName", "xlink:href");
        $set.init(ele);
        expect($set.to).toBe("t1");
        expect($set.attrName).toBe("xlink:href");
        expect($set.defaultValue).toBe("");
        ele.parentNode.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "undef");
        $set.init(ele);
        expect($set.attrNameSpace).toBe("http://www.w3.org/1999/xlink");
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion on a spline mode )", function() {
        $set.init(null);
        expect($set.to).toBe("");
        expect($set.attrName).toBe("");
        expect($set.defaultValue).toBe("");

        $set.init(12);
        expect($set.to).toBe("");
        expect($set.attrName).toBe("");
        expect($set.defaultValue).toBe("");
      } );
    } );
    describe("Frame Set", function() {
      var $set, ele, frame;
      beforeEach( function() {
        $set = base("$calcMode").$attribute.$setElement.up();
        var p = document.createElementNS("http://www.w3.org/2000/svg", "g");
        ele = document.createElementNS("http://www.w3.org/2000/svg", "set");
        p.appendChild(ele);
        frame = base("$frame");
        frame.timelines.length = 0; //配列の初期化
        frame.startTime = Date.now();
        frame.setFrame(0);
      } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect($set.isEnd).toBeFalsy();
        ele.setAttributeNS(null, "dur", "1s");
        ele.setAttributeNS(null, "attributeName", "fill");
        ele.setAttributeNS(null, "to", "red");
        $set.init(ele);
        expect($set.timeline).not.toBe(frame.$begin);
        frame.setFrame(0);
        expect(ele.parentNode.getAttributeNS(null, "fill")).toBe("red");
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion)", function() {
        ele.setAttributeNS(null, "begin", "1s");
        ele.setAttributeNS(null, "dur", "1s");
        ele.setAttributeNS(null, "attributeName", "fill");
        ele.setAttributeNS(null, "to", "red");
        $set.init(ele);
        var f = function(num) {
          frame.setFrame(num);
          expect(ele.parentNode.getAttributeNS(null, "fill") || null).toBeNull();
        }
        f(0);
        f(1);
        f(23);
        frame.setFrame(24);
        expect(ele.parentNode.getAttributeNS(null, "fill")).toBe("red");
        frame.setFrame(25);
        expect(ele.parentNode.getAttributeNS(null, "fill")).toBe("red");
        f(48);
        f(49);
        
        ele.setAttributeNS(null, "fill", "freeze");
        $set.init(ele);
        f(0);
        f(1);
        f(23);
        frame.setFrame(24);
        expect(ele.parentNode.getAttributeNS(null, "fill")).toBe("red");
        frame.setFrame(25);
        expect(ele.parentNode.getAttributeNS(null, "fill")).toBe("red");
        frame.setFrame(48);
        expect(ele.parentNode.getAttributeNS(null, "fill") || null).toBe("red");
        frame.setFrame(49);
        expect(ele.parentNode.getAttributeNS(null, "fill") || null).toBe("red");
        ele.setAttributeNS(null, "begin", "1s");
        ele.setAttributeNS(null, "attributeName", "fill");
        ele.setAttributeNS(null, "to", "red");
        /*eleにはdur属性やendなどが設定されていなくとも、アニメーションが有効*/
        $set.init(ele);
        var f = function(num) {
          frame.setFrame(num);
          expect(ele.parentNode.getAttributeNS(null, "fill") || null).toBe("red");
        }
        f(0);
        f(1);
        f(23);
        f(24);
        f(25);
        f(48);      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion)", function() {

      } );
    } );
  } );
    describe("A $animateElemenet object", function() {
      describe("An init method", function() {
        var $animate, ele, frame;
        beforeEach( function() {
          $animate = base("$calcMode").$attribute.$setElement.$animateElement.up();
          var p = document.createElementNS("http://www.w3.org/2000/svg", "g");
          ele = document.createElementNS("http://www.w3.org/2000/svg", "animate");
          p.appendChild(ele);
          frame = base("$frame");
          frame.timelines.length = 0;
          frame.startTime = Date.now();
          frame.setFrame(0);
        } );
        /*境界条件を調べておく (limit value analysis)*/
        it("should be this for the value  (limit value analysis)", function() {
          $animate.init();
          
          ele.setAttributeNS(null, "begin", "1s");
          ele.setAttributeNS(null, "dur", "1s");
          ele.setAttributeNS(null, "attributeName", "d");
          ele.setAttributeNS(null, "from", "M20 0 L20 30");
          ele.setAttributeNS(null, "to", "M20 20 L10 30");
          $animate.init(ele);
          
          frame.setFrame(0);
          var p = ele.parentNode;
          /*getAttributeNSメソッドは、IE11では空文字列を返す（DOM 2に準拠)のに対して、
           * 他のブラウザではnullを返すため、その対策をする*/
          expect(p.getAttributeNS(null, "d") || null).toBeNull();
          
          function f(fr, result) {
            frame.setFrame(fr);
            expect(p.getAttributeNS(null, "d") || "").toBe(result);
          };
          
          f(24, "M20.0 0.0 L20.0 30.0");
          f(36, "M20.0 10.0 L15.0 30.0");
          f(48, "");
                    
          ele.setAttributeNS(null, "fill", "freeze");
          $animate.init(ele);
          f(24, "M20.0 0.0 L20.0 30.0");
          f(36, "M20.0 10.0 L15.0 30.0");
          f(48, "M20.0 20.0 L10.0 30.0");
          
          frame.timelines.length = 0;
          ele.setAttributeNS(null, "calcMode", "discrete");
          $animate.init(ele);
          expect($animate.mode).toBe("discrete");
          f(24, "M20.0 0.0 L20.0 30.0");
          f(25, "M20.0 0.0 L20.0 30.0");
          f(37, "M20.0 20.0 L10.0 30.0");
          f(48, "M20.0 20.0 L10.0 30.0");
        } );
        /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
        it("should be this for the value (the valid partion )", function() {
          /*24FPSが前提*/
          ele.setAttributeNS(null, "begin", "0s");
          ele.setAttributeNS(null, "dur", "100s");
          ele.setAttributeNS(null, "attributeName", "d");
          ele.setAttributeNS(null, "fill", "freeze");
          ele.setAttributeNS(null, "from", "M20 0 L20 30");
          ele.setAttributeNS(null, "to", "M20 2400 L20 30");
          $animate.init(ele);
          
          var p = ele.parentNode;
          expect(p.getAttributeNS(null, "d") || null).toBeNull();
          
          function f(fr, result) {
            frame.setFrame(fr);
            expect(p.getAttributeNS(null, "d")).toBe(result);
          };
          
          for (var i=0;i<2400;++i) {
            f(i, "M20.0 " +i+ ".0 L20.0 30.0");
          }
          f(2401, "M20.0 2400.0 L20.0 30.0");
          
          
          frame.timelines.length = 0;
          ele.setAttributeNS(null, "begin", "0s");
          ele.setAttributeNS(null, "dur", "1s");
          ele.setAttributeNS(null, "repeatDur", "2s");
          ele.setAttributeNS(null, "attributeName", "d");
          ele.setAttributeNS(null, "fill", "freeze");
          ele.setAttributeNS(null, "from", "M20 0 L20 30");
          ele.setAttributeNS(null, "to", "M20 24 L20 30");
          $animate.init(ele);
          f(23, "M20.0 23.0 L20.0 30.0");
          f(24, "M20.0 0.0 L20.0 30.0");
          f(25, "M20.0 1.0 L20.0 30.0");
          f(48, "M20.0 24.0 L20.0 30.0");

          frame.timelines.length = 0;
          ele.setAttributeNS(null, "begin", "0s");
          ele.setAttributeNS(null, "dur", "2s");
          ele.setAttributeNS(null, "attributeName", "d");
          ele.setAttributeNS(null, "fill", "freeze");
          ele.setAttributeNS(null, "values", "M20 0 L20 30;M20 24 L20 30;M20 26.4 L20 30");
          $animate.init(ele);
          f(0, "M20.0 0.0 L20.0 30.0");
          f(1, "M20.0 1.0 L20.0 30.0");
          f(24, "M20.0 24.0 L20.0 30.0");
          f(25, "M20.0 24.1 L20.0 30.0");
          f(47, "M20.0 26.3 L20.0 30.0");
          f(48, "M20.0 26.4 L20.0 30.0");
          f(49, "M20.0 26.4 L20.0 30.0");
          f(50, "M20.0 26.4 L20.0 30.0");
          
          frame.timelines.length = 0;
          ele.setAttributeNS(null, "begin", "0s");
          ele.setAttributeNS(null, "end", "2s");
          ele.removeAttributeNS(null, "dur"); //単純継続時間が設定されていない場合
          ele.removeAttributeNS(null, "repeatDur");
          ele.setAttributeNS(null, "attributeName", "d");
          ele.setAttributeNS(null, "fill", "freeze");
          ele.setAttributeNS(null, "values", "M20 0 L20 30;M20 24 L20 30;M20 26.4 L20 30");
          $animate.init(ele);
          f(0, "M20.0 0.0 L20.0 30.0");
          f(1, "M20.0 0.0 L20.0 30.0");
          f(24, "M20.0 0.0 L20.0 30.0");
          f(25, "M20.0 0.0 L20.0 30.0");
          f(47, "M20.0 0.0 L20.0 30.0");
          f(48, "M20.0 0.0 L20.0 30.0");
          f(49, "M20.0 0.0 L20.0 30.0");
          f(50, "M20.0 0.0 L20.0 30.0");
          
          frame.timelines.length = 0;
          ele.setAttributeNS(null, "dur", "2s");
          ele.setAttributeNS(null, "fill", "remove");
          var attrValue = p.getAttributeNS(null, "d");
          $animate.init(ele);
          f(48, attrValue);
          
          frame.timelines.length = 0;
          p.removeAttributeNS(null, "d");
          ele.setAttributeNS(null, "fill", "freeze");
          ele.setAttributeNS(null, "keyTimes", "0;0.1;1");
          $animate.init(ele);
          f(1, "M20.0 5.0 L20.0 30.0");
          f(48, "M20.0 26.4 L20.0 30.0");
          
          frame.timelines.length = 0;
          ele.setAttributeNS(null, "fill", "freeze");
          ele.setAttributeNS(null, "calcMode", "discrete");
          ele.setAttributeNS(null, "keyTimes", "0.1;0.5;0.4");
          $animate.init(ele);
          f(1, "M20.0 0.0 L20.0 30.0");
          f(4, "M20.0 0.0 L20.0 30.0");
          f(5, "M20.0 24.0 L20.0 30.0");
          f(25, "M20.0 24.0 L20.0 30.0");
          f(29, "M20.0 26.4 L20.0 30.0");
          f(48, "M20.0 26.4 L20.0 30.0");
          
          frame.timelines.length = 0;
          ele.setAttributeNS(null, "calcMode", "spline");
          ele.removeAttributeNS(null, "keyTimes");
          ele.setAttributeNS(null, "keySplines", "0,0,1,1;0,0,1,1;.75,0,0,.75");
          ele.removeAttributeNS(null, "end");
          ele.setAttributeNS(null, "dur", "9s");
          ele.setAttributeNS(null, "values", "210;177;121;10");
          $animate.init(ele);
          f(0, "210.0");
          f(72, "177.0");
          f(144, "121.0");
          f(216, "10.0");
          f(300, "10.0");
          
          frame.timelines.length = 0;
          ele.setAttributeNS(null, "calcMode", "spline");
          ele.setAttributeNS(null, "keyTimes", "0;.25;.5;1");
          ele.setAttributeNS(null, "keySplines", "0,0,1,1;0,0,1,1;1,0,0,1");
          ele.setAttributeNS(null, "dur", "8s");
          ele.setAttributeNS(null, "values", "300;255;180;30");
          $animate.init(ele);
          f(0, "300.0");
          f(48, "255.0");
          f(96, "180.0");
          f(192, "30.0");
          f(300, "30.0");
          
        } );
        /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
        it("should be this for the value (the invalid partion )", function() {
          ele.setAttributeNS(null, "begin", "0s");
          ele.setAttributeNS(null, "dur", "100s");
          ele.setAttributeNS(null, "attributeName", "d");
          ele.setAttributeNS(null, "fill", "freeze");
          ele.setAttributeNS(null, "from", "M20 0 L20 30");
          ele.setAttributeNS(null, "to", "M20 2400 L20 30");
          ele.setAttributeNS(null, "keyTimes", "0;0.1;1");
          $animate.init(ele);
          
          var p = ele.parentNode;
          expect(p.getAttributeNS(null, "d") || null).toBeNull();
          
          function f(fr, result) {
            frame.setFrame(fr);
            expect(p.getAttributeNS(null, "d") || null).toBe(result);
          };
          f(0, null);
          f(1, null);
          
           frame.timelines.length = 0;
          /*keyTimes属性のリストの個数がvaluesリストと合致しない*/
          ele.setAttributeNS(null, "keyTimes", "0;0.1;0.5;1");
          ele.setAttributeNS(null, "values", "M20 0 L20 30;M20 24 L20 30;M20 26.4 L20 30");
          $animate.init(ele);
          f(0, null);
          f(1, null);
          
          frame.timelines.length = 0;
          ele.setAttributeNS(null, "calcMode", "spline");
          $animate.init(ele);
          expect($animate.mode).toBe("spline");
          f(0, null);
          f(0.2, null);
          f(1, null); 
        } );
      } );
      describe("RGB Color", function() {
        var $animate, ele, frame, f;
        beforeEach( function() {
          $animate = base("$calcMode").$attribute.$setElement.$animateElement.up();
          var p = document.createElementNS("http://www.w3.org/2000/svg", "g");
          ele = document.createElementNS("http://www.w3.org/2000/svg", "animate");
          p.appendChild(ele);
          frame = base("$frame");
          frame.timelines.length = 0;
          
          f = function (fr, result, attr) {
            frame.setFrame(fr);
            expect(p.getAttributeNS(null, attr)).toBe(result);
          };
        } );
        /*境界条件を調べておく (limit value analysis)*/
        it("should be this for the value  (limit value analysis)", function() {
          ele.setAttributeNS(null, "begin", "0s");
          ele.setAttributeNS(null, "dur", "1s");
          ele.setAttributeNS(null, "attributeName", "fill");
          ele.setAttributeNS(null, "fill", "remove");
          ele.setAttributeNS(null, "from", "rgb(0, 0, 0)");
          ele.setAttributeNS(null, "to", "rgb(10, 10, 1)");
          $animate.init(ele);
          
          f(0, "rgb(0, 0, 0)", "fill");
          f(23, "rgb(10, 10, 1)", "fill");
          
          frame.timelines.length = 0;
          ele.setAttributeNS(null, "attributeName", "stroke");
          $animate.init(ele);
          f(0, "rgb(0, 0, 0)", "stroke");
          f(23, "rgb(10, 10, 1)", "stroke");

          frame.timelines.length = 0;
          ele.setAttributeNS(null, "attributeName", "stop-color");
          $animate.init(ele);
          f(0, "rgb(0,0,0)", "stop-color");
          f(23, "rgb(10,10,1)", "stop-color");

          frame.timelines.length = 0;
          ele.setAttributeNS(null, "attributeName", "color");
          $animate.init(ele);
          f(0, "rgb(0,0,0)", "color");
          f(23, "rgb(10,10,1)", "color");
        } );
        /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
        it("should be this for the value (the valid partion )", function() {
          ele.setAttributeNS(null, "begin", "0s");
          ele.setAttributeNS(null, "dur", "1s");
          ele.setAttributeNS(null, "attributeName", "fill");
          ele.setAttributeNS(null, "fill", "remove");
          ele.setAttributeNS(null, "values", "rgb(0, 0, 0);rgb(24, 2.4, 1)");
          $animate.init(ele);
          
          f(0, "rgb(0, 0, 0)", "fill");
          f(1, "rgb(1, 0, 0)", "fill");
          f(23, "rgb(23, 2, 1)", "fill");

          frame.timelines.length = 0;
          ele.setAttributeNS(null, "values", "#00083C;#18203C");
          $animate.init(ele);
          /*rgb形式に変換*/
          
          f(0, "rgb(0, 8, 60)", "fill");
          f(1, "rgb(1, 9, 60)", "fill");
          f(23, "rgb(23, 31, 60)", "fill");
          
          frame.timelines.length = 0;
          ele.setAttributeNS(null, "fill", "freeze");
          ele.setAttributeNS(null, "values", "black;white");
          $animate.init(ele);
          /*色キーワードをrgb形式に変換*/
          
          f(0, "rgb(0, 0, 0)", "fill");
          f(12, "rgb(128, 128, 128)", "fill");
          f(24, "rgb(255, 255, 255)", "fill");
        } );
        /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
        it("should be this for the value (the invalid partion )", function() {
          ele.setAttributeNS(null, "begin", "0s");
          ele.setAttributeNS(null, "dur", "1s");
          ele.setAttributeNS(null, "attributeName", "fi");
          ele.setAttributeNS(null, "fill", "remove");
          ele.setAttributeNS(null, "values", "#00083C;#00107C");
          $animate.init(ele);
          /*rgb形式に変換しない*/
          
          f(0, "#83.0C", "fi");
          f(1, "#84.0C", "fi");
          f(23, "#106.0C", "fi");   
        } );
      } );
    describe("$frame.$svgEvent object", function() {
      var frame = base("$frame").$svgEvent.up(),
          p, ele;
        beforeEach( function() {
          /*firstプロパティとtimelinesプロパティは$frameオブジェクトのフレーム進行に
           * 影響を受けるため、新たに初期化しておく*/
          base("$frame").timelines = frame.timelines = [];
          frame.lastTimeLine = null;
          frame.first = frame.$svgEvent.first;
          p = document.createElementNS("http://www.w3.org/2000/svg", "g");
          ele = document.createElementNS("http://www.w3.org/2000/svg", "animate");
          p.appendChild(ele);
        } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        frame.lastTimeLine = null;
        frame.first = frame.$svgEvent.first;
        expect(frame.lastTimeLine).toBeNull();
        expect(frame.first).toBeNull();
        frame.setTimeTable();
        expect(frame.first).toBeNull();
        frame.addLine( base("$frame").$begin.up().mix({
          timelines: [],
          begin: 0,
          activeTime: 0,
          target: ele
        }) );
        frame.setTimeTable();
        expect(frame.first).toEqual(
          { frame: 0,
            eventType: "begin",
            target: ele,
          
            next: { frame: 0,
              eventType: "end",
              target: ele,
              next: null
            }
          }
        );
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion )", function() {
        frame.addLine( base("$frame").$begin.up().mix({
          timelines: [],
          begin: 0,
          activeTime: 0,
          target: ele
        }) );
        frame.setTimeTable();
        frame.setTimeTable();
        expect(frame.first).toEqual(
          { frame: 0,
            eventType: "begin",
            target: ele,
          
            next: { frame: 0,
              eventType: "end",
              target: ele,
              next: null
            }
          }
        );
        frame.setTimeTable();
        frame.setTimeTable();
        expect(frame.first).toEqual(
          { frame: 0,
            eventType: "begin",
            target: ele,
          
            next: { frame: 0,
              eventType: "end",
              target: ele,
              next: null
            }
          }
        );
        
        var isFiredBeginEvent = false;
        ele.addEventListener("beginEvent", function(evt) {
          isFiredBeginEvent = true;
          expect(evt.target).toBe(ele);
        } );
        ele.addEventListener("endEvent", function(evt) {
          expect(evt.target).toBe(ele);
          expect(isFiredBeginEvent).toBeTruthy();
        } );
        frame.setFrame(0);
        expect(frame.first).toBeNull();
        frame.setFrame(0);
        expect(frame.first).toBeNull();
        
        frame.timelines = [];
        frame.addLine( base("$frame").$begin.up().mix({
          timelines: [],
          begin: 0,
          activeTime: 10,
          target: ele
        }) );
        frame.setTimeTable();
        var a = { frame: 0,
            eventType: "begin",
            target: ele,
          
            next: { frame: 10,
              eventType: "end",
              target: ele,
              next: null
            }
          };
        expect(frame.first).toEqual(a);
        
        frame.addLine( base("$frame").$begin.up().mix({
          timelines: [],
          begin: 1,
          simpleDuration: 9,
          activeTime: 11,
          target: ele
        }) );
        frame.setTimeTable();
        a.next.next = { frame: 1,
            eventType: "begin",
            target: ele,
          
            next: { firstFrame: 10,
              frame: 10,
              eventType: "repeat",
              limit: 12,
              count: 1,
              simpleDuration: 9,
              target: ele,
            
              next: { frame: 12,
                eventType: "end",
                target: ele,
                next: null
              }
            }
          };
        expect(frame.first).toEqual(a);
        frame.setFrame(11);
        expect(frame.first).toEqual( {frame: 12,
                eventType: "end",
                target: ele,
                next: null
              } );
              
        frame.timelines = [];
        frame.first = null;
        frame.addLine( base("$frame").$begin.up().mix({
          timelines: [],
          begin: 1,
          simpleDuration: 4,
          activeTime: 10,
          target: ele
        }) );
        frame.setTimeTable();
        a =  { frame: 1,
            eventType: "begin",
            target: ele,
          
            next: {firstFrame:5,
              frame: 5,
              eventType: "repeat",
              limit: 11,
              count: 1,
              simpleDuration: 4,
              target: ele,
            
              next: { frame: 11,
                eventType: "end",
                target: ele,
                next: null
              }
            }
          };
        expect(frame.first).toEqual(a);
        frame.setFrame(0);
        expect(frame.first).toEqual(a);
        frame.setFrame(1);
        a = a.next;
        expect(frame.first).toEqual(a);
        frame.setFrame(5);
        a.count = 1;
        a.frame = 9;
        expect(frame.first).toEqual(a);

        ele.addEventListener("repeatEvent", function(evt) {
          expect(evt.target).toBe(ele);
        } );
        frame.timelines = [];
        frame.first = null;
        frame.addLine( base("$frame").$begin.up().mix({
          timelines: [],
          begin: 1,
          simpleDuration: 4,
          activeTime: 15,
          target: ele
        }) );
        frame.setFrame(9);
        a.count = 2;
        a.limit = 16;
        a.next.frame = 16;
        expect(frame.first).toEqual(a);
      } );
    } );
    describe("Event", function() {
      var $animate, ele, frame, p;
      beforeEach( function() {
        $animate = base("$calcMode").$attribute.$setElement.$animateElement.up();
        p = document.createElementNS("http://www.w3.org/2000/svg", "g");
        ele = document.createElementNS("http://www.w3.org/2000/svg", "animate");
        p.appendChild(ele);
        frame = base("$frame");
        frame.timelines.length = 0; //配列の初期化
        frame.setFrame(0);
      } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        ele.addEventListener("beginEvent", function(evt) {
          expect(evt.target).toBe(ele);
        } );
        var evt = ele.ownerDocument.createEvent("MouseEvents");
        evt.initMouseEvent("beginEvent",true, true, window, 0, 0, 0, 0, 0, false, false, false, false,0, ele);
        ele.dispatchEvent(evt);
        
        ele.setAttributeNS(null, "begin", "mousedown");
        ele.setAttributeNS(null, "dur", "1s");
        ele.setAttributeNS(null, "attributeName", "fill");
        ele.setAttributeNS(null, "fill", "freeze");
        ele.setAttributeNS(null, "from", "rgb(0,0,0)");
        ele.setAttributeNS(null, "to", "rgb(10,10,1)");
        $animate.init(ele);
        expect(p.getAttributeNS(null, "fill") || null).toBeNull();
        evt = ele.ownerDocument.createEvent("MouseEvents");
        evt.initMouseEvent("beginEvent",true, true, window, 0, 0, 0, 0, 0, false, false, false, false,0, ele);
        p.dispatchEvent(evt);
        expect(p.getAttributeNS(null, "fill") || null).toBeNull();
        evt = ele.ownerDocument.createEvent("MouseEvents");
        evt.initMouseEvent("mousedown",true, true, window, 0, 0, 0, 0, 0, false, false, false, false,0, p);
        p.addEventListener("mousedown", function(evt) {
          expect($animate.isEnd).toBeFalsy();
          frame.setFrame(24);
          expect(evt.target.getAttributeNS(null, "fill") || null).toBe("rgb(10, 10, 1)");
        }, false );
        frame.setFrame(0);
        expect($animate.isEnd).toBeFalsy();
        p.dispatchEvent(evt);
      } );
    } );
      describe("a beginElement method and an endElement method", function() {
        var $animate, ele, frame, p;
        beforeEach( function() {
          $animate = base("$calcMode").$attribute.$setElement.$animateElement.up();
          p = document.createElementNS("http://www.w3.org/2000/svg", "g");
          ele = document.createElementNS("http://www.w3.org/2000/svg", "animate");
          p.appendChild(ele);
          frame = base("$frame");
          frame.timelines.length = 0; //配列の初期化
          frame.setFrame(0);
          ele.setAttributeNS(null, "begin", "indefinite");
          ele.setAttributeNS(null, "dur", "1s");
          ele.setAttributeNS(null, "dur", "1s");
          ele.setAttributeNS(null, "attributeName", "fill");
          ele.setAttributeNS(null, "fill", "freeze");
          ele.setAttributeNS(null, "from", "rgb(0,0,0)");
          ele.setAttributeNS(null, "to", "rgb(10,10,1)");
          $animate.init(ele);
        } );
        /*境界条件を調べておく (limit value analysis)*/
        it("should be this for the value  (limit value analysis)", function() {
          expect(ele.beginElement()).toBeUndefined();
          var cur = frame.currentFrame,
              begin = frame.$begin.$1;
          expect(begin.string).toBe("indefinite");
          expect(begin.begin).toBe(cur);
          expect(ele.endElement()).toBeUndefined();
        } );
        /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
        it("should be this for the value (the valid partion )", function() {
          ele.addEventListener("beginEvent", function(evt){
            expect(evt.target.nodeName).toBe("animate");
          }, false );
          ele.beginElement();
        } );
      });
    } );
} );
