/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import jdbcacsess.sql.ExecuteSqlFactory;
import jdbcacsess.sql.QueryExecuteListener;
import jdbcacsess.sql.SqlAnalyze;

public class QueryExecuteSync {
    private ExecuteSqlFactory executeSql;
    private boolean err = false;

    public QueryExecuteSync(Object source, SqlAnalyze sqlAnalyze, Connection con) {
        this.executeSql = ExecuteSqlFactory.getFactory(source, sqlAnalyze, con);
    }

    public QueryExecuteSync(Object source, ResultSet resultSet) {
        this.executeSql = ExecuteSqlFactory.getFactory(source, resultSet);
    }

    public void addQueryExecuteListener(QueryExecuteListener listener) {
        this.executeSql.addQueryExecuteListener(listener);
    }

    public void open() {
        try {
            if (!this.executeSql.notifyOfInitAndResultHeader()) {
                return;
            }
        }
        catch (Exception e) {
            this.executeSql.notifyOfErrorException(e);
            this.err = true;
        }
    }

    public boolean read() {
        try {
            return this.executeSql.notifyOfResultDetail();
        }
        catch (Error error) {
            this.executeSql.notifyOfErrorException(new Exception(error));
            this.err = true;
            return false;
        }
        catch (Exception e) {
            this.executeSql.notifyOfErrorException(e);
            this.err = true;
            return false;
        }
    }

    public void close() {
        this.executeSql.notifyOfCompleteQuery(false, this.err);
    }
}

